/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.relationship;

import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.relationship.FriendAddApplication;
import com.tencent.imsdk.relationship.FriendApplication;
import com.tencent.imsdk.relationship.FriendApplicationResult;
import com.tencent.imsdk.relationship.FriendCheckResult;
import com.tencent.imsdk.relationship.FriendGroup;
import com.tencent.imsdk.relationship.FriendInfo;
import com.tencent.imsdk.relationship.FriendInfoResult;
import com.tencent.imsdk.relationship.FriendOperationResult;
import com.tencent.imsdk.relationship.FriendResponse;
import com.tencent.imsdk.relationship.FriendSearchParam;
import com.tencent.imsdk.relationship.FriendshipListener;
import com.tencent.imsdk.relationship.ReceiveMessageOptInfo;
import com.tencent.imsdk.relationship.UserInfo;
import java.util.HashMap;
import java.util.List;

public class RelationshipManager {
    private FriendshipListener mFriendshipInternalListener;
    private FriendshipListener mFriendshipListener;

    public static RelationshipManager getInstance() {
        return RelationshipManagerHolder.relationshipManager;
    }

    public void init() {
        this.initFriendshipListener();
    }

    private void initFriendshipListener() {
        if (this.mFriendshipInternalListener == null) {
            this.mFriendshipInternalListener = new FriendshipListener(){

                @Override
                public void OnSelfInfoUpdated(UserInfo userInfo) {
                    BaseManager.getInstance().notifySelfInfoUpdated(userInfo);
                }

                @Override
                public void OnFriendInfoChanged(final List<FriendInfo> friendInfoList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.OnFriendInfoChanged(friendInfoList);
                            }
                        }
                    });
                }

                @Override
                public void OnFriendListAdded(final List<FriendInfo> friendInfoList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.OnFriendListAdded(friendInfoList);
                            }
                        }
                    });
                }

                @Override
                public void OnFriendListDeleted(final List<String> userIDList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.OnFriendListDeleted(userIDList);
                            }
                        }
                    });
                }

                @Override
                public void OnBlackListAdded(final List<FriendInfo> friendInfoList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.OnBlackListAdded(friendInfoList);
                            }
                        }
                    });
                }

                @Override
                public void OnBlackListDeleted(final List<String> userIDList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.OnBlackListDeleted(userIDList);
                            }
                        }
                    });
                }

                @Override
                public void OnFriendApplicationListAdded(final List<FriendApplication> applicationList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.OnFriendApplicationListAdded(applicationList);
                            }
                        }
                    });
                }

                @Override
                public void OnFriendApplicationListDelete(final List<String> userIDList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.OnFriendApplicationListDelete(userIDList);
                            }
                        }
                    });
                }

                @Override
                public void OnFriendApplicationListRead() {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (RelationshipManager.this.mFriendshipListener != null) {
                                RelationshipManager.this.mFriendshipListener.OnFriendApplicationListRead();
                            }
                        }
                    });
                }
            };
        }
        this.nativeSetFriendshipListener(this.mFriendshipInternalListener);
    }

    public void setFriendshipListener(FriendshipListener friendshipListener) {
        this.mFriendshipListener = friendshipListener;
    }

    public void getUsersInfo(List<String> userIDList, IMCallback<List<UserInfo>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetUsersInfo(userIDList, callback);
    }

    public void setSelfInfo(HashMap<String, Object> modifyParams, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetSelfInfo(modifyParams, callback);
    }

    public void setC2CReceiveMessageOpt(List<String> userIDList, int opt, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetC2CReceiveMessageOpt(userIDList, opt, callback);
    }

    public void getC2CReceiveMessageOpt(List<String> userIDList, IMCallback<List<ReceiveMessageOptInfo>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetC2CReceiveMessageOpt(userIDList, callback);
    }

    public void getFriendList(IMCallback<List<FriendInfo>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetFriendList(callback);
    }

    public void getFriendsInfo(List<String> userIDList, IMCallback<List<FriendInfoResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetFriendsInfo(userIDList, callback);
    }

    public void setFriendInfo(String userID, HashMap<String, Object> modifyParams, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetFriendInfo(userID, modifyParams, callback);
    }

    public void searchFriends(FriendSearchParam searchParam, IMCallback<List<FriendInfoResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSearchFriends(searchParam, callback);
    }

    public void addFriend(FriendAddApplication friendAddApplication, IMCallback<FriendOperationResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeAddFriend(friendAddApplication, callback);
    }

    public void deleteFromFriendList(List<String> userIDList, int deleteType, IMCallback<List<FriendOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteFromFriendList(userIDList, deleteType, callback);
    }

    public void checkFriend(List<String> userIDList, int checkType, IMCallback<List<FriendCheckResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeCheckFriend(userIDList, checkType, callback);
    }

    public void getFriendApplicationList(IMCallback<FriendApplicationResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetFriendApplicationList(callback);
    }

    public void responseFriendApplication(FriendResponse friendResponse, IMCallback<FriendOperationResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeResponseFriendApplication(friendResponse, callback);
    }

    public void deleteFriendApplication(int applicationType, String userID, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteFriendApplication(applicationType, userID, callback);
    }

    public void setFriendApplicationRead(IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetFriendApplicationRead(callback);
    }

    public void addToBlackList(List<String> userIDList, IMCallback<List<FriendOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeAddToBlackList(userIDList, callback);
    }

    public void deleteFromBlackList(List<String> userIDList, IMCallback<List<FriendOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteFromBlackList(userIDList, callback);
    }

    public void getBlackList(IMCallback<List<FriendInfo>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetBlackList(callback);
    }

    public void createFriendGroup(String groupName, List<String> userIDList, IMCallback<List<FriendOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeCreateFromGroup(groupName, userIDList, callback);
    }

    public void getFriendGroups(List<String> groupNameList, IMCallback<List<FriendGroup>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetFriendGroups(groupNameList, callback);
    }

    public void deleteFriendGroup(List<String> groupNameList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteFriendGroup(groupNameList, callback);
    }

    public void renameFriendGroup(String oldName, String newName, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeRenameFriendGroup(oldName, newName, callback);
    }

    public void addFriendsToFriendGroup(String groupName, List<String> userIDList, IMCallback<List<FriendOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeAddFriendsToFriendGroup(groupName, userIDList, callback);
    }

    public void deleteFrendsFromFriendGroup(String groupName, List<String> userIDList, IMCallback<List<FriendOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteFriendsFromFriendGroup(groupName, userIDList, callback);
    }

    protected native void nativeGetUsersInfo(List<String> var1, IMCallback<List<UserInfo>> var2);

    protected native void nativeSetSelfInfo(HashMap<String, Object> var1, IMCallback var2);

    protected native void nativeSetFriendshipListener(FriendshipListener var1);

    protected native void nativeGetFriendList(IMCallback var1);

    protected native void nativeGetFriendsInfo(List<String> var1, IMCallback var2);

    protected native void nativeSetFriendInfo(String var1, HashMap<String, Object> var2, IMCallback var3);

    protected native void nativeSearchFriends(FriendSearchParam var1, IMCallback var2);

    protected native void nativeAddFriend(FriendAddApplication var1, IMCallback var2);

    protected native void nativeDeleteFromFriendList(List<String> var1, int var2, IMCallback var3);

    protected native void nativeCheckFriend(List<String> var1, int var2, IMCallback var3);

    protected native void nativeGetFriendApplicationList(IMCallback var1);

    protected native void nativeResponseFriendApplication(FriendResponse var1, IMCallback var2);

    protected native void nativeDeleteFriendApplication(int var1, String var2, IMCallback var3);

    protected native void nativeSetFriendApplicationRead(IMCallback var1);

    protected native void nativeAddToBlackList(List<String> var1, IMCallback var2);

    protected native void nativeDeleteFromBlackList(List<String> var1, IMCallback var2);

    protected native void nativeGetBlackList(IMCallback var1);

    protected native void nativeCreateFromGroup(String var1, List<String> var2, IMCallback var3);

    protected native void nativeGetFriendGroups(List<String> var1, IMCallback var2);

    protected native void nativeDeleteFriendGroup(List<String> var1, IMCallback var2);

    protected native void nativeRenameFriendGroup(String var1, String var2, IMCallback var3);

    protected native void nativeAddFriendsToFriendGroup(String var1, List<String> var2, IMCallback var3);

    protected native void nativeDeleteFriendsFromFriendGroup(String var1, List<String> var2, IMCallback var3);

    protected native void nativeSetC2CReceiveMessageOpt(List<String> var1, int var2, IMCallback var3);

    protected native void nativeGetC2CReceiveMessageOpt(List<String> var1, IMCallback<List<ReceiveMessageOptInfo>> var2);

    private static class RelationshipManagerHolder {
        private static final RelationshipManager relationshipManager = new RelationshipManager();

        private RelationshipManagerHolder() {
        }
    }
}

