package com.tencent.imsdk.message;

import com.tencent.imsdk.v2.V2TIMMessage;

public class FileElement extends MessageBaseElement {
    private String fileUUID;
    private String fileName;
    private String filePath;
    private int fileSize;
    private int fileDownloadFlag;
    private String fileDownloadUrl;
    private int fileBusinessID;

    public FileElement() {
        setElementType(V2TIMMessage.V2TIM_ELEM_TYPE_FILE);
    }

    public String getFileUUID() {
        return fileUUID;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public int getFileSize() {
        return fileSize;
    }

    public int getFileDownloadFlag() {
        return fileDownloadFlag;
    }

    public String getFileDownloadUrl() {
        return fileDownloadUrl;
    }

    public int getFileBusinessID() {
        return fileBusinessID;
    }

    @Override
    public boolean update(MessageBaseElement element) {
        if (elementType == element.elementType) {
            FileElement fileElement = (FileElement)element;
            if (filePath.equals(fileElement.filePath)) {
                fileUUID = fileElement.fileUUID;
                fileName = fileElement.fileName;
                fileSize = fileElement.fileSize;
                fileDownloadFlag = fileElement.fileDownloadFlag;
                fileDownloadUrl = fileElement.fileDownloadUrl;
                fileBusinessID = fileElement.fileBusinessID;

                return true;
            }
        }

        return false;
    }
}
