package com.tencent.imsdk.message;

import com.tencent.imsdk.v2.V2TIMMessage;

public class SoundElement extends MessageBaseElement {
    private String soundUUID;
    private String soundFilePath;
    private int soundFileSize;
    private int soundDuration;
    private int soundDownloadFlag;
    private String soundDownloadUrl;
    private int soundBusinessID;

    public SoundElement() {
        setElementType(V2TIMMessage.V2TIM_ELEM_TYPE_SOUND);
    }

    public String getSoundUUID() {
        return soundUUID;
    }

    public String getSoundFilePath() {
        return soundFilePath;
    }

    public void setSoundFilePath(String soundFilePath) {
        this.soundFilePath = soundFilePath;
    }

    public int getSoundFileSize() {
        return soundFileSize;
    }

    public void setSoundFileSize(int fileSize) {
        this.soundFileSize = fileSize;
    }

    public int getSoundDuration() {
        return soundDuration;
    }

    public void setSoundDuration(int soundDuration) {
        this.soundDuration = soundDuration;
    }

    public String getSoundDownloadUrl() {
        return soundDownloadUrl;
    }

    public int getSoundDownloadFlag() {
        return soundDownloadFlag;
    }

    public int getSoundBusinessID() {
        return soundBusinessID;
    }

    @Override
    public boolean update(MessageBaseElement element) {
        if (elementType == element.elementType) {
            SoundElement soundElement = (SoundElement)element;
            if (soundFilePath.equals(soundElement.soundFilePath)) {
                soundUUID = soundElement.soundUUID;
                soundFileSize = soundElement.soundFileSize;
                soundDuration = soundElement.soundDuration;
                soundDownloadFlag = soundElement.soundDownloadFlag;
                soundDownloadUrl = soundElement.soundDownloadUrl;
                soundBusinessID = soundElement.soundBusinessID;

                return true;
            }
        }

        return false;
    }
}
