package com.tencent.imsdk.offlinePush;

import com.tencent.imsdk.BaseConstants;
import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.manager.BaseManager;

public class OfflinePushManager {
    private static class OfflinePushManagerHolder {
        private static final OfflinePushManager offlinePushManager = new OfflinePushManager();
    }

    public static OfflinePushManager getInstance() {
        return OfflinePushManager.OfflinePushManagerHolder.offlinePushManager;
    }

    public void setOfflinePushToken(OfflinePushToken offlinePushToken, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeSetOfflinePushToken(offlinePushToken, callback);
    }

    public void setOfflinePushConfig(OfflinePushConfig offlinePushConfig, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeSetOfflinePushConfig(offlinePushConfig, callback);
    }

    public void getOfflinePushConfig(IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeGetOfflinePushConfig(callback);
    }

    public void doEnterBackground(EnterBackgroundParam enterBackgroundParam, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeDoEnterBackground(enterBackgroundParam, callback);
    }

    public void doEnterForeground(EnterForegroundParam enterForegroundParam, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeDoEnterForeground(enterForegroundParam, callback);
    }

    protected native void nativeSetOfflinePushToken(OfflinePushToken token, IMCallback callback);

    protected native void nativeSetOfflinePushConfig(OfflinePushConfig config, IMCallback callback);

    protected native void nativeGetOfflinePushConfig(IMCallback callback);

    protected native void nativeDoEnterBackground(EnterBackgroundParam enterBackgroundParam, IMCallback callback);

    protected native void nativeDoEnterForeground(EnterForegroundParam enterForegroundParam, IMCallback callback);
}
