package com.tencent.imsdk.v2;

import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.SystemUtil;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.offlinePush.EnterBackgroundParam;
import com.tencent.imsdk.offlinePush.EnterForegroundParam;
import com.tencent.imsdk.offlinePush.OfflinePushManager;

public class V2TIMOfflinePushManagerImpl extends V2TIMOfflinePushManager {
    private final String TAG = "V2TIMOfflinePushManagerImpl";
    private static class V2TIMOfflinePushManagerImplHolder {
        private static final V2TIMOfflinePushManagerImpl v2TIMOfflinePushManagerImpl = new V2TIMOfflinePushManagerImpl();
    }

    static V2TIMOfflinePushManagerImpl getInstance() {
        return V2TIMOfflinePushManagerImpl.V2TIMOfflinePushManagerImplHolder.v2TIMOfflinePushManagerImpl;
    }

    @Override
    public void setOfflinePushConfig(V2TIMOfflinePushConfig config, V2TIMCallback callback) {
        if (config == null) {
            config = new V2TIMOfflinePushConfig(0, "");
        }

        int brandID = SystemUtil.getInstanceType();
        config.getOfflinePushToken().setDeviceBrand(brandID);
        OfflinePushManager.getInstance().setOfflinePushToken(config.getOfflinePushToken(), new IMCallback(callback) {
            @Override
            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });

        BaseManager.getInstance().checkTUIComponent(BaseManager.TUI_COMPONENT_OFFLINEPUSH);
    }

    @Override
    public void doBackground(int unreadCount, V2TIMCallback callback) {
        if (unreadCount < 0) {
            unreadCount = 0;
        }
        int brandID = SystemUtil.getInstanceType();
        EnterBackgroundParam enterBackgroundParam = new EnterBackgroundParam();
        enterBackgroundParam.setC2cUnreadMessageCount(unreadCount);
        enterBackgroundParam.setDeviceBrand(brandID);
        OfflinePushManager.getInstance().doEnterBackground(enterBackgroundParam, new IMCallback(callback) {
            @Override
            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void doForeground(V2TIMCallback callback) {
        int brandID = SystemUtil.getInstanceType();
        EnterForegroundParam enterForegroundParam = new EnterForegroundParam();
        enterForegroundParam.setDeviceBrand(brandID);
        OfflinePushManager.getInstance().doEnterForeground(enterForegroundParam, new IMCallback(callback) {
            @Override
            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }
}
