/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.common;

import android.os.Process;
import android.text.TextUtils;
import com.tencent.imsdk.common.IMLog;
import com.tencent.imsdk.manager.BaseManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class CpuUsageMeasurer {
    private static final String TAG = "CpuUsageMeasurer";
    private static final long UPDATE_INTERVAL = TimeUnit.SECONDS.toMillis(2L);
    private final long mClockClkInHz = BaseManager.getInstance().getClockTickInHz();
    private final int mProcessorCount = Runtime.getRuntime().availableProcessors();
    private RandomAccessFile mProcessStatFile;
    private RandomAccessFile mSystemStatFile;
    private long mLastUpdateTime = 0L;
    private float mLastAppCpuTimeUsed = 0.0f;
    private float mLastAppCpuUsage = 0.0f;
    private long mTotalCpuTime = 0L;
    private long mIdleCpuTime = 0L;
    private float mLastSysCpuUsage = 0.0f;

    public CpuUsageMeasurer() {
        String filePath = String.format(Locale.ENGLISH, "/proc/%d/stat", Process.myPid());
        try {
            this.mProcessStatFile = new RandomAccessFile(filePath, "r");
        }
        catch (IOException e) {
            IMLog.e(TAG, "open /proc/[PID]/stat failed. " + e.getMessage());
        }
        try {
            this.mSystemStatFile = new RandomAccessFile("/proc/stat", "r");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getCpuUsage() {
        CpuUsageMeasurer cpuUsageMeasurer = this;
        synchronized (cpuUsageMeasurer) {
            if (BaseManager.getInstance().getTimeTick() - this.mLastUpdateTime >= UPDATE_INTERVAL) {
                this.updateCpuUsage();
            }
            return new int[]{(int)(this.mLastAppCpuUsage * 10.0f), (int)(this.mLastSysCpuUsage * 10.0f)};
        }
    }

    private void updateCpuUsage() {
        long totalCpuTime;
        long idleCpuTime;
        String[] params = CpuUsageMeasurer.readFirstLineAndSplit(this.mProcessStatFile);
        if (params == null || params.length < 52) {
            return;
        }
        long ticks = Long.parseLong(params[13]) + Long.parseLong(params[14]) + Long.parseLong(params[15]) + Long.parseLong(params[16]);
        long cpuTimeUsed = (long)(1000.0f * (float)ticks / (float)this.mClockClkInHz);
        String[] cpuInfos = CpuUsageMeasurer.readFirstLineAndSplit(this.mSystemStatFile);
        if (cpuInfos == null || cpuInfos.length < 8) {
            totalCpuTime = idleCpuTime = BaseManager.getInstance().getTimeTick() * (long)this.mProcessorCount;
        } else {
            totalCpuTime = Long.parseLong(cpuInfos[1]) + Long.parseLong(cpuInfos[2]) + Long.parseLong(cpuInfos[3]) + Long.parseLong(cpuInfos[4]) + Long.parseLong(cpuInfos[5]) + Long.parseLong(cpuInfos[6]) + Long.parseLong(cpuInfos[7]);
            idleCpuTime = Long.parseLong(cpuInfos[4]) + Long.parseLong(cpuInfos[5]);
            totalCpuTime = (long)(1000.0f * (float)totalCpuTime / (float)this.mClockClkInHz);
            idleCpuTime = (long)(1000.0f * (float)idleCpuTime / (float)this.mClockClkInHz);
        }
        long timeDelta = totalCpuTime - this.mTotalCpuTime;
        this.mLastAppCpuUsage = 100.0f * ((float)cpuTimeUsed - this.mLastAppCpuTimeUsed) / (float)timeDelta;
        this.mLastSysCpuUsage = 100.0f * (float)(timeDelta - (idleCpuTime - this.mIdleCpuTime)) / (float)timeDelta;
        this.mLastAppCpuTimeUsed = cpuTimeUsed;
        this.mIdleCpuTime = idleCpuTime;
        this.mTotalCpuTime = totalCpuTime;
        this.mLastUpdateTime = BaseManager.getInstance().getTimeTick();
    }

    private static String[] readFirstLineAndSplit(RandomAccessFile file) {
        if (file == null) {
            return null;
        }
        String line = null;
        try {
            file.seek(0L);
            line = file.readLine();
        }
        catch (IOException e) {
            IMLog.e(TAG, "read line failed. " + e.getMessage());
        }
        if (TextUtils.isEmpty((CharSequence)line)) {
            return null;
        }
        return line.split("\\s+");
    }

    protected void finalize() throws Throwable {
        super.finalize();
        CpuUsageMeasurer.closeQuietly(this.mProcessStatFile);
        CpuUsageMeasurer.closeQuietly(this.mSystemStatFile);
        IMLog.i(TAG, "measurer is released");
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

