/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.offlinepush;

import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.offlinepush.EnterBackgroundParam;
import com.tencent.imsdk.offlinepush.EnterForegroundParam;
import com.tencent.imsdk.offlinepush.OfflinePushConfig;
import com.tencent.imsdk.offlinepush.OfflinePushEventItem;
import com.tencent.imsdk.offlinepush.OfflinePushToken;
import java.util.List;

public class OfflinePushManager {
    public static OfflinePushManager getInstance() {
        return OfflinePushManagerHolder.offlinePushManager;
    }

    public void setOfflinePushInfo(String timPushVersion, int notificationBarStatus) {
        this.nativeSetOfflinePushInfo(timPushVersion, notificationBarStatus);
    }

    public void setOfflinePushToken(OfflinePushToken offlinePushToken, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetOfflinePushToken(offlinePushToken, callback);
    }

    public void setOfflinePushConfig(OfflinePushConfig offlinePushConfig, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetOfflinePushConfig(offlinePushConfig, callback);
    }

    public void getOfflinePushConfig(IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetOfflinePushConfig(callback);
    }

    public void doEnterBackground(EnterBackgroundParam enterBackgroundParam, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDoEnterBackground(enterBackgroundParam, callback);
    }

    public void doEnterForeground(EnterForegroundParam enterForegroundParam, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDoEnterForeground(enterForegroundParam, callback);
    }

    public void reportOfflinePushEvent(List<OfflinePushEventItem> eventItemList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeReportOfflinePushEvent(eventItemList, callback);
    }

    protected native void nativeSetOfflinePushInfo(String var1, int var2);

    protected native void nativeSetOfflinePushToken(OfflinePushToken var1, IMCallback var2);

    protected native void nativeSetOfflinePushConfig(OfflinePushConfig var1, IMCallback var2);

    protected native void nativeGetOfflinePushConfig(IMCallback var1);

    protected native void nativeDoEnterBackground(EnterBackgroundParam var1, IMCallback var2);

    protected native void nativeDoEnterForeground(EnterForegroundParam var1, IMCallback var2);

    protected native void nativeReportOfflinePushEvent(List<OfflinePushEventItem> var1, IMCallback var2);

    private static class OfflinePushManagerHolder {
        private static final OfflinePushManager offlinePushManager = new OfflinePushManager();

        private OfflinePushManagerHolder() {
        }
    }
}

