/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import android.text.TextUtils;
import com.tencent.imsdk.conversation.Conversation;
import com.tencent.imsdk.conversation.ConversationAtInfo;
import com.tencent.imsdk.group.GroupMemberInfo;
import com.tencent.imsdk.message.DraftMessage;
import com.tencent.imsdk.v2.V2TIMGroupAtInfo;
import com.tencent.imsdk.v2.V2TIMMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class V2TIMConversation
implements Serializable {
    public static final int CONVERSATION_TYPE_INVALID = 0;
    public static final int V2TIM_C2C = 1;
    public static final int V2TIM_GROUP = 2;
    public static long V2TIM_CONVERSATION_MARK_TYPE_STAR = 1L;
    public static long V2TIM_CONVERSATION_MARK_TYPE_UNREAD = 2L;
    public static long V2TIM_CONVERSATION_MARK_TYPE_FOLD = 4L;
    public static long V2TIM_CONVERSATION_MARK_TYPE_HIDE = 8L;
    static final String CONVERSATION_C2C_PREFIX = "c2c_";
    static final String CONVERSATION_GROUP_PREFIX = "group_";
    static final String CONVERSATION_C2C_TYPE = "c2c";
    static final String CONVERSATION_GROUP_TYPE = "group";
    private Conversation conversation;

    void setConversation(Conversation conversation) {
        this.conversation = conversation;
    }

    public String getConversationID() {
        if (this.conversation != null) {
            String conversationID = "";
            conversationID = this.conversation.getConversationKey().getConversationType() == 1 ? CONVERSATION_C2C_PREFIX + this.conversation.getConversationKey().getConversationID() : (this.conversation.getConversationKey().getConversationType() == 2 ? CONVERSATION_GROUP_PREFIX + this.conversation.getConversationKey().getConversationID() : "");
            return conversationID;
        }
        return null;
    }

    public int getType() {
        if (this.conversation != null) {
            return this.conversation.getConversationType();
        }
        return 0;
    }

    public String getUserID() {
        if (this.conversation == null) {
            return null;
        }
        if (this.conversation.getConversationType() == 1) {
            return this.conversation.getC2cUserID();
        }
        return null;
    }

    public String getGroupID() {
        if (this.conversation == null) {
            return null;
        }
        if (this.conversation.getConversationType() == 2) {
            return this.conversation.getGroupID();
        }
        return null;
    }

    public String getShowName() {
        if (this.conversation == null) {
            return null;
        }
        if (this.conversation.getConversationType() == 2) {
            if (!TextUtils.isEmpty((CharSequence)this.conversation.getGroupName())) {
                return this.conversation.getGroupName();
            }
            return this.conversation.getGroupID();
        }
        if (this.conversation.getConversationType() == 1) {
            if (!TextUtils.isEmpty((CharSequence)this.conversation.getC2cRemark())) {
                return this.conversation.getC2cRemark();
            }
            if (!TextUtils.isEmpty((CharSequence)this.conversation.getC2cNickname())) {
                return this.conversation.getC2cNickname();
            }
            return this.conversation.getC2cUserID();
        }
        return null;
    }

    public String getFaceUrl() {
        if (this.conversation != null) {
            if (this.getType() == 1) {
                return this.conversation.getC2cFaceUrl();
            }
            if (this.getType() == 2) {
                return this.conversation.getGroupFaceUrl();
            }
        }
        return null;
    }

    public int getRecvOpt() {
        if (this.conversation != null) {
            if (this.getType() == 1) {
                int recvOpt = this.conversation.getUserMessageReceiveOption();
                if (recvOpt == 1) {
                    return 0;
                }
                if (recvOpt == 2) {
                    return 1;
                }
                if (recvOpt == 3) {
                    return 2;
                }
            } else if (this.getType() == 2) {
                int recvOpt = this.conversation.getGroupMessageReceiveOption();
                if (recvOpt == GroupMemberInfo.MESSAGE_RECEIVE_OPTION_AUTO_RECEIVE) {
                    return 0;
                }
                if (recvOpt == GroupMemberInfo.MESSAGE_RECEIVE_OPTION_NOT_RECEIVE) {
                    return 1;
                }
                if (recvOpt == GroupMemberInfo.MESSAGE_RECEIVE_OPTION_RECEIVE_WITH_NO_OFFLINE_PUSH) {
                    return 2;
                }
            }
        }
        return 0;
    }

    public String getGroupType() {
        if (this.conversation == null) {
            return null;
        }
        String groupType = this.conversation.getGroupType();
        if (TextUtils.isEmpty((CharSequence)groupType)) {
            return null;
        }
        if (groupType.equals("Private")) {
            return "Work";
        }
        if (groupType.equals("ChatRoom")) {
            return "Meeting";
        }
        return groupType;
    }

    public int getUnreadCount() {
        if (this.conversation != null) {
            return (int)this.conversation.getUnreadMessageCount();
        }
        return 0;
    }

    public V2TIMMessage getLastMessage() {
        if (this.conversation == null || this.conversation.getLastMessage() == null) {
            return null;
        }
        V2TIMMessage v2TIMMessage = new V2TIMMessage();
        v2TIMMessage.setMessage(this.conversation.getLastMessage());
        return v2TIMMessage;
    }

    public String getDraftText() {
        if (this.conversation == null) {
            return null;
        }
        DraftMessage draftMessage = this.conversation.getDraftMessage();
        if (draftMessage == null) {
            return null;
        }
        byte[] draftData = draftMessage.getUserDefinedData();
        if (draftData != null) {
            return new String(draftData);
        }
        return null;
    }

    public long getDraftTimestamp() {
        if (this.conversation == null) {
            return 0L;
        }
        DraftMessage draftMessage = this.conversation.getDraftMessage();
        if (draftMessage == null) {
            return 0L;
        }
        return draftMessage.getEditTime();
    }

    public List<V2TIMGroupAtInfo> getGroupAtInfoList() {
        if (this.conversation == null) {
            return new ArrayList<V2TIMGroupAtInfo>();
        }
        ArrayList<V2TIMGroupAtInfo> v2TIMGroupAtInfoList = new ArrayList<V2TIMGroupAtInfo>();
        List<ConversationAtInfo> conversationAtInfoList = this.conversation.getConversationAtInfoList();
        for (ConversationAtInfo conversationAtInfo : conversationAtInfoList) {
            V2TIMGroupAtInfo v2TIMGroupAtInfo = new V2TIMGroupAtInfo();
            v2TIMGroupAtInfo.setConversationGroupAtInfo(conversationAtInfo);
            v2TIMGroupAtInfoList.add(v2TIMGroupAtInfo);
        }
        return v2TIMGroupAtInfoList;
    }

    public boolean isPinned() {
        if (this.conversation == null) {
            return false;
        }
        return this.conversation.isPinned();
    }

    public long getOrderKey() {
        if (this.conversation == null) {
            return 0L;
        }
        return this.conversation.getOrderKey();
    }

    public List<Long> getMarkList() {
        if (this.conversation == null) {
            return null;
        }
        return this.conversation.getMarkList();
    }

    public String getCustomData() {
        if (this.conversation == null) {
            return null;
        }
        return this.conversation.getCustomData();
    }

    public List<String> getConversationGroupList() {
        if (this.conversation == null) {
            return null;
        }
        return this.conversation.getConversationGroupList();
    }

    public long getC2CReadTimestamp() {
        if (this.conversation == null) {
            return 0L;
        }
        return this.conversation.getC2CReadTimestamp();
    }

    public long getGroupReadSequence() {
        if (this.conversation == null) {
            return 0L;
        }
        return this.conversation.getGroupReadSequence();
    }
}

