/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import android.text.TextUtils;
import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.officialaccount.OfficialAccountInfo;
import com.tencent.imsdk.officialaccount.OfficialAccountInfoResult;
import com.tencent.imsdk.relationship.FollowInfo;
import com.tencent.imsdk.relationship.FollowOperationResult;
import com.tencent.imsdk.relationship.FollowTypeCheckResult;
import com.tencent.imsdk.relationship.FriendApplication;
import com.tencent.imsdk.relationship.FriendApplicationResult;
import com.tencent.imsdk.relationship.FriendCheckResult;
import com.tencent.imsdk.relationship.FriendGroup;
import com.tencent.imsdk.relationship.FriendInfo;
import com.tencent.imsdk.relationship.FriendInfoResult;
import com.tencent.imsdk.relationship.FriendOperationResult;
import com.tencent.imsdk.relationship.FriendResponse;
import com.tencent.imsdk.relationship.FriendshipListener;
import com.tencent.imsdk.relationship.RelationshipManager;
import com.tencent.imsdk.relationship.UserInfo;
import com.tencent.imsdk.relationship.UserInfoResult;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMFollowInfo;
import com.tencent.imsdk.v2.V2TIMFollowOperationResult;
import com.tencent.imsdk.v2.V2TIMFollowTypeCheckResult;
import com.tencent.imsdk.v2.V2TIMFriendAddApplication;
import com.tencent.imsdk.v2.V2TIMFriendApplication;
import com.tencent.imsdk.v2.V2TIMFriendApplicationResult;
import com.tencent.imsdk.v2.V2TIMFriendCheckResult;
import com.tencent.imsdk.v2.V2TIMFriendGroup;
import com.tencent.imsdk.v2.V2TIMFriendInfo;
import com.tencent.imsdk.v2.V2TIMFriendInfoResult;
import com.tencent.imsdk.v2.V2TIMFriendOperationResult;
import com.tencent.imsdk.v2.V2TIMFriendSearchParam;
import com.tencent.imsdk.v2.V2TIMFriendshipListener;
import com.tencent.imsdk.v2.V2TIMFriendshipManager;
import com.tencent.imsdk.v2.V2TIMOfficialAccountInfo;
import com.tencent.imsdk.v2.V2TIMOfficialAccountInfoResult;
import com.tencent.imsdk.v2.V2TIMUserFullInfo;
import com.tencent.imsdk.v2.V2TIMUserInfoResult;
import com.tencent.imsdk.v2.V2TIMValueCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class V2TIMFriendshipManagerImpl
extends V2TIMFriendshipManager {
    private static final String TAG = "V2TIMFriendshipManagerImpl";
    private FriendshipListener mFriendshipInternalListener;
    private V2TIMFriendshipListener mV2TIMFriendshipListener;
    private final List<V2TIMFriendshipListener> mFriendshipListenerList = new ArrayList<V2TIMFriendshipListener>();

    static V2TIMFriendshipManagerImpl getInstance() {
        return V2TIMFriendshipManagerImplHolder.v2TIMFriendshipManagerImpl;
    }

    private V2TIMFriendshipManagerImpl() {
        this.initFriendshipListener();
    }

    @Override
    public void setFriendListener(final V2TIMFriendshipListener v2TIMFriendshipListener) {
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (V2TIMFriendshipManagerImpl.this.mV2TIMFriendshipListener != null) {
                    V2TIMFriendshipManagerImpl.this.mFriendshipListenerList.remove(V2TIMFriendshipManagerImpl.this.mV2TIMFriendshipListener);
                }
                if (v2TIMFriendshipListener != null) {
                    V2TIMFriendshipManagerImpl.this.mFriendshipListenerList.add(v2TIMFriendshipListener);
                }
                V2TIMFriendshipManagerImpl.this.mV2TIMFriendshipListener = v2TIMFriendshipListener;
            }
        });
    }

    @Override
    public void addFriendListener(final V2TIMFriendshipListener listener) {
        if (listener == null) {
            return;
        }
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (V2TIMFriendshipManagerImpl.this.mFriendshipListenerList.contains(listener)) {
                    return;
                }
                V2TIMFriendshipManagerImpl.this.mFriendshipListenerList.add(listener);
            }
        });
    }

    @Override
    public void removeFriendListener(final V2TIMFriendshipListener listener) {
        if (listener == null) {
            return;
        }
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                V2TIMFriendshipManagerImpl.this.mFriendshipListenerList.remove(listener);
            }
        });
    }

    @Override
    public void getFriendList(final V2TIMValueCallback<List<V2TIMFriendInfo>> callback) {
        V2TIMValueCallback<List<FriendInfo>> v2Callback = new V2TIMValueCallback<List<FriendInfo>>(){

            @Override
            public void onSuccess(List<FriendInfo> friendInfoList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendInfo> v2TIMFriendInfoList = new ArrayList<V2TIMFriendInfo>();
                    for (FriendInfo friendInfo : friendInfoList) {
                        V2TIMFriendInfo v2TIMFriendInfo = new V2TIMFriendInfo();
                        v2TIMFriendInfo.setFriendInfo(friendInfo);
                        v2TIMFriendInfoList.add(v2TIMFriendInfo);
                    }
                    callback.onSuccess(v2TIMFriendInfoList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().getFriendList(new IMCallback<List<FriendInfo>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<FriendInfo> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
        BaseManager.getInstance().reportTUIComponentUsage(4L);
    }

    @Override
    public void getFriendsInfo(List<String> userIDList, final V2TIMValueCallback<List<V2TIMFriendInfoResult>> callback) {
        if (userIDList == null || userIDList.isEmpty()) {
            if (callback != null) {
                callback.onError(6017, "userIDList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<FriendInfoResult>> v2Callback = new V2TIMValueCallback<List<FriendInfoResult>>(){

            @Override
            public void onSuccess(List<FriendInfoResult> friendInfoResultList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendInfoResult> v2TIMFriendInfoResultList = new ArrayList<V2TIMFriendInfoResult>();
                    for (FriendInfoResult friendInfoResult : friendInfoResultList) {
                        V2TIMFriendInfoResult v2TIMFriendInfoResult = new V2TIMFriendInfoResult();
                        v2TIMFriendInfoResult.setFriendInfoResult(friendInfoResult);
                        v2TIMFriendInfoResultList.add(v2TIMFriendInfoResult);
                    }
                    callback.onSuccess(v2TIMFriendInfoResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().getFriendsInfo(userIDList, new IMCallback<List<FriendInfoResult>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<FriendInfoResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void setFriendInfo(V2TIMFriendInfo info, V2TIMCallback callback) {
        if (info == null) {
            if (callback != null) {
                callback.onError(6017, "info is null");
            }
            return;
        }
        RelationshipManager.getInstance().setFriendInfo(info.getUserID(), info.getModifyFriendInfo(), new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void searchFriends(V2TIMFriendSearchParam searchParam, final V2TIMValueCallback<List<V2TIMFriendInfoResult>> callback) {
        if (searchParam == null) {
            if (callback != null) {
                callback.onError(6017, "searchParam is null");
            }
            return;
        }
        if (searchParam.getKeywordList() == null || searchParam.getKeywordList().size() == 0) {
            if (callback != null) {
                callback.onError(6017, "keywordList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<FriendInfoResult>> v2Callback = new V2TIMValueCallback<List<FriendInfoResult>>(){

            @Override
            public void onSuccess(List<FriendInfoResult> friendInfoResultList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendInfoResult> v2TIMFriendInfoResultList = new ArrayList<V2TIMFriendInfoResult>();
                    for (FriendInfoResult friendInfoResult : friendInfoResultList) {
                        V2TIMFriendInfoResult v2TIMFriendInfoResult = new V2TIMFriendInfoResult();
                        v2TIMFriendInfoResult.setFriendInfoResult(friendInfoResult);
                        v2TIMFriendInfoResultList.add(v2TIMFriendInfoResult);
                    }
                    callback.onSuccess(v2TIMFriendInfoResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().searchFriends(searchParam.getFriendSearchParam(), new IMCallback<List<FriendInfoResult>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<FriendInfoResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
        BaseManager.getInstance().reportTUIComponentUsage(6L);
    }

    @Override
    public void addFriend(V2TIMFriendAddApplication application, final V2TIMValueCallback<V2TIMFriendOperationResult> callback) {
        if (application == null) {
            if (callback != null) {
                callback.onError(6017, "v2TIMFriendApplication is null");
            }
            return;
        }
        V2TIMValueCallback<FriendOperationResult> v2TIMValueCallback = new V2TIMValueCallback<FriendOperationResult>(){

            @Override
            public void onSuccess(FriendOperationResult friendOperationResult) {
                if (callback != null) {
                    V2TIMFriendOperationResult v2TIMFriendOperationResult = new V2TIMFriendOperationResult();
                    v2TIMFriendOperationResult.setFriendOperationResult(friendOperationResult);
                    callback.onSuccess(v2TIMFriendOperationResult);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().addFriend(application.getFriendAddApplication(), new IMCallback<FriendOperationResult>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(FriendOperationResult data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void deleteFromFriendList(List<String> userIDList, int deleteType, final V2TIMValueCallback<List<V2TIMFriendOperationResult>> callback) {
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "userIDList maybe empty");
            }
            return;
        }
        if (deleteType != 1 && deleteType != 2) {
            if (callback != null) {
                callback.onError(6017, "deleteType is invalid : " + deleteType);
            }
            return;
        }
        V2TIMValueCallback<List<FriendOperationResult>> v2TIMValueCallback = new V2TIMValueCallback<List<FriendOperationResult>>(){

            @Override
            public void onSuccess(List<FriendOperationResult> friendOperationResults) {
                if (callback != null) {
                    ArrayList<V2TIMFriendOperationResult> v2TIMFriendInfoResultList = new ArrayList<V2TIMFriendOperationResult>();
                    for (FriendOperationResult friendOperationResult : friendOperationResults) {
                        V2TIMFriendOperationResult v2TIMFriendOperationResult = new V2TIMFriendOperationResult();
                        v2TIMFriendOperationResult.setFriendOperationResult(friendOperationResult);
                        v2TIMFriendInfoResultList.add(v2TIMFriendOperationResult);
                    }
                    callback.onSuccess(v2TIMFriendInfoResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().deleteFromFriendList(userIDList, deleteType, new IMCallback<List<FriendOperationResult>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FriendOperationResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void checkFriend(List<String> userIDList, int checkType, final V2TIMValueCallback<List<V2TIMFriendCheckResult>> callback) {
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "userIDList maybe empty");
            }
            return;
        }
        if (checkType != 1 && checkType != 2) {
            if (callback != null) {
                callback.onError(6017, "checkType is invalid : " + checkType);
            }
            return;
        }
        V2TIMValueCallback<List<FriendCheckResult>> v2TIMValueCallback = new V2TIMValueCallback<List<FriendCheckResult>>(){

            @Override
            public void onSuccess(List<FriendCheckResult> friendCheckResults) {
                if (callback != null) {
                    ArrayList<V2TIMFriendCheckResult> v2FriendCheckResultList = new ArrayList<V2TIMFriendCheckResult>();
                    for (FriendCheckResult friendCheckResult : friendCheckResults) {
                        V2TIMFriendCheckResult v2TIMFriendCheckResult = new V2TIMFriendCheckResult();
                        v2TIMFriendCheckResult.setFriendCheckResult(friendCheckResult);
                        v2FriendCheckResultList.add(v2TIMFriendCheckResult);
                    }
                    callback.onSuccess(v2FriendCheckResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().checkFriend(userIDList, checkType, new IMCallback<List<FriendCheckResult>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FriendCheckResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getFriendApplicationList(final V2TIMValueCallback<V2TIMFriendApplicationResult> callback) {
        V2TIMValueCallback<FriendApplicationResult> v2TIMValueCallback = new V2TIMValueCallback<FriendApplicationResult>(){

            @Override
            public void onSuccess(FriendApplicationResult friendApplicationResult) {
                if (callback != null) {
                    V2TIMFriendApplicationResult v2TIMFriendApplicationResult = new V2TIMFriendApplicationResult();
                    v2TIMFriendApplicationResult.setFriendApplicationResult(friendApplicationResult);
                    callback.onSuccess(v2TIMFriendApplicationResult);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().getFriendApplicationList(new IMCallback<FriendApplicationResult>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(FriendApplicationResult data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void acceptFriendApplication(V2TIMFriendApplication application, int responseType, final V2TIMValueCallback<V2TIMFriendOperationResult> callback) {
        if (responseType != 0 && responseType != 1) {
            if (callback != null) {
                callback.onError(6017, "responseType is invalid : " + responseType);
            }
            return;
        }
        if (application == null) {
            if (callback != null) {
                callback.onError(6017, "v2TIMFriendApplication is null");
            }
            return;
        }
        V2TIMValueCallback<FriendOperationResult> v2TIMValueCallback = new V2TIMValueCallback<FriendOperationResult>(){

            @Override
            public void onSuccess(FriendOperationResult friendOperationResult) {
                if (callback != null) {
                    V2TIMFriendOperationResult v2TIMFriendOperationResult = new V2TIMFriendOperationResult();
                    v2TIMFriendOperationResult.setFriendOperationResult(friendOperationResult);
                    callback.onSuccess(v2TIMFriendOperationResult);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        FriendResponse friendResponse = new FriendResponse();
        friendResponse.setUserID(application.getUserID());
        int internalResponseType = 0 == responseType ? 1 : 2;
        friendResponse.setResponseType(internalResponseType);
        RelationshipManager.getInstance().responseFriendApplication(friendResponse, new IMCallback<FriendOperationResult>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(FriendOperationResult data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void refuseFriendApplication(V2TIMFriendApplication application, final V2TIMValueCallback<V2TIMFriendOperationResult> callback) {
        if (application == null) {
            if (callback != null) {
                callback.onError(6017, "application is null");
            }
            return;
        }
        V2TIMValueCallback<FriendOperationResult> v2TIMValueCallback = new V2TIMValueCallback<FriendOperationResult>(){

            @Override
            public void onSuccess(FriendOperationResult friendOperationResult) {
                if (callback != null) {
                    V2TIMFriendOperationResult v2TIMFriendOperationResult = new V2TIMFriendOperationResult();
                    v2TIMFriendOperationResult.setFriendOperationResult(friendOperationResult);
                    callback.onSuccess(v2TIMFriendOperationResult);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        FriendResponse friendResponse = new FriendResponse();
        friendResponse.setUserID(application.getUserID());
        friendResponse.setResponseType(3);
        RelationshipManager.getInstance().responseFriendApplication(friendResponse, new IMCallback<FriendOperationResult>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(FriendOperationResult data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void deleteFriendApplication(V2TIMFriendApplication application, V2TIMCallback callback) {
        if (application == null) {
            if (callback != null) {
                callback.onError(6017, "application is null");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)application.getUserID())) {
            if (callback != null) {
                callback.onError(6017, "application userID is empty");
            }
            return;
        }
        RelationshipManager.getInstance().deleteFriendApplication(application.getType(), application.getUserID(), new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void setFriendApplicationRead(V2TIMCallback callback) {
        RelationshipManager.getInstance().setFriendApplicationRead(new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void addToBlackList(List<String> userIDList, final V2TIMValueCallback<List<V2TIMFriendOperationResult>> callback) {
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "userIDList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<FriendOperationResult>> v2TIMValueCallback = new V2TIMValueCallback<List<FriendOperationResult>>(){

            @Override
            public void onSuccess(List<FriendOperationResult> friendOperationResultList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendOperationResult> v2TIMFriendInfoResultList = new ArrayList<V2TIMFriendOperationResult>();
                    for (FriendOperationResult friendOperationResult : friendOperationResultList) {
                        V2TIMFriendOperationResult v2TIMFriendOperationResult = new V2TIMFriendOperationResult();
                        v2TIMFriendOperationResult.setFriendOperationResult(friendOperationResult);
                        v2TIMFriendInfoResultList.add(v2TIMFriendOperationResult);
                    }
                    callback.onSuccess(v2TIMFriendInfoResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().addToBlackList(userIDList, new IMCallback<List<FriendOperationResult>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FriendOperationResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void deleteFromBlackList(List<String> userIDList, final V2TIMValueCallback<List<V2TIMFriendOperationResult>> callback) {
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "userIDList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<FriendOperationResult>> v2TIMValueCallback = new V2TIMValueCallback<List<FriendOperationResult>>(){

            @Override
            public void onSuccess(List<FriendOperationResult> friendOperationResultList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendOperationResult> v2TIMFriendInfoResultList = new ArrayList<V2TIMFriendOperationResult>();
                    for (FriendOperationResult friendOperationResult : friendOperationResultList) {
                        V2TIMFriendOperationResult v2TIMFriendOperationResult = new V2TIMFriendOperationResult();
                        v2TIMFriendOperationResult.setFriendOperationResult(friendOperationResult);
                        v2TIMFriendInfoResultList.add(v2TIMFriendOperationResult);
                    }
                    callback.onSuccess(v2TIMFriendInfoResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().deleteFromBlackList(userIDList, new IMCallback<List<FriendOperationResult>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FriendOperationResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getBlackList(final V2TIMValueCallback<List<V2TIMFriendInfo>> callback) {
        V2TIMValueCallback<List<FriendInfo>> v2Callback = new V2TIMValueCallback<List<FriendInfo>>(){

            @Override
            public void onSuccess(List<FriendInfo> friendInfoList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendInfo> v2TIMFriendInfoList = new ArrayList<V2TIMFriendInfo>();
                    for (FriendInfo friendInfo : friendInfoList) {
                        V2TIMFriendInfo v2TIMFriendInfo = new V2TIMFriendInfo();
                        v2TIMFriendInfo.setFriendInfo(friendInfo);
                        v2TIMFriendInfoList.add(v2TIMFriendInfo);
                    }
                    callback.onSuccess(v2TIMFriendInfoList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().getBlackList(new IMCallback<List<FriendInfo>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<FriendInfo> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void createFriendGroup(String groupName, List<String> userIDList, final V2TIMValueCallback<List<V2TIMFriendOperationResult>> callback) {
        if (groupName == null) {
            if (callback != null) {
                callback.onError(6017, "groupNames is empty");
            }
            return;
        }
        V2TIMValueCallback<List<FriendOperationResult>> v2TIMValueCallback = new V2TIMValueCallback<List<FriendOperationResult>>(){

            @Override
            public void onSuccess(List<FriendOperationResult> friendOperationResultList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendOperationResult> v2TIMFriendInfoResultList = new ArrayList<V2TIMFriendOperationResult>();
                    for (FriendOperationResult friendOperationResult : friendOperationResultList) {
                        V2TIMFriendOperationResult v2TIMFriendOperationResult = new V2TIMFriendOperationResult();
                        v2TIMFriendOperationResult.setFriendOperationResult(friendOperationResult);
                        v2TIMFriendInfoResultList.add(v2TIMFriendOperationResult);
                    }
                    callback.onSuccess(v2TIMFriendInfoResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().createFriendGroup(groupName, userIDList, new IMCallback<List<FriendOperationResult>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FriendOperationResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getFriendGroups(List<String> groupNameList, final V2TIMValueCallback<List<V2TIMFriendGroup>> callback) {
        if (groupNameList != null && groupNameList.size() == 0) {
            groupNameList = null;
        }
        if (callback == null) {
            return;
        }
        V2TIMValueCallback<List<FriendGroup>> v2TIMValueCallback = new V2TIMValueCallback<List<FriendGroup>>(){

            @Override
            public void onSuccess(List<FriendGroup> friendGroupList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendGroup> v2TIMFriendGroupList = new ArrayList<V2TIMFriendGroup>();
                    for (FriendGroup friendGroup : friendGroupList) {
                        V2TIMFriendGroup v2TIMFriendGroup = new V2TIMFriendGroup();
                        v2TIMFriendGroup.setFriendGroup(friendGroup);
                        v2TIMFriendGroupList.add(v2TIMFriendGroup);
                    }
                    callback.onSuccess(v2TIMFriendGroupList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().getFriendGroups(groupNameList, new IMCallback<List<FriendGroup>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FriendGroup> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void deleteFriendGroup(List<String> groupNameList, V2TIMCallback callback) {
        if (groupNameList == null || groupNameList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "groupNames is empty");
            }
            return;
        }
        RelationshipManager.getInstance().deleteFriendGroup(groupNameList, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void renameFriendGroup(String oldName, String newName, V2TIMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.onError(6013, "sdk not init");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)newName)) {
            if (callback != null) {
                callback.onError(6017, "newName is empty");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)oldName)) {
            if (callback != null) {
                callback.onError(6017, "oldName is empty");
            }
            return;
        }
        RelationshipManager.getInstance().renameFriendGroup(oldName, newName, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void addFriendsToFriendGroup(String groupName, List<String> userIDList, final V2TIMValueCallback<List<V2TIMFriendOperationResult>> callback) {
        if (TextUtils.isEmpty((CharSequence)groupName)) {
            if (callback != null) {
                callback.onError(6017, "groupName is empty");
            }
            return;
        }
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "userIDList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<FriendOperationResult>> v2TIMValueCallback = new V2TIMValueCallback<List<FriendOperationResult>>(){

            @Override
            public void onSuccess(List<FriendOperationResult> friendOperationResultList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendOperationResult> v2TIMFriendInfoResultList = new ArrayList<V2TIMFriendOperationResult>();
                    for (FriendOperationResult friendOperationResult : friendOperationResultList) {
                        V2TIMFriendOperationResult v2TIMFriendOperationResult = new V2TIMFriendOperationResult();
                        v2TIMFriendOperationResult.setFriendOperationResult(friendOperationResult);
                        v2TIMFriendInfoResultList.add(v2TIMFriendOperationResult);
                    }
                    callback.onSuccess(v2TIMFriendInfoResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().addFriendsToFriendGroup(groupName, userIDList, new IMCallback<List<FriendOperationResult>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FriendOperationResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void deleteFriendsFromFriendGroup(String groupName, List<String> userIDList, final V2TIMValueCallback<List<V2TIMFriendOperationResult>> callback) {
        if (TextUtils.isEmpty((CharSequence)groupName)) {
            if (callback != null) {
                callback.onError(6017, "groupName is empty");
            }
            return;
        }
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "userIDList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<FriendOperationResult>> v2TIMValueCallback = new V2TIMValueCallback<List<FriendOperationResult>>(){

            @Override
            public void onSuccess(List<FriendOperationResult> friendOperationResultList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendOperationResult> v2TIMFriendInfoResultList = new ArrayList<V2TIMFriendOperationResult>();
                    for (FriendOperationResult friendOperationResult : friendOperationResultList) {
                        V2TIMFriendOperationResult v2TIMFriendOperationResult = new V2TIMFriendOperationResult();
                        v2TIMFriendOperationResult.setFriendOperationResult(friendOperationResult);
                        v2TIMFriendInfoResultList.add(v2TIMFriendOperationResult);
                    }
                    callback.onSuccess(v2TIMFriendInfoResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().deleteFriendsFromFriendGroup(groupName, userIDList, new IMCallback<List<FriendOperationResult>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FriendOperationResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void followUser(List<String> userIDList, final V2TIMValueCallback<List<V2TIMFollowOperationResult>> callback) {
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "userIDList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<FollowOperationResult>> v2TIMValueCallback = new V2TIMValueCallback<List<FollowOperationResult>>(){

            @Override
            public void onSuccess(List<FollowOperationResult> followOperationResultList) {
                if (callback != null) {
                    ArrayList<V2TIMFollowOperationResult> v2TIMFollowOperationResultList = new ArrayList<V2TIMFollowOperationResult>();
                    for (FollowOperationResult followOperationResult : followOperationResultList) {
                        V2TIMFollowOperationResult v2TIMFollowOperationResult = new V2TIMFollowOperationResult();
                        v2TIMFollowOperationResult.setFollowOperationResult(followOperationResult);
                        v2TIMFollowOperationResultList.add(v2TIMFollowOperationResult);
                    }
                    callback.onSuccess(v2TIMFollowOperationResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().followUser(userIDList, new IMCallback<List<FollowOperationResult>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FollowOperationResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void unfollowUser(List<String> userIDList, final V2TIMValueCallback<List<V2TIMFollowOperationResult>> callback) {
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "userIDList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<FollowOperationResult>> v2TIMValueCallback = new V2TIMValueCallback<List<FollowOperationResult>>(){

            @Override
            public void onSuccess(List<FollowOperationResult> followOperationResultList) {
                if (callback != null) {
                    ArrayList<V2TIMFollowOperationResult> v2TIMFollowOperationResultList = new ArrayList<V2TIMFollowOperationResult>();
                    for (FollowOperationResult followOperationResult : followOperationResultList) {
                        V2TIMFollowOperationResult v2TIMFollowOperationResult = new V2TIMFollowOperationResult();
                        v2TIMFollowOperationResult.setFollowOperationResult(followOperationResult);
                        v2TIMFollowOperationResultList.add(v2TIMFollowOperationResult);
                    }
                    callback.onSuccess(v2TIMFollowOperationResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().unfollowUser(userIDList, new IMCallback<List<FollowOperationResult>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FollowOperationResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getMyFollowingList(String nextCursor, final V2TIMValueCallback<V2TIMUserInfoResult> callback) {
        if (nextCursor == null) {
            nextCursor = "";
        }
        V2TIMValueCallback<UserInfoResult> v2TIMValueCallback = new V2TIMValueCallback<UserInfoResult>(){

            @Override
            public void onSuccess(UserInfoResult userInfoResult) {
                if (callback != null) {
                    V2TIMUserInfoResult v2TIMUserInfoResult = new V2TIMUserInfoResult();
                    ArrayList<V2TIMUserFullInfo> v2TIMUserFullInfoList = new ArrayList<V2TIMUserFullInfo>();
                    for (UserInfo userInfo : userInfoResult.getUserInfoList()) {
                        V2TIMUserFullInfo v2TIMUserInfo = new V2TIMUserFullInfo();
                        v2TIMUserInfo.setUserInfo(userInfo);
                        v2TIMUserFullInfoList.add(v2TIMUserInfo);
                    }
                    v2TIMUserInfoResult.setUserFullInfoResult(userInfoResult.getNextCursor(), v2TIMUserFullInfoList);
                    callback.onSuccess(v2TIMUserInfoResult);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().getMyFollowingList(nextCursor, new IMCallback<UserInfoResult>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(UserInfoResult data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getMyFollowersList(String nextCursor, final V2TIMValueCallback<V2TIMUserInfoResult> callback) {
        if (nextCursor == null) {
            nextCursor = "";
        }
        V2TIMValueCallback<UserInfoResult> v2TIMValueCallback = new V2TIMValueCallback<UserInfoResult>(){

            @Override
            public void onSuccess(UserInfoResult userInfoResult) {
                if (callback != null) {
                    V2TIMUserInfoResult v2TIMUserInfoResult = new V2TIMUserInfoResult();
                    ArrayList<V2TIMUserFullInfo> v2TIMUserFullInfoList = new ArrayList<V2TIMUserFullInfo>();
                    for (UserInfo userInfo : userInfoResult.getUserInfoList()) {
                        V2TIMUserFullInfo v2TIMUserInfo = new V2TIMUserFullInfo();
                        v2TIMUserInfo.setUserInfo(userInfo);
                        v2TIMUserFullInfoList.add(v2TIMUserInfo);
                    }
                    v2TIMUserInfoResult.setUserFullInfoResult(userInfoResult.getNextCursor(), v2TIMUserFullInfoList);
                    callback.onSuccess(v2TIMUserInfoResult);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().getMyFollowersList(nextCursor, new IMCallback<UserInfoResult>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(UserInfoResult data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getMutualFollowersList(String nextCursor, final V2TIMValueCallback<V2TIMUserInfoResult> callback) {
        if (nextCursor == null) {
            nextCursor = "";
        }
        V2TIMValueCallback<UserInfoResult> v2TIMValueCallback = new V2TIMValueCallback<UserInfoResult>(){

            @Override
            public void onSuccess(UserInfoResult userInfoResult) {
                if (callback != null) {
                    V2TIMUserInfoResult v2TIMUserInfoResult = new V2TIMUserInfoResult();
                    ArrayList<V2TIMUserFullInfo> v2TIMUserFullInfoList = new ArrayList<V2TIMUserFullInfo>();
                    for (UserInfo userInfo : userInfoResult.getUserInfoList()) {
                        V2TIMUserFullInfo v2TIMUserInfo = new V2TIMUserFullInfo();
                        v2TIMUserInfo.setUserInfo(userInfo);
                        v2TIMUserFullInfoList.add(v2TIMUserInfo);
                    }
                    v2TIMUserInfoResult.setUserFullInfoResult(userInfoResult.getNextCursor(), v2TIMUserFullInfoList);
                    callback.onSuccess(v2TIMUserInfoResult);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().getMutualFollowersList(nextCursor, new IMCallback<UserInfoResult>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(UserInfoResult data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getUserFollowInfo(List<String> userIDList, final V2TIMValueCallback<List<V2TIMFollowInfo>> callback) {
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "userIDList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<FollowInfo>> v2TIMValueCallback = new V2TIMValueCallback<List<FollowInfo>>(){

            @Override
            public void onSuccess(List<FollowInfo> followInfoList) {
                if (callback != null) {
                    ArrayList<V2TIMFollowInfo> v2TIMFollowInfoList = new ArrayList<V2TIMFollowInfo>();
                    for (FollowInfo followInfo : followInfoList) {
                        V2TIMFollowInfo v2TIMFollowInfo = new V2TIMFollowInfo();
                        v2TIMFollowInfo.setFollowInfo(followInfo);
                        v2TIMFollowInfoList.add(v2TIMFollowInfo);
                    }
                    callback.onSuccess(v2TIMFollowInfoList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().getUserFollowInfo(userIDList, new IMCallback<List<FollowInfo>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FollowInfo> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void checkFollowType(List<String> userIDList, final V2TIMValueCallback<List<V2TIMFollowTypeCheckResult>> callback) {
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "userIDList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<FollowTypeCheckResult>> v2TIMValueCallback = new V2TIMValueCallback<List<FollowTypeCheckResult>>(){

            @Override
            public void onSuccess(List<FollowTypeCheckResult> followTypeCheckResultList) {
                if (callback != null) {
                    ArrayList<V2TIMFollowTypeCheckResult> v2TIMFollowTypeCheckResultList = new ArrayList<V2TIMFollowTypeCheckResult>();
                    for (FollowTypeCheckResult followTypeCheckResult : followTypeCheckResultList) {
                        V2TIMFollowTypeCheckResult v2TIMFollowTypeCheckResult = new V2TIMFollowTypeCheckResult();
                        v2TIMFollowTypeCheckResult.setFollowTypeCheckResult(followTypeCheckResult);
                        v2TIMFollowTypeCheckResultList.add(v2TIMFollowTypeCheckResult);
                    }
                    callback.onSuccess(v2TIMFollowTypeCheckResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().checkFollowType(userIDList, new IMCallback<List<FollowTypeCheckResult>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FollowTypeCheckResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void subscribeOfficialAccount(String officialAccountID, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)officialAccountID)) {
            if (callback != null) {
                callback.onError(6017, "officialAccountID is empty");
            }
            return;
        }
        RelationshipManager.getInstance().subscribeOfficialAccount(officialAccountID, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void unsubscribeOfficialAccount(String officialAccountID, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)officialAccountID)) {
            if (callback != null) {
                callback.onError(6017, "officialAccountID is empty");
            }
            return;
        }
        RelationshipManager.getInstance().unsubscribeOfficialAccount(officialAccountID, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getOfficialAccountsInfo(List<String> officialAccountIDList, final V2TIMValueCallback<List<V2TIMOfficialAccountInfoResult>> callback) {
        V2TIMValueCallback<List<OfficialAccountInfoResult>> v2TIMValueCallback = new V2TIMValueCallback<List<OfficialAccountInfoResult>>(){

            @Override
            public void onSuccess(List<OfficialAccountInfoResult> officialAccountInfoResults) {
                if (callback != null) {
                    ArrayList<V2TIMOfficialAccountInfoResult> v2TIMOfficialAccountInfoResultList = new ArrayList<V2TIMOfficialAccountInfoResult>();
                    for (OfficialAccountInfoResult infoResult : officialAccountInfoResults) {
                        V2TIMOfficialAccountInfoResult v2TIMOfficialAccountInfoResult = new V2TIMOfficialAccountInfoResult();
                        v2TIMOfficialAccountInfoResult.setOfficialAccountInfoResult(infoResult);
                        v2TIMOfficialAccountInfoResultList.add(v2TIMOfficialAccountInfoResult);
                    }
                    callback.onSuccess(v2TIMOfficialAccountInfoResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().getOfficialAccountsInfo(officialAccountIDList, new IMCallback<List<OfficialAccountInfoResult>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<OfficialAccountInfoResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private void initFriendshipListener() {
        this.mFriendshipInternalListener = new FriendshipListener(){

            V2TIMFriendInfo convertToV2FriendInfo(FriendInfo friendInfo) {
                V2TIMFriendInfo v2TIMFriendInfo = new V2TIMFriendInfo();
                if (friendInfo != null) {
                    v2TIMFriendInfo.setFriendInfo(friendInfo);
                }
                return v2TIMFriendInfo;
            }

            List<V2TIMFriendInfo> convertToV2FriendInfoList(List<FriendInfo> friendInfoList) {
                ArrayList<V2TIMFriendInfo> v2TIMFriendInfoList = new ArrayList<V2TIMFriendInfo>();
                for (FriendInfo friendInfo : friendInfoList) {
                    v2TIMFriendInfoList.add(this.convertToV2FriendInfo(friendInfo));
                }
                return v2TIMFriendInfoList;
            }

            @Override
            public void onSelfInfoUpdated(UserInfo userInfo) {
            }

            @Override
            public void onFriendInfoChanged(List<FriendInfo> friendInfoList) {
                List<V2TIMFriendInfo> v2TIMFriendInfoList = this.convertToV2FriendInfoList(friendInfoList);
                List<V2TIMFriendInfo> unmodifiableList = Collections.unmodifiableList(v2TIMFriendInfoList);
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onFriendInfoChanged(unmodifiableList);
                }
            }

            @Override
            public void onFriendListAdded(List<FriendInfo> friendInfoList) {
                List<V2TIMFriendInfo> v2TIMFriendInfoList = this.convertToV2FriendInfoList(friendInfoList);
                List<V2TIMFriendInfo> unmodifiableList = Collections.unmodifiableList(v2TIMFriendInfoList);
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onFriendListAdded(unmodifiableList);
                }
            }

            @Override
            public void onFriendListDeleted(List<String> userIDList) {
                List<String> unmodifiableList = Collections.unmodifiableList(userIDList);
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onFriendListDeleted(unmodifiableList);
                }
            }

            @Override
            public void onBlackListAdded(List<FriendInfo> friendInfoList) {
                List<V2TIMFriendInfo> v2TIMFriendInfoList = this.convertToV2FriendInfoList(friendInfoList);
                List<V2TIMFriendInfo> unmodifiableList = Collections.unmodifiableList(v2TIMFriendInfoList);
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onBlackListAdd(unmodifiableList);
                }
            }

            @Override
            public void onBlackListDeleted(List<String> userIDList) {
                List<String> unmodifiableList = Collections.unmodifiableList(userIDList);
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onBlackListDeleted(unmodifiableList);
                }
            }

            @Override
            public void onFriendApplicationListAdded(List<FriendApplication> applicationList) {
                ArrayList<V2TIMFriendApplication> v2TIMFriendApplicationList = new ArrayList<V2TIMFriendApplication>();
                for (FriendApplication friendApplication : applicationList) {
                    V2TIMFriendApplication v2TIMFriendApplication = new V2TIMFriendApplication();
                    v2TIMFriendApplication.setFriendApplication(friendApplication);
                    v2TIMFriendApplicationList.add(v2TIMFriendApplication);
                }
                List<V2TIMFriendApplication> unmodifiableList = Collections.unmodifiableList(v2TIMFriendApplicationList);
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onFriendApplicationListAdded(unmodifiableList);
                }
            }

            @Override
            public void onFriendApplicationListDelete(List<String> userIDList) {
                List<String> unmodifiableList = Collections.unmodifiableList(userIDList);
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onFriendApplicationListDeleted(unmodifiableList);
                }
            }

            @Override
            public void onFriendApplicationListRead() {
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onFriendApplicationListRead();
                }
            }

            V2TIMOfficialAccountInfo convertToV2OfficialAccountInfo(OfficialAccountInfo officialAccountInfo) {
                V2TIMOfficialAccountInfo v2TIMOfficialAccountInfo = new V2TIMOfficialAccountInfo();
                if (officialAccountInfo != null) {
                    v2TIMOfficialAccountInfo.setOfficialAccountInfo(officialAccountInfo);
                }
                return v2TIMOfficialAccountInfo;
            }

            @Override
            public void onOfficialAccountSubscribed(OfficialAccountInfo officialAccountInfo) {
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    V2TIMOfficialAccountInfo v2TIMOfficialAccountInfo = this.convertToV2OfficialAccountInfo(officialAccountInfo);
                    listener.onOfficialAccountSubscribed(v2TIMOfficialAccountInfo);
                }
            }

            @Override
            public void onOfficialAccountUnsubscribed(String officialAccountID) {
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onOfficialAccountUnsubscribed(officialAccountID);
                }
            }

            @Override
            public void onOfficialAccountDeleted(String officialAccountID) {
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onOfficialAccountDeleted(officialAccountID);
                }
            }

            @Override
            public void onOfficialAccountInfoChanged(OfficialAccountInfo officialAccountInfo) {
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    V2TIMOfficialAccountInfo v2TIMOfficialAccountInfo = this.convertToV2OfficialAccountInfo(officialAccountInfo);
                    listener.onOfficialAccountInfoChanged(v2TIMOfficialAccountInfo);
                }
            }

            @Override
            public void onMyFollowingListChanged(List<UserInfo> userInfoList, boolean isAdd) {
                ArrayList<V2TIMUserFullInfo> v2TIMUserInfoList = new ArrayList<V2TIMUserFullInfo>();
                for (UserInfo item : userInfoList) {
                    V2TIMUserFullInfo v2TIMUserInfo = new V2TIMUserFullInfo();
                    v2TIMUserInfo.setUserInfo(item);
                    v2TIMUserInfoList.add(v2TIMUserInfo);
                }
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onMyFollowingListChanged(v2TIMUserInfoList, isAdd);
                }
            }

            @Override
            public void onMyFollowersListChanged(List<UserInfo> userInfoList, boolean isAdd) {
                ArrayList<V2TIMUserFullInfo> v2TIMUserInfoList = new ArrayList<V2TIMUserFullInfo>();
                for (UserInfo item : userInfoList) {
                    V2TIMUserFullInfo v2TIMUserInfo = new V2TIMUserFullInfo();
                    v2TIMUserInfo.setUserInfo(item);
                    v2TIMUserInfoList.add(v2TIMUserInfo);
                }
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onMyFollowersListChanged(v2TIMUserInfoList, isAdd);
                }
            }

            @Override
            public void onMutualFollowersListChanged(List<UserInfo> userInfoList, boolean isAdd) {
                ArrayList<V2TIMUserFullInfo> v2TIMUserInfoList = new ArrayList<V2TIMUserFullInfo>();
                for (UserInfo item : userInfoList) {
                    V2TIMUserFullInfo v2TIMUserInfo = new V2TIMUserFullInfo();
                    v2TIMUserInfo.setUserInfo(item);
                    v2TIMUserInfoList.add(v2TIMUserInfo);
                }
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onMutualFollowersListChanged(v2TIMUserInfoList, isAdd);
                }
            }
        };
        RelationshipManager.getInstance().setFriendshipListener(this.mFriendshipInternalListener);
    }

    private static class V2TIMFriendshipManagerImplHolder {
        private static final V2TIMFriendshipManagerImpl v2TIMFriendshipManagerImpl = new V2TIMFriendshipManagerImpl();

        private V2TIMFriendshipManagerImplHolder() {
        }
    }
}

