/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import android.text.TextUtils;
import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMLog;
import com.tencent.imsdk.group.GroupApplicationResult;
import com.tencent.imsdk.group.GroupInfo;
import com.tencent.imsdk.group.GroupInfoGetResult;
import com.tencent.imsdk.group.GroupInfoModifyParam;
import com.tencent.imsdk.group.GroupManager;
import com.tencent.imsdk.group.GroupMemberInfo;
import com.tencent.imsdk.group.GroupMemberInfoModifyParam;
import com.tencent.imsdk.group.GroupMemberInfoResult;
import com.tencent.imsdk.group.GroupMemberOperationResult;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMCommunityManagerImpl;
import com.tencent.imsdk.v2.V2TIMCreateGroupMemberInfo;
import com.tencent.imsdk.v2.V2TIMGroupApplication;
import com.tencent.imsdk.v2.V2TIMGroupApplicationResult;
import com.tencent.imsdk.v2.V2TIMGroupInfo;
import com.tencent.imsdk.v2.V2TIMGroupInfoResult;
import com.tencent.imsdk.v2.V2TIMGroupManager;
import com.tencent.imsdk.v2.V2TIMGroupMemberFullInfo;
import com.tencent.imsdk.v2.V2TIMGroupMemberInfoResult;
import com.tencent.imsdk.v2.V2TIMGroupMemberOperationResult;
import com.tencent.imsdk.v2.V2TIMGroupMemberSearchParam;
import com.tencent.imsdk.v2.V2TIMGroupSearchParam;
import com.tencent.imsdk.v2.V2TIMTopicInfo;
import com.tencent.imsdk.v2.V2TIMTopicInfoResult;
import com.tencent.imsdk.v2.V2TIMTopicOperationResult;
import com.tencent.imsdk.v2.V2TIMValueCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class V2TIMGroupManagerImpl
extends V2TIMGroupManager {
    private static final String TAG = "V2TIMAdvGroupMgrImpl";

    static V2TIMGroupManagerImpl getInstance() {
        return V2TIMGroupManagerImplHolder.v2TIMGroupManagerImpl;
    }

    private V2TIMGroupManagerImpl() {
    }

    @Override
    public void createGroup(V2TIMGroupInfo info, List<V2TIMCreateGroupMemberInfo> memberList, V2TIMValueCallback<String> callback) {
        if (info == null) {
            IMLog.e(TAG, "createGroup, null info");
            if (callback != null) {
                callback.onError(6017, "info is null");
            }
            return;
        }
        ArrayList<GroupMemberInfo> groupMembers = new ArrayList<GroupMemberInfo>();
        if (memberList != null) {
            for (V2TIMCreateGroupMemberInfo item : memberList) {
                GroupMemberInfo member = new GroupMemberInfo();
                member.setUserID(item.getUserID());
                member.setRole(item.getRole());
                groupMembers.add(member);
            }
        }
        GroupManager.getInstance().createGroup(info.getGroupInfo(), groupMembers, new IMCallback<String>(callback){

            @Override
            public void success(String data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getGroupsInfo(List<String> groupIDList, final V2TIMValueCallback<List<V2TIMGroupInfoResult>> callback) {
        if (groupIDList == null || groupIDList.size() == 0) {
            IMLog.e(TAG, "getGroupsInfo error, empty groupIDList");
            if (callback != null) {
                callback.onError(6017, "empty groupIDList");
            }
            return;
        }
        V2TIMValueCallback<List<GroupInfoGetResult>> v2Callback = new V2TIMValueCallback<List<GroupInfoGetResult>>(){

            @Override
            public void onSuccess(List<GroupInfoGetResult> groupInfoGetResults) {
                if (callback != null) {
                    ArrayList<V2TIMGroupInfoResult> groupInfoList = new ArrayList<V2TIMGroupInfoResult>();
                    for (GroupInfoGetResult item : groupInfoGetResults) {
                        V2TIMGroupInfoResult groupInfo = new V2TIMGroupInfoResult();
                        groupInfo.setGroupInfoGetResult(item);
                        groupInfoList.add(groupInfo);
                    }
                    callback.onSuccess(groupInfoList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        GroupManager.getInstance().getGroupsInfo(groupIDList, new IMCallback<List<GroupInfoGetResult>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<GroupInfoGetResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void searchGroups(V2TIMGroupSearchParam searchParam, final V2TIMValueCallback<List<V2TIMGroupInfo>> callback) {
        if (searchParam == null) {
            if (callback != null) {
                callback.onError(6017, "searchParam is null");
            }
            return;
        }
        if (searchParam.getKeywordList() == null || searchParam.getKeywordList().size() == 0) {
            if (callback != null) {
                callback.onError(6017, "empty keywordList");
            }
            return;
        }
        V2TIMValueCallback<List<GroupInfo>> v2Callback = new V2TIMValueCallback<List<GroupInfo>>(){

            @Override
            public void onSuccess(List<GroupInfo> groupInfos) {
                ArrayList<V2TIMGroupInfo> groupInfoList = new ArrayList<V2TIMGroupInfo>();
                for (GroupInfo item : groupInfos) {
                    V2TIMGroupInfo groupInfo = new V2TIMGroupInfo();
                    groupInfo.setGroupInfo(item);
                    groupInfoList.add(groupInfo);
                }
                callback.onSuccess(groupInfoList);
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        GroupManager.getInstance().searchGroups(searchParam.getGroupSearchParam(), new IMCallback<List<GroupInfo>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<GroupInfo> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
        BaseManager.getInstance().reportTUIComponentUsage(6L);
    }

    @Override
    public void setGroupInfo(V2TIMGroupInfo info, V2TIMCallback callback) {
        if (info == null) {
            IMLog.e(TAG, "setGroupInfo error, null info");
            if (callback != null) {
                callback.onError(6017, "null info");
            }
            return;
        }
        long modifyFlag = info.getModifyFlag();
        GroupInfo groupInfo = info.getGroupInfo();
        GroupInfoModifyParam groupInfoModifyParam = new GroupInfoModifyParam();
        groupInfoModifyParam.setGroupInfo(groupInfo);
        groupInfoModifyParam.setModifyFlag(modifyFlag);
        GroupManager.getInstance().setGroupInfo(groupInfoModifyParam, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void initGroupAttributes(String groupID, HashMap<String, String> attributes, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            IMLog.e(TAG, "initGroupAttributes error, groupID is empty");
            if (callback != null) {
                callback.onError(6017, "groupID is empty");
            }
            return;
        }
        GroupManager.getInstance().initGroupAttributes(groupID, attributes, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void setGroupAttributes(String groupID, HashMap<String, String> attributes, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            IMLog.e(TAG, "setGroupAttributes error, groupID is empty");
            if (callback != null) {
                callback.onError(6017, "groupID is empty");
            }
            return;
        }
        if (attributes == null || attributes.size() == 0) {
            IMLog.e(TAG, "setGroupAttributes error, attributes is empty");
            if (callback != null) {
                callback.onError(6017, "attributes is empty");
            }
            return;
        }
        GroupManager.getInstance().setGroupAttributes(groupID, attributes, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void deleteGroupAttributes(String groupID, List<String> keys, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            IMLog.e(TAG, "deleteGroupAttributes error, groupID is empty");
            if (callback != null) {
                callback.onError(6017, "groupID is empty");
            }
            return;
        }
        GroupManager.getInstance().deleteGroupAttributes(groupID, keys, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getGroupAttributes(String groupID, List<String> keys, V2TIMValueCallback<Map<String, String>> callback) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            IMLog.e(TAG, "getGroupAttributes error, groupID is empty");
            if (callback != null) {
                callback.onError(6017, "groupID is empty");
            }
            return;
        }
        GroupManager.getInstance().getGroupAttributes(groupID, keys, new IMCallback<Map<String, String>>(callback){

            @Override
            public void success(Map<String, String> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getGroupOnlineMemberCount(String groupId, V2TIMValueCallback<Integer> callback) {
        if (TextUtils.isEmpty((CharSequence)groupId)) {
            if (callback != null) {
                callback.onError(6017, "groupID is empty");
            }
            return;
        }
        GroupManager.getInstance().getGroupOnlineMemberCount(groupId, new IMCallback<Integer>(callback){

            @Override
            public void success(Integer data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void setGroupCounters(String groupID, HashMap<String, Long> counters, V2TIMValueCallback<Map<String, Long>> callback) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            IMLog.e(TAG, "setGroupCounters error, groupID is empty");
            if (callback != null) {
                callback.onError(6017, "groupID is empty");
            }
            return;
        }
        if (counters == null || counters.isEmpty()) {
            IMLog.e(TAG, "setGroupCounters error, counters is empty");
            if (callback != null) {
                callback.onError(6017, "counters is empty");
            }
            return;
        }
        GroupManager.getInstance().setGroupCounters(groupID, counters, new IMCallback<Map<String, Long>>(callback){

            @Override
            public void success(Map<String, Long> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getGroupCounters(String groupID, List<String> keys, V2TIMValueCallback<Map<String, Long>> callback) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            IMLog.e(TAG, "setGroupCounters error, groupID is empty");
            if (callback != null) {
                callback.onError(6017, "groupID is empty");
            }
            return;
        }
        GroupManager.getInstance().getGroupCounters(groupID, keys, new IMCallback<Map<String, Long>>(callback){

            @Override
            public void success(Map<String, Long> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void increaseGroupCounter(String groupID, String key, long value, V2TIMValueCallback<Map<String, Long>> callback) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            IMLog.e(TAG, "setGroupCounters error, groupID is empty");
            if (callback != null) {
                callback.onError(6017, "groupID is empty");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)key)) {
            IMLog.e(TAG, "setGroupCounters error, key is empty");
            if (callback != null) {
                callback.onError(6017, "key is empty");
            }
            return;
        }
        GroupManager.getInstance().increaseGroupCounter(groupID, key, value, new IMCallback<Map<String, Long>>(callback){

            @Override
            public void success(Map<String, Long> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void decreaseGroupCounter(String groupID, String key, long value, V2TIMValueCallback<Map<String, Long>> callback) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            IMLog.e(TAG, "setGroupCounters error, groupID is empty");
            if (callback != null) {
                callback.onError(6017, "groupID is empty");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)key)) {
            IMLog.e(TAG, "setGroupCounters error, key is empty");
            if (callback != null) {
                callback.onError(6017, "key is empty");
            }
            return;
        }
        GroupManager.getInstance().decreaseGroupCounter(groupID, key, value, new IMCallback<Map<String, Long>>(callback){

            @Override
            public void success(Map<String, Long> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getGroupMemberList(String groupID, int filter, long nextSeq, final V2TIMValueCallback<V2TIMGroupMemberInfoResult> callback) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            IMLog.e(TAG, "getGroupMemberList error, groupID is empty");
            if (callback != null) {
                callback.onError(6017, "groupID is empty");
            }
            return;
        }
        int filterFlag = GroupMemberInfo.GROUP_MEMBER_FILTER_FLAG_ALL;
        switch (filter) {
            case 0: {
                filterFlag = GroupMemberInfo.GROUP_MEMBER_FILTER_FLAG_ALL;
                break;
            }
            case 1: {
                filterFlag = GroupMemberInfo.GROUP_MEMBER_FILTER_FLAG_OWNER;
                break;
            }
            case 2: {
                filterFlag = GroupMemberInfo.GROUP_MEMBER_FILTER_FLAG_ADMINISTRATOR;
                break;
            }
            case 4: {
                filterFlag = GroupMemberInfo.GROUP_MEMBER_FILTER_FLAG_MEMBER;
                break;
            }
            default: {
                filterFlag = filter;
            }
        }
        V2TIMValueCallback<GroupMemberInfoResult> v2Callback = new V2TIMValueCallback<GroupMemberInfoResult>(){

            @Override
            public void onSuccess(GroupMemberInfoResult groupMemberInfoResult) {
                if (callback != null) {
                    V2TIMGroupMemberInfoResult result = new V2TIMGroupMemberInfoResult();
                    result.setGroupMemberInfoResult(groupMemberInfoResult);
                    callback.onSuccess(result);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        GroupManager.getInstance().getGroupMemberList(groupID, filterFlag, nextSeq, new IMCallback<GroupMemberInfoResult>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(GroupMemberInfoResult data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getGroupMembersInfo(String groupID, List<String> memberList, final V2TIMValueCallback<List<V2TIMGroupMemberFullInfo>> callback) {
        if (memberList == null || memberList.size() == 0) {
            IMLog.e(TAG, "getGroupMembersInfo fail, memberList is empty");
            if (callback != null) {
                callback.onError(6017, "memberList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<GroupMemberInfo>> v2Callback = new V2TIMValueCallback<List<GroupMemberInfo>>(){

            @Override
            public void onSuccess(List<GroupMemberInfo> groupMemberInfos) {
                if (callback != null) {
                    ArrayList<V2TIMGroupMemberFullInfo> resultList = new ArrayList<V2TIMGroupMemberFullInfo>();
                    for (GroupMemberInfo item : groupMemberInfos) {
                        V2TIMGroupMemberFullInfo member = new V2TIMGroupMemberFullInfo();
                        member.setGroupMemberInfo(item);
                        resultList.add(member);
                    }
                    callback.onSuccess(resultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        GroupManager.getInstance().getGroupMembersInfo(groupID, memberList, new IMCallback<List<GroupMemberInfo>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<GroupMemberInfo> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void searchGroupMembers(V2TIMGroupMemberSearchParam searchParam, final V2TIMValueCallback<HashMap<String, List<V2TIMGroupMemberFullInfo>>> callback) {
        if (searchParam == null) {
            if (callback != null) {
                callback.onError(6017, "searchParam is null");
            }
            return;
        }
        if (null == searchParam.getKeywordList() || searchParam.getKeywordList().isEmpty()) {
            if (callback != null) {
                callback.onError(6017, "keywordList cannot be empty");
            }
            return;
        }
        V2TIMValueCallback<HashMap<String, List<GroupMemberInfo>>> v2Callback = new V2TIMValueCallback<HashMap<String, List<GroupMemberInfo>>>(){

            @Override
            public void onSuccess(HashMap<String, List<GroupMemberInfo>> memberHashMap) {
                HashMap resultMap = new HashMap();
                for (Map.Entry<String, List<GroupMemberInfo>> entry : memberHashMap.entrySet()) {
                    ArrayList<V2TIMGroupMemberFullInfo> v2TIMGroupMemberFullInfoList = new ArrayList<V2TIMGroupMemberFullInfo>();
                    List<GroupMemberInfo> memberInfoList = entry.getValue();
                    for (GroupMemberInfo groupMemberInfo : memberInfoList) {
                        V2TIMGroupMemberFullInfo v2TIMGroupMemberFullInfo = new V2TIMGroupMemberFullInfo();
                        v2TIMGroupMemberFullInfo.setGroupMemberInfo(groupMemberInfo);
                        v2TIMGroupMemberFullInfoList.add(v2TIMGroupMemberFullInfo);
                    }
                    resultMap.put(entry.getKey(), v2TIMGroupMemberFullInfoList);
                }
                if (callback != null) {
                    callback.onSuccess(resultMap);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        GroupManager.getInstance().searchGroupMembersInfo(searchParam.getGroupMemberSearchParam(), new IMCallback<HashMap<String, List<GroupMemberInfo>>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(HashMap<String, List<GroupMemberInfo>> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
        BaseManager.getInstance().reportTUIComponentUsage(6L);
    }

    @Override
    public void setGroupMemberInfo(String groupID, V2TIMGroupMemberFullInfo profile, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupID) || profile == null) {
            IMLog.e(TAG, "setGroupMemberInfo error, groupID is empty or profile is null");
            if (callback != null) {
                callback.onError(6017, "groupID is empty or profile is null");
            }
            return;
        }
        GroupMemberInfoModifyParam param = new GroupMemberInfoModifyParam();
        param.setModifyFlag(profile.getModifyFlag());
        param.setMemberInfo(profile.getGroupMemberInfo());
        param.getMemberInfo().setGroupID(groupID);
        GroupManager.getInstance().setGroupMemberInfo(param, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void muteGroupMember(String groupID, String userID, int seconds, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupID) || TextUtils.isEmpty((CharSequence)userID)) {
            if (callback != null) {
                callback.onError(6017, "groupID or userID is empty");
            }
            return;
        }
        GroupManager.getInstance().muteGroupMember(groupID, userID, seconds, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void muteAllGroupMembers(String groupID, boolean isMute, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            if (callback != null) {
                callback.onError(6017, "groupID is empty");
            }
            return;
        }
        GroupManager.getInstance().muteAllGroupMembers(groupID, isMute, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void inviteUserToGroup(String groupID, List<String> userList, final V2TIMValueCallback<List<V2TIMGroupMemberOperationResult>> callback) {
        if (TextUtils.isEmpty((CharSequence)groupID) || userList == null || userList.isEmpty()) {
            IMLog.e(TAG, "inviteUserToGroup error, groupID or userList is empty");
            if (callback != null) {
                callback.onError(6017, "groupID or userList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<GroupMemberOperationResult>> v2Callback = new V2TIMValueCallback<List<GroupMemberOperationResult>>(){

            @Override
            public void onSuccess(List<GroupMemberOperationResult> groupMemberOperationResults) {
                if (callback != null) {
                    ArrayList<V2TIMGroupMemberOperationResult> results = new ArrayList<V2TIMGroupMemberOperationResult>();
                    for (GroupMemberOperationResult item : groupMemberOperationResults) {
                        V2TIMGroupMemberOperationResult result = new V2TIMGroupMemberOperationResult();
                        result.setGroupMemberOperationResult(item);
                        results.add(result);
                    }
                    callback.onSuccess(results);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        GroupManager.getInstance().inviteUserToGroup(groupID, userList, new IMCallback<List<GroupMemberOperationResult>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<GroupMemberOperationResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void kickGroupMember(String groupID, List<String> memberList, String reason, final V2TIMValueCallback<List<V2TIMGroupMemberOperationResult>> callback) {
        if (TextUtils.isEmpty((CharSequence)groupID) || memberList == null || memberList.size() == 0) {
            IMLog.e(TAG, "kickGroupMember error, groupID or memberList is empty");
            if (callback != null) {
                callback.onError(6017, "groupID or memberList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<GroupMemberOperationResult>> v2Callback = new V2TIMValueCallback<List<GroupMemberOperationResult>>(){

            @Override
            public void onSuccess(List<GroupMemberOperationResult> groupMemberOperationResults) {
                if (callback != null) {
                    ArrayList<V2TIMGroupMemberOperationResult> results = new ArrayList<V2TIMGroupMemberOperationResult>();
                    for (GroupMemberOperationResult item : groupMemberOperationResults) {
                        V2TIMGroupMemberOperationResult result = new V2TIMGroupMemberOperationResult();
                        result.setGroupMemberOperationResult(item);
                        results.add(result);
                    }
                    callback.onSuccess(results);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        GroupManager.getInstance().kickGroupMember(groupID, memberList, reason, new IMCallback<List<GroupMemberOperationResult>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<GroupMemberOperationResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void kickGroupMember(String groupID, List<String> memberList, String reason, int duration, final V2TIMValueCallback<List<V2TIMGroupMemberOperationResult>> callback) {
        if (TextUtils.isEmpty((CharSequence)groupID) || memberList == null || memberList.size() == 0) {
            IMLog.e(TAG, "kickGroupMember error, groupID or memberList is empty");
            if (callback != null) {
                callback.onError(6017, "groupID or memberList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<GroupMemberOperationResult>> v2Callback = new V2TIMValueCallback<List<GroupMemberOperationResult>>(){

            @Override
            public void onSuccess(List<GroupMemberOperationResult> groupMemberOperationResults) {
                if (callback != null) {
                    ArrayList<V2TIMGroupMemberOperationResult> results = new ArrayList<V2TIMGroupMemberOperationResult>();
                    for (GroupMemberOperationResult item : groupMemberOperationResults) {
                        V2TIMGroupMemberOperationResult result = new V2TIMGroupMemberOperationResult();
                        result.setGroupMemberOperationResult(item);
                        results.add(result);
                    }
                    callback.onSuccess(results);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        GroupManager.getInstance().banGroupMember(groupID, memberList, reason, duration, new IMCallback<List<GroupMemberOperationResult>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<GroupMemberOperationResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void setGroupMemberRole(String groupID, String userID, int role, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupID) || TextUtils.isEmpty((CharSequence)userID)) {
            IMLog.e(TAG, "setGroupMemberRole error, groupID or userID is empty");
            if (callback != null) {
                callback.onError(6017, "groupID or userID is empty");
            }
            return;
        }
        int memberRole = GroupMemberInfo.MEMBER_ROLE_MEMBER;
        memberRole = 400 == role ? GroupMemberInfo.MEMBER_ROLE_OWNER : (300 == role ? GroupMemberInfo.MEMBER_ROLE_ADMINISTRATOR : role);
        GroupManager.getInstance().setGroupMemberRole(groupID, userID, memberRole, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void markGroupMemberList(String groupID, List<String> memberIDList, int markType, boolean enableMark, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            if (callback != null) {
                callback.onError(6017, "invalid groupID");
            }
            return;
        }
        if (memberIDList == null || memberIDList.isEmpty()) {
            if (callback != null) {
                callback.onError(6017, "empty member list");
            }
            return;
        }
        GroupManager.getInstance().markGroupMemberList(groupID, memberIDList, markType, enableMark, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void transferGroupOwner(String groupID, String userID, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupID) || TextUtils.isEmpty((CharSequence)userID)) {
            IMLog.e(TAG, "transferGroupOwner error, groupID or userID is empty");
            if (callback != null) {
                callback.onError(6017, "groupID or userID is empty");
            }
            return;
        }
        GroupManager.getInstance().transferGroupOwner(groupID, userID, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getJoinedGroupList(final V2TIMValueCallback<List<V2TIMGroupInfo>> callback) {
        V2TIMValueCallback<List<GroupInfo>> v2Callback = new V2TIMValueCallback<List<GroupInfo>>(){

            @Override
            public void onSuccess(List<GroupInfo> groupInfoList) {
                if (callback != null) {
                    ArrayList<V2TIMGroupInfo> v2GroupInfoList = new ArrayList<V2TIMGroupInfo>();
                    for (GroupInfo item : groupInfoList) {
                        V2TIMGroupInfo v2GroupInfo = new V2TIMGroupInfo();
                        v2GroupInfo.setGroupInfo(item);
                        v2GroupInfoList.add(v2GroupInfo);
                    }
                    callback.onSuccess(v2GroupInfoList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        GroupManager.getInstance().getJoinedGroupList(new IMCallback<List<GroupInfo>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<GroupInfo> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getJoinedCommunityList(final V2TIMValueCallback<List<V2TIMGroupInfo>> callback) {
        V2TIMValueCallback<List<GroupInfo>> v2Callback = new V2TIMValueCallback<List<GroupInfo>>(){

            @Override
            public void onSuccess(List<GroupInfo> groupInfoList) {
                if (callback != null) {
                    ArrayList<V2TIMGroupInfo> v2GroupInfoList = new ArrayList<V2TIMGroupInfo>();
                    for (GroupInfo item : groupInfoList) {
                        V2TIMGroupInfo v2GroupInfo = new V2TIMGroupInfo();
                        v2GroupInfo.setGroupInfo(item);
                        v2GroupInfoList.add(v2GroupInfo);
                    }
                    callback.onSuccess(v2GroupInfoList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        GroupManager.getInstance().getJoinedCommunityList(new IMCallback<List<GroupInfo>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<GroupInfo> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
        BaseManager.getInstance().reportTUIComponentUsage(8L);
    }

    @Override
    public void getGroupApplicationList(final V2TIMValueCallback<V2TIMGroupApplicationResult> callback) {
        V2TIMValueCallback<GroupApplicationResult> v2Callback = new V2TIMValueCallback<GroupApplicationResult>(){

            @Override
            public void onSuccess(GroupApplicationResult groupApplicationResult) {
                if (callback != null) {
                    V2TIMGroupApplicationResult result = new V2TIMGroupApplicationResult();
                    result.setGroupApplicationResult(groupApplicationResult);
                    callback.onSuccess(result);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        GroupManager.getInstance().getGroupApplicationList(new IMCallback<GroupApplicationResult>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(GroupApplicationResult data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void acceptGroupApplication(V2TIMGroupApplication application, String reason, V2TIMCallback callback) {
        if (application == null) {
            IMLog.e(TAG, "acceptGroupApplication err, v2TIMGroupApplication is null");
            if (callback != null) {
                callback.onError(6017, "v2TIMGroupApplication is null");
            }
            return;
        }
        GroupManager.getInstance().acceptGroupApplication(application.getGroupApplication(), reason, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void refuseGroupApplication(V2TIMGroupApplication application, String reason, V2TIMCallback callback) {
        if (application == null) {
            IMLog.e(TAG, "acceptGroupApplication err, v2TIMGroupApplication is null");
            if (callback != null) {
                callback.onError(6017, "v2TIMGroupApplication is null");
            }
            return;
        }
        GroupManager.getInstance().refuseGroupApplication(application.getGroupApplication(), reason, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void setGroupApplicationRead(V2TIMCallback callback) {
        GroupManager.getInstance().setGroupApplicationRead(new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void createTopicInCommunity(String groupID, V2TIMTopicInfo topicInfo, V2TIMValueCallback<String> callback) {
        V2TIMCommunityManagerImpl.getInstance().createTopicInCommunity(groupID, topicInfo, callback);
    }

    @Override
    public void deleteTopicFromCommunity(String groupID, List<String> topicIDList, V2TIMValueCallback<List<V2TIMTopicOperationResult>> callback) {
        V2TIMCommunityManagerImpl.getInstance().deleteTopicFromCommunity(groupID, topicIDList, callback);
    }

    @Override
    public void setTopicInfo(V2TIMTopicInfo v2TIMTopicInfo, V2TIMCallback callback) {
        V2TIMCommunityManagerImpl.getInstance().setTopicInfo(v2TIMTopicInfo, callback);
    }

    @Override
    public void getTopicInfoList(String groupID, List<String> topicIDList, V2TIMValueCallback<List<V2TIMTopicInfoResult>> callback) {
        V2TIMCommunityManagerImpl.getInstance().getTopicInfoList(groupID, topicIDList, callback);
    }

    private static class V2TIMGroupManagerImplHolder {
        private static final V2TIMGroupManagerImpl v2TIMGroupManagerImpl = new V2TIMGroupManagerImpl();

        private V2TIMGroupManagerImplHolder() {
        }
    }
}

