/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import com.tencent.matrix.listeners.IAppForeground;
import com.tencent.matrix.util.MatrixHandlerThread;
import com.tencent.matrix.util.MatrixLog;
import java.util.HashSet;
import java.util.Set;

public enum AppActiveMatrixDelegate {
    INSTANCE;

    private static final String TAG = "Matrix.AppActiveDelegate";
    private final Set<IAppForeground> listeners = new HashSet<IAppForeground>();
    private boolean isAppForeground = false;
    private String visibleScene = "default";
    private Controller controller = new Controller();
    private boolean isInit = false;
    private String currentFragmentName;
    private Handler handler;

    public void init(Application application) {
        if (this.isInit) {
            MatrixLog.e(TAG, "has inited!", new Object[0]);
            return;
        }
        this.isInit = true;
        if (null != MatrixHandlerThread.getDefaultHandlerThread()) {
            this.handler = new Handler(MatrixHandlerThread.getDefaultHandlerThread().getLooper());
        }
        application.registerComponentCallbacks((ComponentCallbacks)this.controller);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.controller);
    }

    public String getCurrentFragmentName() {
        return this.currentFragmentName;
    }

    public void setCurrentFragmentName(String fragmentName) {
        MatrixLog.i(TAG, "[setCurrentFragmentName] fragmentName:%s", fragmentName);
        this.currentFragmentName = fragmentName;
        this.updateScene(fragmentName);
    }

    public String getVisibleScene() {
        return this.visibleScene;
    }

    private void onDispatchForeground(String visibleScene) {
        if (this.isAppForeground || !this.isInit) {
            return;
        }
        MatrixLog.i(TAG, "onForeground... visibleScene[%s]", visibleScene);
        this.handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AppActiveMatrixDelegate.this.isAppForeground = true;
                Set set = AppActiveMatrixDelegate.this.listeners;
                synchronized (set) {
                    for (IAppForeground listener : AppActiveMatrixDelegate.this.listeners) {
                        listener.onForeground(true);
                    }
                }
            }
        });
    }

    private void onDispatchBackground(String visibleScene) {
        if (!this.isAppForeground || !this.isInit) {
            return;
        }
        MatrixLog.i(TAG, "onBackground... visibleScene[%s]", visibleScene);
        this.handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AppActiveMatrixDelegate.this.isAppForeground = false;
                Set set = AppActiveMatrixDelegate.this.listeners;
                synchronized (set) {
                    for (IAppForeground listener : AppActiveMatrixDelegate.this.listeners) {
                        listener.onForeground(false);
                    }
                }
            }
        });
    }

    public boolean isAppForeground() {
        return this.isAppForeground;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IAppForeground listener) {
        Set<IAppForeground> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IAppForeground listener) {
        Set<IAppForeground> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    private void updateScene(Activity activity) {
        this.visibleScene = activity.getClass().getName();
    }

    private void updateScene(String currentFragmentName) {
        StringBuilder ss = new StringBuilder();
        ss.append(TextUtils.isEmpty((CharSequence)currentFragmentName) ? "?" : currentFragmentName);
        this.visibleScene = ss.toString();
    }

    /*
     * Exception decompiling
     */
    public static String getTopActivityName() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final class Controller
    implements Application.ActivityLifecycleCallbacks,
    ComponentCallbacks2 {
        private Controller() {
        }

        public void onActivityStarted(Activity activity) {
            AppActiveMatrixDelegate.this.updateScene(activity);
            AppActiveMatrixDelegate.this.onDispatchForeground(AppActiveMatrixDelegate.this.getVisibleScene());
        }

        public void onActivityStopped(Activity activity) {
            if (AppActiveMatrixDelegate.getTopActivityName() == null) {
                AppActiveMatrixDelegate.this.onDispatchBackground(AppActiveMatrixDelegate.this.getVisibleScene());
            }
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
        }

        public void onTrimMemory(int level) {
            MatrixLog.i(AppActiveMatrixDelegate.TAG, "[onTrimMemory] level:%s", level);
            if (level == 20 && AppActiveMatrixDelegate.this.isAppForeground) {
                AppActiveMatrixDelegate.this.onDispatchBackground(AppActiveMatrixDelegate.this.visibleScene);
            }
        }
    }
}

