/*
 * Decompiled with CFR 0.152.
 */
package com.android.dexdeps;

import java.util.Arrays;
import java.util.List;

public class MethodRef {
    private String mDeclClass;
    private String mReturnType;
    private String mMethodName;
    private String[] mArgTypes;

    public MethodRef(String declClass, String[] argTypes, String returnType, String methodName) {
        this.mDeclClass = declClass;
        this.mArgTypes = Arrays.copyOf(argTypes, argTypes.length);
        this.mReturnType = returnType;
        this.mMethodName = methodName;
    }

    public String getDeclClassName() {
        return this.mDeclClass;
    }

    public String getDescriptor() {
        return MethodRef.descriptorFromProtoArray(this.mArgTypes, this.mReturnType);
    }

    public String getName() {
        return this.mMethodName;
    }

    public List<String> getArgumentTypeNames() {
        return Arrays.asList(this.mArgTypes);
    }

    public String getReturnTypeName() {
        return this.mReturnType;
    }

    private static String descriptorFromProtoArray(String[] protos, String returnType) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (int i = 0; i < protos.length; ++i) {
            builder.append(protos[i]);
        }
        builder.append(")");
        builder.append(returnType);
        return builder.toString();
    }
}

