/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.javalib.util;

import java.util.regex.Pattern;

public final class Util {
    private Util() {
    }

    public static boolean isNullOrNil(String str) {
        return str == null || str.isEmpty();
    }

    public static String nullAsNil(String str) {
        return str == null ? "" : str;
    }

    public static boolean isNumber(String str) {
        Pattern pattern = Pattern.compile("\\d+");
        return pattern.matcher(str).matches();
    }

    public static String byteArrayToHex(byte[] data) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] str = new char[data.length * 2];
        int k = 0;
        for (int i = 0; i < data.length; ++i) {
            byte byte0 = data[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        return new String(str);
    }

    public static String formatByteUnit(long bytes) {
        if (bytes >= 0x100000L) {
            return String.format("%.2fMB", (double)bytes / 1048576.0);
        }
        if (bytes >= 1024L) {
            return String.format("%.2fKB", (double)bytes / 1024.0);
        }
        return String.format("%dBytes", bytes);
    }

    public static String globToRegexp(String glob) {
        StringBuilder sb = new StringBuilder(glob.length() * 2);
        int begin = 0;
        sb.append('^');
        int n = glob.length();
        for (int i = 0; i < n; ++i) {
            char c = glob.charAt(i);
            if (c == '*') {
                begin = Util.appendQuoted(sb, glob, begin, i) + 1;
                if (i < n - 1 && glob.charAt(i + 1) == '*') {
                    ++i;
                    ++begin;
                }
                sb.append(".*?");
                continue;
            }
            if (c != '?') continue;
            begin = Util.appendQuoted(sb, glob, begin, i) + 1;
            sb.append(".?");
        }
        Util.appendQuoted(sb, glob, begin, glob.length());
        sb.append('$');
        return sb.toString();
    }

    private static int appendQuoted(StringBuilder sb, String s, int from, int to) {
        if (to > from) {
            int i;
            boolean isSimple = true;
            for (i = from; i < to; ++i) {
                char c = s.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '/' || c == ' ') continue;
                isSimple = false;
                break;
            }
            if (isSimple) {
                for (i = from; i < to; ++i) {
                    sb.append(s.charAt(i));
                }
                return to;
            }
            sb.append(Pattern.quote(s.substring(from, to)));
        }
        return to;
    }

    public static String capitalize(String word) {
        if (word.isEmpty()) {
            return word;
        }
        char c = word.charAt(0);
        char upperChar = Character.toUpperCase(c);
        return upperChar + word.substring(1);
    }
}

