/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace;

import com.tencent.matrix.javalib.util.FileUtil;
import com.tencent.matrix.javalib.util.Util;
import com.tencent.matrix.trace.retrace.MappingCollector;
import java.util.HashSet;

public class Configuration {
    public String packageName;
    public String mappingDir;
    public String baseMethodMapPath;
    public String methodMapFilePath;
    public String ignoreMethodMapFilePath;
    public String blackListFilePath;
    public String traceClassOut;
    public HashSet<String> blackSet = new HashSet();

    Configuration(String packageName, String mappingDir, String baseMethodMapPath, String methodMapFilePath, String ignoreMethodMapFilePath, String blackListFilePath, String traceClassOut) {
        this.packageName = packageName;
        this.mappingDir = Util.nullAsNil((String)mappingDir);
        this.baseMethodMapPath = Util.nullAsNil((String)baseMethodMapPath);
        this.methodMapFilePath = Util.nullAsNil((String)methodMapFilePath);
        this.ignoreMethodMapFilePath = Util.nullAsNil((String)ignoreMethodMapFilePath);
        this.blackListFilePath = Util.nullAsNil((String)blackListFilePath);
        this.traceClassOut = Util.nullAsNil((String)traceClassOut);
    }

    public int parseBlackFile(MappingCollector processor) {
        String blackStr = "[package]\n-keeppackage android/\n-keeppackage com/tencent/matrix/\n" + FileUtil.readFileAsString((String)this.blackListFilePath);
        String[] blackArray = blackStr.trim().replace("/", ".").split("\n");
        if (blackArray != null) {
            for (String black : blackArray) {
                if (black.length() == 0 || black.startsWith("#") || black.startsWith("[")) continue;
                if (black.startsWith("-keepclass ")) {
                    black = black.replace("-keepclass ", "");
                    this.blackSet.add(processor.proguardClassName(black, black));
                    continue;
                }
                if (!black.startsWith("-keeppackage ")) continue;
                black = black.replace("-keeppackage ", "");
                this.blackSet.add(processor.proguardPackageName(black, black));
            }
        }
        return this.blackSet.size();
    }

    public String toString() {
        return "\n# Configuration\n|* packageName:\t" + this.packageName + "\n|* mappingDir:\t" + this.mappingDir + "\n|* baseMethodMapPath:\t" + this.baseMethodMapPath + "\n|* methodMapFilePath:\t" + this.methodMapFilePath + "\n|* ignoreMethodMapFilePath:\t" + this.ignoreMethodMapFilePath + "\n|* blackListFilePath:\t" + this.blackListFilePath + "\n|* traceClassOut:\t" + this.traceClassOut + "\n";
    }

    public static class Builder {
        public String packageName;
        public String mappingPath;
        public String baseMethodMap;
        public String methodMapFile;
        public String ignoreMethodMapFile;
        public String blackListFile;
        public String traceClassOut;

        public Builder setPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder setMappingPath(String mappingPath) {
            this.mappingPath = mappingPath;
            return this;
        }

        public Builder setBaseMethodMap(String baseMethodMap) {
            this.baseMethodMap = baseMethodMap;
            return this;
        }

        public Builder setTraceClassOut(String traceClassOut) {
            this.traceClassOut = traceClassOut;
            return this;
        }

        public Builder setMethodMapFilePath(String methodMapDir) {
            this.methodMapFile = methodMapDir;
            return this;
        }

        public Builder setIgnoreMethodMapFilePath(String methodMapDir) {
            this.ignoreMethodMapFile = methodMapDir;
            return this;
        }

        public Builder setBlackListFile(String blackListFile) {
            this.blackListFile = blackListFile;
            return this;
        }

        public Configuration build() {
            return new Configuration(this.packageName, this.mappingPath, this.baseMethodMap, this.methodMapFile, this.ignoreMethodMapFile, this.blackListFile, this.traceClassOut);
        }
    }
}

