/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.transform;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.hash.Hashing;
import com.tencent.matrix.javalib.util.IOUtil;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.ReflectUtil;
import com.tencent.matrix.javalib.util.Util;
import com.tencent.matrix.trace.Configuration;
import com.tencent.matrix.trace.MethodCollector;
import com.tencent.matrix.trace.MethodTracer;
import com.tencent.matrix.trace.extension.MatrixTraceExtension;
import com.tencent.matrix.trace.item.TraceMethod;
import com.tencent.matrix.trace.retrace.MappingCollector;
import com.tencent.matrix.trace.retrace.MappingReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.gradle.api.Project;
import org.gradle.api.Task;

public class MatrixTraceTransform
extends Transform {
    private static final String TAG = "MatrixTraceTransform";
    private Configuration config;
    private Transform origTransform;
    private ExecutorService executor = Executors.newFixedThreadPool(16);

    public static void inject(Project project, MatrixTraceExtension extension, VariantScope variantScope) {
        GlobalScope globalScope = variantScope.getGlobalScope();
        BaseVariantData variant = variantScope.getVariantData();
        String mappingOut = Joiner.on((char)File.separatorChar).join((Object)String.valueOf(globalScope.getBuildDir()), (Object)"outputs", new Object[]{"mapping", variantScope.getVariantConfiguration().getDirName()});
        String traceClassOut = Joiner.on((char)File.separatorChar).join((Object)String.valueOf(globalScope.getBuildDir()), (Object)"outputs", new Object[]{"traceClassOut", variantScope.getVariantConfiguration().getDirName()});
        Configuration config = new Configuration.Builder().setPackageName(variant.getApplicationId()).setBaseMethodMap(extension.getBaseMethodMapFile()).setBlackListFile(extension.getBlackListFile()).setMethodMapFilePath(mappingOut + "/methodMapping.txt").setIgnoreMethodMapFilePath(mappingOut + "/ignoreMethodMapping.txt").setMappingPath(mappingOut).setTraceClassOut(traceClassOut).build();
        try {
            String[] hardTask = MatrixTraceTransform.getTransformTaskName(extension.getCustomDexTransformName(), variant.getName());
            block2: for (Task task : project.getTasks()) {
                for (String str : hardTask) {
                    if (!task.getName().equalsIgnoreCase(str) || !(task instanceof TransformTask)) continue;
                    TransformTask transformTask = (TransformTask)task;
                    Log.i((String)TAG, (String)("successfully inject task:" + transformTask.getName()), (Object[])new Object[0]);
                    Field field = TransformTask.class.getDeclaredField("transform");
                    field.setAccessible(true);
                    field.set(task, (Object)new MatrixTraceTransform(config, transformTask.getTransform()));
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString(), (Object[])new Object[0]);
        }
    }

    private static String[] getTransformTaskName(String customDexTransformName, String buildTypeSuffix) {
        if (!Util.isNullOrNil((String)customDexTransformName)) {
            return new String[]{customDexTransformName + "For" + buildTypeSuffix};
        }
        String[] names = new String[]{"transformClassesWithDexBuilderFor" + buildTypeSuffix, "transformClassesWithDexFor" + buildTypeSuffix};
        return names;
    }

    public MatrixTraceTransform(Configuration config, Transform origTransform) {
        this.config = config;
        this.origTransform = origTransform;
    }

    public String getName() {
        return TAG;
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        super.transform(transformInvocation);
        long start = System.currentTimeMillis();
        try {
            this.doTransform(transformInvocation);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        long cost = System.currentTimeMillis() - start;
        long begin = System.currentTimeMillis();
        this.origTransform.transform(transformInvocation);
        long origTransformCost = System.currentTimeMillis() - begin;
        Log.i((String)("Matrix." + this.getName()), (String)"[transform] cost time: %dms %s:%sms MatrixTraceTransform:%sms", (Object[])new Object[]{System.currentTimeMillis() - start, this.origTransform.getClass().getSimpleName(), origTransformCost, cost});
    }

    private void doTransform(TransformInvocation transformInvocation) throws ExecutionException, InterruptedException {
        boolean isIncremental = transformInvocation.isIncremental() && this.isIncremental();
        long start = System.currentTimeMillis();
        LinkedList futures = new LinkedList();
        MappingCollector mappingCollector = new MappingCollector();
        AtomicInteger methodId = new AtomicInteger(0);
        ConcurrentHashMap<String, TraceMethod> collectedMethodMap = new ConcurrentHashMap<String, TraceMethod>();
        futures.add(this.executor.submit(new ParseMappingTask(mappingCollector, collectedMethodMap, methodId)));
        ConcurrentHashMap<File, File> dirInputOutMap = new ConcurrentHashMap<File, File>();
        ConcurrentHashMap<File, File> jarInputOutMap = new ConcurrentHashMap<File, File>();
        Collection inputs = transformInvocation.getInputs();
        for (TransformInput transformInput : inputs) {
            for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
                futures.add(this.executor.submit(new CollectDirectoryInputTask(dirInputOutMap, directoryInput, isIncremental)));
            }
            for (JarInput inputJar : transformInput.getJarInputs()) {
                futures.add(this.executor.submit(new CollectJarInputTask(inputJar, isIncremental, jarInputOutMap, dirInputOutMap)));
            }
        }
        for (Future future : futures) {
            future.get();
        }
        futures.clear();
        Log.i((String)TAG, (String)"[doTransform] Step(1)[Parse]... cost:%sms", (Object[])new Object[]{System.currentTimeMillis() - start});
        start = System.currentTimeMillis();
        MethodCollector methodCollector = new MethodCollector(this.executor, mappingCollector, methodId, this.config, collectedMethodMap);
        methodCollector.collect(dirInputOutMap.keySet(), jarInputOutMap.keySet());
        Log.i((String)TAG, (String)"[doTransform] Step(2)[Collection]... cost:%sms", (Object[])new Object[]{System.currentTimeMillis() - start});
        start = System.currentTimeMillis();
        MethodTracer methodTracer = new MethodTracer(this.executor, mappingCollector, this.config, methodCollector.getCollectedMethodMap(), methodCollector.getCollectedClassExtendMap());
        methodTracer.trace(dirInputOutMap, jarInputOutMap);
        Log.i((String)TAG, (String)"[doTransform] Step(3)[Trace]... cost:%sms", (Object[])new Object[]{System.currentTimeMillis() - start});
    }

    protected String getUniqueJarName(File jarFile) {
        String origJarName = jarFile.getName();
        String hashing = Hashing.sha1().hashString((CharSequence)jarFile.getPath(), Charsets.UTF_16LE).toString();
        int dotPos = origJarName.lastIndexOf(46);
        if (dotPos < 0) {
            return String.format("%s_%s", origJarName, hashing);
        }
        String nameWithoutDotExt = origJarName.substring(0, dotPos);
        String dotExt = origJarName.substring(dotPos);
        return String.format("%s_%s%s", nameWithoutDotExt, hashing, dotExt);
    }

    private void replaceFile(QualifiedContent input, File newFile) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException {
        Field fileField = ReflectUtil.getDeclaredFieldRecursive(input.getClass(), (String)"file");
        fileField.set(input, newFile);
    }

    private void replaceChangedFile(DirectoryInput dirInput, Map<File, Status> changedFiles) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException {
        Field changedFilesField = ReflectUtil.getDeclaredFieldRecursive(dirInput.getClass(), (String)"changedFiles");
        changedFilesField.set(dirInput, changedFiles);
    }

    private class CollectJarInputTask
    implements Runnable {
        JarInput inputJar;
        boolean isIncremental;
        Map<File, File> jarInputOutMap;
        Map<File, File> dirInputOutMap;

        CollectJarInputTask(JarInput inputJar, boolean isIncremental, Map<File, File> jarInputOutMap, Map<File, File> dirInputOutMap) {
            this.inputJar = inputJar;
            this.isIncremental = isIncremental;
            this.jarInputOutMap = jarInputOutMap;
            this.dirInputOutMap = dirInputOutMap;
        }

        @Override
        public void run() {
            try {
                this.handle();
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)("Matrix." + MatrixTraceTransform.this.getName()), (String)"%s", (Object[])new Object[]{e.toString()});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handle() throws IllegalAccessException, NoSuchFieldException, ClassNotFoundException, IOException {
            File jarOutput;
            block17: {
                File jarInput;
                String traceClassOut;
                block16: {
                    traceClassOut = ((MatrixTraceTransform)MatrixTraceTransform.this).config.traceClassOut;
                    jarInput = this.inputJar.getFile();
                    jarOutput = new File(traceClassOut, MatrixTraceTransform.this.getUniqueJarName(jarInput));
                    if (jarOutput.exists()) {
                        jarOutput.delete();
                    }
                    if (!jarOutput.getParentFile().exists()) {
                        jarOutput.getParentFile().mkdirs();
                    }
                    if (!IOUtil.isRealZipOrJar((File)jarInput)) break block16;
                    if (this.isIncremental) {
                        if (this.inputJar.getStatus() == Status.ADDED || this.inputJar.getStatus() == Status.CHANGED) {
                            this.jarInputOutMap.put(jarInput, jarOutput);
                        } else if (this.inputJar.getStatus() == Status.REMOVED) {
                            jarOutput.delete();
                        }
                    } else {
                        this.jarInputOutMap.put(jarInput, jarOutput);
                    }
                    break block17;
                }
                Log.i((String)MatrixTraceTransform.TAG, (String)"Special case for WeChat AutoDex. Its rootInput jar file is actually a txt file contains path list.", (Object[])new Object[0]);
                BufferedReader br = null;
                BufferedWriter bw = null;
                try {
                    String realJarInputFullPath;
                    br = new BufferedReader(new InputStreamReader(new FileInputStream(jarInput)));
                    bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(jarOutput)));
                    while ((realJarInputFullPath = br.readLine()) != null) {
                        File realJarInput = new File(realJarInputFullPath);
                        File realJarOutput = new File(traceClassOut, MatrixTraceTransform.this.getUniqueJarName(realJarInput));
                        if (realJarInput.exists() && IOUtil.isRealZipOrJar((File)realJarInput)) {
                            this.jarInputOutMap.put(realJarInput, realJarOutput);
                        } else {
                            realJarOutput.delete();
                            if (realJarInput.exists() && realJarInput.isDirectory()) {
                                File realJarOutputDir = new File(traceClassOut, realJarInput.getName());
                                if (!realJarOutput.exists()) {
                                    realJarOutput.mkdirs();
                                }
                                this.dirInputOutMap.put(realJarInput, realJarOutputDir);
                            }
                        }
                        String realJarOutputFullPath = realJarOutput.getAbsolutePath();
                        bw.write(realJarOutputFullPath);
                        bw.newLine();
                    }
                }
                catch (FileNotFoundException e) {
                    try {
                        Log.e((String)("Matrix." + MatrixTraceTransform.this.getName()), (String)"FileNotFoundException:%s", (Object[])new Object[]{e.toString()});
                    }
                    catch (Throwable throwable) {
                        IOUtil.closeQuietly(br);
                        IOUtil.closeQuietly(bw);
                        throw throwable;
                    }
                    IOUtil.closeQuietly((Object)br);
                    IOUtil.closeQuietly((Object)bw);
                }
                IOUtil.closeQuietly((Object)br);
                IOUtil.closeQuietly((Object)bw);
                jarInput.delete();
            }
            MatrixTraceTransform.this.replaceFile((QualifiedContent)this.inputJar, jarOutput);
        }
    }

    private class CollectDirectoryInputTask
    implements Runnable {
        Map<File, File> dirInputOutMap;
        DirectoryInput directoryInput;
        boolean isIncremental;
        String traceClassOut;

        CollectDirectoryInputTask(Map<File, File> dirInputOutMap, DirectoryInput directoryInput, boolean isIncremental) {
            this.dirInputOutMap = dirInputOutMap;
            this.directoryInput = directoryInput;
            this.isIncremental = isIncremental;
            this.traceClassOut = ((MatrixTraceTransform)MatrixTraceTransform.this).config.traceClassOut;
        }

        @Override
        public void run() {
            try {
                this.handle();
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)("Matrix." + MatrixTraceTransform.this.getName()), (String)"%s", (Object[])new Object[]{e.toString()});
            }
        }

        private void handle() throws IOException, IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
            File dirInput = this.directoryInput.getFile();
            File dirOutput = new File(this.traceClassOut, dirInput.getName());
            String inputFullPath = dirInput.getAbsolutePath();
            String outputFullPath = dirOutput.getAbsolutePath();
            if (!dirOutput.exists()) {
                dirOutput.mkdirs();
            }
            if (!dirInput.exists() && dirOutput.exists()) {
                if (dirOutput.isDirectory()) {
                    FileUtils.deleteFolder((File)dirOutput);
                } else {
                    FileUtils.delete((File)dirOutput);
                }
            }
            if (this.isIncremental) {
                Map fileStatusMap = this.directoryInput.getChangedFiles();
                HashMap<File, Status> outChangedFiles = new HashMap<File, Status>();
                for (Map.Entry entry : fileStatusMap.entrySet()) {
                    Status status = (Status)entry.getValue();
                    File changedFileInput = (File)entry.getKey();
                    String changedFileInputFullPath = changedFileInput.getAbsolutePath();
                    File changedFileOutput = new File(changedFileInputFullPath.replace(inputFullPath, outputFullPath));
                    if (status == Status.ADDED || status == Status.CHANGED) {
                        this.dirInputOutMap.put(changedFileInput, changedFileOutput);
                    } else if (status == Status.REMOVED) {
                        changedFileOutput.delete();
                    }
                    outChangedFiles.put(changedFileOutput, status);
                }
                MatrixTraceTransform.this.replaceChangedFile(this.directoryInput, outChangedFiles);
            } else {
                this.dirInputOutMap.put(dirInput, dirOutput);
            }
            MatrixTraceTransform.this.replaceFile((QualifiedContent)this.directoryInput, dirOutput);
        }
    }

    private class ParseMappingTask
    implements Runnable {
        final MappingCollector mappingCollector;
        final ConcurrentHashMap<String, TraceMethod> collectedMethodMap;
        private final AtomicInteger methodId;

        ParseMappingTask(MappingCollector mappingCollector, ConcurrentHashMap<String, TraceMethod> collectedMethodMap, AtomicInteger methodId) {
            this.mappingCollector = mappingCollector;
            this.collectedMethodMap = collectedMethodMap;
            this.methodId = methodId;
        }

        @Override
        public void run() {
            try {
                long start = System.currentTimeMillis();
                File mappingFile = new File(((MatrixTraceTransform)MatrixTraceTransform.this).config.mappingDir, "mapping.txt");
                if (mappingFile.exists() && mappingFile.isFile()) {
                    MappingReader mappingReader = new MappingReader(mappingFile);
                    mappingReader.read(this.mappingCollector);
                }
                int size = MatrixTraceTransform.this.config.parseBlackFile(this.mappingCollector);
                File baseMethodMapFile = new File(((MatrixTraceTransform)MatrixTraceTransform.this).config.baseMethodMapPath);
                this.getMethodFromBaseMethod(baseMethodMapFile, this.collectedMethodMap);
                this.retraceMethodMap(this.mappingCollector, this.collectedMethodMap);
                Log.i((String)MatrixTraceTransform.TAG, (String)"[ParseMappingTask#run] cost:%sms, black size:%s, collect %s method from %s", (Object[])new Object[]{System.currentTimeMillis() - start, size, this.collectedMethodMap.size(), ((MatrixTraceTransform)MatrixTraceTransform.this).config.baseMethodMapPath});
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void retraceMethodMap(MappingCollector processor, ConcurrentHashMap<String, TraceMethod> methodMap) {
            if (null == processor || null == methodMap) {
                return;
            }
            HashMap<String, TraceMethod> retraceMethodMap = new HashMap<String, TraceMethod>(methodMap.size());
            for (Map.Entry<String, TraceMethod> entry : methodMap.entrySet()) {
                TraceMethod traceMethod = entry.getValue();
                traceMethod.proguard(processor);
                retraceMethodMap.put(traceMethod.getMethodName(), traceMethod);
            }
            methodMap.clear();
            methodMap.putAll(retraceMethodMap);
            retraceMethodMap.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getMethodFromBaseMethod(File baseMethodFile, ConcurrentHashMap<String, TraceMethod> collectedMethodMap) {
            if (!baseMethodFile.exists()) {
                Log.w((String)MatrixTraceTransform.TAG, (String)"[getMethodFromBaseMethod] not exist!%s", (Object[])new Object[]{baseMethodFile.getAbsolutePath()});
                return;
            }
            try (Scanner fileReader = null;){
                fileReader = new Scanner(baseMethodFile, "UTF-8");
                while (fileReader.hasNext()) {
                    String nextLine = fileReader.nextLine();
                    if (Util.isNullOrNil((String)nextLine)) continue;
                    if ((nextLine = nextLine.trim()).startsWith("#")) {
                        Log.i((String)"[getMethodFromBaseMethod] comment %s", (String)nextLine, (Object[])new Object[0]);
                        continue;
                    }
                    String[] fields = nextLine.split(",");
                    TraceMethod traceMethod = new TraceMethod();
                    traceMethod.id = Integer.parseInt(fields[0]);
                    traceMethod.accessFlag = Integer.parseInt(fields[1]);
                    String[] methodField = fields[2].split(" ");
                    traceMethod.className = methodField[0].replace("/", ".");
                    traceMethod.methodName = methodField[1];
                    if (methodField.length > 2) {
                        traceMethod.desc = methodField[2].replace("/", ".");
                    }
                    collectedMethodMap.put(traceMethod.getMethodName(), traceMethod);
                    if (this.methodId.get() >= traceMethod.id || traceMethod.id == 1048574) continue;
                    this.methodId.set(traceMethod.id);
                }
            }
        }
    }
}

