/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.iocanary.config;

import com.tencent.mrs.plugin.IDynamicConfig;

public final class IOConfig {
    private static final String TAG = "Matrix.IOConfig";
    private static final int DEFAULT_FILE_MAIN_THREAD_TRIGGER_THRESHOLD = 500;
    private static final int DEFAULT_FILE_BUFFER_SMALL_THRESHOLD = 4096;
    private static final int DEFAULT_FILE_BUFFER_SMALL_OP_TIMES = 20;
    private static final int DEFAULT_FILE_REPEAT_READ_TIMES_THRESHOLD = 5;
    private static final boolean DEFAULT_DETECT_MIAN_THREAD_FILE_IO = true;
    private static final boolean DEFAULT_DETECT_SMALL_BUFFER = true;
    private static final boolean DEFAULT_DETECT_REPEAT_READ_SAME_FILE = true;
    private static final boolean DEFAULT_DETECT_CLOSABLE_LEAK = true;
    private static final boolean DETECT_NETWORK_IO_IN_MAIN_THREAD = true;
    private static final boolean DETECT_CURSOR_LEAK = true;
    private final IDynamicConfig mDynamicConfig;

    private IOConfig(IDynamicConfig dynamicConfig) {
        this.mDynamicConfig = dynamicConfig;
    }

    public boolean isDetectFileIOInMainThread() {
        return this.mDynamicConfig.get(IDynamicConfig.ExptEnum.clicfg_matrix_io_file_io_main_thread_enable.name(), true);
    }

    public boolean isDetectFileIORepeatReadSameFile() {
        return this.mDynamicConfig.get(IDynamicConfig.ExptEnum.clicfg_matrix_io_repeated_read_enable.name(), true);
    }

    public boolean isDetectFileIOBufferTooSmall() {
        return this.mDynamicConfig.get(IDynamicConfig.ExptEnum.clicfg_matrix_io_small_buffer_enable.name(), true);
    }

    public boolean isDetectIOClosableLeak() {
        return this.mDynamicConfig.get(IDynamicConfig.ExptEnum.clicfg_matrix_io_closeable_leak_enable.name(), true);
    }

    public int getFileMainThreadTriggerThreshold() {
        return this.mDynamicConfig.get(IDynamicConfig.ExptEnum.clicfg_matrix_io_main_thread_enable_threshold.name(), 500);
    }

    public int getFileBufferSmallThreshold() {
        return this.mDynamicConfig.get(IDynamicConfig.ExptEnum.clicfg_matrix_io_small_buffer_threshold.name(), 4096);
    }

    public int getFilBufferSmallOpTimes() {
        return this.mDynamicConfig.get(IDynamicConfig.ExptEnum.clicfg_matrix_io_small_buffer_operator_times.name(), 20);
    }

    public int getFileRepeatReadThreshold() {
        return this.mDynamicConfig.get(IDynamicConfig.ExptEnum.clicfg_matrix_io_repeated_read_threshold.name(), 5);
    }

    public String toString() {
        return String.format("[IOCanary.IOConfig], main_thread:%b, small_buffer:%b, repeat_read:%b, closeable_leak:%b", this.isDetectFileIOInMainThread(), this.isDetectFileIOBufferTooSmall(), this.isDetectFileIORepeatReadSameFile(), this.isDetectIOClosableLeak());
    }

    public static final class Builder {
        private IDynamicConfig mDynamicConfig;

        public Builder dynamicConfig(IDynamicConfig dynamicConfig) {
            this.mDynamicConfig = dynamicConfig;
            return this;
        }

        public IOConfig build() {
            return new IOConfig(this.mDynamicConfig);
        }
    }
}

