/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.iocanary.core;

import com.tencent.matrix.iocanary.IOCanaryPlugin;
import com.tencent.matrix.iocanary.config.IOConfig;
import com.tencent.matrix.iocanary.core.IOCanaryJniBridge;
import com.tencent.matrix.iocanary.core.IOIssue;
import com.tencent.matrix.iocanary.core.OnJniIssuePublishListener;
import com.tencent.matrix.iocanary.detect.CloseGuardHooker;
import com.tencent.matrix.iocanary.util.IOCanaryUtil;
import com.tencent.matrix.report.Issue;
import com.tencent.matrix.report.IssuePublisher;
import java.util.List;

public class IOCanaryCore
implements OnJniIssuePublishListener,
IssuePublisher.OnIssueDetectListener {
    private static final String TAG = "Matrix.IOCanaryCore";
    private final IOConfig mIOConfig;
    private final IOCanaryPlugin mIoCanaryPlugin;
    private boolean mIsStart;
    private CloseGuardHooker mCloseGuardHooker;

    public IOCanaryCore(IOCanaryPlugin ioCanaryPlugin) {
        this.mIOConfig = ioCanaryPlugin.getConfig();
        this.mIoCanaryPlugin = ioCanaryPlugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.initDetectorsAndHookers(this.mIOConfig);
        IOCanaryCore iOCanaryCore = this;
        synchronized (iOCanaryCore) {
            this.mIsStart = true;
        }
    }

    public synchronized boolean isStart() {
        return this.mIsStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        IOCanaryCore iOCanaryCore = this;
        synchronized (iOCanaryCore) {
            this.mIsStart = false;
        }
        if (this.mCloseGuardHooker != null) {
            this.mCloseGuardHooker.unHook();
        }
        IOCanaryJniBridge.uninstall();
    }

    public void onDetectIssue(Issue issue) {
        this.mIoCanaryPlugin.onDetectIssue(issue);
    }

    private void initDetectorsAndHookers(IOConfig ioConfig) {
        assert (ioConfig != null);
        if (ioConfig.isDetectFileIOInMainThread() || ioConfig.isDetectFileIOBufferTooSmall() || ioConfig.isDetectFileIORepeatReadSameFile()) {
            IOCanaryJniBridge.install(ioConfig, this);
        }
        if (ioConfig.isDetectIOClosableLeak()) {
            this.mCloseGuardHooker = new CloseGuardHooker(this);
            this.mCloseGuardHooker.hook();
        }
    }

    @Override
    public void onIssuePublish(List<IOIssue> issues) {
        if (issues == null) {
            return;
        }
        for (int i = 0; i < issues.size(); ++i) {
            this.mIoCanaryPlugin.onDetectIssue(IOCanaryUtil.convertIOIssueToReportIssue(issues.get(i)));
        }
    }
}

