/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sqlitelint;

import android.content.Context;
import android.content.res.XmlResourceParser;
import com.tencent.sqlitelint.SQLiteLintNativeBridge;
import com.tencent.sqlitelint.util.SLog;
import com.tencent.sqlitelint.util.SQLiteLintUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public final class CheckerWhiteListLogic {
    private static final String TAG = "SQLiteLint.CheckerWhiteListLogic";
    private static final String TAG_CHECKER = "checker";
    private static final String ATTRIBUTE_CHECKER_NAME = "name";
    private static final String TAG_WHITE_LIST_ELEMENT = "element";

    public static void setWhiteList(Context context, String concernedDbPath, int xmlResId) {
        XmlResourceParser parser;
        try {
            parser = context.getResources().getXml(xmlResId);
        }
        catch (Exception e) {
            SLog.w(TAG, "buildWhiteListSet: getResources exp=%s", e.getLocalizedMessage());
            return;
        }
        if (parser == null) {
            SLog.w(TAG, "buildWhiteListSet: parser null", new Object[0]);
            return;
        }
        try {
            int protectCnt = 0;
            int eventType = parser.getEventType();
            String enclosedCheckerName = null;
            HashMap<String, List<String>> whiteListMap = new HashMap<String, List<String>>();
            while (eventType != 1) {
                switch (eventType) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        String tagName = parser.getName();
                        if (TAG_CHECKER.equalsIgnoreCase(tagName)) {
                            enclosedCheckerName = parser.getAttributeValue(null, ATTRIBUTE_CHECKER_NAME);
                        }
                        if (!TAG_WHITE_LIST_ELEMENT.equalsIgnoreCase(tagName) || SQLiteLintUtil.isNullOrNil(enclosedCheckerName)) break;
                        String text = parser.nextText();
                        if (whiteListMap.get(enclosedCheckerName) == null) {
                            ArrayList<String> list = new ArrayList<String>();
                            list.add(text);
                            whiteListMap.put(enclosedCheckerName, list);
                        } else {
                            ((List)whiteListMap.get(enclosedCheckerName)).add(text);
                        }
                        SLog.v(TAG, "buildWhiteListMap: add to whiteList[%s]: %s", enclosedCheckerName, text);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        SLog.w(TAG, "buildWhiteListMap: default branch , eventType:%d", eventType);
                    }
                }
                parser.next();
                eventType = parser.getEventType();
                if (++protectCnt <= 10000) continue;
                SLog.e(TAG, "buildWhiteListMap:maybe dead loop!!", new Object[0]);
                break;
            }
            CheckerWhiteListLogic.addToNative(concernedDbPath, whiteListMap);
        }
        catch (XmlPullParserException e) {
            SLog.w(TAG, "buildWhiteListSet: exp=%s", e.getLocalizedMessage());
        }
        catch (IOException e) {
            SLog.w(TAG, "buildWhiteListSet: exp=%s", e.getLocalizedMessage());
        }
        parser.close();
    }

    private static void addToNative(String concernedDbPath, Map<String, List<String>> whiteListMap) {
        if (whiteListMap == null) {
            return;
        }
        Iterator<Map.Entry<String, List<String>>> it = whiteListMap.entrySet().iterator();
        String[] checkerArr = new String[whiteListMap.size()];
        String[][] whiteListArr = new String[whiteListMap.size()][];
        int index = 0;
        while (it.hasNext()) {
            Map.Entry<String, List<String>> entry = it.next();
            checkerArr[index] = entry.getKey();
            List<String> list = entry.getValue();
            whiteListArr[index] = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                whiteListArr[index][i] = list.get(i);
            }
            ++index;
        }
        SQLiteLintNativeBridge.nativeAddToWhiteList(concernedDbPath, checkerArr, whiteListArr);
    }
}

