/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sqlitelint;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import com.tencent.sqlitelint.ISQLiteExecutionDelegate;
import com.tencent.sqlitelint.SQLiteLintAndroidCoreManager;
import com.tencent.sqlitelint.SQLiteLintNativeBridge;
import com.tencent.sqlitelint.SimpleSQLiteExecutionDelegate;
import com.tencent.sqlitelint.behaviour.report.IssueReportBehaviour;
import com.tencent.sqlitelint.util.SQLite3ProfileHooker;
import java.util.List;

public class SQLiteLint {
    private static SqlExecutionCallbackMode sSqlExecutionCallbackMode = null;
    static IssueReportBehaviour.IReportDelegate sReportDelegate;
    public static String sPackageName;
    private static final int BEHAVIOUR_ALERT = 1;
    private static final int BEHAVIOUR_REPORT = 2;

    private SQLiteLint() {
    }

    public static void init() {
        SQLiteLintNativeBridge.loadLibrary();
    }

    public static void setSqlExecutionCallbackMode(SqlExecutionCallbackMode sqlExecutionCallbackMode) {
        if (sSqlExecutionCallbackMode != null) {
            return;
        }
        sSqlExecutionCallbackMode = sqlExecutionCallbackMode;
        if (sSqlExecutionCallbackMode == SqlExecutionCallbackMode.HOOK) {
            SQLite3ProfileHooker.hook();
        }
    }

    public static SqlExecutionCallbackMode getSqlExecutionCallbackMode() {
        return sSqlExecutionCallbackMode;
    }

    public static void install(Context context, SQLiteDatabase db) {
        assert (db != null);
        assert (sSqlExecutionCallbackMode != null) : "SqlExecutionCallbackMode not set\uff01setSqlExecutionCallbackMode must be called before install";
        InstallEnv installEnv = new InstallEnv(db.getPath(), new SimpleSQLiteExecutionDelegate(db));
        SQLiteLintAndroidCoreManager.INSTANCE.install(context, installEnv, Options.LAX);
    }

    public static void install(Context context, InstallEnv installEnv, Options options) {
        assert (installEnv != null);
        assert (sSqlExecutionCallbackMode != null) : "SqlExecutionCallbackMode is UNKNOWN\uff01setSqlExecutionCallbackMode must be called before install";
        options = options == null ? Options.LAX : options;
        SQLiteLintAndroidCoreManager.INSTANCE.install(context, installEnv, options);
    }

    public static void notifySqlExecution(String concernedDbPath, String sql, int timeCost) {
        if (SQLiteLintAndroidCoreManager.INSTANCE.get(concernedDbPath) == null) {
            return;
        }
        SQLiteLintAndroidCoreManager.INSTANCE.get(concernedDbPath).notifySqlExecution(concernedDbPath, sql, timeCost);
    }

    public static void uninstall(String concernedDbPath) {
        SQLiteLintAndroidCoreManager.INSTANCE.get(concernedDbPath).release();
        SQLiteLintAndroidCoreManager.INSTANCE.remove(concernedDbPath);
    }

    public static void setWhiteList(String concernedDbPath, int xmlResId) {
        if (SQLiteLintAndroidCoreManager.INSTANCE.get(concernedDbPath) == null) {
            return;
        }
        SQLiteLintAndroidCoreManager.INSTANCE.get(concernedDbPath).setWhiteList(xmlResId);
    }

    public static void enableCheckers(String concernedDbPath, List<String> enableCheckerList) {
        if (SQLiteLintAndroidCoreManager.INSTANCE.get(concernedDbPath) == null) {
            return;
        }
        if (enableCheckerList == null || enableCheckerList.isEmpty()) {
            return;
        }
        SQLiteLintAndroidCoreManager.INSTANCE.get(concernedDbPath).enableCheckers(enableCheckerList);
    }

    static void setReportDelegate(IssueReportBehaviour.IReportDelegate reportDelegate) {
        sReportDelegate = reportDelegate;
    }

    public static void setPackageName(Context context) {
        if (sPackageName == null) {
            sPackageName = context.getPackageName();
        }
    }

    static {
        sPackageName = null;
    }

    public static final class Options {
        public static final Options LAX = new Builder().build();
        private int behaviourMask;

        public boolean isAlertBehaviourEnable() {
            return (this.behaviourMask & 1) > 0;
        }

        public boolean isReportBehaviourEnable() {
            return (this.behaviourMask & 2) > 0;
        }

        public static final class Builder {
            private int mBehaviourMask;

            public Builder() {
                this.mBehaviourMask |= 1;
            }

            public Builder setAlertBehaviour(boolean enable) {
                this.mBehaviourMask = enable ? (this.mBehaviourMask |= 1) : (this.mBehaviourMask &= 0xFFFFFFFE);
                return this;
            }

            public Builder setReportBehaviour(boolean enable) {
                this.mBehaviourMask = enable ? (this.mBehaviourMask |= 2) : (this.mBehaviourMask &= 0xFFFFFFFD);
                return this;
            }

            public Options build() {
                Options options = new Options();
                options.behaviourMask = this.mBehaviourMask;
                return options;
            }
        }
    }

    public static enum SqlExecutionCallbackMode {
        HOOK,
        CUSTOM_NOTIFY;

    }

    public static final class InstallEnv {
        private final String mConcernedDbPath;
        private final ISQLiteExecutionDelegate mSQLiteExecutionDelegate;

        public InstallEnv(String concernedDbPath, ISQLiteExecutionDelegate executionDelegate) {
            assert (concernedDbPath != null);
            assert (executionDelegate != null);
            this.mConcernedDbPath = concernedDbPath;
            this.mSQLiteExecutionDelegate = executionDelegate;
        }

        public String getConcernedDbPath() {
            return this.mConcernedDbPath;
        }

        public ISQLiteExecutionDelegate getSQLiteExecutionDelegate() {
            return this.mSQLiteExecutionDelegate;
        }
    }
}

