/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sqlitelint;

import android.content.Context;
import com.tencent.sqlitelint.CheckerWhiteListLogic;
import com.tencent.sqlitelint.IOnIssuePublishListener;
import com.tencent.sqlitelint.ISQLiteExecutionDelegate;
import com.tencent.sqlitelint.SQLiteLint;
import com.tencent.sqlitelint.SQLiteLintIssue;
import com.tencent.sqlitelint.SQLiteLintNativeBridge;
import com.tencent.sqlitelint.behaviour.BaseBehaviour;
import com.tencent.sqlitelint.behaviour.alert.IssueAlertBehaviour;
import com.tencent.sqlitelint.behaviour.persistence.IssueStorage;
import com.tencent.sqlitelint.behaviour.persistence.PersistenceBehaviour;
import com.tencent.sqlitelint.behaviour.persistence.SQLiteLintDbHelper;
import com.tencent.sqlitelint.behaviour.report.IssueReportBehaviour;
import com.tencent.sqlitelint.util.SQLite3ProfileHooker;
import com.tencent.sqlitelint.util.SQLiteLintUtil;
import java.util.ArrayList;
import java.util.List;

class SQLiteLintAndroidCore
implements IOnIssuePublishListener {
    private static final String TAG = "SQLiteLint.SQLiteLintAndroidCore";
    private final Context mContext;
    private final String mConcernedDbPath;
    private final ISQLiteExecutionDelegate mSQLiteExecutionDelegate;
    private final List<BaseBehaviour> mBehaviors;

    SQLiteLintAndroidCore(Context context, SQLiteLint.InstallEnv installEnv, SQLiteLint.Options options) {
        this.mContext = context;
        SQLiteLintDbHelper.INSTANCE.initialize(context);
        this.mConcernedDbPath = installEnv.getConcernedDbPath();
        this.mSQLiteExecutionDelegate = installEnv.getSQLiteExecutionDelegate();
        if (SQLiteLint.getSqlExecutionCallbackMode() == SQLiteLint.SqlExecutionCallbackMode.HOOK) {
            SQLite3ProfileHooker.hook();
        }
        SQLiteLintNativeBridge.nativeInstall(this.mConcernedDbPath);
        this.mBehaviors = new ArrayList<BaseBehaviour>();
        this.mBehaviors.add(new PersistenceBehaviour());
        if (options.isAlertBehaviourEnable()) {
            this.mBehaviors.add(new IssueAlertBehaviour(context, this.mConcernedDbPath));
        }
        if (options.isReportBehaviourEnable()) {
            this.mBehaviors.add(new IssueReportBehaviour(SQLiteLint.sReportDelegate));
        }
    }

    public void addBehavior(BaseBehaviour behaviour) {
        if (!this.mBehaviors.contains(behaviour)) {
            this.mBehaviors.add(behaviour);
        }
    }

    public void removeBehavior(BaseBehaviour behaviour) {
        this.mBehaviors.remove(behaviour);
    }

    public void release() {
        if (SQLiteLint.getSqlExecutionCallbackMode() == SQLiteLint.SqlExecutionCallbackMode.HOOK) {
            SQLite3ProfileHooker.unHook();
        }
        SQLiteLintNativeBridge.nativeUninstall(this.mConcernedDbPath);
    }

    public ISQLiteExecutionDelegate getSQLiteExecutionDelegate() {
        return this.mSQLiteExecutionDelegate;
    }

    public void notifySqlExecution(String dbPath, String sql, long timeCost) {
        String extInfoStack = "null";
        if (timeCost >= 8L) {
            extInfoStack = SQLiteLintUtil.getThrowableStack(new Throwable());
        }
        SQLiteLintNativeBridge.nativeNotifySqlExecute(dbPath, sql, timeCost, extInfoStack);
    }

    public void setWhiteList(int xmlResId) {
        CheckerWhiteListLogic.setWhiteList(this.mContext, this.mConcernedDbPath, xmlResId);
    }

    public void enableCheckers(List<String> enableCheckers) {
        String[] enableCheckerArr = new String[enableCheckers.size()];
        for (int i = 0; i < enableCheckers.size(); ++i) {
            enableCheckerArr[i] = enableCheckers.get(i);
        }
        SQLiteLintNativeBridge.nativeEnableCheckers(this.mConcernedDbPath, enableCheckerArr);
    }

    @Override
    public void onPublish(List<SQLiteLintIssue> publishedIssues) {
        for (SQLiteLintIssue issue : publishedIssues) {
            if (IssueStorage.hasIssue(issue.id)) {
                issue.isNew = false;
                continue;
            }
            issue.isNew = true;
        }
        for (int i = 0; i < this.mBehaviors.size(); ++i) {
            this.mBehaviors.get(i).onPublish(publishedIssues);
        }
    }
}

