/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sqlitelint;

import android.content.Context;
import com.tencent.sqlitelint.SQLiteLint;
import com.tencent.sqlitelint.SQLiteLintAndroidCore;
import com.tencent.sqlitelint.behaviour.BaseBehaviour;
import com.tencent.sqlitelint.util.SLog;
import java.util.concurrent.ConcurrentHashMap;

public enum SQLiteLintAndroidCoreManager {
    INSTANCE;

    private static final String TAG = "SQLiteLint.SQLiteLintAndroidCoreManager";
    private ConcurrentHashMap<String, SQLiteLintAndroidCore> mCoresMap = new ConcurrentHashMap();

    public void install(Context context, SQLiteLint.InstallEnv installEnv, SQLiteLint.Options options) {
        String concernedDbPath = installEnv.getConcernedDbPath();
        if (this.mCoresMap.containsKey(concernedDbPath)) {
            SLog.w(TAG, "install twice!! ignore", new Object[0]);
            return;
        }
        SQLiteLintAndroidCore core = new SQLiteLintAndroidCore(context, installEnv, options);
        this.mCoresMap.put(concernedDbPath, core);
    }

    public void addBehavior(BaseBehaviour behaviour, String dbPath) {
        if (this.get(dbPath) == null) {
            return;
        }
        this.get(dbPath).addBehavior(behaviour);
    }

    public void removeBehavior(BaseBehaviour behaviour, String dbPath) {
        if (this.get(dbPath) == null) {
            return;
        }
        this.get(dbPath).removeBehavior(behaviour);
    }

    public SQLiteLintAndroidCore get(String dbPath) {
        return this.mCoresMap.get(dbPath);
    }

    public void remove(String dbPath) {
        this.mCoresMap.remove(dbPath);
    }
}

