/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sqlitelint;

import android.app.Application;
import android.content.Context;
import com.tencent.matrix.plugin.Plugin;
import com.tencent.matrix.plugin.PluginListener;
import com.tencent.matrix.report.Issue;
import com.tencent.matrix.util.DeviceUtil;
import com.tencent.sqlitelint.SQLiteLint;
import com.tencent.sqlitelint.SQLiteLintIssue;
import com.tencent.sqlitelint.behaviour.report.IssueReportBehaviour;
import com.tencent.sqlitelint.config.SQLiteLintConfig;
import com.tencent.sqlitelint.util.SLog;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class SQLiteLintPlugin
extends Plugin {
    private static final String TAG = "Matrix.SQLiteLintPlugin";
    private final SQLiteLintConfig mConfig;
    private Context mContext;

    public SQLiteLintPlugin(SQLiteLintConfig config) {
        this.mConfig = config;
    }

    public void init(Application app, PluginListener listener) {
        super.init(app, listener);
        SQLiteLint.init();
        SQLiteLint.setPackageName((Context)app);
        this.mContext = app.getApplicationContext();
    }

    public void start() {
        super.start();
        if (!this.isSupported()) {
            return;
        }
        SQLiteLint.setReportDelegate(new IssueReportBehaviour.IReportDelegate(){

            @Override
            public void report(SQLiteLintIssue issue) {
                if (issue == null) {
                    return;
                }
                SQLiteLintPlugin.this.reportMatrixIssue(issue);
            }
        });
        List<SQLiteLintConfig.ConcernDb> concernDbList = this.mConfig.getConcernDbList();
        for (int i = 0; i < concernDbList.size(); ++i) {
            SQLiteLintConfig.ConcernDb concernDb = concernDbList.get(i);
            String concernedDbPath = concernDb.getInstallEnv().getConcernedDbPath();
            SQLiteLint.install(this.mContext, concernDb.getInstallEnv(), concernDb.getOptions());
            SQLiteLint.setWhiteList(concernedDbPath, concernDb.getWhiteListXmlResId());
            SQLiteLint.enableCheckers(concernedDbPath, concernDb.getEnableCheckerList());
        }
    }

    public void stop() {
        super.stop();
        if (!this.isSupported()) {
            return;
        }
        List<SQLiteLintConfig.ConcernDb> concernDbList = this.mConfig.getConcernDbList();
        for (int i = 0; i < concernDbList.size(); ++i) {
            SQLiteLintConfig.ConcernDb concernDb = concernDbList.get(i);
            SQLiteLint.uninstall(concernDb.getInstallEnv().getConcernedDbPath());
        }
        SQLiteLint.setReportDelegate(null);
    }

    public void destroy() {
        super.destroy();
    }

    public String getTag() {
        return "SQLiteLint";
    }

    public void notifySqlExecution(String concernedDbPath, String sql, int timeCost) {
        if (!this.isPluginStarted()) {
            SLog.i(TAG, "notifySqlExecution isPluginStarted not", new Object[0]);
            return;
        }
        SQLiteLint.notifySqlExecution(concernedDbPath, sql, timeCost);
    }

    public void addConcernedDB(SQLiteLintConfig.ConcernDb concernDb) {
        if (!this.isPluginStarted()) {
            SLog.i(TAG, "addConcernedDB isPluginStarted not", new Object[0]);
            return;
        }
        if (concernDb == null) {
            return;
        }
        this.mConfig.addConcernDB(concernDb);
        String concernedDbPath = concernDb.getInstallEnv().getConcernedDbPath();
        SQLiteLint.install(this.mContext, concernDb.getInstallEnv(), concernDb.getOptions());
        SQLiteLint.setWhiteList(concernedDbPath, concernDb.getWhiteListXmlResId());
        SQLiteLint.enableCheckers(concernedDbPath, concernDb.getEnableCheckerList());
    }

    private void reportMatrixIssue(SQLiteLintIssue lintIssue) {
        SLog.i(TAG, "reportMatrixIssue type:%d, isNew %b", lintIssue.type, lintIssue.isNew);
        if (!lintIssue.isNew) {
            return;
        }
        Issue issue = new Issue(lintIssue.type);
        issue.setKey(lintIssue.id);
        JSONObject content = new JSONObject();
        issue.setContent(content);
        try {
            content.put("machine", (Object)DeviceUtil.getLevel((Context)this.getApplication()));
            content.put("id", (Object)lintIssue.id);
            content.put("dbPath", (Object)lintIssue.dbPath);
            content.put("level", lintIssue.level);
            content.put("sql", (Object)lintIssue.sql);
            content.put("table", (Object)lintIssue.table);
            content.put("desc", (Object)lintIssue.desc);
            content.put("detail", (Object)lintIssue.detail);
            content.put("advice", (Object)lintIssue.advice);
            content.put("createTime", lintIssue.createTime);
            content.put("stack", (Object)lintIssue.extInfo);
            content.put("sqlTimeCost", lintIssue.sqlTimeCost);
            content.put("isInMainThread", lintIssue.isInMainThread);
        }
        catch (JSONException e) {
            SLog.i(TAG, "reportMatrixIssue e:%s", e.getLocalizedMessage());
        }
        this.onDetectIssue(issue);
    }
}

