/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sqlitelint.behaviour.alert;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.tencent.sqlitelint.R;
import com.tencent.sqlitelint.behaviour.alert.CheckResultActivity;
import com.tencent.sqlitelint.behaviour.alert.SQLiteLintBaseActivity;
import com.tencent.sqlitelint.behaviour.persistence.IssueStorage;
import com.tencent.sqlitelint.behaviour.persistence.SQLiteLintDbHelper;
import com.tencent.sqlitelint.util.SLog;
import com.tencent.sqlitelint.util.SQLiteLintUtil;
import java.util.List;

public class CheckedDatabaseListActivity
extends SQLiteLintBaseActivity {
    private static final String TAG = "SQLiteLint.CheckedDatabaseListActivity";
    private ListView mListView;
    private CheckedDatabaseListAdapter mListAdapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        SQLiteLintDbHelper.INSTANCE.initialize((Context)this);
        this.initView();
    }

    protected void onResume() {
        super.onResume();
        this.refreshView();
    }

    @Override
    protected int getLayoutId() {
        return R.layout.activity_checked_database_list;
    }

    private void initView() {
        this.setTitle(this.getString(R.string.checked_database_list_title));
        this.mListView = (ListView)this.findViewById(R.id.list);
        this.mListAdapter = new CheckedDatabaseListAdapter((Context)this);
        this.mListView.setAdapter((ListAdapter)this.mListAdapter);
        this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                String dbPath = (String)parent.getItemAtPosition(position);
                if (SQLiteLintUtil.isNullOrNil(dbPath)) {
                    return;
                }
                Intent intent = new Intent();
                intent.setClass((Context)CheckedDatabaseListActivity.this, CheckResultActivity.class);
                intent.putExtra("db_label", dbPath);
                CheckedDatabaseListActivity.this.startActivity(intent);
            }
        });
    }

    private void refreshView() {
        List<String> defectiveDbList = IssueStorage.getDbPathList();
        SLog.i(TAG, "refreshView defectiveDbList is %d", defectiveDbList.size());
        this.mListAdapter.setData(defectiveDbList);
    }

    static class ViewHolder {
        public TextView dbPathTv;

        ViewHolder() {
        }
    }

    private static class CheckedDatabaseListAdapter
    extends BaseAdapter {
        private final LayoutInflater mInflater;
        private List<String> mDefectiveDbList;

        CheckedDatabaseListAdapter(Context context) {
            this.mInflater = LayoutInflater.from((Context)context);
        }

        public void setData(List<String> defectiveDbList) {
            this.mDefectiveDbList = defectiveDbList;
            this.notifyDataSetChanged();
        }

        public int getCount() {
            if (this.mDefectiveDbList == null) {
                return 0;
            }
            return this.mDefectiveDbList.size();
        }

        public String getItem(int position) {
            return this.mDefectiveDbList.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder viewHolder;
            if (convertView == null) {
                convertView = this.mInflater.inflate(R.layout.view_checked_database_item, parent, false);
                viewHolder = new ViewHolder();
                viewHolder.dbPathTv = (TextView)convertView.findViewById(R.id.db_path);
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)convertView.getTag();
            }
            String dbPath = this.getItem(position);
            viewHolder.dbPathTv.setText((CharSequence)dbPath);
            return convertView;
        }
    }
}

