/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sqlitelint.behaviour.alert;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import com.tencent.sqlitelint.R;
import com.tencent.sqlitelint.SQLiteLintIssue;
import com.tencent.sqlitelint.behaviour.BaseBehaviour;
import com.tencent.sqlitelint.behaviour.alert.CheckResultActivity;
import com.tencent.sqlitelint.behaviour.alert.CheckedDatabaseListActivity;
import com.tencent.sqlitelint.behaviour.persistence.IssueStorage;
import com.tencent.sqlitelint.util.SLog;
import java.util.List;

public class IssueAlertBehaviour
extends BaseBehaviour {
    private static final String TAG = "Matrix.IssueAlertBehaviour";
    private final Context mContext;
    private final String mConcernedDbPath;
    private long mLastInsertRowId;
    private static Handler sMainHandler = new Handler(Looper.getMainLooper());
    private static final String NAME = "SQLiteLint";

    public IssueAlertBehaviour(Context context, String dbPath) {
        this.mContext = context;
        this.mConcernedDbPath = dbPath;
        IssueAlertBehaviour.createShortCut(context);
    }

    @Override
    public void onPublish(List<SQLiteLintIssue> publishedIssues) {
        if (publishedIssues == null || publishedIssues.isEmpty()) {
            return;
        }
        long currentInsertRowId = IssueStorage.getLastRowId();
        if (currentInsertRowId == this.mLastInsertRowId) {
            SLog.v(TAG, "no new issue", new Object[0]);
            return;
        }
        this.mLastInsertRowId = currentInsertRowId;
        sMainHandler.post(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent();
                intent.setClass(IssueAlertBehaviour.this.mContext, CheckResultActivity.class);
                intent.addFlags(0x10000000);
                intent.putExtra("db_label", IssueAlertBehaviour.this.mConcernedDbPath);
                IssueAlertBehaviour.this.mContext.startActivity(intent);
            }
        });
    }

    private static void createShortCut(Context context) {
        ContentResolver cr = context.getContentResolver();
        Uri contentUri = Uri.parse((String)"content://com.android.launcher2.settings/favorites?notify=true");
        Cursor c = cr.query(contentUri, new String[]{"title", "iconResource"}, "title=?", new String[]{NAME}, null);
        if (c != null) {
            int count = c.getCount();
            c.close();
            if (count > 0) {
                return;
            }
        }
        Intent shortcut = new Intent("com.android.launcher.action.INSTALL_SHORTCUT");
        shortcut.putExtra("android.intent.extra.shortcut.NAME", NAME);
        shortcut.putExtra("duplicate", false);
        Intent shortcutIntent = new Intent("android.intent.action.MAIN");
        shortcutIntent.setClassName(context, CheckedDatabaseListActivity.class.getName());
        shortcut.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)shortcutIntent);
        Intent.ShortcutIconResource iconRes = Intent.ShortcutIconResource.fromContext((Context)context, (int)R.drawable.sqlite_lint_icon);
        shortcut.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)iconRes);
        context.sendBroadcast(shortcut);
    }
}

