/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sqlitelint.behaviour.persistence;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import com.tencent.sqlitelint.SQLiteLintIssue;
import com.tencent.sqlitelint.behaviour.persistence.SQLiteLintDbHelper;
import com.tencent.sqlitelint.util.SLog;
import com.tencent.sqlitelint.util.SQLiteLintUtil;
import java.util.ArrayList;
import java.util.List;

public class IssueStorage {
    private static final String TAG = "SQLiteLint.IssueStorage";
    public static final String TABLE_NAME = "Issue";
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_DB_PATH = "dbPath";
    public static final String COLUMN_LEVEL = "level";
    public static final String COLUMN_DESC = "desc";
    public static final String COLUMN_DETAIL = "detail";
    public static final String COLUMN_ADVICE = "advice";
    public static final String COLUMN_CREATE_TIME = "createTime";
    public static final String COLUMN_EXT_INFO = "extInfo";
    public static final String COLUMN_SQL_TIME_COST = "sqlTimeCost";
    public static final String DB_VERSION_1_CREATE_SQL = String.format("CREATE TABLE IF NOT EXISTS %s (%s TEXT PRIMARY KEY NOT NULL, %s TEXT NOT NULL, %s INTEGER, %s TEXT, %s TEXT, %s TEXT, %s INTEGER, %s TEXT, %s INTEGER)", "Issue", "id", "dbPath", "level", "desc", "detail", "advice", "createTime", "extInfo", "sqlTimeCost");
    public static final String[] DB_VERSION_1_CREATE_INDEX = new String[]{String.format("CREATE INDEX IF NOT EXISTS %s ON %s(%s)", "DbLabel_Index", "Issue", "dbPath"), String.format("CREATE INDEX IF NOT EXISTS %s ON %s(%s,%s)", "DbLabel_CreateTime_Index", "Issue", "dbPath", "createTime")};
    private static SQLiteStatement sInsertAllSqlStatement;

    public static boolean saveIssue(SQLiteLintIssue issue) {
        if (IssueStorage.hasIssue(issue.id)) {
            SLog.i(TAG, "saveIssue already recorded id=%s", issue.id);
            return false;
        }
        return IssueStorage.doInsertIssue(issue);
    }

    public static void saveIssues(List<SQLiteLintIssue> issues) {
        SQLiteLintDbHelper.INSTANCE.getDatabase().beginTransaction();
        try {
            for (int i = 0; i < issues.size(); ++i) {
                IssueStorage.saveIssue(issues.get(i));
            }
            SQLiteLintDbHelper.INSTANCE.getDatabase().setTransactionSuccessful();
        }
        finally {
            SQLiteLintDbHelper.INSTANCE.getDatabase().endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasIssue(String id2) {
        String querySql = String.format("SELECT %s FROM %s WHERE %s='%s' limit 1", COLUMN_ID, TABLE_NAME, COLUMN_ID, id2);
        try (Cursor cursor = SQLiteLintDbHelper.INSTANCE.getDatabase().rawQuery(querySql, null);){
            boolean bl = cursor.getCount() > 0;
            return bl;
        }
    }

    private static boolean doInsertIssue(SQLiteLintIssue issue) {
        SQLiteStatement insertSql = IssueStorage.getInsertAllSqlStatement();
        insertSql.bindString(1, issue.id);
        insertSql.bindString(2, issue.dbPath);
        insertSql.bindLong(3, (long)issue.level);
        insertSql.bindString(4, SQLiteLintUtil.nullAsNil(issue.desc));
        insertSql.bindString(5, SQLiteLintUtil.nullAsNil(issue.detail));
        insertSql.bindString(6, SQLiteLintUtil.nullAsNil(issue.advice));
        insertSql.bindLong(7, issue.createTime);
        insertSql.bindString(8, issue.extInfo);
        insertSql.bindLong(9, issue.sqlTimeCost);
        long r = insertSql.executeInsert();
        SLog.d(TAG, "saveIssue insert ret=%s, id=%s", r, issue.id);
        if (r == -1L) {
            SLog.e(TAG, "addIssue failed", new Object[0]);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SQLiteLintIssue> getIssueListByDb(String dbLabel) {
        ArrayList<SQLiteLintIssue> issueList = new ArrayList<SQLiteLintIssue>();
        if (SQLiteLintUtil.isNullOrNil(dbLabel)) {
            return issueList;
        }
        String querySql = String.format("SELECT * FROM %s where %s=? ORDER BY %s DESC", TABLE_NAME, COLUMN_DB_PATH, COLUMN_CREATE_TIME);
        try (Cursor cursor = SQLiteLintDbHelper.INSTANCE.getDatabase().rawQuery(querySql, new String[]{dbLabel});){
            while (cursor.moveToNext()) {
                issueList.add(IssueStorage.issueConvertFromCursor(cursor));
            }
        }
        return issueList;
    }

    public static List<String> getDbPathList() {
        ArrayList<String> dbPathList = new ArrayList<String>();
        String querySql = String.format("SELECT DISTINCT(%s) FROM %s", COLUMN_DB_PATH, TABLE_NAME);
        try (Cursor cursor = SQLiteLintDbHelper.INSTANCE.getDatabase().rawQuery(querySql, null);){
            while (cursor.moveToNext()) {
                dbPathList.add(cursor.getString(cursor.getColumnIndex(COLUMN_DB_PATH)));
            }
        }
        return dbPathList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastRowId() {
        String querySql = String.format("SELECT rowid FROM %s order by rowid desc limit 1", TABLE_NAME);
        try (Cursor cursor = SQLiteLintDbHelper.INSTANCE.getDatabase().rawQuery(querySql, null);){
            if (cursor != null && cursor.getCount() > 0) {
                cursor.moveToFirst();
                long l = cursor.getLong(0);
                return l;
            }
            long l = -1L;
            return l;
        }
    }

    public static void clearData() {
        String sql = String.format("delete from %s", TABLE_NAME);
        SQLiteLintDbHelper.INSTANCE.getDatabase().execSQL(sql);
    }

    private static SQLiteStatement getInsertAllSqlStatement() {
        if (sInsertAllSqlStatement == null) {
            sInsertAllSqlStatement = SQLiteLintDbHelper.INSTANCE.getDatabase().compileStatement(String.format("INSERT INTO %s VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)", TABLE_NAME));
        }
        return sInsertAllSqlStatement;
    }

    private static SQLiteLintIssue issueConvertFromCursor(Cursor cursor) {
        SQLiteLintIssue issue = new SQLiteLintIssue();
        issue.id = cursor.getString(cursor.getColumnIndex(COLUMN_ID));
        issue.dbPath = cursor.getString(cursor.getColumnIndex(COLUMN_DB_PATH));
        issue.level = cursor.getInt(cursor.getColumnIndex(COLUMN_LEVEL));
        issue.desc = cursor.getString(cursor.getColumnIndex(COLUMN_DESC));
        issue.detail = cursor.getString(cursor.getColumnIndex(COLUMN_DETAIL));
        issue.advice = cursor.getString(cursor.getColumnIndex(COLUMN_ADVICE));
        issue.createTime = cursor.getLong(cursor.getColumnIndex(COLUMN_CREATE_TIME));
        issue.extInfo = cursor.getString(cursor.getColumnIndex(COLUMN_EXT_INFO));
        issue.sqlTimeCost = cursor.getLong(cursor.getColumnIndex(COLUMN_SQL_TIME_COST));
        return issue;
    }
}

