/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sqlitelint.behaviour.persistence;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.os.Environment;
import com.tencent.sqlitelint.behaviour.persistence.IssueStorage;
import com.tencent.sqlitelint.util.SLog;
import com.tencent.sqlitelint.util.SQLiteLintUtil;

public enum SQLiteLintOwnDatabase {
    INSTANCE;

    private static final String TAG = "SQLiteLint.SQLiteLintOwnDatabase";
    private static final String ROOT_PATH;
    private static final String DATABASE_DIRECTORY = "database";
    private static final String DATABASE_NAME = "own.db";
    private static String sOwnDbDirectory;
    private static final int VERSION_1 = 1;
    private static final int NEW_VERSION = 1;
    private volatile SQLiteDatabase mDatabase;
    private boolean mIsInitializing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteDatabase getDatabase() {
        if (this.mDatabase == null || !this.mDatabase.isOpen()) {
            SQLiteLintOwnDatabase sQLiteLintOwnDatabase = this;
            synchronized (sQLiteLintOwnDatabase) {
                if (this.mDatabase == null || !this.mDatabase.isOpen()) {
                    this.mDatabase = this.openOrCreateDatabase();
                }
            }
        }
        return this.mDatabase;
    }

    public synchronized void closeDatabase() {
        if (this.mIsInitializing) {
            throw new IllegalStateException("Closed during initialization");
        }
        if (this.mDatabase != null && this.mDatabase.isOpen()) {
            this.mDatabase.close();
            this.mDatabase = null;
        }
    }

    private void onCreate(SQLiteDatabase db) {
        SLog.i(TAG, "onCreate", new Object[0]);
        db.execSQL(IssueStorage.DB_VERSION_1_CREATE_SQL);
        for (int i = 0; i < IssueStorage.DB_VERSION_1_CREATE_INDEX.length; ++i) {
            db.execSQL(IssueStorage.DB_VERSION_1_CREATE_INDEX[i]);
        }
    }

    private void onUpgrade(SQLiteDatabase db, int oldVersion) {
        SLog.i(TAG, "onUpgrade oldVersion=%d, newVersion=%d", oldVersion, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLiteDatabase openOrCreateDatabase() {
        if (this.mIsInitializing) {
            throw new IllegalStateException("getDatabase called recursively");
        }
        if (SQLiteLintUtil.isNullOrNil(sOwnDbDirectory)) {
            throw new IllegalStateException("OwnDbDirectory not init");
        }
        try {
            this.mIsInitializing = true;
            String databasePath = String.format("%s/%s", sOwnDbDirectory, DATABASE_NAME);
            SLog.i(TAG, "openOrCreateDatabase path=%s", databasePath);
            SQLiteLintUtil.mkdirs(databasePath);
            SQLiteDatabase db = SQLiteDatabase.openDatabase((String)databasePath, null, (int)0x10000000, null);
            int version = db.getVersion();
            if (version != 1) {
                db.beginTransaction();
                try {
                    if (version == 0) {
                        this.onCreate(db);
                    } else if (version != 1) {
                        this.onUpgrade(db, version);
                    }
                    db.setVersion(1);
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
            }
            SQLiteDatabase sQLiteDatabase = db;
            return sQLiteDatabase;
        }
        finally {
            this.mIsInitializing = false;
        }
    }

    public static void setOwnDbDirectory(Context context) {
        if (!SQLiteLintUtil.isNullOrNil(sOwnDbDirectory)) {
            return;
        }
        sOwnDbDirectory = String.format("%s/SQLiteLint-%s/%s/", ROOT_PATH, context.getPackageManager(), DATABASE_DIRECTORY);
    }

    static {
        ROOT_PATH = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getAbsolutePath();
        sOwnDbDirectory = "";
    }
}

