/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sqlitelint.config;

import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.tencent.sqlitelint.SQLiteLint;
import com.tencent.sqlitelint.SimpleSQLiteExecutionDelegate;
import java.util.ArrayList;
import java.util.List;

public final class SQLiteLintConfig {
    private final List<ConcernDb> sConcernDbList;

    public SQLiteLintConfig(SQLiteLint.SqlExecutionCallbackMode sqlExecutionCallbackMode) {
        SQLiteLint.setSqlExecutionCallbackMode(sqlExecutionCallbackMode);
        this.sConcernDbList = new ArrayList<ConcernDb>();
    }

    public void addConcernDB(ConcernDb concernDB) {
        if (concernDB == null) {
            return;
        }
        if (concernDB.mInstallEnv == null) {
            return;
        }
        String concernDbPath = concernDB.mInstallEnv.getConcernedDbPath();
        if (TextUtils.isEmpty((CharSequence)concernDbPath)) {
            return;
        }
        for (int i = 0; i < this.sConcernDbList.size(); ++i) {
            if (!concernDbPath.equals(concernDB.mInstallEnv.getConcernedDbPath())) continue;
            return;
        }
        this.sConcernDbList.add(concernDB);
    }

    public List<ConcernDb> getConcernDbList() {
        return this.sConcernDbList;
    }

    public static final class ConcernDb {
        private static final String EXPLAIN_QUERY_PLAN_CHECKER_NAME = "ExplainQueryPlanChecker";
        private static final String AVOID_SELECT_ALL_CHECKER_NAME = "AvoidSelectAllChecker";
        private static final String WITHOUT_ROWID_BETTER_CHECKER_NAME = "WithoutRowIdBetterChecker";
        private static final String AVOID_AUTO_INCREMENT_CHECKER_NAME = "AvoidAutoIncrementChecker";
        private static final String PREPARED_STATEMENT_BETTER_CHECKER_NAME = "PreparedStatementBetterChecker";
        private static final String REDUNDANT_INDEX_CHECKER_NAME = "RedundantIndexChecker";
        private final SQLiteLint.InstallEnv mInstallEnv;
        private final SQLiteLint.Options mOptions;
        private int mWhiteListXmlResId;
        private final List<String> mEnableCheckerList = new ArrayList<String>();

        public ConcernDb(SQLiteLint.InstallEnv installEnv, SQLiteLint.Options options) {
            this.mInstallEnv = installEnv;
            this.mOptions = options;
        }

        public ConcernDb(SQLiteDatabase db) {
            assert (db != null);
            this.mInstallEnv = new SQLiteLint.InstallEnv(db.getPath(), new SimpleSQLiteExecutionDelegate(db));
            this.mOptions = SQLiteLint.Options.LAX;
        }

        public ConcernDb setWhiteListXml(int xmlResId) {
            this.mWhiteListXmlResId = xmlResId;
            return this;
        }

        public SQLiteLint.InstallEnv getInstallEnv() {
            return this.mInstallEnv;
        }

        public SQLiteLint.Options getOptions() {
            return this.mOptions;
        }

        public int getWhiteListXmlResId() {
            return this.mWhiteListXmlResId;
        }

        public ConcernDb enableAllCheckers() {
            return this.enableExplainQueryPlanChecker().enableAvoidSelectAllChecker().enableWithoutRowIdBetterChecker().enableAvoidAutoIncrementChecker().enablePreparedStatementBetterChecker().enableRedundantIndexChecker();
        }

        public ConcernDb enableExplainQueryPlanChecker() {
            return this.enableChecker(EXPLAIN_QUERY_PLAN_CHECKER_NAME);
        }

        public ConcernDb enableAvoidSelectAllChecker() {
            return this.enableChecker(AVOID_SELECT_ALL_CHECKER_NAME);
        }

        public ConcernDb enableWithoutRowIdBetterChecker() {
            return this.enableChecker(WITHOUT_ROWID_BETTER_CHECKER_NAME);
        }

        public ConcernDb enableAvoidAutoIncrementChecker() {
            return this.enableChecker(AVOID_AUTO_INCREMENT_CHECKER_NAME);
        }

        public ConcernDb enablePreparedStatementBetterChecker() {
            return this.enableChecker(PREPARED_STATEMENT_BETTER_CHECKER_NAME);
        }

        public ConcernDb enableRedundantIndexChecker() {
            return this.enableChecker(REDUNDANT_INDEX_CHECKER_NAME);
        }

        public List<String> getEnableCheckerList() {
            return this.mEnableCheckerList;
        }

        private ConcernDb enableChecker(String checkerName) {
            this.mEnableCheckerList.add(checkerName);
            return this;
        }
    }
}

