/*
 * Decompiled with CFR 0.152.
 */
package org.libpag;

import android.content.res.AssetManager;
import android.text.TextUtils;
import org.extra.tools.a;
import org.libpag.NativeTask;
import org.libpag.PAGComposition;
import org.libpag.PAGImage;
import org.libpag.PAGLayer;
import org.libpag.PAGText;
import org.libpag.b;

public class PAGFile
extends PAGComposition {
    public static native int MaxSupportedTagLevel();

    public static PAGFile Load(String string) {
        if (!TextUtils.isEmpty((CharSequence)string) && (string.startsWith("http://") || string.startsWith("https://"))) {
            byte[] byArray = b.a(string);
            if (byArray == null) {
                return null;
            }
            return PAGFile.LoadFromBytes(byArray, byArray.length, string);
        }
        return PAGFile.LoadFromPath(string);
    }

    public static void LoadAsync(String string, LoadListener loadListener) {
        NativeTask.Run(() -> {
            string = PAGFile.Load(string);
            if (loadListener != null) {
                loadListener.onLoad((PAGFile)((Object)string));
            }
        });
    }

    public static PAGFile Load(byte[] byArray) {
        return PAGFile.LoadFromBytes(byArray, byArray.length, "");
    }

    public static PAGFile Load(AssetManager assetManager, String string) {
        return PAGFile.LoadFromAssets(assetManager, string);
    }

    private static native PAGFile LoadFromPath(String var0);

    private static native PAGFile LoadFromBytes(byte[] var0, int var1, String var2);

    private static native PAGFile LoadFromAssets(AssetManager var0, String var1);

    private PAGFile(long l2) {
        super(l2);
    }

    private static final native void nativeInit();

    static {
        a.b("pag");
        PAGFile.nativeInit();
    }

    public native int tagLevel();

    public native int numTexts();

    public native int numImages();

    public native int numVideos();

    public native String path();

    public native PAGText getTextData(int var1);

    public native void replaceText(int var1, PAGText var2);

    public void replaceImage(int n, PAGImage pAGImage) {
        if (pAGImage == null) {
            this.nativeReplaceImage(n, 0L);
        } else {
            long l2 = pAGImage.nativeContext;
            this.nativeReplaceImage(n, l2);
        }
    }

    public native void nativeReplaceImage(int var1, long var2);

    public void replaceImageByName(String string, PAGImage pAGImage) {
        if (pAGImage == null) {
            this.nativeReplaceImageByName(string, 0L);
        } else {
            long l2 = pAGImage.nativeContext;
            this.nativeReplaceImageByName(string, l2);
        }
    }

    public native void nativeReplaceImageByName(String var1, long var2);

    public native PAGLayer[] getLayersByEditableIndex(int var1, int var2);

    public native int[] getEditableIndices(int var1);

    public native int timeStretchMode();

    public native void setTimeStretchMode(int var1);

    public native void setDuration(long var1);

    public native PAGFile copyOriginal();

    public static interface LoadListener {
        public void onLoad(PAGFile var1);
    }
}

