/*
 * Decompiled with CFR 0.152.
 */
package com.toolmatrix.feedback;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import com.toolmatrix.feedback.MiddlePageActivity;
import com.toolmatrix.feedback.WebContainerActivity;
import com.toolmatrix.feedback.jsbridge.FeedbackJavascriptInterface;
import com.toolmatrix.feedback.utils.ActivityMonitor;
import com.toolmatrix.feedback.utils.ActivityState;
import com.toolmatrix.feedback.utils.EncryptUtils;
import com.toolmatrix.webview.lib_jsbridge.util.BridgeUtil;
import java.io.IOException;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0019\u0018\u0000 42\u00020\u0001:\u00043456B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\r\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u000e\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0006J\u000f\u0010\"\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b#J\u000f\u0010$\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b%J\u0016\u0010&\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nJ\r\u0010'\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b(J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010/\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004J\u000e\u00100\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0004J\u0016\u00101\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004J\u000e\u00102\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/toolmatrix/feedback/FeedbackManager;", "", "()V", "appName", "", "autoRequestRedDotCallback", "Lcom/toolmatrix/feedback/FeedbackManager$Callback;", "context", "Landroid/content/Context;", "darkMode", "", "formalUrl", "gaid", "isTestEnv", "mcc", "offlineFeedbackClickCallback", "Lcom/toolmatrix/feedback/FeedbackManager$OfflineFeedbackClickCallback;", "okHttpClient", "Lokhttp3/OkHttpClient;", "redDotRequestFormalUrl", "redDotRequestTestUrl", "telegramJumpUrl", "testUrl", "userIdentifier", "checkInitialized", "", "checkParam", "param", "errorDesc", "getBaseParamObj", "Lorg/json/JSONObject;", "getBaseParamObj$feedback_release", "getHasUnreadMsg", "callback", "getOfflineFeedbackClickCallback", "getOfflineFeedbackClickCallback$feedback_release", "getTelegramJumpUrl", "getTelegramJumpUrl$feedback_release", "initFeedback", "isDarkMode", "isDarkMode$feedback_release", "setAppName", "setAutoRequestRedDotCallback", "setDarkMode", "setGaid", "setMcc", "setOfflineFeedbackClickCallback", "setRedDotRequestUrl", "setTelegramJumpUrl", "setUrl", "setUserIdentifier", "Callback", "Companion", "InstanceHolder", "OfflineFeedbackClickCallback", "feedback_release"})
public final class FeedbackManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String formalUrl;
    @Nullable
    private String testUrl;
    @Nullable
    private String appName;
    @Nullable
    private String userIdentifier;
    @Nullable
    private String gaid;
    @Nullable
    private String mcc;
    private boolean darkMode;
    @Nullable
    private String redDotRequestFormalUrl;
    @Nullable
    private String redDotRequestTestUrl;
    @Nullable
    private String telegramJumpUrl;
    private boolean isTestEnv;
    @Nullable
    private Callback autoRequestRedDotCallback;
    @Nullable
    private OfflineFeedbackClickCallback offlineFeedbackClickCallback;
    @Nullable
    private Context context;
    @NotNull
    private final OkHttpClient okHttpClient = new OkHttpClient.Builder().build();

    private FeedbackManager() {
    }

    @NotNull
    public final FeedbackManager setUrl(@NotNull String formalUrl, @NotNull String testUrl) {
        Intrinsics.checkNotNullParameter((Object)formalUrl, (String)"formalUrl");
        Intrinsics.checkNotNullParameter((Object)testUrl, (String)"testUrl");
        this.formalUrl = formalUrl;
        this.testUrl = testUrl;
        return this;
    }

    @NotNull
    public final FeedbackManager setAppName(@NotNull String appName) {
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        this.appName = appName;
        return this;
    }

    @NotNull
    public final FeedbackManager setUserIdentifier(@NotNull String userIdentifier) {
        Intrinsics.checkNotNullParameter((Object)userIdentifier, (String)"userIdentifier");
        this.userIdentifier = userIdentifier;
        return this;
    }

    @NotNull
    public final FeedbackManager setGaid(@NotNull String gaid) {
        Intrinsics.checkNotNullParameter((Object)gaid, (String)"gaid");
        this.gaid = gaid;
        return this;
    }

    @NotNull
    public final FeedbackManager setMcc(@NotNull String mcc) {
        Intrinsics.checkNotNullParameter((Object)mcc, (String)"mcc");
        this.mcc = mcc;
        return this;
    }

    @NotNull
    public final FeedbackManager setDarkMode(boolean darkMode) {
        this.darkMode = darkMode;
        return this;
    }

    @NotNull
    public final FeedbackManager setRedDotRequestUrl(@NotNull String formalUrl, @NotNull String testUrl) {
        Intrinsics.checkNotNullParameter((Object)formalUrl, (String)"formalUrl");
        Intrinsics.checkNotNullParameter((Object)testUrl, (String)"testUrl");
        this.redDotRequestFormalUrl = formalUrl;
        this.redDotRequestTestUrl = testUrl;
        return this;
    }

    @NotNull
    public final FeedbackManager setTelegramJumpUrl(@NotNull String telegramJumpUrl) {
        Intrinsics.checkNotNullParameter((Object)telegramJumpUrl, (String)"telegramJumpUrl");
        this.telegramJumpUrl = telegramJumpUrl;
        return this;
    }

    @NotNull
    public final FeedbackManager setAutoRequestRedDotCallback(@NotNull Callback autoRequestRedDotCallback) {
        Intrinsics.checkNotNullParameter((Object)autoRequestRedDotCallback, (String)"autoRequestRedDotCallback");
        this.autoRequestRedDotCallback = autoRequestRedDotCallback;
        return this;
    }

    @NotNull
    public final FeedbackManager setOfflineFeedbackClickCallback(@NotNull OfflineFeedbackClickCallback offlineFeedbackClickCallback) {
        Intrinsics.checkNotNullParameter((Object)offlineFeedbackClickCallback, (String)"offlineFeedbackClickCallback");
        this.offlineFeedbackClickCallback = offlineFeedbackClickCallback;
        return this;
    }

    public final void initFeedback(@NotNull Context context, boolean isTestEnv) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.checkParam(this.formalUrl, "\u2018formalUrl' not set.");
        this.checkParam(this.testUrl, "'testUrl' not set.");
        this.checkParam(this.appName, "'appName' not set.");
        this.checkParam(this.userIdentifier, "'userIdentifier' not set.");
        this.checkParam(this.redDotRequestFormalUrl, "'redDotRequestUrl' not set.");
        this.checkParam(this.redDotRequestTestUrl, "'redDotRequestUrl' not set.");
        this.context = context;
        this.isTestEnv = isTestEnv;
        if (this.autoRequestRedDotCallback != null) {
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNull((Object)context2, (String)"null cannot be cast to non-null type android.app.Application");
            Application application = (Application)context2;
            application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    ActivityMonitor.getInstance().onActivityEvent(activity, ActivityState.CREATED);
                }

                public void onActivityStarted(@NotNull Activity activity) {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    ActivityMonitor.getInstance().onActivityEvent(activity, ActivityState.STARTED);
                }

                public void onActivityResumed(@NotNull Activity activity) {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    ActivityMonitor.getInstance().onActivityEvent(activity, ActivityState.RESUMED);
                }

                public void onActivityPaused(@NotNull Activity activity) {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    ActivityMonitor.getInstance().onActivityEvent(activity, ActivityState.PAUSED);
                }

                public void onActivityStopped(@NotNull Activity activity) {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    ActivityMonitor.getInstance().onActivityEvent(activity, ActivityState.STOPPED);
                }

                public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
                }

                public void onActivityDestroyed(@NotNull Activity activity) {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    ActivityMonitor.getInstance().onActivityEvent(activity, ActivityState.DESTROYED);
                }
            });
            ActivityMonitor.getInstance().registerAppStateChangeListener(arg_0 -> FeedbackManager.initFeedback$lambda$0(this, arg_0));
        }
        BridgeUtil.INSTANCE.initJavaScriptsMethods(FeedbackJavascriptInterface.class);
    }

    private final void checkParam(String param, String errorDesc) {
        CharSequence charSequence = param;
        if (charSequence == null || charSequence.length() == 0) {
            throw new IllegalArgumentException(errorDesc);
        }
    }

    private final void checkInitialized() {
        if (this.context == null) {
            throw new IllegalStateException("'feedback' module not initialized.");
        }
    }

    public final boolean isDarkMode$feedback_release() {
        return this.darkMode;
    }

    @Nullable
    public final String getTelegramJumpUrl$feedback_release() {
        return this.telegramJumpUrl;
    }

    @Nullable
    public final OfflineFeedbackClickCallback getOfflineFeedbackClickCallback$feedback_release() {
        return this.offlineFeedbackClickCallback;
    }

    @NotNull
    public final JSONObject getBaseParamObj$feedback_release() {
        JSONObject jsonObject;
        JSONObject jSONObject;
        JSONObject $this$getBaseParamObj_u24lambda_u241 = jSONObject = (jsonObject = new JSONObject());
        boolean bl = false;
        $this$getBaseParamObj_u24lambda_u241.put("osType", (Object)"android");
        Context context = this.context;
        Intrinsics.checkNotNull((Object)context);
        $this$getBaseParamObj_u24lambda_u241.put("pkgName", (Object)context.getPackageName());
        $this$getBaseParamObj_u24lambda_u241.put("appName", (Object)this.appName);
        $this$getBaseParamObj_u24lambda_u241.put("osVersion", (Object)Build.VERSION.RELEASE);
        $this$getBaseParamObj_u24lambda_u241.put("model", (Object)Build.MODEL);
        try {
            Context context2 = this.context;
            Intrinsics.checkNotNull((Object)context2);
            PackageManager packageManager = context2.getPackageManager();
            Context context3 = this.context;
            Intrinsics.checkNotNull((Object)context3);
            PackageInfo packageInfo = packageManager.getPackageInfo(context3.getPackageName(), 0);
            String versionName = packageInfo.versionName;
            long versionCode = Build.VERSION.SDK_INT >= 28 ? packageInfo.getLongVersionCode() : (long)packageInfo.versionCode;
            $this$getBaseParamObj_u24lambda_u241.put("appVersion", (Object)String.valueOf(versionCode));
            $this$getBaseParamObj_u24lambda_u241.put("versionName", (Object)String.valueOf(versionName));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        Context context4 = this.context;
        Intrinsics.checkNotNull((Object)context4);
        Locale locale = context4.getResources().getConfiguration().locale;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"locale");
        Locale locale2 = locale;
        $this$getBaseParamObj_u24lambda_u241.put("language", (Object)locale2.getLanguage());
        $this$getBaseParamObj_u24lambda_u241.put("gaid", (Object)this.gaid);
        $this$getBaseParamObj_u24lambda_u241.put("mcc", (Object)this.mcc);
        $this$getBaseParamObj_u24lambda_u241.put("encryptUid", (Object)EncryptUtils.aesEncode(this.userIdentifier, "PoqRfJ8S1TNrxC8Kckedrg=="));
        $this$getBaseParamObj_u24lambda_u241.put("timezone", (Object)TimeZone.getDefault().getDisplayName(false, 0));
        $this$getBaseParamObj_u24lambda_u241.put("country", (Object)Locale.getDefault().getCountry());
        return jsonObject;
    }

    public final void getHasUnreadMsg(@NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.checkInitialized();
        JSONObject jsonObject = this.getBaseParamObj$feedback_release();
        String url = this.isTestEnv ? this.redDotRequestTestUrl : this.redDotRequestFormalUrl;
        Request.Builder builder = new Request.Builder();
        String string = url;
        Intrinsics.checkNotNull((Object)string);
        Request.Builder builder2 = builder.url(string);
        String string2 = jsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        Request request = builder2.put(RequestBody.Companion.create(string2, MediaType.Companion.get("application/json"))).build();
        this.okHttpClient.newCall(request).enqueue(new okhttp3.Callback(callback){
            final /* synthetic */ Callback $callback;
            {
                this.$callback = $callback;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$callback.onFail(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    Boolean hasNewReply;
                    String jsonStr = String.valueOf(response.body());
                    JSONObject jsonObj = new JSONObject(jsonStr);
                    JSONObject jSONObject = jsonObj.optJSONObject("data");
                    Boolean bl = hasNewReply = jSONObject != null ? Boolean.valueOf(jSONObject.optBoolean("hasNewReply")) : null;
                    this.$callback.onSuccess(bl != null ? bl : false);
                }
                catch (Exception e) {
                    this.$callback.onFail(e);
                }
            }
        });
    }

    private static final void initFeedback$lambda$0(FeedbackManager this$0, boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (it) {
            this$0.getHasUnreadMsg(new Callback(this$0){
                final /* synthetic */ FeedbackManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onSuccess(boolean hasUnreadMsg) {
                    block0: {
                        Callback callback = FeedbackManager.access$getAutoRequestRedDotCallback$p(this.this$0);
                        if (callback == null) break block0;
                        callback.onSuccess(hasUnreadMsg);
                    }
                }

                public void onFail(@NotNull Throwable throwable) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                        Callback callback = FeedbackManager.access$getAutoRequestRedDotCallback$p(this.this$0);
                        if (callback == null) break block0;
                        callback.onFail(throwable);
                    }
                }
            });
        }
    }

    public /* synthetic */ FeedbackManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final /* synthetic */ Callback access$getAutoRequestRedDotCallback$p(FeedbackManager $this) {
        return $this.autoRequestRedDotCallback;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\t"}, d2={"Lcom/toolmatrix/feedback/FeedbackManager$Callback;", "", "onFail", "", "throwable", "", "onSuccess", "hasUnreadMsg", "", "feedback_release"})
    public static interface Callback {
        public void onSuccess(boolean var1);

        public void onFail(@NotNull Throwable var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lcom/toolmatrix/feedback/FeedbackManager$Companion;", "", "()V", "getInstance", "Lcom/toolmatrix/feedback/FeedbackManager;", "startFeedbackPage", "", "context", "Landroid/content/Context;", "startMiddlePage", "feedback_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FeedbackManager getInstance() {
            return InstanceHolder.INSTANCE.getInstance();
        }

        public final void startMiddlePage(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.getInstance().checkInitialized();
            MiddlePageActivity.Companion.start(context);
        }

        public final void startFeedbackPage(@NotNull Context context) {
            String url;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.getInstance().checkInitialized();
            String string = url = this.getInstance().isTestEnv ? this.getInstance().testUrl : this.getInstance().formalUrl;
            Intrinsics.checkNotNull((Object)string);
            WebContainerActivity.Companion.start(context, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/toolmatrix/feedback/FeedbackManager$InstanceHolder;", "", "()V", "instance", "Lcom/toolmatrix/feedback/FeedbackManager;", "getInstance", "()Lcom/toolmatrix/feedback/FeedbackManager;", "feedback_release"})
    private static final class InstanceHolder {
        @NotNull
        public static final InstanceHolder INSTANCE = new InstanceHolder();
        @NotNull
        private static final FeedbackManager instance = new FeedbackManager(null);

        private InstanceHolder() {
        }

        @NotNull
        public final FeedbackManager getInstance() {
            return instance;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/toolmatrix/feedback/FeedbackManager$OfflineFeedbackClickCallback;", "", "onOfflineFeedbackClick", "", "feedback_release"})
    public static interface OfflineFeedbackClickCallback {
        public void onOfflineFeedbackClick();
    }
}

