/*
 * Decompiled with CFR 0.152.
 */
package com.toolmatrix.feedback.utils;

import android.app.Activity;
import android.util.Log;
import com.toolmatrix.feedback.utils.ActivityState;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ActivityMonitor {
    private static final String TAG = "ActivityMonitor";
    private static final ActivityState[] ACTIVE_ORDER = new ActivityState[]{ActivityState.DESTROYED, ActivityState.STOPPED, ActivityState.CREATED, ActivityState.STARTED, ActivityState.PAUSED, ActivityState.RESUMED};
    private static final ActivityState[] STRICT_ACTIVE_ORDER = new ActivityState[]{ActivityState.DESTROYED, ActivityState.STOPPED, ActivityState.PAUSED, ActivityState.CREATED, ActivityState.STARTED, ActivityState.RESUMED};
    private static boolean sDebug = false;
    private static boolean sStrictForeground = true;
    private final List<ActivityEntry> mActivityEntries = new ArrayList<ActivityEntry>();
    private boolean mAppForeground;
    private final List<OnAppStateChangeListener> mOnAppStateChangeListeners = new CopyOnWriteArrayList<OnAppStateChangeListener>();

    private ActivityMonitor() {
    }

    public static ActivityMonitor getInstance() {
        return SingletonHolder.sInstance;
    }

    public static void setDebug(boolean debug) {
        sDebug = debug;
    }

    public static void setStrictForeground(boolean strictForeground) {
        sStrictForeground = strictForeground;
    }

    private static int compare(ActivityState left, ActivityState right) {
        ActivityState[] order = sStrictForeground ? STRICT_ACTIVE_ORDER : ACTIVE_ORDER;
        return ActivityMonitor.getOrder(order, left) - ActivityMonitor.getOrder(order, right);
    }

    private static int getOrder(ActivityState[] order, ActivityState activityState) {
        int j = order.length;
        for (int i = 0; i < j; ++i) {
            if (order[i] != activityState) continue;
            return i;
        }
        return -1;
    }

    public void onActivityEvent(Activity activity, ActivityState activityState) {
        this.updateActivityState(activity, activityState);
    }

    public Activity getTopActivity() {
        if (this.mActivityEntries.isEmpty()) {
            return null;
        }
        return (Activity)this.mActivityEntries.get((int)(this.mActivityEntries.size() - 1)).mActivityRef.get();
    }

    public boolean isAppForeground() {
        if (this.mActivityEntries.isEmpty()) {
            return false;
        }
        ActivityEntry activityEntry = this.mActivityEntries.get(this.mActivityEntries.size() - 1);
        if (!sStrictForeground) {
            return activityEntry.mState == ActivityState.RESUMED || activityEntry.mState == ActivityState.PAUSED;
        }
        return activityEntry.mState == ActivityState.RESUMED || activityEntry.mState == ActivityState.PAUSED || activityEntry.mState == ActivityState.STARTED || activityEntry.mState == ActivityState.CREATED;
    }

    private void updateActivityState(Activity activity, ActivityState activityState) {
        ActivityEntry activityEntry = new ActivityEntry(activity, activityState);
        this.mActivityEntries.remove(activityEntry);
        this.mActivityEntries.add(activityEntry);
        this.clearAndSort();
        boolean foreground = this.isAppForeground();
        if (this.mAppForeground != foreground) {
            this.mAppForeground = foreground;
            this.notifyAppStateChanged();
        }
        if (sDebug) {
            Activity topActivity = this.getTopActivity();
            Log.d((String)TAG, (String)(activity.getClass().getSimpleName() + " " + (Object)((Object)activityEntry.mState) + ", top activity is " + (topActivity == null ? "null" : topActivity.getClass().getSimpleName()) + ", foreground = " + this.isAppForeground() + ", activities = " + this.mActivityEntries.size()));
        }
    }

    private void clearAndSort() {
        this.mActivityEntries.removeIf(activityEntry -> activityEntry.mState == ActivityState.DESTROYED);
        this.mActivityEntries.sort((lhs, rhs) -> ActivityMonitor.compare(lhs.mState, rhs.mState));
    }

    public void registerAppStateChangeListener(OnAppStateChangeListener onAppStateChangeListener) {
        if (!this.mOnAppStateChangeListeners.contains(onAppStateChangeListener)) {
            this.mOnAppStateChangeListeners.add(onAppStateChangeListener);
        }
    }

    public void removeAppStateChangeListener(OnAppStateChangeListener onAppStateChangeListener) {
        this.mOnAppStateChangeListeners.remove(onAppStateChangeListener);
    }

    private void notifyAppStateChanged() {
        for (OnAppStateChangeListener onAppStateChangeListener : this.mOnAppStateChangeListeners) {
            onAppStateChangeListener.onAppStateChange(this.mAppForeground);
        }
    }

    private static class SingletonHolder {
        static ActivityMonitor sInstance = new ActivityMonitor();

        private SingletonHolder() {
        }
    }

    private static class ActivityEntry {
        WeakReference<Activity> mActivityRef;
        ActivityState mState;

        ActivityEntry(Activity activity, ActivityState activityState) {
            this.mActivityRef = new WeakReference<Activity>(activity);
            this.mState = activityState;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ActivityEntry) {
                ActivityEntry activityEntry = (ActivityEntry)o;
                return this.mActivityRef == activityEntry.mActivityRef || this.mActivityRef != null && activityEntry.mActivityRef != null && this.mActivityRef.get() == activityEntry.mActivityRef.get();
            }
            return false;
        }
    }

    public static interface OnAppStateChangeListener {
        public void onAppStateChange(boolean var1);
    }
}

