/*
 * Decompiled with CFR 0.152.
 */
package com.toolmatrix.feedback.utils;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;

public final class BarUtils {
    private static final String TAG_STATUS_BAR = "TAG_STATUS_BAR";

    private BarUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static int getStatusBarHeight() {
        Resources resources = Resources.getSystem();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        return resources.getDimensionPixelSize(resourceId);
    }

    public static void setStatusBarLightMode(Activity activity, boolean isLightMode) {
        BarUtils.setStatusBarLightMode(activity.getWindow(), isLightMode);
    }

    public static void setStatusBarLightMode(Window window, boolean isLightMode) {
        if (Build.VERSION.SDK_INT >= 23) {
            View decorView = window.getDecorView();
            int vis = decorView.getSystemUiVisibility();
            vis = isLightMode ? (vis |= 0x2000) : (vis &= 0xFFFFDFFF);
            decorView.setSystemUiVisibility(vis);
        }
    }

    public static View setStatusBarColor(Activity activity, int color) {
        return BarUtils.setStatusBarColor(activity, color, false);
    }

    public static View setStatusBarColor(Activity activity, int color, boolean isDecor) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        BarUtils.transparentStatusBar(activity);
        return BarUtils.applyStatusBarColor(activity, color, isDecor);
    }

    private static View applyStatusBarColor(Activity activity, int color, boolean isDecor) {
        return BarUtils.applyStatusBarColor(activity.getWindow(), color, isDecor);
    }

    private static View applyStatusBarColor(Window window, int color, boolean isDecor) {
        ViewGroup parent = isDecor ? (ViewGroup)window.getDecorView() : (ViewGroup)window.findViewById(0x1020002);
        View fakeStatusBarView = parent.findViewWithTag((Object)TAG_STATUS_BAR);
        if (fakeStatusBarView != null) {
            if (fakeStatusBarView.getVisibility() == 8) {
                fakeStatusBarView.setVisibility(0);
            }
            fakeStatusBarView.setBackgroundColor(color);
        } else {
            fakeStatusBarView = BarUtils.createStatusBarView(window.getContext(), color);
            parent.addView(fakeStatusBarView);
        }
        return fakeStatusBarView;
    }

    private static View createStatusBarView(Context context, int color) {
        View statusBarView = new View(context);
        statusBarView.setLayoutParams(new ViewGroup.LayoutParams(-1, BarUtils.getStatusBarHeight()));
        statusBarView.setBackgroundColor(color);
        statusBarView.setTag((Object)TAG_STATUS_BAR);
        return statusBarView;
    }

    public static void transparentStatusBar(Activity activity) {
        BarUtils.transparentStatusBar(activity.getWindow());
    }

    public static void transparentStatusBar(Window window) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            int option = 1280;
            int vis = window.getDecorView().getSystemUiVisibility();
            window.getDecorView().setSystemUiVisibility(option | vis);
            window.setStatusBarColor(0);
        } else {
            window.addFlags(0x4000000);
        }
    }
}

