/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk;

import android.content.Context;
import android.graphics.Rect;
import android.net.Uri;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.tp.adx.R;
import com.tp.adx.open.AdError;
import com.tp.adx.open.TPAdOptions;
import com.tp.adx.open.TPInnerMediaView;
import com.tp.adx.open.TPInnerNativeAd;
import com.tp.adx.sdk.InnerParseManager;
import com.tp.adx.sdk.bean.TPPayloadInfo;
import com.tp.adx.sdk.event.InnerSendEventMessage;
import com.tp.adx.sdk.tracking.InnerTrackNotification;
import com.tp.adx.sdk.tracking.InnerVastNotificationUtils;
import com.tp.adx.sdk.ui.BaseWebView;
import com.tp.adx.sdk.ui.InnerHtmlWebView;
import com.tp.adx.sdk.ui.InnerMraidWebView;
import com.tp.adx.sdk.ui.MraidJavascript;
import com.tp.adx.sdk.ui.TPInnerNativeBannerFactory;
import com.tp.adx.sdk.util.InnerLog;
import com.tp.adx.sdk.util.ViewUtils;
import com.tp.common.InnerImpressionUtils;
import com.tp.vast.VastManager;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.common.util.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class InnerBannerMgr
extends InnerParseManager {
    private static final String TAG = "InnerSDK";
    private static final long LOSS_TIME_DELAY = 1200000L;
    private FrameLayout bannerView;
    private BaseWebView mWebView;
    private boolean mIsShowing = false;
    private int width;
    private int height;
    private boolean isShowClose = false;
    private boolean isDestroy;
    View.OnClickListener onClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (InnerBannerMgr.this.bannerView == null || !InnerBannerMgr.this.checkViewHasVisible((View)InnerBannerMgr.this.bannerView, InnerBannerMgr.this.bidInfo)) {
                return;
            }
            try {
                Object tag = v.getTag();
                if (tag instanceof String && "tp_inner_privacy_tag".equals(String.valueOf(tag))) {
                    InnerBannerMgr.this.onJumpAction(v.getContext(), InnerBannerMgr.this.mNativeInfo.getPrivacy(), "", InnerBannerMgr.this.adUnitId);
                    return;
                }
                if (InnerBannerMgr.this.innerSendEventMessage != null) {
                    InnerBannerMgr.this.innerSendEventMessage.sendClickAdStart();
                }
                ArrayList<String> urls = new ArrayList<String>();
                InnerBannerMgr.this.getClickUrlByNativeInfo(InnerBannerMgr.this.mNativeInfo, urls);
                if (urls.size() <= 0) {
                    return;
                }
                Log.v((String)InnerBannerMgr.TAG, (String)"onClick");
                InnerLog.v(InnerBannerMgr.TAG, "onClick :" + urls.get(0));
                boolean success = InnerBannerMgr.this.onJumpAction(v.getContext(), urls.get(0), InnerBannerMgr.this.innerSendEventMessage.getRequestId(), InnerBannerMgr.this.adUnitId);
                if (InnerBannerMgr.this.tpInnerAdListener != null) {
                    InnerBannerMgr.this.tpInnerAdListener.onAdClicked();
                }
                InnerVastNotificationUtils.getInstance().sendCompanionClickNotification(InnerBannerMgr.this.innerNativeAd.getVastVideoConfig());
                InnerTrackNotification.sendClickNotification(InnerBannerMgr.this.bidInfo, InnerBannerMgr.this.innerSendEventMessage, VastManager.getVastNetworkMediaUrl(InnerBannerMgr.this.innerNativeAd.getVastVideoConfig()));
                if (InnerBannerMgr.this.innerSendEventMessage != null) {
                    InnerBannerMgr.this.innerSendEventMessage.sendClickAdEnd(success ? 1 : 32);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    private int validCount;

    public InnerBannerMgr(String adUnitId, FrameLayout bannerView, String payload) {
        super(adUnitId, payload);
        this.bannerView = bannerView;
    }

    @Override
    public void setAdOption(TPAdOptions options) {
        super.setAdOption(options);
        this.width = options.getWidth();
        this.height = options.getHeight();
        this.isMute = options.isMute();
        this.isShowClose = options.isShowCloseBtn();
    }

    @Override
    public boolean parseAdm() {
        if (this.getAdmType() == 1) {
            if (!this.parseNativeInfo()) {
                return false;
            }
        } else {
            this.startTimeOutDelay(this.innerSendEventMessage);
            this.sendWinNotification();
            this.loadDataEnd();
        }
        return true;
    }

    @Override
    protected void loadDataEnd() {
        TPTaskManager.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        if (InnerBannerMgr.this.getAdmType() == 1) {
                            InnerBannerMgr.this.addAndRegisterNativeBanner();
                        } else {
                            if (InnerBannerMgr.this.bidInfo.getAdm().contains("mraid.js")) {
                                InnerBannerMgr.this.bidInfo.setAdm(InnerBannerMgr.this.bidInfo.getAdm().replace("src=\"mraid.js\">", ">" + MraidJavascript.JAVASCRIPT_SOURCE));
                                InnerLog.v(InnerBannerMgr.TAG, "adm:" + InnerBannerMgr.this.bidInfo.getAdm());
                                InnerBannerMgr.this.prepareMraidView();
                            } else {
                                InnerBannerMgr.this.prepareHtmlView();
                            }
                            InnerBannerMgr.this.mIsShowing = false;
                            InnerBannerMgr.this.mWebView.loadHtmlResponse(InnerBannerMgr.this.bidInfo.getAdm());
                        }
                        InnerBannerMgr.this.startObserverView();
                    }
                    catch (Throwable throwable) {
                        if (InnerBannerMgr.this.tpInnerAdListener == null) break block6;
                        InnerBannerMgr.this.tpInnerAdListener.onAdLoadFailed(new AdError(1007, "webview package not found"));
                    }
                }
            }
        });
    }

    @Override
    protected void loadVastDataEnd() {
        if (this.getAdmType() == 1) {
            this.addAndRegisterNativeBanner();
        }
    }

    private void addAndRegisterNativeBanner() {
        TPInnerNativeBannerFactory tpInnerNativeBannerFactory = new TPInnerNativeBannerFactory();
        ViewGroup view = tpInnerNativeBannerFactory.createNativeBanner(this.bannerView.getContext(), this.innerNativeAd, this.width, this.height);
        this.addViewToBanner(view);
        this.registerView(view, tpInnerNativeBannerFactory.getClickViews(), this.innerNativeAd, true);
    }

    private void prepareMraidView() {
        this.mWebView = new InnerMraidWebView(this.bannerView.getContext());
        this.prepareView();
    }

    private void prepareHtmlView() {
        this.mWebView = new InnerHtmlWebView(this.bannerView.getContext(), true);
        this.prepareView();
    }

    private void addViewToBanner(ViewGroup viewGroup) {
        FrameLayout.LayoutParams layoutParams = this.width > 0 && this.height > 0 ? new FrameLayout.LayoutParams(ViewUtils.dp2px(this.bannerView.getContext(), this.width), ViewUtils.dp2px(this.bannerView.getContext(), this.height)) : new FrameLayout.LayoutParams(-1, -2);
        layoutParams.gravity = 17;
        if (this.isShowClose) {
            layoutParams.rightMargin = ViewUtils.dp2px(this.bannerView.getContext(), 15);
        }
        this.bannerView.addView((View)viewGroup, (ViewGroup.LayoutParams)layoutParams);
        if (this.isShowClose) {
            ImageView closeBtn = new ImageView(this.bannerView.getContext());
            closeBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (InnerBannerMgr.this.tpInnerAdListener != null) {
                        InnerBannerMgr.this.tpInnerAdListener.onAdClosed();
                    }
                    InnerBannerMgr.this.bannerView.removeAllViews();
                }
            });
            closeBtn.setBackgroundResource(R.drawable.tp_adx_close_bg);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(ViewUtils.dp2px(this.bannerView.getContext(), 15), ViewUtils.dp2px(this.bannerView.getContext(), 15));
            lp.gravity = 53;
            this.bannerView.addView((View)closeBtn, (ViewGroup.LayoutParams)lp);
        }
    }

    @Override
    public void registerView(ViewGroup viewGroup, List<View> clickableViews, TPInnerNativeAd nativeAd, boolean provicyIcon) {
        if (this.innerSendEventMessage == null) {
            this.innerSendEventMessage = new InnerSendEventMessage(GlobalTradPlus.getInstance().getContext(), this.adUnitId, "", this.payloadInfo);
        }
        this.innerSendEventMessage.sendShowAdStart();
        if (this.checkAdIsTimeOut(this.bidInfo)) {
            Log.v((String)TAG, (String)"adx native time out");
            this.innerSendEventMessage.sendShowEndAd(14);
            return;
        }
        if (viewGroup == null) {
            Log.v((String)TAG, (String)"registerView adLayout is null");
            this.innerSendEventMessage.sendShowEndAd(14);
            return;
        }
        if (!this.checkNativeAdValid(nativeAd) || nativeAd != this.innerNativeAd) {
            Log.v((String)TAG, (String)"nativeAd is not valid");
            this.innerSendEventMessage.sendShowEndAd(14);
            return;
        }
        if (this.mNativeInfo == null) {
            Log.v((String)TAG, (String)"native info has destroyed");
            this.innerSendEventMessage.sendShowEndAd(14);
            return;
        }
        this.prepareView(viewGroup, clickableViews);
    }

    public void prepareView(ViewGroup viewGroup, List<View> clickableViews) {
        try {
            ArrayList<View> tempAllChild = new ArrayList<View>();
            this.getAllChildByViewGroup(viewGroup, tempAllChild);
            if (this.width == 300 && this.height == 250) {
                for (View view : tempAllChild) {
                    if (!(view instanceof TPInnerMediaView)) continue;
                    this.tpInnerMediaView = (TPInnerMediaView)view;
                    ((TPInnerMediaView)view).setIsMute(this.isMute);
                    ((TPInnerMediaView)view).setVastVideoConfig(this.innerNativeAd);
                    ((TPInnerMediaView)view).setOnPlayerListener(this.onPlayerListener);
                    break;
                }
            }
            this.registerViewClick(tempAllChild, clickableViews, this.onClickListener);
        }
        catch (Exception e) {
            Log.v((String)TAG, (String)("register view click exception:" + e));
        }
    }

    private void startObserverView() {
        final ViewTreeObserver viewTreeObserver = this.bannerView.getViewTreeObserver();
        if (!viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                if (InnerBannerMgr.this.checkAdIsTimeOut(InnerBannerMgr.this.bidInfo)) {
                    Log.v((String)InnerBannerMgr.TAG, (String)"adx banner time out");
                    InnerBannerMgr.this.innerSendEventMessage.sendShowEndAd(14);
                    return;
                }
                LogUtil.ownShow((String)("adx banner " + InnerBannerMgr.this.bannerView.getWidth() + " height = " + InnerBannerMgr.this.bannerView.getHeight()));
                if (InnerBannerMgr.this.mIsShowing) {
                    return;
                }
                InnerBannerMgr.this.mIsShowing = true;
                if (InnerImpressionUtils.isDefaultImpressionSetting(InnerBannerMgr.this.payloadInfo)) {
                    InnerBannerMgr.this.onImpression();
                } else {
                    InnerBannerMgr.this.checkVisible((ViewGroup)InnerBannerMgr.this.bannerView);
                }
            }
        });
    }

    public void prepareView() {
        this.addViewToBanner((ViewGroup)this.mWebView);
        this.mWebView.setLoadListener(new BaseWebView.InnerHtmlLoadListener(){

            @Override
            public void onLoaded() {
                Log.v((String)InnerBannerMgr.TAG, (String)"onLoaded");
                InnerBannerMgr.this.endOverTimeRunnable(InnerBannerMgr.this.innerSendEventMessage.getRequestId());
                if (InnerBannerMgr.this.tpInnerAdListener != null) {
                    InnerBannerMgr.this.tpInnerAdListener.onAdLoaded();
                }
                if (InnerBannerMgr.this.innerSendEventMessage != null) {
                    InnerBannerMgr.this.innerSendEventMessage.sendLoadAdNetworkEnd(1);
                }
            }

            @Override
            public void onClicked() {
                Log.v((String)InnerBannerMgr.TAG, (String)"onClicked");
                if (InnerBannerMgr.this.tpInnerAdListener != null) {
                    InnerBannerMgr.this.tpInnerAdListener.onAdClicked();
                }
                if (InnerBannerMgr.this.innerSendEventMessage != null) {
                    InnerBannerMgr.this.innerSendEventMessage.sendClickAdStart();
                }
                InnerTrackNotification.sendClickNotification(InnerBannerMgr.this.bidInfo, InnerBannerMgr.this.innerSendEventMessage, "");
            }

            @Override
            public void onJump(String url) {
                InnerLog.v(InnerBannerMgr.TAG, "onJump :" + url);
                if (url.startsWith(":data:text")) {
                    return;
                }
                boolean result = false;
                if (url != null) {
                    result = InnerBannerMgr.this.onJumpAction(InnerBannerMgr.this.bannerView.getContext(), url, InnerBannerMgr.this.innerSendEventMessage.getRequestId(), InnerBannerMgr.this.innerSendEventMessage.getPid());
                }
                if (InnerBannerMgr.this.innerSendEventMessage != null) {
                    InnerBannerMgr.this.innerSendEventMessage.sendClickAdEnd(result ? 1 : 32);
                }
            }

            @Override
            public void onVisibilityChanged(boolean isVisible) {
            }
        });
    }

    @Override
    protected void checkVisible(final ViewGroup viewGroup) {
        if (this.mWebView instanceof InnerHtmlWebView) {
            if (this.isDestroy) {
                return;
            }
            TPTaskManager.getInstance().getThreadHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (InnerImpressionUtils.needViewVisible(InnerBannerMgr.this.payloadInfo) && !InnerBannerMgr.this.checkViewHasVisible((View)InnerBannerMgr.this.bannerView, InnerBannerMgr.this.bidInfo) || InnerImpressionUtils.isCover((View)InnerBannerMgr.this.bannerView, InnerBannerMgr.this.payloadInfo, InnerBannerMgr.this.bidInfo.getW(), InnerBannerMgr.this.bidInfo.getH())) {
                        InnerBannerMgr.this.checkVisible(viewGroup);
                    } else {
                        InnerBannerMgr.this.validCount++;
                        if (InnerBannerMgr.this.validCount >= InnerImpressionUtils.getValidCount(InnerBannerMgr.this.payloadInfo)) {
                            InnerBannerMgr.this.onImpression();
                        } else {
                            InnerBannerMgr.this.checkVisible(viewGroup);
                        }
                    }
                }
            }, 1000L);
        } else if (this.checkViewHasVisible((View)this.bannerView, this.bidInfo) && !ViewUtils.isCover((View)this.bannerView)) {
            this.onImpression();
        }
    }

    @Override
    protected void onImpression() {
        this.onShownNoti();
        Log.v((String)TAG, (String)"onShown");
        if (this.tpInnerAdListener != null) {
            this.tpInnerAdListener.onAdImpression();
        }
        if (this.innerSendEventMessage != null && this.getAdmType() != 1) {
            this.innerSendEventMessage.sendShowAdStart();
        }
        InnerTrackNotification.sendImpressionNotification(this.bidInfo, this.innerSendEventMessage, "");
    }

    private boolean checkViewHasVisible(View view, TPPayloadInfo.SeatBid.Bid bidInfo) {
        if (view.getVisibility() != 0 || !view.isShown()) {
            InnerLog.v(TAG, "view is not visible");
            return false;
        }
        if (view.getWidth() <= bidInfo.getW() || view.getHeight() <= bidInfo.getH()) {
            return false;
        }
        Rect globalRect = new Rect();
        if (!view.getGlobalVisibleRect(globalRect)) {
            return false;
        }
        return globalRect.width() > bidInfo.getW() && globalRect.height() > bidInfo.getH();
    }

    private void onShownNoti() {
        TPTaskManager.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (InnerBannerMgr.this.mWebView instanceof InnerMraidWebView) {
                    InnerMraidWebView.MraidScreenMetrics mraidScreenMetrics = new InnerMraidWebView.MraidScreenMetrics();
                    DisplayMetrics displayMetrics = InnerBannerMgr.this.bannerView.getResources().getDisplayMetrics();
                    mraidScreenMetrics.screenRectDips = displayMetrics.widthPixels + "," + displayMetrics.heightPixels;
                    int[] location = new int[2];
                    View rootView = InnerBannerMgr.this.bannerView.getRootView();
                    rootView.getLocationOnScreen(location);
                    mraidScreenMetrics.rootViewRectDips = location[0] + "," + location[1] + "," + rootView.getWidth() + "," + rootView.getHeight();
                    InnerBannerMgr.this.bannerView.getLocationOnScreen(location);
                    mraidScreenMetrics.defaultAdRectDips = location[0] + "," + location[1] + "," + InnerBannerMgr.this.bannerView.getWidth() + "," + InnerBannerMgr.this.bannerView.getHeight();
                    InnerBannerMgr.this.mWebView.getLocationOnScreen(location);
                    mraidScreenMetrics.currentAdRectDips = location[0] + "," + location[1] + "," + InnerBannerMgr.this.mWebView.getWidth() + "," + InnerBannerMgr.this.mWebView.getHeight();
                    ((InnerMraidWebView)InnerBannerMgr.this.mWebView).handlePageLoad(mraidScreenMetrics);
                }
            }
        });
    }

    @Override
    protected boolean onJumpAction(Context context, String url, String requestId, String pid) {
        boolean openSuccessed = false;
        try {
            if (url.startsWith("market:")) {
                this.openMarket(context, url);
            } else if (url.contains("mraid://open") && this.getAdmType() != 1) {
                this.openMraidUrl(url, requestId, pid);
            } else if (url.startsWith("http")) {
                this.startHtmlActivity(context, url, requestId, pid);
            } else {
                this.openDeepLink(context, url);
            }
            openSuccessed = true;
        }
        catch (Throwable t) {
            InnerLog.v(TAG, "onJumpAction:" + t.getMessage());
        }
        return openSuccessed;
    }

    private void openMraidUrl(String url, String requestId, String pid) {
        Uri uri = Uri.parse((String)url);
        HashMap<String, String> params = new HashMap<String, String>();
        for (String queryParam : uri.getQueryParameterNames()) {
            params.put(queryParam, TextUtils.join((CharSequence)",", (Iterable)uri.getQueryParameters(queryParam)));
        }
        String tempUrl = (String)params.get("url");
        if (tempUrl.contains("deeplink")) {
            this.openDeepLink(this.bannerView.getContext(), tempUrl);
        } else {
            this.startHtmlActivity(this.bannerView.getContext(), tempUrl, requestId, pid);
        }
        ((InnerMraidWebView)this.mWebView).commandCompleteEvent("open");
    }

    public void onDestroy() {
        this.isDestroy = true;
    }
}

