/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk;

import android.content.Context;
import android.graphics.Rect;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import com.tp.adx.R;
import com.tp.adx.open.TPAdOptions;
import com.tp.adx.open.TPInnerMediaView;
import com.tp.adx.open.TPInnerNativeAd;
import com.tp.adx.sdk.InnerParseManager;
import com.tp.adx.sdk.bean.TPNativeInfo;
import com.tp.adx.sdk.event.InnerSendEventMessage;
import com.tp.adx.sdk.tracking.InnerTrackNotification;
import com.tp.adx.sdk.tracking.InnerVastNotificationUtils;
import com.tp.adx.sdk.util.InnerLog;
import com.tp.adx.sdk.util.ViewUtils;
import com.tp.common.InnerImpressionUtils;
import com.tp.vast.VastManager;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.common.TPTaskManager;
import java.util.ArrayList;
import java.util.List;

public class InnerNativeMgr
extends InnerParseManager {
    private static final int AD_MIN_VISIBLE_WIDTH = 100;
    private static final int AD_MIN_VISIBLE_HEIGHT = 100;
    private boolean isDestroy;
    private boolean mIsShowing = false;
    private ViewGroup mAdLayoutView;
    private int validCount;
    View.OnClickListener onClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (InnerNativeMgr.this.mAdLayoutView == null || !InnerNativeMgr.this.checkViewHasVisible((View)InnerNativeMgr.this.mAdLayoutView)) {
                return;
            }
            try {
                Object tag = v.getTag();
                if (tag instanceof String && "tp_inner_privacy_tag".equals(String.valueOf(tag))) {
                    InnerNativeMgr.this.onJumpAction(v.getContext(), InnerNativeMgr.this.mNativeInfo.getPrivacy(), "", InnerNativeMgr.this.adUnitId);
                    return;
                }
                if (InnerNativeMgr.this.innerSendEventMessage != null) {
                    InnerNativeMgr.this.innerSendEventMessage.sendClickAdStart();
                }
                ArrayList<String> urls = new ArrayList<String>();
                InnerNativeMgr.this.getClickUrlByNativeInfo(InnerNativeMgr.this.mNativeInfo, urls);
                if (urls.size() <= 0) {
                    return;
                }
                Log.v((String)"InnerSDK", (String)"onClick");
                InnerLog.v("InnerSDK", "onClick :" + urls.get(0));
                boolean success = InnerNativeMgr.this.onJumpAction(v.getContext(), urls.get(0), InnerNativeMgr.this.innerSendEventMessage.getRequestId(), InnerNativeMgr.this.adUnitId);
                if (InnerNativeMgr.this.tpInnerAdListener != null) {
                    InnerNativeMgr.this.tpInnerAdListener.onAdClicked();
                }
                InnerVastNotificationUtils.getInstance().sendCompanionClickNotification(InnerNativeMgr.this.innerNativeAd.getVastVideoConfig());
                InnerTrackNotification.sendClickNotification(InnerNativeMgr.this.bidInfo, InnerNativeMgr.this.innerSendEventMessage, VastManager.getVastNetworkMediaUrl(InnerNativeMgr.this.innerNativeAd.getVastVideoConfig()));
                if (InnerNativeMgr.this.innerSendEventMessage != null) {
                    InnerNativeMgr.this.innerSendEventMessage.sendClickAdEnd(success ? 1 : 32);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };

    public InnerNativeMgr(String adUnitId, String payload) {
        super(adUnitId, payload);
    }

    @Override
    public void setAdOption(TPAdOptions options) {
        super.setAdOption(options);
        this.isMute = options.isMute();
    }

    @Override
    public boolean parseAdm() {
        boolean isParse = this.parseNativeInfo();
        return isParse;
    }

    @Override
    protected void loadDataEnd() {
    }

    @Override
    protected void loadVastDataEnd() {
    }

    @Override
    public TPInnerNativeAd getNativeAd() {
        return this.innerNativeAd;
    }

    @Override
    public void registerView(ViewGroup viewGroup, List<View> clickableViews, TPInnerNativeAd nativeAd, boolean provicyIcon) {
        if (this.innerSendEventMessage == null) {
            this.innerSendEventMessage = new InnerSendEventMessage(GlobalTradPlus.getInstance().getContext(), this.adUnitId, "", this.payloadInfo);
        }
        this.innerSendEventMessage.sendShowAdStart();
        if (this.checkAdIsTimeOut(this.bidInfo)) {
            Log.v((String)"InnerSDK", (String)"adx native time out");
            this.innerSendEventMessage.sendShowEndAd(14);
            return;
        }
        if (viewGroup == null) {
            Log.v((String)"InnerSDK", (String)"registerView adLayout is null");
            this.innerSendEventMessage.sendShowEndAd(14);
            return;
        }
        if (!this.checkNativeAdValid(nativeAd) || nativeAd != this.innerNativeAd) {
            Log.v((String)"InnerSDK", (String)"nativeAd is not valid");
            this.innerSendEventMessage.sendShowEndAd(14);
            return;
        }
        if (this.mNativeInfo == null) {
            Log.v((String)"InnerSDK", (String)"native info has destroyed");
            this.innerSendEventMessage.sendShowEndAd(14);
            return;
        }
        this.prepareView(viewGroup, clickableViews, provicyIcon);
    }

    public void prepareView(ViewGroup viewGroup, List<View> clickableViews, boolean provicyIcon) {
        Context context = viewGroup.getContext();
        if (!TextUtils.isEmpty((CharSequence)this.mNativeInfo.getPrivacy()) && this.mNativeInfo.getPrivacy().contains("http") && provicyIcon) {
            ImageView imageView = new ImageView(context);
            imageView.setTag((Object)"tp_inner_privacy_tag");
            imageView.setImageResource(R.drawable.tp_inner_ad_privacy);
            ViewGroup.LayoutParams temp = ViewUtils.generateLayoutParamsByViewGroup(viewGroup, ViewUtils.dp2px(context, 15), ViewUtils.dp2px(context, 15), 4);
            viewGroup.addView((View)imageView, temp);
        }
        try {
            ArrayList<View> tempAllChild = new ArrayList<View>();
            this.getAllChildByViewGroup(viewGroup, tempAllChild);
            for (View view : tempAllChild) {
                if (!(view instanceof TPInnerMediaView)) continue;
                this.tpInnerMediaView = (TPInnerMediaView)view;
                ((TPInnerMediaView)view).setIsMute(this.isMute);
                ((TPInnerMediaView)view).setVastVideoConfig(this.innerNativeAd);
                ((TPInnerMediaView)view).setOnPlayerListener(this.onPlayerListener);
                break;
            }
            this.registerViewClick(tempAllChild, clickableViews, this.onClickListener);
        }
        catch (Exception e) {
            Log.v((String)"InnerSDK", (String)("register view click exception:" + e));
        }
        this.visibilityTracker(viewGroup);
    }

    private void visibilityTracker(final ViewGroup viewGroup) {
        final ViewTreeObserver viewTreeObserver = viewGroup.getViewTreeObserver();
        if (!viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                if (InnerNativeMgr.this.checkAdIsTimeOut(InnerNativeMgr.this.bidInfo)) {
                    Log.v((String)"InnerSDK", (String)"adx native time out");
                    InnerNativeMgr.this.pushErrorNotification("900");
                    return;
                }
                Log.i((String)"InnerSDK", (String)("mIsShowing = " + InnerNativeMgr.this.mIsShowing));
                if (InnerNativeMgr.this.mIsShowing) {
                    return;
                }
                InnerNativeMgr.this.mIsShowing = true;
                if (InnerImpressionUtils.isDefaultImpressionSetting(InnerNativeMgr.this.payloadInfo)) {
                    InnerNativeMgr.this.mAdLayoutView = viewGroup;
                    InnerNativeMgr.this.onImpression();
                } else {
                    InnerNativeMgr.this.checkVisible(viewGroup);
                }
            }
        });
    }

    @Override
    protected void checkVisible(final ViewGroup viewGroup) {
        if (this.isDestroy) {
            return;
        }
        TPTaskManager.getInstance().getThreadHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                TPNativeInfo.Asset.Img img = InnerNativeMgr.this.compareViewSizeValid();
                if (InnerImpressionUtils.needViewVisible(InnerNativeMgr.this.payloadInfo) && !InnerNativeMgr.this.checkViewHasVisible((View)viewGroup) || InnerImpressionUtils.isCover((View)viewGroup, InnerNativeMgr.this.payloadInfo, img == null ? 0 : img.getW(), img == null ? 0 : img.getH())) {
                    InnerNativeMgr.this.checkVisible(viewGroup);
                    return;
                }
                InnerNativeMgr.this.validCount++;
                if (InnerNativeMgr.this.validCount >= InnerImpressionUtils.getValidCount(InnerNativeMgr.this.payloadInfo)) {
                    InnerNativeMgr.this.mAdLayoutView = viewGroup;
                    InnerNativeMgr.this.onImpression();
                } else {
                    InnerNativeMgr.this.checkVisible(viewGroup);
                }
            }
        }, 1000L);
    }

    @Override
    protected void onImpression() {
        this.innerSendEventMessage.sendShowEndAd(1);
        InnerVastNotificationUtils.getInstance().sendCompanionImpNotification(this.innerNativeAd.getVastVideoConfig());
        InnerTrackNotification.sendImpressionNotification(this.bidInfo, this.innerSendEventMessage, VastManager.getVastNetworkMediaUrl(this.innerNativeAd.getVastVideoConfig()));
        Log.i((String)"InnerSDK", (String)"onShown");
        if (this.tpInnerAdListener != null) {
            this.tpInnerAdListener.onAdImpression();
        }
    }

    private TPNativeInfo.Asset.Img compareViewSizeValid() {
        TPNativeInfo.Asset.Img img;
        if (this.mNativeInfo == null) {
            return null;
        }
        boolean hasIcon = false;
        ArrayList<TPNativeInfo.Asset> assets = this.mNativeInfo.getAssets();
        for (TPNativeInfo.Asset asset : assets) {
            if (201 != asset.getId() || asset.getImg() == null) continue;
            img = asset.getImg();
            if (img == null) break;
            hasIcon = true;
            return img;
        }
        if (!hasIcon) {
            for (TPNativeInfo.Asset asset : assets) {
                if (203 != asset.getId() || asset.getImg() == null) continue;
                img = asset.getImg();
                return img;
            }
        }
        return null;
    }

    private boolean checkViewHasVisible(View view) {
        if (view.getVisibility() != 0 || !view.isShown()) {
            InnerLog.v("InnerSDK", "view is not visible");
            return false;
        }
        if (view.getWidth() <= 100 || view.getHeight() <= 100) {
            return false;
        }
        Rect globalRect = new Rect();
        return view.getGlobalVisibleRect(globalRect);
    }

    @Override
    protected boolean onJumpAction(Context context, String url, String requestId, String pid) {
        boolean openSuccessed = false;
        try {
            if (url.startsWith("market:")) {
                this.openMarket(context, url);
            } else if (url.startsWith("http")) {
                this.startHtmlActivity(context, url, requestId, pid);
            } else {
                this.openDeepLink(context, url);
            }
            openSuccessed = true;
        }
        catch (Throwable t) {
            InnerLog.v("InnerSDK", "onJumpAction:" + t.getMessage());
        }
        return openSuccessed;
    }

    public void onDestroy() {
        this.isDestroy = true;
    }

    public void onResume() {
        if (this.tpInnerMediaView != null && !this.tpInnerMediaView.isPlaying()) {
            this.tpInnerMediaView.start();
        }
        InnerVastNotificationUtils.getInstance().sendResumeNotification(this.innerNativeAd.getVastVideoConfig());
    }

    public void onPause() {
        if (this.tpInnerMediaView != null) {
            this.tpInnerMediaView.pause();
        }
        InnerVastNotificationUtils.getInstance().sendPauseNotification(this.innerNativeAd.getVastVideoConfig());
    }
}

