/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.tp.adx.open.AdError;
import com.tp.adx.open.InnerSdk;
import com.tp.adx.open.TPInnerAdListener;
import com.tp.adx.open.TPInnerMediaView;
import com.tp.adx.open.TPInnerNativeAd;
import com.tp.adx.sdk.InnerBaseMgr;
import com.tp.adx.sdk.bean.TPNativeInfo;
import com.tp.adx.sdk.bean.TPPayloadInfo;
import com.tp.adx.sdk.event.InnerSendEventMessage;
import com.tp.adx.sdk.tracking.InnerTrackNotification;
import com.tp.adx.sdk.tracking.InnerVastNotificationUtils;
import com.tp.adx.sdk.ui.InnerWebViewActivity;
import com.tp.adx.sdk.util.InnerLog;
import com.tp.vast.VastManager;
import com.tp.vast.VastManagerFactory;
import com.tp.vast.VastTracker;
import com.tp.vast.VastVideoConfig;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.common.UrlAction;
import com.tradplus.ads.common.UrlHandler;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.DeviceUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public abstract class InnerParseManager
extends InnerBaseMgr {
    protected static final String NATIVE_AD_PRIVACY_TAG = "tp_inner_privacy_tag";
    protected static final String ADM_NATIVE_OBJ_KEY = "native";
    protected TPPayloadInfo payloadInfo;
    protected InnerSendEventMessage innerSendEventMessage;
    protected TPPayloadInfo.SeatBid.Bid bidInfo;
    protected TPInnerNativeAd innerNativeAd;
    protected TPNativeInfo mNativeInfo;
    protected boolean isReady;
    protected TPInnerMediaView tpInnerMediaView;
    protected final int TYPE_NORMAL = 0;
    protected final int TYPE_NATIVE = 1;
    protected final int TYPE_INTERSTITIAL = 2;
    protected boolean isMute = true;
    protected TPInnerMediaView.OnPlayerListener onPlayerListener = new TPInnerMediaView.OnPlayerListener(){

        @Override
        public void onVideoPlayStart() {
            InnerParseManager.this.sendVideoPlayProgressTrack(0);
            if (InnerParseManager.this.tpInnerAdListener != null) {
                InnerParseManager.this.tpInnerAdListener.onVideoStart();
            }
        }

        @Override
        public void onVideoUpdateProgress(int progress, int duration) {
        }

        @Override
        public void onVideoPlayCompletion() {
            Log.v((String)"InnerSDK", (String)"onVideoPlayCompletion");
            InnerParseManager.this.sendVideoPlayProgressTrack(100);
            if (InnerParseManager.this.tpInnerAdListener != null) {
                InnerParseManager.this.tpInnerAdListener.onVideoEnd();
            }
        }

        @Override
        public void onVideoShowFailed() {
            if (InnerParseManager.this.innerSendEventMessage != null) {
                InnerParseManager.this.innerSendEventMessage.sendShowEndAd(24);
            }
            InnerParseManager.this.pushErrorNotification("405");
        }

        @Override
        public void onVideoPlayProgress(int progressArea) {
            InnerParseManager.this.sendVideoPlayProgressTrack(progressArea);
        }

        @Override
        public void onVideoMute() {
            Log.v((String)"InnerSDK", (String)"onVideoMute");
        }

        @Override
        public void onVideoNoMute() {
            Log.v((String)"InnerSDK", (String)"onVideoNoMute");
        }
    };

    InnerParseManager(String adUnitId, String payload) {
        super(adUnitId, payload);
    }

    @Override
    public void loadAd() {
        if (!this.checkAndParsePayloadData()) {
            return;
        }
        try {
            if (!this.parseBidInfo()) {
                return;
            }
            if (!this.parseAdm()) {
                return;
            }
        }
        catch (Exception e) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1005, "payload parse error"));
            return;
        }
    }

    protected abstract void loadDataEnd();

    protected abstract void loadVastDataEnd();

    protected boolean checkAndParsePayloadData() {
        if (this.tpInnerAdListener == null) {
            this.tpInnerAdListener = new TPInnerAdListener();
        }
        if (this.adUnitId == null || this.adUnitId.length() <= 0) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1000, "adUnitId is null"));
            return false;
        }
        if (this.payload == null || this.payload.length() <= 0) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1001, "payload is null"));
            return false;
        }
        Log.v((String)"InnerSDK", (String)"loadStart");
        InnerLog.v("InnerSDK", "payload:" + this.payload + " adUnitId:" + this.adUnitId);
        this.payloadInfo = (TPPayloadInfo)JSON.parseObject((String)this.payload, TPPayloadInfo.class);
        this.innerSendEventMessage = new InnerSendEventMessage(GlobalTradPlus.getInstance().getContext(), this.adUnitId, this.payloadInfo);
        this.innerSendEventMessage.sendLoadAdNetworkStart();
        if (this.payloadInfo == null || this.payloadInfo.getSeatBid() == null || this.payloadInfo.getSeatBid().size() <= 0 || this.payloadInfo.getSeatBid().get(0).getBid() == null || this.payloadInfo.getSeatBid().get(0).getBid().size() <= 0) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1100, "no fill, payload is null"));
            this.innerSendEventMessage.sendLoadAdNetworkEnd(12);
            return false;
        }
        return true;
    }

    protected int getAdmType() {
        if (this.payloadInfo == null) {
            return 0;
        }
        TPPayloadInfo.Ext ext = this.payloadInfo.getExt();
        if (ext == null) {
            return 0;
        }
        TPPayloadInfo.Ext.Tp tp = ext.getTp();
        if (tp == null) {
            return 0;
        }
        return tp.getDsp_ad_type();
    }

    protected boolean parseBidInfo() {
        this.bidInfo = this.payloadInfo.getSeatBid().get(0).getBid().get(0);
        if (this.bidInfo.getAdm() == null) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1100, "no fill\uff0cadm is null"));
            this.innerSendEventMessage.sendLoadAdNetworkEnd(12);
            return false;
        }
        if (!DeviceUtils.isNetworkAvailable((Context)GlobalTradPlus.getInstance().getContext())) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1002, "network is not connection"));
            this.innerSendEventMessage.sendLoadAdNetworkEnd(7);
            return false;
        }
        if (this.checkAdIsTimeOut(this.bidInfo)) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1004, "payload is timeout"));
            this.innerSendEventMessage.sendLoadAdNetworkEnd(16);
            return false;
        }
        return true;
    }

    protected boolean parseNativeInfo() {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(this.bidInfo.getAdm());
            if (jsonObject == null || TextUtils.isEmpty((CharSequence)jsonObject.optString(ADM_NATIVE_OBJ_KEY))) {
                this.tpInnerAdListener.onAdLoadFailed(new AdError(1100, "no fill\uff0cadm parse error"));
                this.innerSendEventMessage.sendLoadAdNetworkEnd(17);
                return false;
            }
            this.mNativeInfo = (TPNativeInfo)JSON.parseObject((String)jsonObject.optJSONObject(ADM_NATIVE_OBJ_KEY).toString(), TPNativeInfo.class);
            if (this.mNativeInfo == null || this.mNativeInfo.getAssets().size() <= 0) {
                this.tpInnerAdListener.onAdLoadFailed(new AdError(1100, "no fill, native is null"));
                this.innerSendEventMessage.sendLoadAdNetworkEnd(17);
                return false;
            }
            this.innerNativeAd = this.parseAssets();
            InnerLog.v("InnerSDK", "parseAssets " + JSON.toJSONString((Object)this.innerNativeAd));
            if (!this.checkNativeAdValid(this.innerNativeAd)) {
                return false;
            }
            this.getTrackUrlToBidInfo();
            this.innerSendEventMessage.sendLoadAdNetworkEnd(1);
            if (this.innerNativeAd.getVideoVast() == null) {
                this.isReady = true;
                this.sendWinNotification();
                this.tpInnerAdListener.onAdLoaded();
                this.loadDataEnd();
                return true;
            }
            this.parseVast();
            this.sendWinNotification();
        }
        catch (Throwable e) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1100, "no fill\uff0cadm parse error"));
            this.innerSendEventMessage.sendLoadAdNetworkEnd(17);
            return false;
        }
        return true;
    }

    protected void sendWinNotification() {
        InnerTrackNotification.sendWinNotification(this.bidInfo, "");
    }

    protected abstract boolean parseAdm();

    protected boolean checkNativeAdValid(TPInnerNativeAd innerNativeAd) {
        boolean isValid = true;
        if (innerNativeAd == null) {
            isValid = false;
        }
        if (innerNativeAd.getCallToAction() == null || innerNativeAd.getIconUrl() == null || innerNativeAd.getTitle() == null) {
            isValid = false;
        }
        if (!isValid) {
            this.tpInnerAdListener.onAdLoadFailed(new AdError(1100, "no fill, parse assets no matched resource"));
            this.innerSendEventMessage.sendLoadAdNetworkEnd(17);
        }
        return isValid;
    }

    protected void getTrackUrlToBidInfo() {
        ArrayList<String> imptrackers;
        Object clickTrackers;
        if (this.bidInfo == null || this.mNativeInfo == null) {
            return;
        }
        if (this.bidInfo.getExt() == null) {
            this.bidInfo.setExt(new TPPayloadInfo.SeatBid.Bid.Ext());
        }
        if (this.mNativeInfo.getLink() != null && (clickTrackers = this.mNativeInfo.getLink().getClicktrackers()) != null) {
            Iterator<String> iterator = ((ArrayList)clickTrackers).iterator();
            while (iterator.hasNext()) {
                String tracker = iterator.next();
                if (TextUtils.isEmpty((CharSequence)tracker)) continue;
                this.bidInfo.getExt().getClkurl().add(tracker);
            }
        }
        if (this.mNativeInfo.getEventTrackers() != null) {
            for (TPNativeInfo.EventTracker tracker : this.mNativeInfo.getEventTrackers()) {
                if (tracker.getEvent() != 1 || TextUtils.isEmpty((CharSequence)tracker.getUrl())) continue;
                this.bidInfo.getExt().getImpurl().add(tracker.getUrl());
            }
        }
        if (this.mNativeInfo.getImptrackers() != null && (imptrackers = this.mNativeInfo.getImptrackers()) != null) {
            for (String tracker : imptrackers) {
                if (TextUtils.isEmpty((CharSequence)tracker)) continue;
                this.bidInfo.getExt().getImpurl().add(tracker);
            }
        }
    }

    protected void parseVast() {
        final long startTime = System.currentTimeMillis();
        this.startTimeOutDelay(this.innerSendEventMessage);
        VastManager vastManager = VastManagerFactory.create(GlobalTradPlus.getInstance().getContext(), true);
        vastManager.prepareVastVideoConfiguration(this.innerNativeAd.getVideoVast(), new VastManager.VastManagerListener(){

            @Override
            public void onVastVideoConfigurationPrepared(VastVideoConfig vastVideoConfig) {
                InnerLog.v("InnerSDK", "onVastVideoConfigurationPrepared " + (vastVideoConfig == null ? "null" : vastVideoConfig.toJsonString()));
                InnerParseManager.this.endOverTimeRunnable(InnerParseManager.this.innerSendEventMessage != null ? InnerParseManager.this.innerSendEventMessage.getRequestId() : "");
                if (vastVideoConfig == null || vastVideoConfig.getDiskMediaFileUrl() == null) {
                    if (InnerParseManager.this.tpInnerAdListener != null) {
                        InnerParseManager.this.tpInnerAdListener.onAdLoadFailed(new AdError(1006, "ad media source download fail"));
                    }
                    if (InnerParseManager.this.innerSendEventMessage != null) {
                        InnerParseManager.this.innerSendEventMessage.sendDownloadAdEnd("5840", 18, startTime);
                    }
                    return;
                }
                InnerParseManager.this.getTrackUrlToBidInfo(InnerParseManager.this.bidInfo, vastVideoConfig);
                InnerParseManager.this.isReady = true;
                Log.v((String)"InnerSDK", (String)"native download video success");
                if (InnerParseManager.this.innerNativeAd != null) {
                    InnerParseManager.this.innerNativeAd.setVastVideoConfig(vastVideoConfig);
                }
                if (InnerParseManager.this.tpInnerAdListener != null) {
                    InnerParseManager.this.tpInnerAdListener.onAdLoaded();
                }
                if (InnerParseManager.this.innerSendEventMessage != null) {
                    InnerParseManager.this.innerSendEventMessage.sendDownloadAdEnd("5840", 1, startTime);
                }
                InnerParseManager.this.loadVastDataEnd();
            }

            @Override
            public void onVastVideoDownloadStart() {
                InnerParseManager.this.innerSendEventMessage.sendDownloadAdStart("5830");
            }
        }, this.bidInfo.getCrid(), GlobalTradPlus.getInstance().getContext());
    }

    private void getTrackUrlToBidInfo(TPPayloadInfo.SeatBid.Bid bid, VastVideoConfig config) {
        if (bid == null || config == null) {
            return;
        }
        if (bid.getExt() == null) {
            bid.setExt(new TPPayloadInfo.SeatBid.Bid.Ext());
        }
        for (VastTracker vastTracker : config.getImpressionTrackers()) {
            if (TextUtils.isEmpty((CharSequence)vastTracker.getContent())) continue;
            bid.getExt().getImpurl().add(vastTracker.getContent());
        }
        for (VastTracker vastTracker : config.getClickTrackers()) {
            if (TextUtils.isEmpty((CharSequence)vastTracker.getContent())) continue;
            bid.getExt().getClkurl().add(vastTracker.getContent());
        }
    }

    protected void getAllChildByViewGroup(ViewGroup viewGroup, ArrayList<View> allChild) {
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View view = viewGroup.getChildAt(i);
            if (view instanceof ViewGroup) {
                this.getAllChildByViewGroup((ViewGroup)view, allChild);
            }
            allChild.add(view);
        }
    }

    protected void registerViewClick(ArrayList<View> tempAllChild, List<View> clickableViews, View.OnClickListener onClickListener) {
        if (clickableViews != null) {
            for (View view : clickableViews) {
                if (!tempAllChild.contains(view)) continue;
                view.setOnClickListener(onClickListener);
            }
            return;
        }
        for (View view : tempAllChild) {
            view.setOnClickListener(onClickListener);
        }
    }

    protected void getClickUrlByNativeInfo(TPNativeInfo nativeInfo, ArrayList<String> urls) {
        TPNativeInfo.Link link = nativeInfo.getLink();
        if (link != null) {
            if (!TextUtils.isEmpty((CharSequence)link.getUrl())) {
                urls.add(link.getUrl());
            }
            if (!TextUtils.isEmpty((CharSequence)link.getFallback())) {
                urls.add(link.getFallback());
            }
        }
        if (this.innerNativeAd != null && this.innerNativeAd.getVastVideoConfig() != null && !TextUtils.isEmpty((CharSequence)this.innerNativeAd.getVastVideoConfig().getClickThroughUrl())) {
            urls.add(this.innerNativeAd.getVastVideoConfig().getClickThroughUrl());
        }
    }

    protected abstract void checkVisible(ViewGroup var1);

    protected abstract void onImpression();

    protected TPInnerNativeAd parseAssets() {
        TPInnerNativeAd tpInnerNativeAd = new TPInnerNativeAd();
        ArrayList<TPNativeInfo.Asset> assets = this.mNativeInfo.getAssets();
        for (TPNativeInfo.Asset asset : assets) {
            if (100 == asset.getId()) {
                if (asset.getTitle() == null) continue;
                tpInnerNativeAd.setTitle(asset.getTitle().getText());
            } else if (203 == asset.getId()) {
                if (asset.getImg() == null) continue;
                tpInnerNativeAd.setImageUrl(asset.getImg().getUrl());
            } else if (402 == asset.getId()) {
                if (asset.getData() == null) continue;
                tpInnerNativeAd.setSubTitle(asset.getData().getValue());
            } else if (412 == asset.getId()) {
                if (asset.getData() == null) continue;
                tpInnerNativeAd.setCallToAction(asset.getData().getValue());
            } else if (300 == asset.getId()) {
                if (asset.getVideo() == null) continue;
                tpInnerNativeAd.setVideoVast(asset.getVideo().getVasttag());
            } else if (403 == asset.getId()) {
                if (asset.getData() == null) continue;
                tpInnerNativeAd.setRating(asset.getData().getValue());
            } else if (404 == asset.getId()) {
                if (asset.getData() == null) continue;
                tpInnerNativeAd.setLikes(asset.getData().getValue());
            } else if (401 == asset.getId()) {
                if (asset.getData() == null) continue;
                tpInnerNativeAd.setSponsored(asset.getData().getValue());
            } else if (201 == asset.getId()) {
                if (asset.getImg() == null) continue;
                tpInnerNativeAd.setIconUrl(asset.getImg().getUrl());
            } else if (202 == asset.getId()) {
                if (asset.getData() == null) continue;
                tpInnerNativeAd.setLogoUrl(asset.getData().getValue());
            }
            if (asset.getLink() == null || TextUtils.isEmpty((CharSequence)asset.getLink().getUrl()) && TextUtils.isEmpty((CharSequence)asset.getLink().getFallback())) continue;
            TPNativeInfo.Link link = this.mNativeInfo.getLink();
            if (link == null) {
                link = new TPNativeInfo.Link();
            }
            link.setClicktrackers(asset.getLink().getClicktrackers());
            link.setFallback(asset.getLink().getFallback());
            link.setUrl(asset.getLink().getUrl());
        }
        return tpInnerNativeAd;
    }

    protected abstract boolean onJumpAction(Context var1, String var2, String var3, String var4);

    protected void openMarket(Context context, String url) {
        Intent i = new Intent("android.intent.action.VIEW");
        i.setData(Uri.parse((String)url));
        i.setFlags(0x10000000);
        context.startActivity(i);
    }

    protected void openDeepLink(Context context, String deepLinkUrl) {
        UrlHandler.Builder builder = new UrlHandler.Builder();
        EnumSet<UrlAction[]> urlActions = EnumSet.of(UrlAction.IGNORE_ABOUT_SCHEME, new UrlAction[]{UrlAction.OPEN_NATIVE_BROWSER, UrlAction.OPEN_IN_APP_BROWSER, UrlAction.HANDLE_SHARE_TWEET, UrlAction.FOLLOW_DEEP_LINK_WITH_FALLBACK, UrlAction.FOLLOW_DEEP_LINK});
        builder.withSupportedUrlActions(urlActions).build().handleUrl(context, deepLinkUrl);
    }

    protected void startHtmlActivity(Context context, String url, String requestId, String pid) {
        Intent intent;
        if (InnerSdk.isJumpWebViewOutSide()) {
            intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addCategory("android.intent.category.BROWSABLE");
        } else {
            intent = new Intent(context, InnerWebViewActivity.class);
            intent.putExtra("inner_adx_url", url);
            intent.putExtra("inner_adx_tp", (Serializable)this.payloadInfo);
            if (requestId != null && pid != null) {
                intent.putExtra("inner_adx_request_id", requestId);
                intent.putExtra("inner_adx_pid", pid);
            }
        }
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    protected void pushErrorNotification(String ec) {
        if (this.innerNativeAd != null && this.innerNativeAd.getVastVideoConfig() != null) {
            ArrayList<String> tempUrls = new ArrayList<String>();
            for (VastTracker vastTracker : this.innerNativeAd.getVastVideoConfig().getErrorTrackers()) {
                if (TextUtils.isEmpty((CharSequence)vastTracker.getContent())) continue;
                tempUrls.add(vastTracker.getContent());
            }
            InnerTrackNotification.sendErrorNotification(tempUrls, ec, VastManager.getVastNetworkMediaUrl(this.innerNativeAd.getVastVideoConfig()));
        }
    }

    public boolean isReady() {
        return this.isReady;
    }

    private void sendVideoPlayProgressTrack(int progress) {
        if (this.mNativeInfo == null) {
            return;
        }
        InnerVastNotificationUtils.getInstance().sendProgressNotification(progress, this.innerNativeAd.getVastVideoConfig());
    }
}

