/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk.ui;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebView;
import com.tradplus.ads.base.util.WebViews;
import com.tradplus.ads.common.util.Views;

public class BaseWebView
extends WebView {
    private static boolean sDeadlockCleared = false;
    protected boolean mIsDestroyed;
    private final Handler handler = new Handler(Looper.getMainLooper());
    InnerHtmlLoadListener loadListener;

    public BaseWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.restrictDeviceContentAccess();
        WebViews.setDisableJSChromeClient((WebView)this);
        if (!sDeadlockCleared) {
            this.clearWebViewDeadlock(this.getContext());
            sDeadlockCleared = true;
        }
    }

    public BaseWebView(Context context) {
        super(context.getApplicationContext());
        this.restrictDeviceContentAccess();
        WebViews.setDisableJSChromeClient((WebView)this);
        if (!sDeadlockCleared) {
            this.clearWebViewDeadlock(this.getContext());
            sDeadlockCleared = true;
        }
    }

    public void setLoadListener(InnerHtmlLoadListener listener) {
        this.loadListener = listener;
    }

    public void loadHtmlResponse(String htmlResponse) {
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        WebViews.manageThirdPartyCookies((WebView)this);
    }

    public void destroy() {
        if (this.mIsDestroyed) {
            return;
        }
        this.mIsDestroyed = true;
        Views.removeFromParent((View)this);
        this.removeAllViews();
        super.destroy();
    }

    private void delayedDestroy() {
        super.destroy();
    }

    private void restrictDeviceContentAccess() {
        this.getSettings().setAllowFileAccess(false);
        this.getSettings().setAllowContentAccess(false);
        this.getSettings().setAllowFileAccessFromFileURLs(false);
        this.getSettings().setAllowUniversalAccessFromFileURLs(false);
        this.getSettings().setSavePassword(false);
        this.removeJavascriptInterface("searchBoxJavaBridge_");
        this.removeJavascriptInterface("accessibility");
        this.removeJavascriptInterface("accessibilityTraversal");
    }

    protected void setWebViewScaleJS() {
        String js = "var meta = document.querySelector('meta[name=viewport]');if (!meta){meta = document.createElement('meta');meta.name = 'viewport'; meta.content = 'width=device-width,user-scalable=no,initial-scale=1,maximum-scale=1';document.getElementsByTagName('head')[0].appendChild(meta);}";
        this.loadUrl("javascript:" + js);
    }

    private void clearWebViewDeadlock(Context context) {
        if (Build.VERSION.SDK_INT == 19) {
            WebView webView = new WebView(context.getApplicationContext());
            webView.setBackgroundColor(0);
            webView.loadDataWithBaseURL(null, "", "text/html", "UTF-8", null);
            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
            params.width = 1;
            params.height = 1;
            params.type = 2005;
            params.flags = 0x1000018;
            params.format = -2;
            params.gravity = 0x800033;
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            windowManager.addView((View)webView, (ViewGroup.LayoutParams)params);
        }
    }

    @Deprecated
    void setIsDestroyed(boolean isDestroyed) {
        this.mIsDestroyed = isDestroyed;
    }

    public static interface InnerHtmlLoadListener {
        public void onLoaded();

        public void onClicked();

        public void onJump(String var1);

        public void onVisibilityChanged(boolean var1);
    }
}

