/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.JsResult;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.tp.adx.sdk.ui.BaseWebView;
import com.tp.adx.sdk.ui.MraidJavascript;
import com.tp.adx.sdk.util.InnerLog;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Locale;
import org.json.JSONObject;

public class InnerMraidWebView
extends BaseWebView {
    private static final String MRAID_JS = "mraid.js";
    private static final String MRAID_INJECTION_JAVASCRIPT = "javascript:" + MraidJavascript.JAVASCRIPT_SOURCE;
    private static final String TAG = "InnerSDK";
    private boolean mMraidViewable;
    private static final int MAX_DISTANCE_FOR_CLICK = 100;
    private int mDownX = 0;
    private int mDownY = 0;
    private boolean mIsWaitUpEvent = false;
    private boolean mIsLoaded = false;

    public InnerMraidWebView(Context context) {
        super(context);
        if (Build.VERSION.SDK_INT <= 22) {
            this.mMraidViewable = this.getVisibility() == 0;
        }
        this.disableScrollingAndZoom();
        this.initializeWebView();
        this.setBackgroundColor(0);
        this.setWebViewClient();
    }

    private void setMraidViewable(boolean viewable) {
        if (this.mMraidViewable == viewable) {
            return;
        }
        this.mMraidViewable = viewable;
        if (this.loadListener != null) {
            this.loadListener.onVisibilityChanged(viewable);
        }
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.setMraidViewable(visibility == 0);
    }

    public boolean isMraidViewable() {
        return this.mMraidViewable;
    }

    public void loadUrl(String url) {
        if (url == null) {
            return;
        }
        super.loadUrl(url);
    }

    public void stopLoading() {
        if (this.mIsDestroyed) {
            return;
        }
        WebSettings webSettings = this.getSettings();
        if (webSettings == null) {
            return;
        }
        webSettings.setJavaScriptEnabled(false);
        super.stopLoading();
        webSettings.setJavaScriptEnabled(true);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.mDownX = (int)event.getX();
            this.mDownY = (int)event.getY();
            this.mIsWaitUpEvent = true;
        }
        if (event.getAction() == 2) {
            int mTempX = (int)event.getX();
            int mTempY = (int)event.getY();
            if (Math.abs(mTempX - this.mDownX) > 100 || Math.abs(mTempY - this.mDownY) > 100) {
                this.mIsWaitUpEvent = false;
            }
        }
        if (event.getAction() == 1 && this.mIsWaitUpEvent) {
            this.mIsWaitUpEvent = false;
            if (this.loadListener != null) {
                this.loadListener.onClicked();
            }
        }
        if (event.getAction() == 3) {
            this.mIsWaitUpEvent = false;
        }
        return super.onTouchEvent(event);
    }

    private void setWebViewClient() {
        this.setWebViewClient(new WebViewClient(){
            private int running = 0;

            public boolean shouldOverrideUrlLoading(WebView view, String urlNewString) {
                InnerLog.v("shouldOverrideUrlLoading:" + urlNewString);
                ++this.running;
                if (InnerMraidWebView.this.loadListener != null) {
                    InnerMraidWebView.this.loadListener.onJump(urlNewString);
                }
                return true;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                this.running = Math.max(this.running, 1);
            }

            public void onPageFinished(WebView view, String url) {
                if (--this.running == 0) {
                    if (InnerMraidWebView.this.mIsLoaded) {
                        return;
                    }
                    InnerMraidWebView.this.mIsLoaded = true;
                    if (InnerMraidWebView.this.loadListener != null) {
                        InnerMraidWebView.this.loadListener.onLoaded();
                    }
                }
                InnerMraidWebView.this.setWebViewScaleJS();
            }

            public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
                if (InnerMraidWebView.this.matchesInjectionUrl(url)) {
                    return InnerMraidWebView.this.createMraidInjectionResponse();
                }
                return super.shouldInterceptRequest(view, url);
            }

            public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
                if (Build.VERSION.SDK_INT >= 21) {
                    if (request.getUrl().toString().equals(InnerMraidWebView.MRAID_JS)) {
                        return InnerMraidWebView.this.createMraidInjectionResponse();
                    }
                    return super.shouldInterceptRequest(view, request);
                }
                return super.shouldInterceptRequest(view, request);
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                InnerLog.v("onReceivedError:" + error.toString());
                super.onReceivedError(view, request, error);
            }

            public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                InnerLog.v("onReceivedHttpError:" + errorResponse.toString());
                super.onReceivedHttpError(view, request, errorResponse);
            }

            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                InnerLog.v(InnerMraidWebView.TAG, "onReceivedSslError:" + error.toString());
                super.onReceivedSslError(view, handler, error);
            }
        });
        this.setWebChromeClient(new WebChromeClient(){

            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                result.confirm();
                return true;
            }
        });
    }

    boolean matchesInjectionUrl(String url) {
        Uri uri = Uri.parse((String)url.toLowerCase(Locale.US));
        return MRAID_JS.equals(uri.getLastPathSegment());
    }

    private WebResourceResponse createMraidInjectionResponse() {
        ByteArrayInputStream data = new ByteArrayInputStream(MRAID_INJECTION_JAVASCRIPT.getBytes());
        InnerLog.v("createMraidInjectionResponse");
        return new WebResourceResponse("text/javascript", "UTF-8", (InputStream)data);
    }

    private void disableScrollingAndZoom() {
        this.setHorizontalScrollBarEnabled(false);
        this.setHorizontalScrollbarOverlay(false);
        this.setVerticalScrollBarEnabled(false);
        this.setVerticalScrollbarOverlay(false);
        this.requestFocus();
    }

    private void initializeWebView() {
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setAppCacheEnabled(true);
        webSettings.setAppCacheMaxSize(0x500000L);
        webSettings.setAllowFileAccess(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        webSettings.setDomStorageEnabled(true);
        webSettings.setSupportZoom(false);
        webSettings.setSavePassword(false);
        webSettings.setDatabaseEnabled(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
        webSettings.setAppCachePath(this.getContext().getCacheDir().getAbsolutePath());
        if (Build.VERSION.SDK_INT >= 17) {
            webSettings.setMediaPlaybackRequiresUserGesture(false);
        }
        try {
            if (Build.VERSION.SDK_INT >= 16) {
                webSettings.setAllowUniversalAccessFromFileURLs(true);
            }
        }
        catch (Throwable var6) {
            var6.printStackTrace();
        }
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                webSettings.setMixedContentMode(0);
            }
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
        if (Build.VERSION.SDK_INT >= 11) {
            try {
                Method var7 = WebSettings.class.getDeclaredMethod("setDisplayZoomControls", Boolean.TYPE);
                var7.setAccessible(true);
                var7.invoke((Object)webSettings, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void loadHtmlResponse(String htmlResponse) {
        this.mIsLoaded = false;
        this.loadDataWithBaseURL(null, htmlResponse, "text/html", "utf-8", null);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.loadListener = null;
    }

    public void handlePageLoad(MraidScreenMetrics mScreenMetrics) {
        this.notifySupports(false, false, false, false, false);
        InnerLog.i("handlePageLoad viewable: " + this.mMraidViewable);
        this.notifyViewability(this.mMraidViewable);
        this.notifyScreenMetrics(mScreenMetrics);
        this.notifyViewState("default");
        this.notifyReady();
    }

    public void notifyScreenMetrics(MraidScreenMetrics screenMetrics) {
        this.injectJavaScript("mraidbridge.setScreenSize(" + screenMetrics.getScreenRectDips() + ");mraidbridge.setMaxSize(" + screenMetrics.getRootViewRectDips() + ");mraidbridge.setCurrentPosition(" + screenMetrics.getCurrentAdRectDips() + ");mraidbridge.setDefaultPosition(" + screenMetrics.getDefaultAdRectDips() + ")");
        this.injectJavaScript("mraidbridge.notifySizeChangeEvent(" + screenMetrics.getCurrentAdRectDips() + ")");
    }

    void injectJavaScript(String javascript) {
        InnerLog.i("injectJavaScript: " + javascript);
        this.loadUrl("javascript:" + javascript);
    }

    void notifyViewState(String state) {
        this.injectJavaScript("mraidbridge.setState(" + JSONObject.quote((String)state) + ")");
    }

    void notifyViewability(boolean isViewable) {
        this.injectJavaScript("mraidbridge.setPlacementType(" + JSONObject.quote((String)"inline") + ")");
        this.injectJavaScript("mraidbridge.fireReadyEvent()");
        this.injectJavaScript("mraidbridge.setIsViewable(" + isViewable + ")");
        this.injectJavaScript("mraidbridge.setState(" + JSONObject.quote((String)"expanded") + ")");
    }

    public void commandCompleteEvent(String command) {
        this.injectJavaScript("window.mraidbridge.nativeCallComplete(" + JSONObject.quote((String)command) + ")");
    }

    void notifySupports(boolean sms, boolean telephone, boolean calendar, boolean storePicture, boolean inlineVideo) {
        this.injectJavaScript("mraidbridge.setSupports(" + sms + "," + telephone + "," + calendar + "," + storePicture + "," + inlineVideo + ")");
    }

    void notifyReady() {
        this.injectJavaScript("mraidbridge.notifyReadyEvent();");
    }

    public static class MraidScreenMetrics {
        public String screenRectDips;
        public String rootViewRectDips;
        public String currentAdRectDips;
        public String defaultAdRectDips;

        public String getScreenRectDips() {
            return this.screenRectDips;
        }

        public String getRootViewRectDips() {
            return this.rootViewRectDips;
        }

        public String getCurrentAdRectDips() {
            return this.currentAdRectDips;
        }

        public String getDefaultAdRectDips() {
            return this.defaultAdRectDips;
        }
    }
}

