/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk.ui.views;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.tp.adx.open.TPInnerAdListener;
import com.tp.adx.sdk.event.InnerSendEventMessage;
import com.tp.adx.sdk.ui.views.CountDownAnimiView;
import com.tradplus.ads.common.util.ResourceUtils;
import java.util.Locale;

public class CountDownView
extends RelativeLayout {
    private Handler handler;
    private LinearLayout layout_render;
    private LinearLayout layout_skip;
    private Context context;
    private int countDown = 5;
    private CountDownAnimiView tv_countdown;
    private TextView tv_skip;
    private boolean canSkip;
    private int canSkipCount = 5;
    private boolean isSkip;
    private boolean isShowSkip;
    private boolean isClose;
    private TPInnerAdListener adListener;
    private InnerSendEventMessage innerSendEventMessage;
    private int mProgress = -1;

    public CountDownView(Context context, TPInnerAdListener adListener, InnerSendEventMessage innerSendEventMessage) {
        super(context);
        this.adListener = adListener;
        this.innerSendEventMessage = innerSendEventMessage;
        this.init(context);
    }

    public CountDownView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public CountDownView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.handler = new Handler(Looper.getMainLooper());
        CountDownView.inflate((Context)context, (int)ResourceUtils.getLayoutIdByName((Context)context, (String)"tp_innerlayout_native_countdown"), (ViewGroup)this);
        this.layout_render = (LinearLayout)this.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"tp_innerlayout_render"));
        this.tv_countdown = (CountDownAnimiView)this.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"tp_innertv_countdown"));
        this.tv_skip = (TextView)this.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"tp_innertv_skip"));
        this.layout_skip = (LinearLayout)this.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"tp_innerlayout_skip"));
    }

    public ViewGroup setRenderAdView(View view) {
        this.isSkip = false;
        this.tv_skip.setVisibility(8);
        ViewGroup parent = (ViewGroup)view.getParent();
        if (parent != null) {
            parent.removeView(view);
        }
        this.layout_render.addView(view);
        if (CountDownView.isZh(this.context)) {
            this.tv_skip.setText((CharSequence)"\u8df3\u8fc7");
        } else {
            this.tv_skip.setText((CharSequence)"Skip");
        }
        this.tv_countdown.setCountdownTime(this.countDown);
        this.tv_countdown.setAddCountDownListener(new CountDownAnimiView.OnCountDownFinishListener(){

            @Override
            public void countDownFinished() {
                CountDownView.this.innerSendEventMessage.sendCloseAd(0.0f, 0.0f);
                if (CountDownView.this.adListener != null) {
                    CountDownView.this.adListener.onAdClosed();
                }
            }

            @Override
            public void countDownProgress(int progress) {
                if (progress != CountDownView.this.mProgress && !CountDownView.this.isSkip) {
                    CountDownView.this.mProgress = progress;
                    if (CountDownView.this.adListener != null) {
                        CountDownView.this.adListener.onCountDown(progress);
                    }
                }
                if (CountDownView.this.countDown - CountDownView.this.canSkipCount >= progress) {
                    if (CountDownView.this.canSkip) {
                        CountDownView.this.tv_skip.setVisibility(0);
                    }
                    if (!CountDownView.this.isShowSkip) {
                        CountDownView.this.isShowSkip = true;
                    }
                }
            }
        });
        this.tv_countdown.startCountDown();
        this.layout_render.setVisibility(0);
        this.layout_skip.setVisibility(0);
        return this;
    }

    public static boolean isZh(Context context) {
        Locale locale = context.getResources().getConfiguration().locale;
        String language = locale.getLanguage();
        return language.endsWith("zh");
    }

    public boolean isClose() {
        return this.isClose;
    }

    public void setClose(boolean close) {
        this.isClose = close;
    }
}

