/*
 * Decompiled with CFR 0.152.
 */
package com.tp.common.util;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import com.tp.adx.sdk.util.InnerLog;
import com.tradplus.ads.common.Preconditions;
import java.util.concurrent.Executor;

public class AsyncTasks {
    private static Executor sExecutor;
    private static Handler sUiThreadHandler;

    private static void init() {
        sExecutor = AsyncTask.THREAD_POOL_EXECUTOR;
        sUiThreadHandler = new Handler(Looper.getMainLooper());
    }

    public static void setExecutor(Executor executor) {
        sExecutor = executor;
    }

    public static <P> void safeExecuteOnExecutor(final AsyncTask<P, ?, ?> asyncTask, final P ... params) {
        Preconditions.checkNotNull(asyncTask, (String)"Unable to execute null AsyncTask.");
        if (Looper.getMainLooper() == Looper.myLooper()) {
            asyncTask.executeOnExecutor(sExecutor, (Object[])params);
        } else {
            InnerLog.v("Posting AsyncTask to main thread for execution.");
            sUiThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    asyncTask.executeOnExecutor(sExecutor, params);
                }
            });
        }
    }

    static {
        AsyncTasks.init();
    }
}

