/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import com.tradplus.ads.base.util.XmlUtils;
import com.tradplus.ads.common.Preconditions;
import org.w3c.dom.Node;

class VastMediaXmlManager {
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String DELIVERY = "delivery";
    private static final String VIDEO_TYPE = "type";
    private static final String BITRATE = "bitrate";
    private static final String BITRATE_MIN = "minBitrate";
    private static final String BITRATE_MAX = "maxBitrate";
    private final Node mMediaNode;

    VastMediaXmlManager(Node mediaNode) {
        Preconditions.checkNotNull((Object)mediaNode, (String)"mediaNode cannot be null");
        this.mMediaNode = mediaNode;
    }

    String getDelivery() {
        return XmlUtils.getAttributeValue((Node)this.mMediaNode, (String)DELIVERY);
    }

    Integer getWidth() {
        return XmlUtils.getAttributeValueAsInt((Node)this.mMediaNode, (String)WIDTH);
    }

    Integer getHeight() {
        return XmlUtils.getAttributeValueAsInt((Node)this.mMediaNode, (String)HEIGHT);
    }

    String getType() {
        return XmlUtils.getAttributeValue((Node)this.mMediaNode, (String)VIDEO_TYPE);
    }

    String getMediaUrl() {
        return XmlUtils.getNodeValue((Node)this.mMediaNode);
    }

    Integer getBitrate() {
        Integer bitrate = XmlUtils.getAttributeValueAsInt((Node)this.mMediaNode, (String)BITRATE);
        if (bitrate != null) {
            return bitrate;
        }
        Integer minBitrate = XmlUtils.getAttributeValueAsInt((Node)this.mMediaNode, (String)BITRATE_MIN);
        Integer maxBitrate = XmlUtils.getAttributeValueAsInt((Node)this.mMediaNode, (String)BITRATE_MAX);
        if (minBitrate != null && maxBitrate != null) {
            return (minBitrate + maxBitrate) / 2;
        }
        if (minBitrate != null) {
            return minBitrate;
        }
        return maxBitrate;
    }
}

