/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.tp.adx.sdk.util.InnerLog;
import com.tp.common.TPHttpUrlConnection;
import com.tp.vast.VastAdVerificationsParser;
import com.tp.vast.VastAdXmlManager;
import com.tp.vast.VastBaseInLineWrapperXmlManager;
import com.tp.vast.VastCompanionAdConfig;
import com.tp.vast.VastCompanionAdXmlManager;
import com.tp.vast.VastExtensionParentXmlManager;
import com.tp.vast.VastExtensionXmlManager;
import com.tp.vast.VastIconConfig;
import com.tp.vast.VastIconXmlManager;
import com.tp.vast.VastInLineXmlManager;
import com.tp.vast.VastLinearXmlManager;
import com.tp.vast.VastMediaXmlManager;
import com.tp.vast.VastResource;
import com.tp.vast.VastTracker;
import com.tp.vast.VastVideoConfig;
import com.tp.vast.VastWrapperXmlManager;
import com.tp.vast.VastXmlManager;
import com.tp.vast.ViewabilityVendor;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.util.Streams;
import com.tradplus.ads.common.util.Strings;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;

public class VastXmlManagerAggregator
extends AsyncTask<String, Void, VastVideoConfig> {
    private static final String MOPUB = "MoPub";
    public static final String ADS_BY_AD_SLOT_ID = "adsBy";
    static final int MAX_TIMES_TO_FOLLOW_VAST_REDIRECT = 10;
    private static final String MIME_TYPE_MP4 = "video/mp4";
    private static final String MIME_TYPE_3GPP = "video/3gpp";
    private static final List<String> VIDEO_MIME_TYPES = Arrays.asList("video/mp4", "video/3gpp");
    private static final int MINIMUM_COMPANION_AD_WIDTH = 300;
    private static final int MINIMUM_COMPANION_AD_HEIGHT = 250;
    private static final int BITRATE_THRESHOLD_HIGH = 1500;
    private static final int BITRATE_THRESHOLD_LOW = 700;
    private final VastXmlManagerAggregatorListener mVastXmlManagerAggregatorListener;
    private final double mScreenAspectRatio;
    private final Context mContext;
    private final int mScreenWidthDp;
    private int mTimesFollowedVastRedirect;

    VastXmlManagerAggregator(VastXmlManagerAggregatorListener vastXmlManagerAggregatorListener, double screenAspectRatio, int screenWidthDp, Context context) {
        Preconditions.checkNotNull((Object)vastXmlManagerAggregatorListener);
        Preconditions.checkNotNull((Object)context);
        this.mVastXmlManagerAggregatorListener = vastXmlManagerAggregatorListener;
        this.mScreenAspectRatio = screenAspectRatio;
        this.mScreenWidthDp = screenWidthDp;
        this.mContext = context.getApplicationContext();
    }

    protected void onPreExecute() {
        System.getProperty("http.agent");
    }

    protected VastVideoConfig doInBackground(String ... strings) {
        if (strings == null || strings.length == 0 || strings[0] == null) {
            return null;
        }
        try {
            String vastXml = strings[0];
            return this.evaluateVastXmlManager(vastXml, new ArrayList<VastTracker>());
        }
        catch (Exception e) {
            InnerLog.v("Unable to generate VastVideoConfig." + e);
            return null;
        }
    }

    protected void onPostExecute(VastVideoConfig vastVideoConfig) {
        VastXmlManagerAggregatorListener listener = this.mVastXmlManagerAggregatorListener;
        if (listener != null) {
            listener.onAggregationComplete(vastVideoConfig);
        } else {
            InnerLog.v("onPostExecute listener is null");
        }
    }

    protected void onCancelled() {
        VastXmlManagerAggregatorListener listener = this.mVastXmlManagerAggregatorListener;
        if (listener != null) {
            listener.onAggregationComplete(null);
        } else {
            InnerLog.v("onCancelled listener is null");
        }
    }

    VastVideoConfig evaluateVastXmlManager(String vastXml, List<VastTracker> errorTrackers) {
        Preconditions.checkNotNull((Object)vastXml, (String)"vastXml cannot be null");
        Preconditions.checkNotNull(errorTrackers, (String)"errorTrackers cannot be null");
        VastXmlManager xmlManager = new VastXmlManager();
        try {
            xmlManager.parseVastXml(vastXml);
        }
        catch (Exception e) {
            InnerLog.v("Failed to parse VAST XML" + e);
            return null;
        }
        List<VastAdXmlManager> vastAdXmlManagers = xmlManager.getAdXmlManagers();
        if (this.fireErrorTrackerIfNoAds(vastAdXmlManagers, xmlManager, this.mContext)) {
            return null;
        }
        for (VastAdXmlManager vastAdXmlManager : vastAdXmlManagers) {
            VastVideoConfig vastVideoConfig;
            VastVideoConfig vastVideoConfig2;
            if (!VastXmlManagerAggregator.isValidSequenceNumber(vastAdXmlManager.getSequence())) continue;
            VastInLineXmlManager vastInLineXmlManager = vastAdXmlManager.getInLineXmlManager();
            if (vastInLineXmlManager != null && (vastVideoConfig2 = this.evaluateInLineXmlManager(vastInLineXmlManager, errorTrackers)) != null) {
                this.populateMoPubCustomElements(xmlManager, vastVideoConfig2);
                return vastVideoConfig2;
            }
            VastWrapperXmlManager vastWrapperXmlManager = vastAdXmlManager.getWrapperXmlManager();
            if (vastWrapperXmlManager == null) continue;
            ArrayList<VastTracker> wrapperErrorTrackers = new ArrayList<VastTracker>(errorTrackers);
            wrapperErrorTrackers.addAll(vastWrapperXmlManager.getErrorTrackers());
            String vastRedirectXml = this.evaluateWrapperRedirect(vastWrapperXmlManager, wrapperErrorTrackers);
            if (vastRedirectXml == null || (vastVideoConfig = this.evaluateVastXmlManager(vastRedirectXml, wrapperErrorTrackers)) == null) continue;
            vastVideoConfig.addImpressionTrackers(vastWrapperXmlManager.getImpressionTrackers());
            List<VastLinearXmlManager> linearXmlManagers = vastWrapperXmlManager.getLinearXmlManagers();
            for (VastLinearXmlManager linearXmlManager : linearXmlManagers) {
                this.populateLinearTrackersAndIcon(linearXmlManager, vastVideoConfig);
            }
            this.populateVideoViewabilityTracker(vastWrapperXmlManager, vastVideoConfig);
            this.populateViewabilityMetadata(vastWrapperXmlManager, vastVideoConfig);
            this.populateAdVerificationsOmid(vastWrapperXmlManager.mNode, vastVideoConfig);
            List<VastCompanionAdXmlManager> companionAdXmlManagers = vastWrapperXmlManager.getCompanionAdXmlManagers();
            if (!vastVideoConfig.hasCompanionAd()) {
                vastVideoConfig.addVastCompanionAdConfigs(this.getAllCompanionAds(companionAdXmlManagers));
            } else {
                Set<VastCompanionAdConfig> companionAds = vastVideoConfig.getVastCompanionAdConfigs();
                for (VastCompanionAdConfig vastCompanionAdConfig : companionAds) {
                    for (VastCompanionAdXmlManager companionAdXmlManager : companionAdXmlManagers) {
                        if (companionAdXmlManager.hasResources()) continue;
                        vastCompanionAdConfig.addClickTrackers(companionAdXmlManager.getClickTrackers());
                        vastCompanionAdConfig.addCreativeViewTrackers(companionAdXmlManager.getCompanionCreativeViewTrackers());
                    }
                }
            }
            this.populateMoPubCustomElements(xmlManager, vastVideoConfig);
            return vastVideoConfig;
        }
        return null;
    }

    private VastVideoConfig evaluateInLineXmlManager(VastInLineXmlManager vastInLineXmlManager, List<VastTracker> errorTrackers) {
        Preconditions.checkNotNull((Object)vastInLineXmlManager);
        Preconditions.checkNotNull(errorTrackers);
        List<VastLinearXmlManager> linearXmlManagers = vastInLineXmlManager.getLinearXmlManagers();
        for (VastLinearXmlManager linearXmlManager : linearXmlManagers) {
            Rect rect = new Rect();
            String bestMediaFileUrl = this.getBestMediaFileUrl(linearXmlManager.getMediaXmlManagers(), rect);
            if (bestMediaFileUrl == null) continue;
            VastVideoConfig vastVideoConfig = new VastVideoConfig();
            vastVideoConfig.addImpressionTrackers(vastInLineXmlManager.getImpressionTrackers());
            this.populateLinearTrackersAndIcon(linearXmlManager, vastVideoConfig);
            vastVideoConfig.setClickThroughUrl(linearXmlManager.getClickThroughUrl());
            vastVideoConfig.setNetworkMediaFileUrl(bestMediaFileUrl);
            vastVideoConfig.setVideoWidth(rect.width());
            vastVideoConfig.setVideoHeight(rect.height());
            List<VastCompanionAdXmlManager> companionAdXmlManagers = vastInLineXmlManager.getCompanionAdXmlManagers();
            vastVideoConfig.addVastCompanionAdConfigs(this.getAllCompanionAds(companionAdXmlManagers));
            errorTrackers.addAll(vastInLineXmlManager.getErrorTrackers());
            vastVideoConfig.addErrorTrackers(errorTrackers);
            this.populateVideoViewabilityTracker(vastInLineXmlManager, vastVideoConfig);
            this.populateViewabilityMetadata(vastInLineXmlManager, vastVideoConfig);
            this.populateAdVerificationsOmid(vastInLineXmlManager.mNode, vastVideoConfig);
            return vastVideoConfig;
        }
        return null;
    }

    private void populateVideoViewabilityTracker(VastBaseInLineWrapperXmlManager vastInLineXmlManager, VastVideoConfig vastVideoConfig) {
        Preconditions.checkNotNull((Object)vastInLineXmlManager);
        Preconditions.checkNotNull((Object)vastVideoConfig);
        if (vastVideoConfig.getVideoViewabilityTracker() != null) {
            return;
        }
        VastExtensionParentXmlManager vastExtensionParentXmlManager = vastInLineXmlManager.getVastExtensionParentXmlManager();
        if (vastExtensionParentXmlManager != null) {
            List<VastExtensionXmlManager> vastExtensionXmlManagers = vastExtensionParentXmlManager.getVastExtensionXmlManagers();
            for (VastExtensionXmlManager vastExtensionXmlManager : vastExtensionXmlManagers) {
                if (!MOPUB.equals(vastExtensionXmlManager.getType())) continue;
                vastVideoConfig.setVideoViewabilityTracker(vastExtensionXmlManager.getVideoViewabilityTracker());
                break;
            }
        }
    }

    private void populateViewabilityMetadata(VastBaseInLineWrapperXmlManager vastInLineXmlManager, VastVideoConfig vastVideoConfig) {
        VastExtensionParentXmlManager vastExtensionParentXmlManager = vastInLineXmlManager.getVastExtensionParentXmlManager();
        if (vastExtensionParentXmlManager != null) {
            List<VastExtensionXmlManager> vastExtensionXmlManagers = vastExtensionParentXmlManager.getVastExtensionXmlManagers();
            for (VastExtensionXmlManager vastExtensionXmlManager : vastExtensionXmlManagers) {
                if (vastExtensionXmlManager == null) continue;
                this.populateAdVerificationsOmid(vastExtensionXmlManager.mExtensionNode, vastVideoConfig);
            }
        }
    }

    private void populateAdVerificationsOmid(Node adVerificationsParent, VastVideoConfig vastVideoConfig) {
        VastAdVerificationsParser adVerificationNodes = new VastAdVerificationsParser(adVerificationsParent);
        Set<ViewabilityVendor> vendors = adVerificationNodes.getViewabilityVendors();
        vastVideoConfig.addViewabilityVendors(vendors);
    }

    private String evaluateWrapperRedirect(VastWrapperXmlManager vastWrapperXmlManager, List<VastTracker> wrapperErrorTrackers) {
        String vastAdTagUri = vastWrapperXmlManager.getVastAdTagURI();
        if (vastAdTagUri == null) {
            return null;
        }
        String vastRedirectXml = null;
        try {
            vastRedirectXml = this.followVastRedirect(vastAdTagUri);
        }
        catch (Exception e) {
            InnerLog.v("Failed to follow VAST redirect" + e);
            if (!wrapperErrorTrackers.isEmpty()) {
                // empty if block
            }
        }
        return vastRedirectXml;
    }

    private void populateLinearTrackersAndIcon(VastLinearXmlManager linearXmlManager, VastVideoConfig vastVideoConfig) {
        Preconditions.checkNotNull((Object)linearXmlManager, (String)"linearXmlManager cannot be null");
        Preconditions.checkNotNull((Object)vastVideoConfig, (String)"vastVideoConfig cannot be null");
        vastVideoConfig.addAbsoluteTrackers(linearXmlManager.getAbsoluteProgressTrackers());
        vastVideoConfig.addFractionalTrackers(linearXmlManager.getFractionalProgressTrackers());
        vastVideoConfig.addPauseTrackers(linearXmlManager.getPauseTrackers());
        vastVideoConfig.addResumeTrackers(linearXmlManager.getResumeTrackers());
        vastVideoConfig.addCompleteTrackers(linearXmlManager.getVideoCompleteTrackers());
        vastVideoConfig.addCloseTrackers(linearXmlManager.getVideoCloseTrackers());
        vastVideoConfig.addSkipTrackers(linearXmlManager.getVideoSkipTrackers());
        vastVideoConfig.addClickTrackers(linearXmlManager.getClickTrackers());
        if (vastVideoConfig.getSkipOffset() == null) {
            vastVideoConfig.setSkipOffset(linearXmlManager.getSkipOffset());
        }
        if (vastVideoConfig.getVastIconConfig() == null) {
            vastVideoConfig.setVastIconConfig(this.getBestIcon(linearXmlManager.getIconXmlManagers()));
        }
    }

    private void populateMoPubCustomElements(VastXmlManager xmlManager, VastVideoConfig vastVideoConfig) {
        Preconditions.checkNotNull((Object)xmlManager, (String)"xmlManager cannot be null");
        Preconditions.checkNotNull((Object)vastVideoConfig, (String)"vastVideoConfig cannot be null");
        vastVideoConfig.addImpressionTrackers(xmlManager.getMoPubImpressionTrackers());
        if (vastVideoConfig.getCustomCtaText() == null) {
            vastVideoConfig.setCustomCtaText(xmlManager.getCustomCtaText());
        }
        if (vastVideoConfig.getCustomSkipText() == null) {
            vastVideoConfig.setCustomSkipText(xmlManager.getCustomSkipText());
        }
        if (vastVideoConfig.getCustomCloseIconUrl() == null) {
            vastVideoConfig.setCustomCloseIconUrl(xmlManager.getCustomCloseIconUrl());
        }
    }

    private boolean fireErrorTrackerIfNoAds(List<VastAdXmlManager> vastAdXmlManagers, VastXmlManager xmlManager, Context context) {
        return vastAdXmlManagers.isEmpty() && xmlManager.getErrorTracker() != null;
    }

    String getBestMediaFileUrl(List<VastMediaXmlManager> managers, Rect rect) {
        Preconditions.checkNotNull(managers, (String)"managers cannot be null");
        ArrayList<VastMediaXmlManager> mediaXmlManagers = new ArrayList<VastMediaXmlManager>(managers);
        double bestMediaFitness = Double.NEGATIVE_INFINITY;
        String bestMediaFileUrl = null;
        Iterator xmlManagerIterator = mediaXmlManagers.iterator();
        while (xmlManagerIterator.hasNext()) {
            double mediaFitness;
            VastMediaXmlManager mediaXmlManager = (VastMediaXmlManager)xmlManagerIterator.next();
            String mediaType = mediaXmlManager.getType();
            String mediaUrl = mediaXmlManager.getMediaUrl();
            if (!VIDEO_MIME_TYPES.contains(mediaType) || mediaUrl == null) {
                xmlManagerIterator.remove();
                continue;
            }
            Integer mediaWidth = mediaXmlManager.getWidth();
            Integer mediaHeight = mediaXmlManager.getHeight();
            Integer mediaBitrate = mediaXmlManager.getBitrate();
            if (mediaWidth == null || mediaWidth <= 0 || mediaHeight == null || mediaHeight <= 0 || !((mediaFitness = this.calculateFitness(mediaWidth, mediaHeight, mediaBitrate, mediaType)) > bestMediaFitness)) continue;
            bestMediaFitness = mediaFitness;
            bestMediaFileUrl = mediaUrl;
            rect.set(0, 0, mediaWidth.intValue(), mediaHeight.intValue());
        }
        return bestMediaFileUrl;
    }

    Set<VastCompanionAdConfig> getAllCompanionAds(List<VastCompanionAdXmlManager> managers) {
        Preconditions.checkNotNull(managers, (String)"managers cannot be null");
        HashSet<VastCompanionAdConfig> vastCompanionAdConfigs = new HashSet<VastCompanionAdConfig>();
        ArrayList<VastCompanionAdXmlManager> companionXmlManagers = new ArrayList<VastCompanionAdXmlManager>(managers);
        for (VastResource.Type type : VastResource.Type.values()) {
            for (VastCompanionAdXmlManager companionXmlManager : companionXmlManagers) {
                Integer width = companionXmlManager.getWidth();
                Integer height = companionXmlManager.getHeight();
                if (width == null || width < 300 || height == null || height < 250) continue;
                Point vastScaledDimensions = this.getScaledDimensions(width, height, type);
                VastResource vastResource = VastResource.fromVastResourceXmlManager(companionXmlManager.getResourceXmlManager(), type, vastScaledDimensions.x, vastScaledDimensions.y);
                if (vastResource == null) continue;
                VastCompanionAdConfig vastCompanionAdConfig = new VastCompanionAdConfig(vastScaledDimensions.x, vastScaledDimensions.y, vastResource, companionXmlManager.getClickThroughUrl(), companionXmlManager.getClickTrackers(), companionXmlManager.getCompanionCreativeViewTrackers(), null);
                vastCompanionAdConfigs.add(vastCompanionAdConfig);
            }
        }
        return vastCompanionAdConfigs;
    }

    Point getScaledDimensions(int widthDp, int heightDp, VastResource.Type type) {
        Point defaultPoint = new Point(widthDp, heightDp);
        return defaultPoint;
    }

    VastIconConfig getBestIcon(List<VastIconXmlManager> managers) {
        Preconditions.checkNotNull(managers, (String)"managers cannot be null");
        ArrayList<VastIconXmlManager> iconXmlManagers = new ArrayList<VastIconXmlManager>(managers);
        for (VastResource.Type type : VastResource.Type.values()) {
            for (VastIconXmlManager iconXmlManager : iconXmlManagers) {
                VastResource vastResource;
                Integer width = iconXmlManager.getWidth();
                Integer height = iconXmlManager.getHeight();
                if (width == null || width <= 0 || width > 300 || height == null || height <= 0 || height > 300 || (vastResource = VastResource.fromVastResourceXmlManager(iconXmlManager.getResourceXmlManager(), type, width, height)) == null) continue;
                return new VastIconConfig(iconXmlManager.getWidth(), iconXmlManager.getHeight(), iconXmlManager.getOffsetMS(), iconXmlManager.getDurationMS(), vastResource, iconXmlManager.getClickTrackingUris(), iconXmlManager.getClickThroughUri(), iconXmlManager.getViewTrackingUris());
            }
        }
        return null;
    }

    private double calculateFitness(int widthDp, int heightDp, Integer bitrate, String format) {
        double screenFitness = this.calculateScreenFitnessFactor(widthDp, heightDp);
        double bitrateFitness = this.calculateBitrateFitnessFactor(bitrate);
        double formatFitness = this.calculateFormatFitnessFactor(format);
        return formatFitness * (1.0 / (1.0 + screenFitness + bitrateFitness));
    }

    private double calculateBitrateFitnessFactor(Integer bitrate) {
        int usableBitrate;
        int n = usableBitrate = bitrate == null || bitrate < 0 ? 0 : bitrate;
        if (700 <= usableBitrate && usableBitrate <= 1500) {
            return 0.0;
        }
        double lowDistance = (float)Math.abs(700 - usableBitrate) / 700.0f;
        double highDistance = (float)Math.abs(1500 - usableBitrate) / 1500.0f;
        return Math.min(lowDistance, highDistance);
    }

    private double calculateScreenFitnessFactor(int widthDp, int heightDp) {
        double mediaAspectRatio = (double)widthDp / (double)heightDp;
        double aspectRatioScore = Math.abs(this.mScreenAspectRatio - mediaAspectRatio);
        double widthScore = Math.abs((this.mScreenWidthDp - widthDp) / this.mScreenWidthDp);
        return aspectRatioScore + widthScore;
    }

    private double calculateFormatFitnessFactor(String format) {
        String safeFormat;
        switch (safeFormat = format == null ? "" : format) {
            case "video/mp4": {
                return 1.5;
            }
        }
        return 1.0;
    }

    static boolean isValidSequenceNumber(String sequence) {
        if (TextUtils.isEmpty((CharSequence)sequence)) {
            return true;
        }
        try {
            int sequenceInt = Integer.parseInt(sequence);
            return sequenceInt < 2;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String followVastRedirect(String redirectUrl) throws IOException {
        Preconditions.checkNotNull((Object)redirectUrl);
        if (this.mTimesFollowedVastRedirect < 10) {
            String string;
            ++this.mTimesFollowedVastRedirect;
            HttpURLConnection urlConnection = null;
            BufferedInputStream inputStream = null;
            try {
                urlConnection = TPHttpUrlConnection.getHttpUrlConnection(redirectUrl);
                inputStream = new BufferedInputStream(urlConnection.getInputStream());
                string = Strings.fromStream((InputStream)inputStream);
            }
            catch (Throwable throwable) {
                Streams.closeStream(inputStream);
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                throw throwable;
            }
            Streams.closeStream((Closeable)inputStream);
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            return string;
        }
        return null;
    }

    @Deprecated
    void setTimesFollowedVastRedirect(int timesFollowedVastRedirect) {
        this.mTimesFollowedVastRedirect = timesFollowedVastRedirect;
    }

    static enum CompanionOrientation {
        LANDSCAPE,
        PORTRAIT;

    }

    static interface VastXmlManagerAggregatorListener {
        public void onAggregationComplete(VastVideoConfig var1);
    }
}

