/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.tp.adx.R;
import com.tp.adx.open.InnerSdk;
import com.tp.adx.open.TPInnerAdListener;
import com.tp.adx.open.TPInnerMediaView;
import com.tp.adx.sdk.InnerFullScreenMgr;
import com.tp.adx.sdk.bean.TPFullScreenInfo;
import com.tp.adx.sdk.bean.TPPayloadInfo;
import com.tp.adx.sdk.event.InnerSendEventMessage;
import com.tp.adx.sdk.tracking.InnerTrackNotification;
import com.tp.adx.sdk.tracking.InnerVastNotificationUtils;
import com.tp.adx.sdk.ui.BaseWebView;
import com.tp.adx.sdk.ui.InnerHtmlWebView;
import com.tp.adx.sdk.ui.InnerMraidWebView;
import com.tp.adx.sdk.ui.InnerWebViewActivity;
import com.tp.adx.sdk.ui.views.InnerSkipDialog;
import com.tp.adx.sdk.util.InnerLog;
import com.tp.common.InnerImpressionUtils;
import com.tp.vast.VastCompanionAdConfig;
import com.tp.vast.VastManager;
import com.tp.vast.VastTracker;
import com.tp.vast.VastVideoConfig;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.common.TPImageLoader;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.common.UrlAction;
import com.tradplus.ads.common.UrlHandler;
import com.tradplus.ads.common.util.Audio;
import com.tradplus.ads.common.util.ResourceUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;

public class InnerActivity
extends Activity
implements View.OnClickListener {
    private static final String TAG = "InnerSDK";
    private TPInnerMediaView inner_mediaview;
    private int mScreenWidth;
    private int mScreenHeight;
    private TPPayloadInfo.SeatBid.Bid bidInfo;
    private VastVideoConfig vastVideoConfig;
    private InnerSendEventMessage innerSendEventMessage;
    private String adUnitId;
    private ImageView img_mute;
    private ImageView img_close;
    private LinearLayout layout_close;
    private TextView tv_countdown;
    private TextView img_skip;
    private TextView tp_tv_ad;
    private boolean isMute;
    private TPInnerAdListener tpInnerAdListener;
    private ImageView img_endcard;
    private String endCardUrl;
    private int isRewared;
    private boolean isCallReward;
    private boolean isHtml;
    private LinearLayout tp_layout_intersittial_webview;
    private BaseWebView mWebView;
    private int maxSkipTime;
    private boolean canShown = true;
    private boolean isSkip;
    private TPPayloadInfo tpPayloadInfo;
    private int validCount;
    private float touchX;
    private float touchY;
    private boolean isHtmlEndCard;
    private boolean isPause;

    public static void start(String adUnitId) {
        Intent intent = new Intent(GlobalTradPlus.getInstance().getContext(), InnerActivity.class);
        intent.putExtra("adUnitId", adUnitId);
        intent.addFlags(0x10000000);
        GlobalTradPlus.getInstance().getContext().startActivity(intent);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(ResourceUtils.getLayoutIdByName((Context)this, (String)"tp_activity_layout_inner_fullscreen"));
        this.init();
    }

    private void init() {
        this.getScreenParams();
        this.adUnitId = this.getIntent().getStringExtra("adUnitId");
        TPFullScreenInfo tpFullScreenInfo = InnerFullScreenMgr.InnerFullscreenAdMessager.getInstance().getListener(this.adUnitId);
        if (tpFullScreenInfo != null) {
            this.tpPayloadInfo = tpFullScreenInfo.getTpPayloadInfo();
            this.bidInfo = tpFullScreenInfo.getBidInfo();
            this.vastVideoConfig = tpFullScreenInfo.getVastVideoConfig();
            this.adUnitId = tpFullScreenInfo.getAdUnitId();
            this.isMute = tpFullScreenInfo.isMute();
            if (!this.isMute) {
                this.isMute = Audio.isAudioSilent((Context)this);
            }
            this.isRewared = tpFullScreenInfo.getIsRewared();
            this.isHtml = tpFullScreenInfo.isHtml();
            this.innerSendEventMessage = tpFullScreenInfo.getInnerSendEventMessage();
            this.tpInnerAdListener = tpFullScreenInfo.getTpInnerAdListener();
            this.maxSkipTime = tpFullScreenInfo.getSkipTime();
            this.initView();
        } else {
            if (this.tpInnerAdListener != null) {
                this.tpInnerAdListener.onAdClosed();
            }
            this.showFailed("900");
            this.finish();
        }
    }

    private void initView() {
        this.img_mute = (ImageView)this.findViewById(ResourceUtils.getViewIdByName((Context)this, (String)"tp_img_mute"));
        this.img_mute.setOnClickListener((View.OnClickListener)this);
        this.img_close = (ImageView)this.findViewById(ResourceUtils.getViewIdByName((Context)this, (String)"tp_img_close"));
        this.layout_close = (LinearLayout)this.findViewById(ResourceUtils.getViewIdByName((Context)this, (String)"tp_layout_close"));
        this.img_close.setOnClickListener((View.OnClickListener)this);
        this.layout_close.setOnClickListener((View.OnClickListener)this);
        this.tp_tv_ad = (TextView)this.findViewById(ResourceUtils.getViewIdByName((Context)this, (String)"tp_tv_ad"));
        this.img_skip = (TextView)this.findViewById(ResourceUtils.getViewIdByName((Context)this, (String)"tp_img_skip"));
        this.img_skip.setOnClickListener((View.OnClickListener)this);
        this.tv_countdown = (TextView)this.findViewById(ResourceUtils.getViewIdByName((Context)this, (String)"tp_tv_countdown"));
        this.img_endcard = (ImageView)this.findViewById(ResourceUtils.getViewIdByName((Context)this, (String)"tp_img_endcard"));
        this.img_endcard.setOnClickListener((View.OnClickListener)this);
        this.inner_mediaview = (TPInnerMediaView)this.findViewById(ResourceUtils.getViewIdByName((Context)this, (String)"tp_inner_mediaview"));
        this.tp_layout_intersittial_webview = (LinearLayout)this.findViewById(ResourceUtils.getViewIdByName((Context)this, (String)"tp_layout_intersittial_webview"));
        this.tp_tv_ad.setText((CharSequence)this.getResources().getString(ResourceUtils.getStringByName((Context)this, (String)"tp_ad")));
        this.img_skip.setText((CharSequence)("| " + this.getResources().getString(ResourceUtils.getStringByName((Context)this, (String)"tp_skip"))));
        this.initEndCard();
        this.innerSendEventMessage.sendShowAdStart();
        if (!this.isHtml) {
            if (this.vastVideoConfig != null) {
                String videoUrl = this.vastVideoConfig.getDiskMediaFileUrl();
                if (TextUtils.isEmpty((CharSequence)videoUrl)) {
                    this.innerSendEventMessage.sendShowEndAd(1);
                    if (!this.showEndCard()) {
                        this.showFailed("401");
                        this.finish();
                    } else {
                        this.impression();
                    }
                } else {
                    this.initMediaPlayer();
                }
            } else {
                this.showFailed("100");
                this.finish();
            }
        }
    }

    private void setAllMediaViewFriendViews() {
        ArrayList<View> views = new ArrayList<View>();
        views.add((View)this.img_mute);
        views.add((View)this.img_close);
        views.add((View)this.layout_close);
        views.add((View)this.tp_tv_ad);
        views.add((View)this.img_skip);
        views.add((View)this.tv_countdown);
        views.add((View)this.img_endcard);
        views.add(this.findViewById(R.id.tp_layout_countdown));
        views.add(this.findViewById(R.id.tp_layout_mute));
        views.add(this.findViewById(R.id.tp_layout_ad));
        views.add((View)this.tp_layout_intersittial_webview);
        this.inner_mediaview.setFriendlyObstruction(views);
    }

    private void initMediaPlayer() {
        this.setAllMediaViewFriendViews();
        this.inner_mediaview.setVastVideoConfig(this.bidInfo, this.vastVideoConfig);
        this.inner_mediaview.setIsMute(this.isMute);
        this.setMute();
        this.inner_mediaview.setOnPlayerListener(new TPInnerMediaView.OnPlayerListener(){

            @Override
            public void onVideoPlayStart() {
                if (InnerActivity.this.tpInnerAdListener != null) {
                    InnerActivity.this.tpInnerAdListener.onVideoStart();
                }
                InnerActivity.this.sendVideoPlayProgressTrack(0);
                InnerActivity.this.startVideo();
            }

            @Override
            public void onVideoUpdateProgress(int progress, int duration) {
                int videoPlayTime = (InnerActivity.this.inner_mediaview.getVideoLength() - progress) / 1000;
                if (videoPlayTime > 0) {
                    InnerActivity.this.tv_countdown.setText((CharSequence)(videoPlayTime + "s"));
                    if (InnerActivity.this.inner_mediaview.getDuration() / 1000 > InnerActivity.this.maxSkipTime) {
                        if (InnerActivity.this.isRewared == 1 && progress / 1000 > 30 && !InnerActivity.this.isCallReward) {
                            InnerActivity.this.isCallReward = true;
                        }
                        if (InnerActivity.this.inner_mediaview.getVideoLength() / 1000 - videoPlayTime > InnerActivity.this.maxSkipTime && !InnerActivity.this.isSkip) {
                            InnerActivity.this.img_skip.setVisibility(0);
                        }
                    }
                } else {
                    if (!InnerActivity.this.isCallReward) {
                        InnerActivity.this.isCallReward = true;
                    }
                    InnerActivity.this.innerSendEventMessage.sendShowEndAd(1);
                    InnerActivity.this.showEndCard();
                }
            }

            @Override
            public void onVideoPlayCompletion() {
                Log.v((String)InnerActivity.TAG, (String)"onVideoPlayCompletion");
                if (InnerActivity.this.tpInnerAdListener != null) {
                    InnerActivity.this.tpInnerAdListener.onVideoEnd();
                }
                InnerActivity.this.sendVideoPlayProgressTrack(100);
                if (InnerActivity.this.inner_mediaview != null) {
                    InnerActivity.this.inner_mediaview.release();
                }
            }

            @Override
            public void onVideoShowFailed() {
                InnerActivity.this.showFailed("405");
                InnerActivity.this.showEndCard();
            }

            @Override
            public void onVideoPlayProgress(int progressArea) {
                InnerActivity.this.sendVideoPlayProgressTrack(progressArea);
            }

            @Override
            public void onVideoMute() {
                Log.v((String)InnerActivity.TAG, (String)"onVideoMute");
            }

            @Override
            public void onVideoNoMute() {
                Log.v((String)InnerActivity.TAG, (String)"onVideoNoMute");
            }
        });
        this.inner_mediaview.setOnClickListener(this);
    }

    private void startVideo() {
        this.tv_countdown.setVisibility(0);
        this.impression();
    }

    private void impression() {
        if (InnerImpressionUtils.isDefaultImpressionSetting(this.tpPayloadInfo)) {
            this.impressionCallback();
        } else {
            this.checkVisible();
        }
    }

    private void checkVisible() {
        InnerLog.v(TAG, "checkVisible:");
        TPTaskManager.getInstance().getThreadHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (InnerActivity.this.canShown) {
                    if (!InnerActivity.this.isPause) {
                        InnerActivity.this.validCount++;
                        Log.i((String)InnerActivity.TAG, (String)("valid count  = " + InnerImpressionUtils.getValidCount(InnerActivity.this.tpPayloadInfo)));
                        if (InnerActivity.this.validCount >= InnerImpressionUtils.getValidCount(InnerActivity.this.tpPayloadInfo)) {
                            InnerActivity.this.impressionCallback();
                        } else {
                            InnerActivity.this.checkVisible();
                        }
                    } else {
                        InnerActivity.this.checkVisible();
                    }
                }
            }
        }, 1000L);
    }

    private void impressionCallback() {
        InnerVastNotificationUtils.getInstance().sendCompanionImpNotification(this.vastVideoConfig);
        InnerTrackNotification.sendImpressionNotification(this.bidInfo, this.innerSendEventMessage, VastManager.getVastNetworkMediaUrl(this.vastVideoConfig));
        if (this.tpInnerAdListener != null) {
            this.tpInnerAdListener.onAdImpression();
        }
        this.checkCanShowClose();
    }

    private void checkCanShowClose() {
        TPTaskManager.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (InnerActivity.this.img_close.getVisibility() == 8 && InnerActivity.this.tv_countdown.getVisibility() == 8) {
                    InnerActivity.this.img_close.setVisibility(0);
                    InnerActivity.this.layout_close.setVisibility(0);
                }
            }
        });
    }

    private void showFailed(String errorcode) {
        if (this.innerSendEventMessage != null) {
            this.innerSendEventMessage.sendShowEndAd(24);
        }
        if (this.vastVideoConfig != null) {
            HashSet<String> tempUrls = new HashSet<String>();
            for (VastTracker vastTracker : this.vastVideoConfig.getErrorTrackers()) {
                if (TextUtils.isEmpty((CharSequence)vastTracker.getContent())) continue;
                tempUrls.add(vastTracker.getContent());
            }
            InnerTrackNotification.sendErrorNotification(tempUrls, errorcode, VastManager.getVastNetworkMediaUrl(this.vastVideoConfig));
        }
    }

    private void sendVideoPlayProgressTrack(int progress) {
        if (this.vastVideoConfig == null) {
            return;
        }
        InnerVastNotificationUtils.getInstance().sendProgressNotification(progress, this.vastVideoConfig);
    }

    private void getScreenParams() {
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        this.mScreenWidth = dm.widthPixels;
        this.mScreenHeight = dm.heightPixels;
        if (this.mScreenWidth > this.mScreenHeight) {
            this.setRequestedOrientation(6);
        } else {
            this.setRequestedOrientation(1);
        }
    }

    private void setMute() {
        if (this.isMute) {
            this.img_mute.setBackgroundResource(R.drawable.tp_inner_video_mute);
        } else {
            this.img_mute.setBackgroundResource(R.drawable.tp_inner_video_no_mute);
        }
        if (this.inner_mediaview != null) {
            this.inner_mediaview.setMute(this.isMute);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == ResourceUtils.getViewIdByName((Context)this, (String)"tp_img_mute")) {
            this.isMute = !this.isMute;
            this.setMute();
        } else if (id2 == ResourceUtils.getViewIdByName((Context)this, (String)"tp_layout_close") || id2 == ResourceUtils.getViewIdByName((Context)this, (String)"tp_img_close")) {
            if (this.tpInnerAdListener != null) {
                if (this.isCallReward && this.tpInnerAdListener != null && this.isRewared == 1) {
                    this.tpInnerAdListener.onReward();
                }
                this.innerSendEventMessage.sendCloseAd(this.touchX, this.touchY);
                InnerVastNotificationUtils.getInstance().sendCloseNotification(this.vastVideoConfig);
                this.tpInnerAdListener.onAdClosed();
            }
            this.finish();
        } else if (id2 == ResourceUtils.getViewIdByName((Context)this, (String)"tp_img_skip")) {
            this.skipAction();
        } else if (id2 == ResourceUtils.getViewIdByName((Context)this, (String)"tp_inner_mediaview")) {
            this.mediaViewClick();
        } else if (id2 == ResourceUtils.getViewIdByName((Context)this, (String)"tp_img_endcard")) {
            this.mediaViewClick();
        }
    }

    private void skipAction() {
        this.isSkip = true;
        if (this.isRewared == 1 && !this.isCallReward) {
            if (this.inner_mediaview != null && this.inner_mediaview.isPlaying()) {
                this.inner_mediaview.pause();
            }
            InnerSkipDialog dialog = new InnerSkipDialog((Context)this, new InnerSkipDialog.OnSkipActionListener(){

                @Override
                public void onClose() {
                    InnerActivity.this.showEndCard();
                    InnerVastNotificationUtils.getInstance().sendSkipNotification(InnerActivity.this.vastVideoConfig);
                }

                @Override
                public void onKeepPlay() {
                    InnerActivity.this.isSkip = false;
                    if (InnerActivity.this.inner_mediaview != null && !InnerActivity.this.inner_mediaview.isPlaying()) {
                        InnerActivity.this.inner_mediaview.start();
                    }
                }
            });
            dialog.show();
        } else if (this.inner_mediaview != null && this.inner_mediaview.isPlaying()) {
            this.inner_mediaview.pause();
            this.showEndCard();
            InnerVastNotificationUtils.getInstance().sendSkipNotification(this.vastVideoConfig);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        String text = "You click at x = " + event.getX() + " and y = " + event.getY();
        this.touchX = event.getX();
        this.touchY = event.getY();
        InnerLog.v(text);
        return super.dispatchTouchEvent(event);
    }

    private void mediaViewClick() {
        String url = this.vastVideoConfig.getClickThroughUrl();
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (this.tpInnerAdListener != null) {
            this.tpInnerAdListener.onAdClicked();
        }
        this.innerSendEventMessage.sendClickAdStart(this.touchX, this.touchY);
        boolean result = this.onJumpAction((Context)this, url, "", this.adUnitId);
        if (this.innerSendEventMessage != null) {
            this.innerSendEventMessage.sendClickAdEnd(result ? 1 : 32);
        }
        InnerVastNotificationUtils.getInstance().sendCompanionClickNotification(this.vastVideoConfig);
        InnerTrackNotification.sendClickNotification(this.bidInfo, this.innerSendEventMessage, VastManager.getVastNetworkMediaUrl(this.vastVideoConfig));
    }

    private boolean onJumpAction(Context context, String url, String requestId, String pid) {
        boolean openSuccessed = false;
        try {
            if (url.startsWith("market:")) {
                this.openMarket(context, url);
            } else if (url.startsWith("http")) {
                this.startHtmlActivity(context, url, requestId, pid);
            } else {
                this.openDeepLink(context, url);
            }
            openSuccessed = true;
        }
        catch (Throwable t) {
            InnerLog.v(TAG, "onJumpAction:" + t.getMessage());
        }
        return openSuccessed;
    }

    private void openMarket(Context context, String url) {
        Intent i = new Intent("android.intent.action.VIEW");
        i.setData(Uri.parse((String)url));
        i.setFlags(0x10000000);
        context.startActivity(i);
    }

    private void startHtmlActivity(Context context, String url, String requestId, String pid) {
        Intent intent;
        if (InnerSdk.isJumpWebViewOutSide()) {
            intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addCategory("android.intent.category.BROWSABLE");
        } else {
            intent = new Intent(context, InnerWebViewActivity.class);
            intent.putExtra("inner_adx_url", url);
            intent.putExtra("inner_adx_tp", (Serializable)this.innerSendEventMessage.getTpPayloadInfo());
            if (requestId != null && pid != null) {
                intent.putExtra("inner_adx_request_id", requestId);
                intent.putExtra("inner_adx_pid", pid);
            }
        }
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    private void openDeepLink(Context context, String deepLinkUrl) {
        UrlHandler.Builder builder = new UrlHandler.Builder();
        EnumSet<UrlAction[]> urlActions = EnumSet.of(UrlAction.IGNORE_ABOUT_SCHEME, new UrlAction[]{UrlAction.OPEN_NATIVE_BROWSER, UrlAction.OPEN_IN_APP_BROWSER, UrlAction.HANDLE_SHARE_TWEET, UrlAction.FOLLOW_DEEP_LINK_WITH_FALLBACK, UrlAction.FOLLOW_DEEP_LINK});
        builder.withSupportedUrlActions(urlActions).build().handleUrl(context, deepLinkUrl);
    }

    private void initEndCard() {
        if (!this.isHtml) {
            if (this.vastVideoConfig != null && this.vastVideoConfig.getVastCompanionAdConfigs().iterator().hasNext()) {
                VastCompanionAdConfig vastCompanionAdConfig = this.vastVideoConfig.getVastCompanionAdConfigs().iterator().next();
                this.endCardUrl = vastCompanionAdConfig.getVastResource().getResource();
            }
            if (!TextUtils.isEmpty((CharSequence)this.endCardUrl)) {
                if (this.endCardUrl.startsWith("<") || this.endCardUrl.contains("mraid.js")) {
                    this.isHtmlEndCard = true;
                } else {
                    TPImageLoader.getInstance().loadImage(this.img_endcard, this.endCardUrl);
                }
            }
        } else {
            try {
                if (this.bidInfo.getAdm().contains("mraid.js")) {
                    this.prepareMraidView(this.innerSendEventMessage, this.bidInfo);
                } else {
                    this.prepareHtmlView(this.innerSendEventMessage, this.bidInfo);
                }
                this.mWebView.loadHtmlResponse(this.bidInfo.getAdm());
                this.showClose();
                this.impression();
            }
            catch (Throwable throwable) {
                if (this.tpInnerAdListener != null) {
                    this.tpInnerAdListener.onAdClosed();
                }
                this.showFailed("401");
                this.finish();
            }
        }
    }

    private void prepareMraidView(InnerSendEventMessage innerSendEventMessage, TPPayloadInfo.SeatBid.Bid bidInfo) {
        this.mWebView = new InnerMraidWebView((Context)this, bidInfo.isOpenOMSdk());
        this.prepareView(innerSendEventMessage, bidInfo);
    }

    private void prepareHtmlView(InnerSendEventMessage innerSendEventMessage, TPPayloadInfo.SeatBid.Bid bidInfo) {
        this.mWebView = new InnerHtmlWebView((Context)this);
        this.prepareView(innerSendEventMessage, bidInfo);
    }

    private void addWebViewToInner() {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -1);
        layoutParams.gravity = 17;
        this.tp_layout_intersittial_webview.addView((View)this.mWebView, (ViewGroup.LayoutParams)layoutParams);
    }

    private void prepareView(final InnerSendEventMessage innerSendEventMessage, final TPPayloadInfo.SeatBid.Bid bidInfo) {
        this.addWebViewToInner();
        this.mWebView.setLoadListener(new BaseWebView.InnerHtmlLoadListener(){

            @Override
            public void onLoaded() {
            }

            @Override
            public void onClicked() {
                Log.v((String)InnerActivity.TAG, (String)"onClicked");
                if (InnerActivity.this.tpInnerAdListener != null) {
                    InnerActivity.this.tpInnerAdListener.onAdClicked();
                }
                if (innerSendEventMessage != null) {
                    innerSendEventMessage.sendClickAdStart(InnerActivity.this.touchX, InnerActivity.this.touchY);
                }
                InnerVastNotificationUtils.getInstance().sendCompanionClickNotification(InnerActivity.this.vastVideoConfig);
                InnerTrackNotification.sendClickNotification(bidInfo, innerSendEventMessage, VastManager.getVastNetworkMediaUrl(InnerActivity.this.vastVideoConfig));
            }

            @Override
            public void onJump(String url) {
                InnerLog.v(InnerActivity.TAG, "onJump :" + url);
                boolean result = false;
                if (url != null) {
                    result = InnerActivity.this.onJumpAction((Context)InnerActivity.this, url, innerSendEventMessage.getRequestId(), innerSendEventMessage.getPid());
                }
                if (innerSendEventMessage != null) {
                    innerSendEventMessage.sendClickAdEnd(result ? 1 : 32);
                }
            }

            @Override
            public void onVisibilityChanged(boolean isVisible) {
            }
        });
    }

    private void showClose() {
        this.tv_countdown.setVisibility(8);
        this.img_skip.setVisibility(8);
        Log.i((String)TAG, (String)("valid count  = " + InnerImpressionUtils.getValidCount(this.tpPayloadInfo)));
        if (this.validCount >= InnerImpressionUtils.getValidCount(this.tpPayloadInfo)) {
            this.img_close.setVisibility(0);
            this.layout_close.setVisibility(0);
        }
        this.img_mute.setVisibility(8);
    }

    private boolean showEndCard() {
        this.showClose();
        if (this.isHtmlEndCard) {
            if (this.endCardUrl.contains("mraid.js")) {
                this.prepareMraidView(this.innerSendEventMessage, this.bidInfo);
            } else {
                this.prepareHtmlView(this.innerSendEventMessage, this.bidInfo);
            }
            this.mWebView.loadHtmlResponse(this.endCardUrl);
        }
        if (!TextUtils.isEmpty((CharSequence)this.endCardUrl)) {
            this.img_endcard.setVisibility(0);
            this.inner_mediaview.setVisibility(8);
            return true;
        }
        return false;
    }

    protected void onResume() {
        this.isPause = false;
        if (this.inner_mediaview != null && !this.inner_mediaview.isPlaying() && !this.isSkip) {
            this.inner_mediaview.start();
            InnerVastNotificationUtils.getInstance().sendResumeNotification(this.vastVideoConfig);
        }
        super.onResume();
    }

    protected void onPause() {
        this.isPause = true;
        if (this.inner_mediaview != null) {
            this.inner_mediaview.pause();
            InnerVastNotificationUtils.getInstance().sendPauseNotification(this.vastVideoConfig);
        }
        super.onPause();
    }

    protected void onDestroy() {
        this.canShown = false;
        InnerFullScreenMgr.InnerFullscreenAdMessager.getInstance().unRegister(this.adUnitId);
        if (this.inner_mediaview != null) {
            this.inner_mediaview.release();
        }
        super.onDestroy();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (4 == keyCode) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }
}

