/*
 * Decompiled with CFR 0.152.
 */
package com.tp.vast;

import android.content.Context;
import android.text.TextUtils;
import android.view.Display;
import android.view.WindowManager;
import com.tp.adx.sdk.util.InnerLog;
import com.tp.common.CacheService;
import com.tp.common.util.AsyncTasks;
import com.tp.vast.VastVideoConfig;
import com.tp.vast.VastXmlManagerAggregator;
import com.tp.vast.VideoDownloader;
import com.tradplus.ads.common.Preconditions;

public class VastManager
implements VastXmlManagerAggregator.VastXmlManagerAggregatorListener {
    private boolean isStartDownload;
    private VastManagerListener mVastManagerListener;
    private VastXmlManagerAggregator mVastXmlManagerAggregator;
    private String mDspCreativeId;
    private double mScreenAspectRatio;
    private int mScreenWidthDp;
    private final boolean mShouldPreCacheVideo;

    public boolean isStartDownload() {
        return this.isStartDownload;
    }

    public VastManager(Context context, boolean shouldPreCacheVideo) {
        this.initializeScreenDimensions(context);
        this.mShouldPreCacheVideo = shouldPreCacheVideo;
        if (shouldPreCacheVideo) {
            CacheService.initializeDiskCache(context);
        }
    }

    public void prepareVastVideoConfiguration(String vastXml, VastManagerListener vastManagerListener, String dspCreativeId, Context context) {
        Preconditions.checkNotNull((Object)vastManagerListener, (String)"vastManagerListener cannot be null");
        Preconditions.checkNotNull((Object)context, (String)"context cannot be null");
        if (this.mVastXmlManagerAggregator == null) {
            this.mVastManagerListener = vastManagerListener;
            this.mVastXmlManagerAggregator = new VastXmlManagerAggregator(this, this.mScreenAspectRatio, this.mScreenWidthDp, context.getApplicationContext());
            this.mDspCreativeId = dspCreativeId;
            try {
                AsyncTasks.safeExecuteOnExecutor(this.mVastXmlManagerAggregator, vastXml);
            }
            catch (Exception e) {
                InnerLog.v("Failed to aggregate vast xml" + e);
                this.mVastManagerListener.onVastVideoConfigurationPrepared(null);
            }
        }
    }

    public void cancel() {
        if (this.mVastXmlManagerAggregator != null) {
            this.mVastXmlManagerAggregator.cancel(true);
            this.mVastXmlManagerAggregator = null;
        }
    }

    @Override
    public void onAggregationComplete(final VastVideoConfig vastVideoConfig) {
        if (this.mVastManagerListener == null) {
            throw new IllegalStateException("mVastManagerListener cannot be null here. Did you call prepareVastVideoConfiguration()?");
        }
        if (vastVideoConfig == null) {
            this.mVastManagerListener.onVastVideoConfigurationPrepared(null);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mDspCreativeId)) {
            vastVideoConfig.setDspCreativeId(this.mDspCreativeId);
        }
        if (!this.mShouldPreCacheVideo || this.updateDiskMediaFileUrl(vastVideoConfig)) {
            this.isStartDownload = true;
            this.mVastManagerListener.onVastVideoDownloadStart();
            this.mVastManagerListener.onVastVideoConfigurationPrepared(vastVideoConfig);
            return;
        }
        VideoDownloader.VideoDownloaderListener videoDownloaderListener = new VideoDownloader.VideoDownloaderListener(){

            @Override
            public void onComplete(boolean success) {
                if (success && VastManager.this.updateDiskMediaFileUrl(vastVideoConfig)) {
                    VastManager.this.mVastManagerListener.onVastVideoConfigurationPrepared(vastVideoConfig);
                } else {
                    InnerLog.v("Failed to download VAST video.");
                    VastManager.this.mVastManagerListener.onVastVideoConfigurationPrepared(null);
                }
            }

            @Override
            public void onStart() {
                VastManager.this.isStartDownload = true;
                VastManager.this.mVastManagerListener.onVastVideoDownloadStart();
            }
        };
        String mediaUrl = vastVideoConfig.getNetworkMediaFileUrl();
        if (mediaUrl != null) {
            mediaUrl = mediaUrl.endsWith(".mp") ? mediaUrl + "4" : mediaUrl;
        }
        VideoDownloader.cache(mediaUrl, videoDownloaderListener);
    }

    public static String getVastNetworkMediaUrl(VastVideoConfig vastVideoConfig) {
        if (vastVideoConfig == null) {
            return "";
        }
        return vastVideoConfig.getNetworkMediaFileUrl();
    }

    private boolean updateDiskMediaFileUrl(VastVideoConfig vastVideoConfig) {
        Preconditions.checkNotNull((Object)vastVideoConfig, (String)"vastVideoConfig cannot be null");
        String mediaUrl = vastVideoConfig.getNetworkMediaFileUrl();
        if (mediaUrl != null) {
            String string = mediaUrl = mediaUrl.endsWith("mp") ? mediaUrl + "4" : mediaUrl;
        }
        if (CacheService.containsKeyDiskCache(mediaUrl)) {
            String filePathDiskCache = CacheService.getFilePathDiskCache(mediaUrl);
            vastVideoConfig.setDiskMediaFileUrl(filePathDiskCache);
            return true;
        }
        return false;
    }

    private void initializeScreenDimensions(Context context) {
        Preconditions.checkNotNull((Object)context, (String)"context cannot be null");
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        int screenWidth = display.getWidth();
        int screenHeight = display.getHeight();
        float density = context.getResources().getDisplayMetrics().density;
        if (density <= 0.0f) {
            density = 1.0f;
        }
        this.mScreenAspectRatio = (double)screenWidth / (double)screenHeight;
        this.mScreenWidthDp = (int)((float)screenWidth / density);
    }

    @Deprecated
    int getScreenWidthDp() {
        return this.mScreenWidthDp;
    }

    @Deprecated
    double getScreenAspectRatio() {
        return this.mScreenAspectRatio;
    }

    public static interface VastManagerListener {
        public void onVastVideoConfigurationPrepared(VastVideoConfig var1);

        public void onVastVideoDownloadStart();
    }
}

