/*
 * Decompiled with CFR 0.152.
 */
package com.tp.adx.sdk.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.tp.adx.common.n;
import com.tp.adx.common.w;
import com.tp.adx.sdk.util.InnerBrowser;
import com.tp.adx.sdk.util.InnerLog;
import com.tp.adx.sdk.util.Preconditions;
import com.tp.adx.sdk.util.UrlAction;

public class Intents {
    public static void startActivity(Context context, Intent intent) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(intent);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        try {
            context.startActivity(intent);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static Intent getStartActivityIntent(Context context, Class clazz, Bundle bundle) {
        Intent intent;
        Intent intent2 = intent;
        intent = new Intent(context, clazz);
        if (!(context instanceof Activity)) {
            intent2.addFlags(0x10000000);
        }
        if (bundle != null) {
            intent2.putExtras(bundle);
        }
        return intent2;
    }

    public static boolean deviceCanHandleIntent(Context context, Intent intent) {
        return false;
    }

    public static Intent intentForNativeBrowserScheme(Uri object) {
        Preconditions.checkNotNull(object);
        if (UrlAction.OPEN_NATIVE_BROWSER.shouldTryHandlingUrl((Uri)object)) {
            if ("navigate".equals(object.getHost())) {
                block4: {
                    try {
                        object = object.getQueryParameter("url");
                        if (object == null) break block4;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        InnerLog.d("Could not handle url: " + object);
                        throw new w("Passed-in URL did not create a hierarchical URI.");
                    }
                    object = Uri.parse((String)object);
                    return new Intent("android.intent.action.VIEW", object);
                }
                throw new w("URL missing 'url' query parameter.");
            }
            throw new w("URL missing 'navigate' host parameter.");
        }
        throw new w("URL does not have tpnativebrowser:// scheme.");
    }

    public static Intent intentForShareTweet(Uri object) {
        if (UrlAction.HANDLE_SHARE_TWEET.shouldTryHandlingUrl((Uri)object)) {
            String string;
            Uri uri;
            try {
                Uri uri2 = object;
                uri = uri2;
                string = uri2.getQueryParameter("screen_name");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                InnerLog.d("Could not handle url: " + object);
                throw new w("Passed-in URL did not create a hierarchical URI.");
            }
            object = uri.getQueryParameter("tweet_id");
            if (!TextUtils.isEmpty((CharSequence)string)) {
                if (!TextUtils.isEmpty((CharSequence)object)) {
                    Object[] objectArray = new Object[2];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = string;
                    objectArray[1] = object;
                    object = String.format("https://twitter.com/%s/status/%s", objectArray2);
                    Object[] objectArray3 = new Object[2];
                    objectArray2 = objectArray3;
                    objectArray3[0] = string;
                    objectArray3[1] = object;
                    object = String.format("Check out @%s's Tweet: %s", objectArray2);
                    Intent intent = new Intent("android.intent.action.SEND");
                    intent.setType("text/plain");
                    intent.putExtra("android.intent.extra.SUBJECT", (String)object);
                    intent.putExtra("android.intent.extra.TEXT", (String)object);
                    return intent;
                }
                throw new w("URL missing non-empty 'tweet_id' query parameter.");
            }
            throw new w("URL missing non-empty 'screen_name' query parameter.");
        }
        throw new w("URL does not have tpshare://tweet? format.");
    }

    public static void showInnerBrowserForUrl(Context context, Uri uri, String string) {
        Bundle bundle;
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(uri);
        InnerLog.d("Final URI to show in browser: " + uri);
        Bundle bundle2 = bundle;
        bundle2();
        bundle.putString("URL", uri.toString());
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle2.putString("tp-dsp-creative-id", string);
        }
        Context context2 = context;
        Intents.launchIntentForUserClick(context2, Intents.getStartActivityIntent(context2, InnerBrowser.class, bundle2), "Could not show InnerBrowser for url: " + uri + "\n\tPerhaps you forgot to declare InnerBrowser in your Android manifest file.");
    }

    public static void launchIntentForUserClick(Context context, Intent intent, String string) {
        Preconditions.NoThrow.checkNotNull(context);
        Preconditions.NoThrow.checkNotNull(intent);
        try {
            Intents.startActivity(context, intent);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void launchApplicationUrl(Context context, Uri uri) {
        Intent intent;
        Intent intent2 = intent;
        intent = new Intent("android.intent.action.VIEW", uri);
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(uri);
        if (Intents.deviceCanHandleIntent(context, intent2)) {
            Intents.launchApplicationIntent(context, intent2);
            return;
        }
        throw new n("Could not handle application specific action: " + uri + "\n\tYou may be running in the emulator or another device which does not have the required application.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void launchApplicationIntent(Context context, Intent intent) {
        Intent intent2 = intent;
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(intent2);
        if (Intents.deviceCanHandleIntent(context, intent2)) {
            String string = "Unable to open intent: " + intent;
            if (!(context instanceof Activity)) {
                intent.addFlags(0x10000000);
            }
            Intents.launchIntentForUserClick(context, intent, string);
            return;
        } else {
            String string = intent.getStringExtra("browser_fallback_url");
            if (TextUtils.isEmpty((CharSequence)string)) {
                if ("market".equalsIgnoreCase(intent.getScheme())) throw new n("Device could not handle neither intent nor market url.\nIntent: " + intent.toString());
                Intents.launchApplicationUrl(context, Intents.getPlayStoreUri(intent));
                return;
            } else {
                intent = Uri.parse((String)string);
                if (!"http".equalsIgnoreCase(string = intent.getScheme()) && !"https".equalsIgnoreCase(string)) {
                    Intents.launchApplicationUrl(context, (Uri)intent);
                    return;
                } else {
                    Intents.showInnerBrowserForUrl(context, (Uri)intent, null);
                }
            }
        }
    }

    public static Uri getPlayStoreUri(Intent intent) {
        Preconditions.checkNotNull(intent);
        return Uri.parse((String)("market://details?id=" + intent.getPackage()));
    }

    public static void launchActionViewIntent(Context context, Uri uri, String string) {
        Intent intent;
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(uri);
        Intent intent2 = intent;
        intent = new Intent("android.intent.action.VIEW", uri);
        if (!(context instanceof Activity)) {
            intent2.addFlags(0x10000000);
        }
        Intents.launchIntentForUserClick(context, intent2, string);
    }

    @Deprecated
    public static boolean canHandleApplicationUrl(Context context, Uri uri) {
        return false;
    }

    @Deprecated
    public static boolean canHandleApplicationUrl(Context context, Uri uri, boolean bl) {
        return false;
    }
}

