/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.applovin.carouselui.adapter;

import android.content.Context;
import android.util.Log;
import android.view.View;
import com.applovin.adview.AppLovinAdView;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinSdk;
import com.tradplus.ads.applovin.carouselui.adapter.AppLovinErrorUtil;
import com.tradplus.ads.applovin.carouselui.adapter.AppLovinInitManager;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.banner.TPBannerAdImpl;
import com.tradplus.ads.base.adapter.banner.TPBannerAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.common.util.Views;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class AppLovinBanner
extends TPBannerAdapter
implements AppLovinAdLoadListener,
AppLovinAdDisplayListener,
AppLovinAdClickListener {
    public static final String TAG = "AppLovinBanner";
    private AppLovinAdView mAppLovinBanner;
    private AppLovinSdk mAppLovinSdk;
    private String mAdSize = "1";
    private String zoneId;
    private TPBannerAdImpl mTpBannerAd;

    public void loadCustomAd(final Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (this.extrasAreValid(tpParams)) {
            this.zoneId = tpParams.get("placementId");
            if (tpParams.containsKey("ad_size" + this.zoneId)) {
                this.mAdSize = tpParams.get("ad_size" + this.zoneId);
            }
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        AppLovinInitManager.getInstance().initSDK(context, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                AppLovinBanner.this.mAppLovinSdk = AppLovinInitManager.getInstance().getAppLovinSdk();
                AppLovinBanner.this.looadAppLovinAds(context);
            }

            public void onFailed(String code, String msg) {
            }
        });
    }

    private void looadAppLovinAds(Context context) {
        this.mAppLovinBanner = new AppLovinAdView(this.mAppLovinSdk, this.calculateAdSize(this.mAdSize), this.zoneId, context);
        this.mAppLovinBanner.setId(Views.generateViewId());
        this.mAppLovinBanner.setAdLoadListener((AppLovinAdLoadListener)this);
        this.mAppLovinBanner.setAdDisplayListener((AppLovinAdDisplayListener)this);
        this.mAppLovinBanner.setAdClickListener((AppLovinAdClickListener)this);
        this.mAppLovinBanner.loadNextAd();
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("placementId");
    }

    public void clean() {
        if (this.mAppLovinBanner != null) {
            Views.removeFromParent((View)this.mAppLovinBanner);
            this.mAppLovinBanner.setAdLoadListener(null);
            this.mAppLovinBanner.setAdDisplayListener(null);
            this.mAppLovinBanner.setAdClickListener(null);
            this.mAppLovinBanner.destroy();
            this.mAppLovinBanner = null;
        }
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("9");
    }

    public String getNetworkVersion() {
        return AppLovinSdk.VERSION;
    }

    public void adReceived(AppLovinAd appLovinAd) {
        if (this.mAppLovinBanner == null) {
            return;
        }
        AppLovinAdSize size = this.mAppLovinBanner.getSize();
        if (size != null) {
            Log.i((String)TAG, (String)("AppLovinAdSize: " + size));
        }
        Log.i((String)TAG, (String)"adReceived: ");
        this.mTpBannerAd = new TPBannerAdImpl((Object)appLovinAd, (View)this.mAppLovinBanner);
        if (this.mLoadAdapterListener != null) {
            this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)this.mTpBannerAd);
        }
    }

    public void failedToReceiveAd(int errorCode) {
        Log.i((String)TAG, (String)("AppLovin banner ad failed to load with error code " + errorCode));
        if (this.mLoadAdapterListener != null) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(AppLovinErrorUtil.getTradPlusErrorCode(errorCode));
        }
    }

    public void adDisplayed(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)"AppLovin banner ad loaded Displayed");
        if (this.mTpBannerAd != null) {
            this.mTpBannerAd.adShown();
        }
    }

    public void adHidden(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)"AppLovin banner ad loaded Hidden");
    }

    public void adClicked(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)"AppLovin banner ad loaded Clicked");
        if (this.mTpBannerAd != null) {
            this.mTpBannerAd.adClicked();
        }
    }

    private AppLovinAdSize calculateAdSize(String adSize) {
        Log.i((String)TAG, (String)("calculateAdSize: " + adSize));
        if ("1".equals(adSize)) {
            return AppLovinAdSize.BANNER;
        }
        if ("2".equals(adSize)) {
            return AppLovinAdSize.MREC;
        }
        if ("3".equals(adSize)) {
            return AppLovinAdSize.LEADER;
        }
        return AppLovinAdSize.BANNER;
    }
}

