/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.applovin.carouselui.adapter;

import android.content.Context;
import android.util.Log;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.applovin.sdk.AppLovinSdkSettings;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.util.TestDeviceUtil;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class AppLovinInitManager
extends TPInitMediation {
    private static final String TAG = "AppLovin";
    private static AppLovinInitManager sInstance;
    private String sdkKey;
    private AppLovinSdk appLovinSdk;

    public static synchronized AppLovinInitManager getInstance() {
        if (sInstance == null) {
            sInstance = new AppLovinInitManager();
        }
        return sInstance;
    }

    public AppLovinSdk getAppLovinSdk() {
        return this.appLovinSdk;
    }

    public void initSDK(Context context, Map<String, Object> userParams, Map<String, String> tpParams, TPInitMediation.InitCallback initCallback) {
        final String customAs = RequestUtils.getInstance().getCustomAs("9");
        if (AppLovinInitManager.isInited((String)customAs)) {
            initCallback.onSuccess();
            return;
        }
        if (this.hasInit(customAs, initCallback)) {
            return;
        }
        if (tpParams != null && tpParams.size() > 0) {
            this.sdkKey = tpParams.get("Sdk_Key");
        }
        this.suportGDPR(context, userParams);
        AppLovinSdkSettings appLovinSdkSettings = new AppLovinSdkSettings(context);
        boolean needTestDevice = TestDeviceUtil.getInstance().isNeedTestDevice();
        this.appLovinSdk = AppLovinSdk.getInstance((String)this.sdkKey, (AppLovinSdkSettings)appLovinSdkSettings, (Context)context);
        this.appLovinSdk.setMediationProvider("other");
        this.appLovinSdk.getSettings().setVerboseLogging(needTestDevice);
        this.appLovinSdk.initializeSdk(new AppLovinSdk.SdkInitializationListener(){

            public void onSdkInitialized(AppLovinSdkConfiguration config) {
                Log.d((String)"InitNetworkSDK", (String)"initSDK: ");
                AppLovinInitManager.this.sendResult(customAs, true);
            }
        });
    }

    public void suportGDPR(Context context, Map<String, Object> localExtras) {
        if (localExtras != null && localExtras.size() > 0) {
            if (localExtras.containsKey("gdpr_consent") && localExtras.containsKey("isue")) {
                boolean need_set_gdpr = false;
                int consent = (Integer)localExtras.get("gdpr_consent");
                if (consent == 0) {
                    need_set_gdpr = true;
                }
                boolean isEu = (Boolean)localExtras.get("isue");
                Log.i((String)"privacylaws", (String)("suportGDPR: " + need_set_gdpr + ":isUe:" + isEu));
                AppLovinPrivacySettings.setHasUserConsent((boolean)need_set_gdpr, (Context)context);
            }
            if (localExtras.containsKey("COPPA")) {
                boolean coppa = (Boolean)localExtras.get("COPPA");
                Log.i((String)"privacylaws", (String)("coppa" + coppa));
                AppLovinPrivacySettings.setIsAgeRestrictedUser((boolean)coppa, (Context)context);
            }
            if (localExtras.containsKey("CCPA")) {
                boolean ccpa = (Boolean)localExtras.get("CCPA");
                Log.i((String)"privacylaws", (String)("ccpa: " + ccpa));
                AppLovinPrivacySettings.setDoNotSell((!ccpa ? 1 : 0) != 0, (Context)context);
            }
        }
    }

    public String getNetworkVersionCode() {
        return AppLovinSdk.VERSION;
    }

    public String getNetworkVersionName() {
        return TAG;
    }
}

