/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.applovin.carouselui.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinSdk;
import com.tradplus.ads.applovin.carouselui.adapter.AppLovinErrorUtil;
import com.tradplus.ads.applovin.carouselui.adapter.AppLovinInitManager;
import com.tradplus.ads.applovin.carouselui.adapter.AppLovinInterstitialCallbackRouter;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.reward.TPRewardAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class AppLovinInterstitialVideo
extends TPRewardAdapter
implements AppLovinAdLoadListener,
AppLovinAdRewardListener,
AppLovinAdClickListener,
AppLovinAdVideoPlaybackListener,
AppLovinAdDisplayListener {
    public static final String TAG = "AppLovinRewardVideo";
    private AppLovinSdk mAppLovinSdk;
    private AppLovinAd loadedAd;
    private AppLovinIncentivizedInterstitial mAppLovinIncentivizedInterstitial;
    private AppLovinInterstitialCallbackRouter mAppLovinICBR;
    private String payload;
    private String zoneId;
    private String userId;
    private boolean hasGrantedReward = false;
    private boolean alwaysRewardUser;

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (this.extrasAreValid(tpParams)) {
            this.zoneId = tpParams.get("placementId");
            this.payload = (String)userParams.get("Bidding-Payload");
            if (!TextUtils.isEmpty((CharSequence)tpParams.get("always_reward"))) {
                int rewardUser = Integer.parseInt(tpParams.get("always_reward"));
                this.alwaysRewardUser = rewardUser == 1;
            }
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        if (userParams != null && userParams.size() > 0) {
            this.userId = (String)userParams.get("user_id");
            if (TextUtils.isEmpty((CharSequence)this.userId)) {
                this.userId = "";
            }
        }
        this.mAppLovinICBR = AppLovinInterstitialCallbackRouter.getInstance();
        if (this.mLoadAdapterListener != null) {
            this.mAppLovinICBR.addListener(this.zoneId, this.mLoadAdapterListener);
        }
        AppLovinInitManager.getInstance().initSDK(context, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                AppLovinInterstitialVideo.this.mAppLovinSdk = AppLovinInitManager.getInstance().getAppLovinSdk();
                if (!TextUtils.isEmpty((CharSequence)AppLovinInterstitialVideo.this.userId)) {
                    Log.i((String)AppLovinInterstitialVideo.TAG, (String)("RewardData: userId : " + AppLovinInterstitialVideo.this.userId));
                    AppLovinInterstitialVideo.this.mAppLovinSdk.setUserIdentifier(AppLovinInterstitialVideo.this.userId);
                }
                AppLovinInterstitialVideo.this.loadWithSdkInitialized();
            }

            public void onFailed(String code, String msg) {
            }
        });
    }

    protected void loadWithSdkInitialized() {
        if (TextUtils.isEmpty((CharSequence)this.payload)) {
            LogUtil.ownShow((String)"normal load");
            this.mAppLovinIncentivizedInterstitial = AppLovinIncentivizedInterstitial.create((String)this.zoneId, (AppLovinSdk)this.mAppLovinSdk);
            this.mAppLovinIncentivizedInterstitial.preload((AppLovinAdLoadListener)this);
        } else {
            LogUtil.ownShow((String)"bidding load");
            this.mAppLovinSdk.getAdService().loadNextAdForAdToken(this.payload, (AppLovinAdLoadListener)this);
        }
    }

    public void showAd() {
        Context context;
        if (this.mAppLovinICBR != null && this.zoneId != null && this.mShowListener != null) {
            this.mAppLovinICBR.addShowListener(this.zoneId, this.mShowListener);
        }
        if ((context = GlobalTradPlus.getInstance().getContext()) == null) {
            if (this.mShowListener != null) {
                TPError tpError = new TPError("Context == null");
                tpError.setErrorMessage("context == null");
                this.mShowListener.onAdVideoError(tpError);
            }
            return;
        }
        if (!this.mAppLovinIncentivizedInterstitial.isAdReadyToDisplay()) {
            if (this.zoneId != null && this.mAppLovinICBR.getShowListener(this.zoneId) != null) {
                TPError tpError = new TPError("Didn't find valid adv.Show Failed");
                tpError.setErrorMessage("is not Ad Ready To Display");
                this.mAppLovinICBR.getShowListener(this.zoneId).onAdVideoError(tpError);
            }
            return;
        }
        this.mAppLovinIncentivizedInterstitial.show(context, (AppLovinAdRewardListener)this, (AppLovinAdVideoPlaybackListener)this, (AppLovinAdDisplayListener)this, (AppLovinAdClickListener)this);
    }

    public boolean isReady() {
        if (this.mAppLovinIncentivizedInterstitial == null) {
            return false;
        }
        return this.mAppLovinIncentivizedInterstitial.isAdReadyToDisplay() && !this.isAdsTimeOut();
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("9");
    }

    public String getNetworkVersion() {
        return AppLovinSdk.VERSION;
    }

    public void clean() {
        super.clean();
        if (this.mAppLovinIncentivizedInterstitial != null) {
            this.mAppLovinIncentivizedInterstitial = null;
        }
        if (this.zoneId != null) {
            this.mAppLovinICBR.removeListeners(this.zoneId);
        }
    }

    public void adReceived(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)"adReceived:");
        if (this.mAppLovinICBR.getListener(this.zoneId) != null) {
            this.setNetworkObjectAd(appLovinAd);
            this.mAppLovinICBR.getListener(this.zoneId).loadAdapterLoaded(null);
        }
    }

    public void failedToReceiveAd(int errorCode) {
        Log.i((String)TAG, (String)("AppLovin rewarded ad failed to load with error code :" + errorCode));
        if (this.mAppLovinICBR.getListener(this.zoneId) != null) {
            this.mAppLovinICBR.getListener(this.zoneId).loadAdapterLoadFailed(AppLovinErrorUtil.getTradPlusErrorCode(errorCode));
        }
    }

    public void userOverQuota(AppLovinAd appLovinAd, Map map) {
        Log.i((String)TAG, (String)"userOverQuota: ");
    }

    public void userRewardRejected(AppLovinAd appLovinAd, Map map) {
        Log.i((String)TAG, (String)"userRewardRejected: ");
    }

    public void userRewardVerified(AppLovinAd appLovinAd, Map map) {
        Log.i((String)TAG, (String)"userRewardVerified: ");
    }

    public void validationRequestFailed(AppLovinAd appLovinAd, int errorCode) {
        Log.i((String)TAG, (String)"validationRequestFailed: ");
    }

    public void videoPlaybackBegan(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)"videoPlaybackBegan: ");
        if (this.mAppLovinICBR.getShowListener(this.zoneId) != null) {
            this.mAppLovinICBR.getShowListener(this.zoneId).onAdVideoStart();
        }
    }

    public void videoPlaybackEnded(AppLovinAd appLovinAd, double v, boolean b) {
        Log.i((String)TAG, (String)"videoPlaybackEnded:");
        this.hasGrantedReward = b;
        if (this.mAppLovinICBR.getShowListener(this.zoneId) != null) {
            this.mAppLovinICBR.getShowListener(this.zoneId).onAdVideoEnd();
        }
    }

    public void adDisplayed(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)"adDisplayed:");
        if (this.mAppLovinICBR.getShowListener(this.zoneId) != null) {
            this.mAppLovinICBR.getShowListener(this.zoneId).onAdShown();
        }
    }

    public void adHidden(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)"adHidden:");
        if (this.mAppLovinICBR.getShowListener(this.zoneId) != null) {
            if (this.hasGrantedReward || this.alwaysRewardUser) {
                this.mAppLovinICBR.getShowListener(this.zoneId).onReward();
            }
            this.mAppLovinICBR.getShowListener(this.zoneId).onAdClosed();
        }
    }

    public void adClicked(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)"adClicked:");
        if (this.mAppLovinICBR.getShowListener(this.zoneId) != null) {
            this.mAppLovinICBR.getShowListener(this.zoneId).onAdVideoClicked();
        }
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("placementId");
    }
}

