/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.core;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPLoadAdapterListener;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.LoadMode;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.config.ConfigLoadManager;
import com.tradplus.ads.base.filter.NetWorkFrequencyUtils;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.core.AdCacheManager;
import com.tradplus.ads.core.AdIntervalManager;
import com.tradplus.ads.core.AdMediationManager;
import com.tradplus.ads.core.HbTokenManager;
import com.tradplus.ads.core.cache.AdCache;
import com.tradplus.ads.core.factory.CustomEventFactory;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AdLoadManager {
    private static final int LOAD_STATUS_SUCCESS = 1;
    private static final int LOAD_STATUS_HAS_CACHE = 2;
    private static final int LOAD_STATUS_FAILED = 0;
    private static final int DEFAULT_INTERSTITIAL_TIMEOUT_DELAY = 60000;
    private ArrayList<ConfigResponse.WaterfallBean> mWaterfallBeans;
    private String mAdUnitId;
    private int mParallelNum;
    private int mMinCache;
    private int mCurrentNume;
    private volatile int currentIndex;
    private HashMap<ConfigResponse.WaterfallBean, Integer> mLoadFinishLayers;
    private ConcurrentHashMap<String, Runnable> mOverTimeMap;
    private Handler mThreadHandler;
    private int op;
    private LoadMode loadMode;
    private int[] cacheIndex;
    private boolean isloadAllNetwork;

    public AdLoadManager(String string, ArrayList<ConfigResponse.WaterfallBean> arrayList, int n, int n2, int n3, LoadMode loadMode) {
        AdLoadManager adLoadManager = this;
        this.mWaterfallBeans = arrayList;
        this.mParallelNum = n;
        this.mMinCache = n2;
        this.mAdUnitId = string;
        adLoadManager.mCurrentNume = n;
        adLoadManager.mThreadHandler = TPTaskManager.getInstance().getThresholdThreadHandler();
        adLoadManager.mOverTimeMap = new ConcurrentHashMap();
        adLoadManager.mLoadFinishLayers = new HashMap();
        this.op = n3;
        this.loadMode = loadMode;
    }

    private void loadLayerAd(int n, LoadLifecycleCallback loadLifecycleCallback) {
        d d2;
        if (n >= this.mWaterfallBeans.size()) {
            return;
        }
        AdLoadManager adLoadManager = this;
        ConfigResponse.WaterfallBean waterfallBean = adLoadManager.mWaterfallBeans.get(n);
        Object object = adLoadManager.cacheIndex;
        if (adLoadManager.cacheIndex != null && object[n] == 1) {
            AdLoadManager adLoadManager2 = this;
            int n2 = adLoadManager2.currentIndex;
            adLoadManager2.currentIndex = n2 + 1;
            adLoadManager2.loadLayerAd(n2, loadLifecycleCallback);
            return;
        }
        if (waterfallBean == null) {
            this.loadAdLoadFailed(null, null, loadLifecycleCallback, "9", null);
            return;
        }
        if (!NetWorkFrequencyUtils.getInstance().checkNetworkFrequency(waterfallBean)) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "4", null);
            return;
        }
        if (!NetWorkFrequencyUtils.getInstance().checkAdSourceFilter(waterfallBean)) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "4", null);
            return;
        }
        Object object2 = AdCacheManager.getInstance().isExistCache(this.mAdUnitId, waterfallBean);
        if (object2 != null) {
            this.currentLayerHasCache((AdCache)object2, waterfallBean, loadLifecycleCallback);
            return;
        }
        ConfigResponse.WaterfallBean waterfallBean2 = waterfallBean;
        object2 = waterfallBean2.getCustomClassName();
        object2 = waterfallBean2.getC2sAdapter() != null ? waterfallBean.getC2sAdapter() : CustomEventFactory.create((String)object2);
        if (object2 == null) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "13", null);
            return;
        }
        if (!HbTokenManager.checkPayLoadInfoExist(waterfallBean)) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "17", null);
            return;
        }
        AdIntervalManager adIntervalManager = AdIntervalManager.getInstance(waterfallBean);
        object = adIntervalManager;
        if (adIntervalManager != null && !((AdIntervalManager)object).canLoadToWaterfall()) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "1107", null);
            return;
        }
        object = d2;
        d2 = new d((TPBaseAdapter)object2, loadLifecycleCallback);
        int n3 = this.mWaterfallBeans.indexOf(waterfallBean);
        object2.setRequestId(loadLifecycleCallback.getRequestId());
        object2.initAdapter(this.mAdUnitId, waterfallBean, n3, (TPLoadAdapterListener)object);
        if (waterfallBean.getIs_main_thread() == 0) {
            this.loadAdapterOnThread((TPBaseAdapter)object2, loadLifecycleCallback, waterfallBean);
        } else {
            this.loadAdapterOnMainThread((TPBaseAdapter)object2, loadLifecycleCallback, waterfallBean);
        }
    }

    private void loadAdapterOnMainThread(final TPBaseAdapter tPBaseAdapter, final LoadLifecycleCallback loadLifecycleCallback, final ConfigResponse.WaterfallBean waterfallBean) {
        TPTaskManager.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                a a2 = a9;
                a a3 = a2;
                a a4 = a2;
                AdLoadManager adLoadManager = a2.AdLoadManager.this;
                a a5 = a9;
                a a6 = a5;
                a a7 = a5;
                TPBaseAdapter tPBaseAdapter2 = a5.tPBaseAdapter;
                LoadLifecycleCallback loadLifecycleCallback2 = a7.loadLifecycleCallback;
                ConfigResponse.WaterfallBean waterfallBean2 = a6.waterfallBean;
                try {
                    adLoadManager.startOverTimeRunnable(tPBaseAdapter2, loadLifecycleCallback2, waterfallBean2);
                    a4.loadLifecycleCallback.loadNetWorkStart(a9.tPBaseAdapter);
                    a3.tPBaseAdapter.loadAd();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    a a8 = a9;
                    a a9 = a8.waterfallBean;
                    tPBaseAdapter2 = a8.tPBaseAdapter;
                    loadLifecycleCallback2 = a8.loadLifecycleCallback;
                    a9.AdLoadManager.this.loadAdLoadFailed((ConfigResponse.WaterfallBean)a9, tPBaseAdapter2, loadLifecycleCallback2, "18", null);
                }
            }
        });
    }

    private void loadAdapterOnThread(final TPBaseAdapter tPBaseAdapter, final LoadLifecycleCallback loadLifecycleCallback, final ConfigResponse.WaterfallBean waterfallBean) {
        TPTaskManager.getInstance().runDyCorePool(new Runnable(){

            @Override
            public void run() {
                b b2 = b9;
                b b3 = b2;
                b b4 = b2;
                AdLoadManager adLoadManager = b2.AdLoadManager.this;
                b b5 = b9;
                b b6 = b5;
                b b7 = b5;
                TPBaseAdapter tPBaseAdapter2 = b5.tPBaseAdapter;
                LoadLifecycleCallback loadLifecycleCallback2 = b7.loadLifecycleCallback;
                ConfigResponse.WaterfallBean waterfallBean2 = b6.waterfallBean;
                try {
                    adLoadManager.startOverTimeRunnable(tPBaseAdapter2, loadLifecycleCallback2, waterfallBean2);
                    b4.loadLifecycleCallback.loadNetWorkStart(b9.tPBaseAdapter);
                    b3.tPBaseAdapter.loadAd();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    b b8 = b9;
                    b b9 = b8.waterfallBean;
                    tPBaseAdapter2 = b8.tPBaseAdapter;
                    loadLifecycleCallback2 = b8.loadLifecycleCallback;
                    b9.AdLoadManager.this.loadAdLoadFailed((ConfigResponse.WaterfallBean)b9, tPBaseAdapter2, loadLifecycleCallback2, "18", null);
                }
            }
        });
    }

    private void startOverTimeRunnable(final TPBaseAdapter tPBaseAdapter, final LoadLifecycleCallback loadLifecycleCallback, final ConfigResponse.WaterfallBean waterfallBean) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                AdIntervalManager adIntervalManager;
                c c2 = c4;
                c2.AdLoadManager.this.endOverTimeRunnable(c4.waterfallBean.getAdsource_placement_id());
                if (!c2.AdLoadManager.this.mLoadFinishLayers.containsKey(c4.tPBaseAdapter.getWaterfallBean()) && (adIntervalManager = AdIntervalManager.getInstance(c4.tPBaseAdapter.getWaterfallBean())) != null) {
                    adIntervalManager.loadWaterfallFailed();
                }
                AdLoadManager adLoadManager = c4.AdLoadManager.this;
                c c3 = c4;
                c c4 = c3.waterfallBean;
                adIntervalManager = c3.tPBaseAdapter;
                LoadLifecycleCallback loadLifecycleCallback2 = c3.loadLifecycleCallback;
                String string = adLoadManager.getErrorMessage();
                adLoadManager.loadAdLoadFailed((ConfigResponse.WaterfallBean)c4, (TPBaseAdapter)adIntervalManager, loadLifecycleCallback2, "3", string);
            }
        };
        long l = 60000L;
        if (waterfallBean.getLoadTimeout() > 0L && waterfallBean.getLoadTimeout() <= 300L) {
            l = waterfallBean.getLoadTimeout() * 1000L;
        }
        AdLoadManager adLoadManager = this;
        LogUtil.ownShow((String)("AdLoadManager startOverTimeRunnable timeout:" + l));
        adLoadManager.mThreadHandler.postDelayed(runnable2, l);
        adLoadManager.mOverTimeMap.put(waterfallBean.getAdsource_placement_id(), runnable2);
    }

    private String getErrorMessage() {
        if (!DeviceUtils.isNetworkAvailable((Context)GlobalTradPlus.getInstance().getContext())) {
            TPError tPError = new TPError();
            tPError.setErrorMessage("Network is unavailable.");
            tPError.setErrorCode("7");
            return tPError.getEmsg();
        }
        return null;
    }

    private void endOverTimeRunnable(String string) {
        Runnable runnable = this.mOverTimeMap.get(string);
        if (runnable != null) {
            this.mThreadHandler.removeCallbacks(runnable);
        }
        this.mOverTimeMap.remove(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    private synchronized void loadAdLoaded(TPBaseAd tPBaseAd, TPBaseAdapter tPBaseAdapter, LoadLifecycleCallback loadLifecycleCallback) {
        AdCache adCache;
        ConfigResponse.WaterfallBean waterfallBean = tPBaseAdapter.getWaterfallBean();
        if (this.mLoadFinishLayers.containsKey(waterfallBean)) {
            return;
        }
        this.mLoadFinishLayers.put(waterfallBean, 1);
        this.endOverTimeRunnable(tPBaseAdapter.getAdSourcePid());
        this.saveHighPrice(waterfallBean);
        Object object = AdIntervalManager.getInstance(waterfallBean);
        if (object != null) {
            ((AdIntervalManager)object).loadWaterfallLoaded();
        }
        if (AdMediationManager.isReload(this.op) && (object = ConfigLoadManager.getInstance().getLocalConfigResponse(this.mAdUnitId)) != null && AdCacheManager.getInstance().getReadyAdNum(this.mAdUnitId) > object.getMinCache()) {
            AdCacheManager.getInstance().removeEndCache(this.mAdUnitId, 1);
        }
        object = adCache;
        ((AdCache)object)();
        ((AdCache)object).setAdapter(tPBaseAdapter);
        ((AdCache)object).setAdObj(tPBaseAd);
        ((AdCache)object).setCallback(loadLifecycleCallback);
        adCache.setConfigBean(waterfallBean);
        adCache.setStatus(0);
        AdCacheManager.getInstance().saveWaterfallCache(this.mAdUnitId, (AdCache)object, this.mWaterfallBeans.indexOf(waterfallBean));
        loadLifecycleCallback.loadNetWorkEnd((AdCache)object, tPBaseAdapter.getWaterfallBean(), tPBaseAdapter, "1", null);
        if (!TextUtils.isEmpty((CharSequence)tPBaseAdapter.getPayLoadStr()) || waterfallBean.getC2sAdapter() != null) {
            HbTokenManager.sendWinOrDisplayNotification(true, tPBaseAdapter, loadLifecycleCallback);
        }
        AdLoadManager adLoadManager = this;
        int n = AdCacheManager.getInstance().getReadyAdNum(this.mAdUnitId);
        int n2 = adLoadManager.getLoadSuccessNum();
        int n3 = (adLoadManager.loadMode == LoadMode.SPEED ? n == this.mMinCache : n2 == this.mCurrentNume) ? 1 : 0;
        if (n3 != 0 || this.mLoadFinishLayers.size() == this.mWaterfallBeans.size()) {
            this.loadAllNetwork(loadLifecycleCallback, n2);
        }
        LogUtil.ownShow((String)("AdLoadManager loadAdLoaded tempHasCache:" + n + ", ParallelNum:" + this.mParallelNum + ", MinCache:" + this.mMinCache));
        n2 = this.mParallelNum;
        n3 = this.mMinCache;
        if (n2 < n3 && n + (n2 - 1) < n3) {
            AdLoadManager adLoadManager2 = this;
            int n4 = adLoadManager2.currentIndex;
            adLoadManager2.currentIndex = n4 + 1;
            adLoadManager2.loadLayerAd(n4, loadLifecycleCallback);
        }
    }

    private synchronized void loadAllNetwork(LoadLifecycleCallback loadLifecycleCallback, int n) {
        if (!this.isloadAllNetwork) {
            AdLoadManager adLoadManager = this;
            boolean bl = AdMediationManager.isReload(adLoadManager.op);
            int n2 = adLoadManager.op;
            loadLifecycleCallback.loadAllNetwork("1", bl, n2, n);
            AdLoadManager adLoadManager2 = this;
            int n3 = adLoadManager2.currentIndex;
            HbTokenManager.removeUnLoadBiddingPayload(this.mAdUnitId, n3, adLoadManager2.mWaterfallBeans, loadLifecycleCallback);
            this.isloadAllNetwork = true;
        }
    }

    private int getLoadSuccessNum() {
        int n = 0;
        Iterator<Map.Entry<ConfigResponse.WaterfallBean, Integer>> iterator = this.mLoadFinishLayers.entrySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getValue() != 1) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void loadAdLoadFailed(ConfigResponse.WaterfallBean waterfallBean, TPBaseAdapter object, LoadLifecycleCallback loadLifecycleCallback, String object22, String string) {
        void var5_16;
        if (waterfallBean == null) {
            this.mLoadFinishLayers.put(new ConfigResponse.WaterfallBean(), 0);
        } else {
            if (this.mLoadFinishLayers.containsKey(waterfallBean)) {
                return;
            }
            this.mLoadFinishLayers.put(waterfallBean, 0);
            this.endOverTimeRunnable(waterfallBean.getAdsource_placement_id());
            if (waterfallBean.getPayLoadInfo() != null && waterfallBean.getC2sAdapter() == null && TextUtils.equals((CharSequence)"2", (CharSequence)object22)) {
                HbTokenManager.sendLosNotification("1", waterfallBean, loadLifecycleCallback);
                waterfallBean.setPayLoadInfo(null);
            }
        }
        loadLifecycleCallback.loadNetWorkEnd(null, waterfallBean, (TPBaseAdapter)object, (String)object22, (String)var5_16);
        if (this.mLoadFinishLayers.size() == this.mWaterfallBeans.size()) {
            void var4_14;
            for (Map.Entry entry : this.mLoadFinishLayers.entrySet()) {
                if ((Integer)entry.getValue() != 1 && (Integer)entry.getValue() != 2) continue;
                AdLoadManager adLoadManager = this;
                adLoadManager.loadAllNetwork(loadLifecycleCallback, adLoadManager.getLoadSuccessNum());
                return;
            }
            object = AdCacheManager.getInstance().getBottomCacheAd(this.mAdUnitId);
            String string2 = "11";
            if (object != null) {
                if (((AdCache)object).isBottomWaterfall()) {
                    ((AdCache)object).setEffectTime(0L);
                    loadLifecycleCallback.loadAdLoaded((AdCache)object);
                }
                String string3 = "1";
            }
            if (waterfallBean != null && (waterfallBean = waterfallBean.getPayLoadInfo()) != null && waterfallBean.getIs_exclusive() == 1) {
                String string4 = "105";
            }
            AdLoadManager adLoadManager = this;
            LogUtil.ownShow((String)"AdLoadManager loadAdLoadFailed loadAllNetwork:");
            boolean bl = AdMediationManager.isReload(adLoadManager.op);
            int n = adLoadManager.op;
            int n2 = adLoadManager.getLoadSuccessNum();
            loadLifecycleCallback.loadAllNetwork((String)var4_14, bl, n, n2);
            HbTokenManager.removeUnLoadBiddingPayload(this.mAdUnitId, 0, this.mWaterfallBeans, loadLifecycleCallback);
            return;
        }
        if (this.currentIndex >= this.mWaterfallBeans.size()) {
            return;
        }
        AdLoadManager adLoadManager = this;
        int n = adLoadManager.currentIndex;
        adLoadManager.currentIndex = n + 1;
        adLoadManager.loadLayerAd(n, loadLifecycleCallback);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean currentCache(AdCache adCache, ConfigResponse.WaterfallBean waterfallBean, LoadLifecycleCallback loadLifecycleCallback) {
        AdLoadManager adLoadManager = this;
        AdLoadManager adLoadManager2 = this;
        AdCacheManager.getInstance().sortWaterfallCacheById(this.mAdUnitId, waterfallBean, this.mWaterfallBeans.indexOf(waterfallBean));
        loadLifecycleCallback.currentLayerHasCache(adCache);
        adLoadManager2.mLoadFinishLayers.put(waterfallBean, 2);
        int n = adLoadManager2.getLoadSuccessNum();
        int n2 = AdCacheManager.getInstance().getReadyAdNum(this.mAdUnitId);
        adLoadManager.saveHighPrice(waterfallBean);
        LogUtil.ownShow((String)("AdLoadManager currentCache = " + n + ", mMinCache :" + this.mMinCache));
        n2 = (adLoadManager.loadMode == LoadMode.SPEED ? n2 == this.mMinCache : n == this.mCurrentNume) ? 1 : 0;
        if (n2 == 0 && this.mLoadFinishLayers.size() != this.mWaterfallBeans.size() && !AdMediationManager.isReload(this.op)) {
            return this.currentIndex < this.mWaterfallBeans.size();
        }
        this.loadAllNetwork(loadLifecycleCallback, n);
        return false;
    }

    private void currentLayerHasCache(AdCache adCache, ConfigResponse.WaterfallBean waterfallBean, LoadLifecycleCallback loadLifecycleCallback) {
        if (this.currentCache(adCache, waterfallBean, loadLifecycleCallback)) {
            AdLoadManager adLoadManager = this;
            int n = adLoadManager.currentIndex;
            adLoadManager.currentIndex = n + 1;
            adLoadManager.loadLayerAd(n, loadLifecycleCallback);
        }
    }

    private int isFindWaterfall(ArrayList<ConfigResponse.WaterfallBean> arrayList, ConfigResponse.WaterfallBean waterfallBean) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!TextUtils.equals((CharSequence)arrayList.get(i).getAdsource_placement_id(), (CharSequence)waterfallBean.getAdsource_placement_id())) continue;
            return i;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private void saveHighPrice(ConfigResponse.WaterfallBean var1_1) {
        block30: {
            block32: {
                block31: {
                    block27: {
                        block26: {
                            v0 = var1_1;
                            var2_2 = this.mWaterfallBeans.indexOf(var1_1);
                            var3_4 = v0.getPayLoadInfo();
                            var4_5 = null;
                            var5_6 = 0.0f;
                            if (var3_4 != null) break block26;
                            v1 = var1_1;
                            v2 = v1;
                            var4_5 = String.valueOf(v1.getEcpm());
                            var5_6 = (float)v2.getEcpm_cny();
                            break block27;
                        }
                        if (var3_4.getExt() == null) break block27;
                        v3 = var3_4;
                        v4 = v3;
                        var4_5 = String.valueOf(v3.getExt().getValue());
                        var5_6 = v4.getPrice_cny();
                    }
                    Log.i((String)"BiddingPayload", (String)("saveHighPrice beanPriceCny: " + var5_6));
                    while (true) {
                        block29: {
                            block28: {
                                if (var2_2 >= this.mWaterfallBeans.size() - 1) break;
                                ++var2_2;
                                var6_7 = this.mWaterfallBeans.get(var2_2).getPayLoadInfo();
                                if (var6_7 == null) continue;
                                var7_8 = var6_7.getHighPrice();
                                if (var7_8 == null) break block28;
                                if (var7_8.length() <= 0) break block28;
                                if (!var7_8.equals("0")) break block29;
                            }
                            var6_7.setHighPrice(var4_5);
                            var6_7.setHighaspid(var1_1.getAdsource_placement_id());
                        }
                        if (var5_6 == 0.0f) continue;
                        var6_7.setPrice_cny(var5_6);
                        continue;
                        break;
                    }
                    if (var3_4 == null) {
                        return;
                    }
                    ++var2_2;
                    var4_5 = null;
                    if (var2_2 >= this.mWaterfallBeans.size()) break block30;
                    this = this.mWaterfallBeans.get(var2_2);
                    if (this != null) break block31;
                    return;
                }
                var2_3 = this.getPayLoadInfo();
                if (var2_3 == null) break block32;
                if (var2_3.getExt() == null) break block32;
                v5 = String.valueOf(var2_3.getExt().getValue());
lbl70:
                // 2 sources

                while (true) {
                    var4_5 = v5;
                    ** GOTO lbl78
                    break;
                }
            }
            if (var2_3 != null) ** GOTO lbl78
            v5 = String.valueOf(var1_1.getEcpm());
            ** continue;
lbl78:
            // 2 sources

            var3_4.setSecondPrice(var4_5);
            var3_4.setSecondAspid(this.getAdsource_placement_id());
        }
        try {
            Log.i((String)"SecondPrice", (String)("secondBeanPrice: " + var4_5));
        }
        catch (Exception v6) {}
    }

    public void loadWaterfall(LoadLifecycleCallback loadLifecycleCallback) {
        int n;
        this.currentIndex = 0;
        this.mLoadFinishLayers.clear();
        this.checkCacheIndex(loadLifecycleCallback);
        int n2 = AdCacheManager.getInstance().getReadyAdNum(this.mAdUnitId);
        if (n2 > 0) {
            n = this.mParallelNum;
            int n3 = this.mMinCache;
            this.mCurrentNume = n >= n3 ? n3 - n2 : Math.min(n, n3 - n2);
        }
        if (this.mCurrentNume > this.mWaterfallBeans.size()) {
            this.mCurrentNume = this.mWaterfallBeans.size();
        }
        LogUtil.ownShow((String)("AdLoadManager \u8be5\u8f6e\u5e76\u884c\u6570currentNume = " + this.mCurrentNume + ", \u5df2\u7f13\u5b58readyAdNum:" + n2 + " ,ParallelNum:" + this.mParallelNum + " ,\u6700\u5c0f\u7f13\u5b58\u6570MinCache :" + this.mMinCache));
        for (n2 = 0; n2 < this.mCurrentNume; ++n2) {
            AdLoadManager adLoadManager = this;
            n = adLoadManager.currentIndex;
            adLoadManager.currentIndex = n + 1;
            adLoadManager.loadLayerAd(n, loadLifecycleCallback);
        }
    }

    public void checkCacheIndex(LoadLifecycleCallback loadLifecycleCallback) {
        if (this.loadMode != LoadMode.SPEED) {
            return;
        }
        for (int i = 0; i < this.mWaterfallBeans.size(); ++i) {
            ConfigResponse.WaterfallBean waterfallBean = this.mWaterfallBeans.get(i);
            AdCache adCache = AdCacheManager.getInstance().isExistCache(this.mAdUnitId, waterfallBean);
            if (adCache == null) continue;
            if (this.cacheIndex == null) {
                this.cacheIndex = new int[this.mWaterfallBeans.size()];
            }
            AdLoadManager adLoadManager = this;
            adLoadManager.currentCache(adCache, waterfallBean, loadLifecycleCallback);
            adLoadManager.cacheIndex[i] = 1;
        }
    }

    public class d
    implements TPLoadAdapterListener {
        public TPBaseAdapter a;
        public LoadLifecycleCallback b;

        public d(TPBaseAdapter tPBaseAdapter, LoadLifecycleCallback loadLifecycleCallback) {
            this.a = tPBaseAdapter;
            this.b = loadLifecycleCallback;
        }

        public void loadAdapterLoaded(final TPBaseAd tPBaseAd) {
            TPTaskManager.getInstance().getLoadThreadHandler().post(new Runnable(){

                @Override
                public void run() {
                    d d2;
                    d d3 = a2.d.this;
                    d d4 = d2 = d3;
                    a a2 = a2.tPBaseAd;
                    d2 = d4.a;
                    LoadLifecycleCallback loadLifecycleCallback = d4.b;
                    d3.AdLoadManager.this.loadAdLoaded((TPBaseAd)a2, (TPBaseAdapter)d2, loadLifecycleCallback);
                }
            });
        }

        public void loadAdapterLoadFailed(final TPError tPError) {
            TPTaskManager.getInstance().getLoadThreadHandler().post(new Runnable(){

                @Override
                public void run() {
                    Object object;
                    if (!b3.AdLoadManager.this.mLoadFinishLayers.containsKey(b3.d.this.a.getWaterfallBean()) && (object = AdIntervalManager.getInstance(b3.d.this.a.getWaterfallBean())) != null) {
                        ((AdIntervalManager)object).loadWaterfallFailed();
                    }
                    d d2 = b3.d.this;
                    object = d2;
                    object = ((d)object).a.getWaterfallBean();
                    Object object2 = b3.d.this;
                    Object object3 = object;
                    b b2 = b3;
                    d d3 = object2;
                    b b3 = d3.a;
                    object = d3.b;
                    object2 = b2.tPError.getTpErrorCode();
                    String string = b2.tPError.getEmsg();
                    d2.AdLoadManager.this.loadAdLoadFailed((ConfigResponse.WaterfallBean)object3, (TPBaseAdapter)b3, (LoadLifecycleCallback)object, (String)object2, string);
                }
            });
        }
    }
}

