/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.core;

import android.content.Context;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.common.IntervalLock;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.common.ValidBoolean;
import com.tradplus.ads.base.config.ConfigLoadManager;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.FrequencyUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.core.AdCacheManager;
import com.tradplus.ads.core.AdLoadManager;
import com.tradplus.ads.core.HbTokenManager;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import com.tradplus.ads.mobileads.util.TradPlusDataConstants;
import com.tradplus.ads.network.response.ConfigResponse;
import com.tradplus.ads.volley.VolleyError;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

public class AdMediationManager {
    private final long LOAD_FAIL_TIME_INTERVAL = 10000L;
    private final long LOAD_SUCCESS_BUT_NOT_SHOW_VALID = 240000L;
    private static ConcurrentHashMap<String, AdMediationManager> adMediationManagerMap = new ConcurrentHashMap();
    private String mAdUnitId;
    private boolean isLoading = false;
    private ValidBoolean loadSuccess;
    private IntervalLock intervalLock;

    private AdMediationManager(String string) {
        this.mAdUnitId = string;
        this.intervalLock = new IntervalLock(10000L);
        this.loadSuccess = new ValidBoolean(240000L);
    }

    public static synchronized AdMediationManager getInstance(String string) {
        AdMediationManager adMediationManager = adMediationManagerMap.get(string);
        if (adMediationManager == null) {
            adMediationManager = new AdMediationManager(string);
            adMediationManagerMap.put(string, adMediationManager);
        }
        return adMediationManager;
    }

    public void loadAd(final LoadLifecycleCallback loadLifecycleCallback) {
        ConfigLoadManager.getInstance().loadConfig(this.mAdUnitId, new ConfigLoadManager.ConfigLoadListener(){

            public final void onSuccess(ConfigResponse configResponse) {
                if (configResponse == null) {
                    loadLifecycleCallback.loadEndNoConfig();
                    return;
                }
                AdMediationManager.this.changeThreadAndLoadAd(configResponse, loadLifecycleCallback);
            }

            public final void onFailed(VolleyError volleyError) {
                loadLifecycleCallback.loadEndNoConfig();
            }
        });
    }

    private void changeThreadAndLoadAd(final ConfigResponse configResponse, final LoadLifecycleCallback loadLifecycleCallback) {
        TPTaskManager.getInstance().runOnThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                AdMediationManager adMediationManager = AdMediationManager.this;
                synchronized (adMediationManager) {
                    loadLifecycleCallback.loadStart();
                    AdMediationManager.this.checkAndLoadAd(configResponse, loadLifecycleCallback);
                    return;
                }
            }
        });
    }

    private void checkAndLoadAd(ConfigResponse configResponse, final LoadLifecycleCallback loadLifecycleCallback) {
        final int n = configResponse.getCacheNum();
        int n2 = 0;
        int n3 = 0;
        ArrayList arrayList = configResponse.getWaterfall();
        if (arrayList != null) {
            n2 = arrayList.size();
        }
        if ((arrayList = configResponse.getBiddingwaterfall()) != null) {
            n3 = arrayList.size();
        }
        if (n <= 0 || n2 <= 0 && n3 <= 0) {
            loadLifecycleCallback.loadEnd("9");
            return;
        }
        if (this.checkFilter()) {
            loadLifecycleCallback.loadEnd("4");
            return;
        }
        if (this.checkCacheFill(Math.min(n, n2 + n3))) {
            loadLifecycleCallback.loadEnd("8");
            return;
        }
        if (this.checkHadCache()) {
            loadLifecycleCallback.loadEnd("19");
            return;
        }
        if (this.checkNetwork()) {
            loadLifecycleCallback.loadEnd("7");
            return;
        }
        this.intervalLock.setExpireSecond(configResponse.getLoadFailedInterval());
        if (this.intervalLock.isLocked()) {
            loadLifecycleCallback.loadEnd("15");
            return;
        }
        GlobalTradPlus.getInstance().setConfigParam(this.mAdUnitId, configResponse);
        HbTokenManager.getInstance(this.mAdUnitId).startBidding(configResponse, loadLifecycleCallback, new HbTokenManager.a(){

            @Override
            public final void a(ArrayList<ConfigResponse.WaterfallBean> arrayList) {
                if (arrayList == null || arrayList.size() <= 0) {
                    loadLifecycleCallback.loadEnd("9");
                    return;
                }
                new AdLoadManager(AdMediationManager.this.mAdUnitId, arrayList, n).loadWaterfall(loadLifecycleCallback);
            }
        });
    }

    private boolean checkFilter() {
        Context context = GlobalTradPlus.getInstance().getContext();
        return !FrequencyUtils.getInstance().needFrequencyShow(context, this.mAdUnitId, TradPlusDataConstants.CACHETRADPLUSTYPE);
    }

    private boolean checkNetwork() {
        return !DeviceUtils.isNetworkAvailable((Context)GlobalTradPlus.getInstance().getContext());
    }

    private boolean checkCacheFill(int n) {
        int n2 = AdCacheManager.getInstance().getReadyAdNum(this.mAdUnitId);
        LogUtil.ownShow((String)("AdMediationManager checkCacheFill hasCache:" + n2 + " needCache:" + n));
        return n2 >= n;
    }

    private boolean checkHadCache() {
        int n = AdCacheManager.getInstance().getReadyAdNum(this.mAdUnitId);
        LogUtil.ownShow((String)("AdMediationManager checkHadCache hasCache:" + n + " loadSuccessButNotShow:" + this.checkHasLoadSuccess()));
        return n > 0 && this.checkHasLoadSuccess();
    }

    public boolean checkIsLoading() {
        return this.isLoading;
    }

    public synchronized void setLoading(boolean bl) {
        this.isLoading = bl;
    }

    public boolean checkHasLoadSuccess() {
        return this.loadSuccess.checkResult();
    }

    public synchronized void setLoadSuccess(boolean bl) {
        this.loadSuccess.setResult(bl);
    }

    public synchronized void setAllLoadFail() {
        this.intervalLock.tryLock();
    }
}

