/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.core.track;

import android.content.Context;
import android.text.TextUtils;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.common.Util;
import com.tradplus.ads.base.config.response.BiddingResponse;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.core.AdCacheManager;
import com.tradplus.ads.core.HbTokenManager;
import com.tradplus.ads.core.cache.AdCache;
import com.tradplus.ads.core.track.LoadAdListener;
import com.tradplus.ads.network.response.ConfigResponse;
import com.tradplus.ads.pushcenter.PushCenter;
import com.tradplus.ads.pushcenter.event.request.EventBiddingNotification;
import com.tradplus.ads.pushcenter.reqeust.AdconfRequest;
import com.tradplus.ads.pushcenter.reqeust.BiddingEndRequest;
import com.tradplus.ads.pushcenter.reqeust.BiddingStartRequest;
import com.tradplus.ads.pushcenter.reqeust.ClickRequest;
import com.tradplus.ads.pushcenter.reqeust.LoadFirstNetworkAd;
import com.tradplus.ads.pushcenter.reqeust.LoadNetworkRequest;
import com.tradplus.ads.pushcenter.reqeust.LoadRequest;
import com.tradplus.ads.pushcenter.reqeust.ReadyRequest;
import com.tradplus.ads.pushcenter.reqeust.RewardRequest;
import com.tradplus.ads.pushcenter.reqeust.ShowRequest;
import com.tradplus.ads.pushcenter.reqeust.ShowStartRequest;
import com.tradplus.ads.pushcenter.reqeust.VideoCloseRequest;
import com.tradplus.ads.pushcenter.reqeust.VideoRequest;
import com.tradplus.ads.pushcenter.utils.PushMessageUtils;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.ads.pushcenter.utils.SendMessageUtil;
import java.util.Map;
import java.util.UUID;

public class LoadLifecycleCallback {
    private String requestId = UUID.randomUUID().toString();
    private String mAdUnitId;
    private LoadAdListener mLoadListener;
    private long startLoadAdTime = 0L;
    private String allLoadUUID = null;

    public LoadLifecycleCallback(String string, LoadAdListener loadAdListener) {
        this.mLoadListener = loadAdListener;
        this.mAdUnitId = string;
    }

    public void refreshListener(LoadAdListener loadAdListener) {
        this.mLoadListener = loadAdListener;
    }

    public void loadStart() {
        SendMessageUtil.getInstance().sendLoadAdStart(GlobalTradPlus.getInstance().getContext(), this.mAdUnitId, this.requestId);
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_START, this.mAdUnitId);
        this.startLoadAdTime = System.currentTimeMillis();
    }

    public void loadEndNoConfig() {
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdLoadFailed("12");
        }
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_FAILED_CONFIG, this.mAdUnitId);
    }

    public void loadEnd(String string) {
        Object object;
        if (this.mLoadListener != null) {
            if ("19".equals(string) || "8".equals(string)) {
                object = AdCacheManager.getInstance().getReadyAd(this.mAdUnitId);
                this.mLoadListener.onAdLoaded((AdCache)object);
                this.mLoadListener.onAdAllLoaded(true);
            } else if (!"1".equals(string)) {
                this.mLoadListener.onAdLoadFailed(string);
            }
        }
        object = GlobalTradPlus.getInstance().getContext();
        LoadRequest loadRequest = new LoadRequest(object, PushMessageUtils.PushStatus.EV_LOAD_AD.getValue());
        loadRequest.setLuid(this.mAdUnitId);
        loadRequest.setRequestId(this.requestId);
        loadRequest.setEc(string);
        PushCenter.getInstance().sendMessageToCenter(object, (Object)loadRequest, PushMessageUtils.Type.EV_TRADPLUS.getValue());
        if (TextUtils.equals((CharSequence)"7", (CharSequence)string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOADADFAILEDNOCONNECTION, this.mAdUnitId);
            return;
        }
        if (TextUtils.equals((CharSequence)"19", (CharSequence)string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_FAILED_HASCACHE, this.mAdUnitId);
            return;
        }
        if (TextUtils.equals((CharSequence)"4", (CharSequence)string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_FAILED_FREQUENCYLIMIT, this.mAdUnitId);
            return;
        }
        if (TextUtils.equals((CharSequence)"9", (CharSequence)string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_FAILED_NOTHING, this.mAdUnitId);
            return;
        }
        if (TextUtils.equals((CharSequence)"15", (CharSequence)string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOADADFAILEDINTERVAL, this.mAdUnitId);
            return;
        }
        if (TextUtils.equals((CharSequence)"12", (CharSequence)string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_FAILED_CONFIG, this.mAdUnitId);
        }
    }

    public void startBiddingEvent(ConfigResponse.WaterfallBean waterfallBean) {
        Context context = GlobalTradPlus.getInstance().getContext();
        String string = "";
        String string2 = "";
        String string3 = "";
        if (waterfallBean != null) {
            string3 = waterfallBean.getId();
            string2 = waterfallBean.getAdsource_placement_id();
            if ((waterfallBean = waterfallBean.getConfig()) != null) {
                string = waterfallBean.getPlacementId();
            }
        }
        waterfallBean = new BiddingStartRequest(context, PushMessageUtils.PushStatus.BIDDING_LOAD_START_AD.getValue());
        waterfallBean.setAsu(string);
        waterfallBean.setLuid(this.mAdUnitId);
        waterfallBean.setBi(string2);
        waterfallBean.setAdsource(string2);
        waterfallBean.setPID(string);
        waterfallBean.setRequestId(this.requestId);
        waterfallBean.setAs(string3);
        PushCenter.getInstance().sendMessageToCenter(context, (Object)waterfallBean, PushMessageUtils.Type.EV_TRADPLUS.getValue());
    }

    public void endBiddingEvent(ConfigResponse.WaterfallBean waterfallBean, BiddingResponse.PayLoadInfo object, long l) {
        Context context = GlobalTradPlus.getInstance().getContext();
        String string = "";
        String string2 = "";
        String string3 = "";
        if (waterfallBean != null) {
            string3 = waterfallBean.getId();
            string2 = waterfallBean.getAdsource_placement_id();
            if ((waterfallBean = waterfallBean.getConfig()) != null) {
                string = waterfallBean.getPlacementId();
            }
        }
        int n = object != null ? object.getNbr() : 0;
        object = object != null && object.getIsbid() == 1 ? "1" : "3";
        BiddingEndRequest biddingEndRequest = new BiddingEndRequest(context, PushMessageUtils.PushStatus.BIDDING_LOAD_AD.getValue());
        biddingEndRequest.setBt("" + RequestUtils.getInstance().countRuntime(l));
        biddingEndRequest.setRt("" + RequestUtils.getInstance().countRuntime(l));
        biddingEndRequest.setLuid(this.mAdUnitId);
        biddingEndRequest.setBi(string2);
        biddingEndRequest.setAsu(string);
        biddingEndRequest.setAdsource(string2);
        biddingEndRequest.setPID(string);
        biddingEndRequest.setRequestId(this.requestId);
        biddingEndRequest.setNbr(String.valueOf(n));
        biddingEndRequest.setAs(string3);
        biddingEndRequest.setEc((String)object);
        PushCenter.getInstance().sendMessageToCenter(context, (Object)biddingEndRequest, PushMessageUtils.Type.EV_TRADPLUS.getValue());
    }

    public void sendLossNotification(ConfigResponse.WaterfallBean waterfallBean, String string, String string2) {
        Context context = GlobalTradPlus.getInstance().getContext();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (waterfallBean != null) {
            string5 = waterfallBean.getId();
            string4 = waterfallBean.getAdsource_placement_id();
            if ((waterfallBean = waterfallBean.getConfig()) != null) {
                string3 = waterfallBean.getPlacementId();
            }
        }
        waterfallBean = new EventBiddingNotification(context, PushMessageUtils.PushStatus.BIDDING_LOSS_AD.getValue());
        waterfallBean.setLuid(this.mAdUnitId);
        waterfallBean.setLc(string2);
        waterfallBean.setAdsource(string4);
        waterfallBean.setApid(string4);
        waterfallBean.setPID(string3);
        waterfallBean.setEc(string);
        waterfallBean.setAs(string5);
        waterfallBean.setRequestid(this.requestId);
        waterfallBean.setAsu(string3);
        waterfallBean.setEc(string);
        PushCenter.getInstance().sendMessageToCenter(context, (Object)waterfallBean, PushMessageUtils.Type.EV_TRADPLUS.getValue());
    }

    public void loadNetWorkStart(ConfigResponse.WaterfallBean waterfallBean, TPBaseAdapter tPBaseAdapter) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onLoadBefor(this, tPBaseAdapter);
        }
        Context context = GlobalTradPlus.getInstance().getContext();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (waterfallBean != null) {
            string = waterfallBean.getId();
            string2 = waterfallBean.getName();
            string4 = waterfallBean.getAdsource_placement_id();
            if ((waterfallBean = waterfallBean.getConfig()) != null) {
                string3 = waterfallBean.getPlacementId();
            }
        }
        waterfallBean = new VideoRequest(context, PushMessageUtils.PushStatus.EV_LOAD_NETWORK_AD_START.getValue());
        waterfallBean.setLuid(this.mAdUnitId);
        waterfallBean.setAs(string);
        waterfallBean.setPID(string3);
        waterfallBean.setAdsource(string4);
        waterfallBean.setRequestId(this.requestId);
        waterfallBean.setAsu(string3);
        waterfallBean.setApid(Util.parseToInteger((String)string4));
        PushCenter.getInstance().sendMessageToCenter(context, (Object)waterfallBean, PushMessageUtils.Type.EV_TRADPLUS.getValue());
        CustomLogUtils.getInstance().log(string2 + " ", CustomLogUtils.TradPlusLog.LOAD_LOADING_ADS);
        if (tPBaseAdapter != null) {
            tPBaseAdapter.setLoadStartTime();
        }
    }

    public void loadNetWorkEnd(AdCache adCache, ConfigResponse.WaterfallBean waterfallBean, TPBaseAdapter tPBaseAdapter, String string, String string2) {
        Context context = GlobalTradPlus.getInstance().getContext();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        if (waterfallBean != null) {
            string3 = waterfallBean.getId();
            string5 = waterfallBean.getName();
            string4 = waterfallBean.getCustomClassName();
            string7 = waterfallBean.getAdsource_placement_id();
            if ((waterfallBean = waterfallBean.getConfig()) != null) {
                string6 = waterfallBean.getPlacementId();
            }
        }
        if (tPBaseAdapter != null) {
            tPBaseAdapter.setLoadEndTime();
        }
        if (tPBaseAdapter == null || tPBaseAdapter.getLoadStartTime() <= 0L) {
            waterfallBean = new VideoRequest(context, PushMessageUtils.PushStatus.EV_LOAD_NETWORK_AD_START.getValue());
            waterfallBean.setLuid(this.mAdUnitId);
            waterfallBean.setAs(string3);
            waterfallBean.setPID(string6);
            waterfallBean.setAdsource(string7);
            waterfallBean.setAsu(string6);
            waterfallBean.setApid(Util.parseToInteger((String)string7));
            waterfallBean.setRequestId(this.requestId);
            PushCenter.getInstance().sendMessageToCenter(context, (Object)waterfallBean, PushMessageUtils.Type.EV_TRADPLUS.getValue());
        }
        waterfallBean = new LoadNetworkRequest(context, PushMessageUtils.PushStatus.EV_LOAD_NETWORK_AD.getValue());
        waterfallBean.setCreateTime(tPBaseAdapter == null ? 0L : tPBaseAdapter.getLoadStartTime());
        waterfallBean.setLuid(this.mAdUnitId);
        waterfallBean.setAdsource(string7);
        waterfallBean.setAs(string3);
        waterfallBean.setPID(string6);
        waterfallBean.setLt("" + RequestUtils.getInstance().countRuntime(waterfallBean.getCreateTime()));
        waterfallBean.setRequestId(this.requestId);
        waterfallBean.setEc(string);
        waterfallBean.setFill(adCache != null ? "2" : "1");
        waterfallBean.setEmsg(string2);
        waterfallBean.setAsu(string6);
        waterfallBean.setApid(Util.parseToInteger((String)string7));
        PushCenter.getInstance().sendMessageToCenter(context, (Object)waterfallBean, PushMessageUtils.Type.EV_TRADPLUS.getValue());
        if ("1".equals(string) && this.mLoadListener != null && adCache != null) {
            this.loadFirstAdLoaded(string6, string3, string7);
            this.mLoadListener.onAdLoaded(adCache);
            this.mLoadListener.oneLayerLoaded(adCache);
        }
        if (!"1".equals(string) && this.mLoadListener != null) {
            this.mLoadListener.oneLayerLoadFailed(string, tPBaseAdapter, string2);
        }
        if ("1".equals(string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_NETWORK_SUCCESS, string5 + "  " + this.mAdUnitId);
            return;
        }
        if ("9".equals(string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_FAILED_NOTHING, this.mAdUnitId);
            return;
        }
        if ("13".equals(string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.NOTFOUNT_ADAPTER, string4);
            return;
        }
        if ("18".equals(string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_ADAPTER_EXCEPTION, "exception");
            return;
        }
        if ("3".equals(string)) {
            CustomLogUtils.getInstance().log(string4, CustomLogUtils.TradPlusLog.LOAD_TIMEOUT);
            return;
        }
        if ("2".equals(string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.ADAPTER_INTERNAL_ERROR, string4 + " " + string2);
            return;
        }
        if ("12".equals(string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_FAILED_CONFIG, this.mAdUnitId);
            return;
        }
        if ("17".equals(string)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.ADAPTER_CONFIG_ERROR, string4);
            return;
        }
        LogUtil.ownShow((String)string);
    }

    public void currentLayerHasCache(AdCache adCache) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdLoaded(adCache);
            this.mLoadListener.oneLayerLoaded(adCache);
        }
    }

    public void loadFirstAdLoaded(String string, String string2, String string3) {
        if (GlobalTradPlus.getInstance().getAdUnitFirstLoadTrace(this.mAdUnitId)) {
            return;
        }
        Context context = GlobalTradPlus.getInstance().getContext();
        LoadFirstNetworkAd loadFirstNetworkAd = new LoadFirstNetworkAd(context, PushMessageUtils.PushStatus.EV_LOAD_FIRST_NETWORK_AD.getValue());
        loadFirstNetworkAd.setCreateTime(this.startLoadAdTime);
        long l = RequestUtils.getInstance().countRuntime(loadFirstNetworkAd.getCreateTime());
        loadFirstNetworkAd.setLuid(this.mAdUnitId);
        loadFirstNetworkAd.setAsu(string);
        loadFirstNetworkAd.setLt(String.valueOf(l));
        loadFirstNetworkAd.setRequestId(this.requestId);
        loadFirstNetworkAd.setApid(Util.parseToInteger((String)string3));
        loadFirstNetworkAd.setAs(string2);
        loadFirstNetworkAd.setPID(string);
        loadFirstNetworkAd.setAdsource(string3);
        PushCenter.getInstance().sendMessageToCenter(context, (Object)loadFirstNetworkAd, PushMessageUtils.Type.EV_TRADPLUS.getValue());
        GlobalTradPlus.getInstance().setAdUnitFirstLoadTrace(this.mAdUnitId);
    }

    public void loadAllNetwork(String string) {
        Context context = GlobalTradPlus.getInstance().getContext();
        AdconfRequest adconfRequest = new AdconfRequest(context, PushMessageUtils.PushStatus.EV_ALLLOAD_NETWORK_AD_END.getValue());
        adconfRequest.setLuid(this.mAdUnitId);
        adconfRequest.setEc(string);
        adconfRequest.setRequestId(this.requestId);
        if (this.allLoadUUID != null) {
            adconfRequest.setSuuid(this.allLoadUUID);
        } else {
            this.allLoadUUID = adconfRequest.getSuuid();
        }
        PushCenter.getInstance().sendMessageToCenter(context, (Object)adconfRequest, PushMessageUtils.Type.EV_TRADPLUS.getValue());
        if (this.mLoadListener != null && "11".equals(string)) {
            this.mLoadListener.onAdLoadFailed(string);
        }
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdAllLoaded("1".equals(string));
        }
    }

    public void sendWinNotification(ConfigResponse.WaterfallBean waterfallBean, String string) {
        Context context = GlobalTradPlus.getInstance().getContext();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (waterfallBean != null) {
            string4 = waterfallBean.getId();
            string3 = waterfallBean.getAdsource_placement_id();
            if ((waterfallBean = waterfallBean.getConfig()) != null) {
                string2 = waterfallBean.getPlacementId();
            }
        }
        waterfallBean = new EventBiddingNotification(context, PushMessageUtils.PushStatus.BIDDING_WIN_AD.getValue());
        waterfallBean.setLuid(this.mAdUnitId);
        waterfallBean.setAdsource(string3);
        waterfallBean.setApid(string3);
        waterfallBean.setPID(string2);
        waterfallBean.setRequestid(this.requestId);
        waterfallBean.setEc(string);
        waterfallBean.setLc("0");
        waterfallBean.setAs(string4);
        waterfallBean.setAsu(string2);
        waterfallBean.setEc(string);
        PushCenter.getInstance().sendMessageToCenter(context, (Object)waterfallBean, PushMessageUtils.Type.EV_TRADPLUS.getValue());
    }

    public void entryScenario(String string, AdCache adCache) {
        Context context = GlobalTradPlus.getInstance().getContext();
        TPBaseAdapter tPBaseAdapter = adCache == null ? null : adCache.getAdapter();
        tPBaseAdapter = tPBaseAdapter == null ? null : tPBaseAdapter.getWaterfallBean();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (tPBaseAdapter != null) {
            string2 = tPBaseAdapter.getId();
            string4 = tPBaseAdapter.getAdsource_placement_id();
            if ((tPBaseAdapter = tPBaseAdapter.getConfig()) != null) {
                string3 = tPBaseAdapter.getPlacementId();
            }
        }
        tPBaseAdapter = new ReadyRequest(context, PushMessageUtils.PushStatus.EV_CONFIRM_USER_IS_VIEW_AD.getValue());
        tPBaseAdapter.setLuid(this.mAdUnitId);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            tPBaseAdapter.setScid(string);
        }
        tPBaseAdapter.setIar(adCache == null ? "1" : "2");
        tPBaseAdapter.setAdsource(string4);
        tPBaseAdapter.setAs(string2);
        tPBaseAdapter.setPID(string3);
        tPBaseAdapter.setAsu(string3);
        tPBaseAdapter.setApid(Util.parseToInteger((String)string4));
        PushCenter.getInstance().sendMessageToCenter(context, (Object)tPBaseAdapter, PushMessageUtils.Type.EV_TRADPLUS.getValue());
    }

    public void isReady(AdCache adCache) {
        Context context = GlobalTradPlus.getInstance().getContext();
        TPBaseAdapter tPBaseAdapter = adCache == null ? null : adCache.getAdapter();
        tPBaseAdapter = tPBaseAdapter == null ? null : tPBaseAdapter.getWaterfallBean();
        String string = "";
        String string2 = "";
        String string3 = "";
        if (tPBaseAdapter != null) {
            string = tPBaseAdapter.getId();
            string3 = tPBaseAdapter.getAdsource_placement_id();
            if ((tPBaseAdapter = tPBaseAdapter.getConfig()) != null) {
                string2 = tPBaseAdapter.getPlacementId();
            }
        }
        tPBaseAdapter = new ReadyRequest(context, PushMessageUtils.PushStatus.EV_IS_READY.getValue());
        tPBaseAdapter.setLuid(this.mAdUnitId);
        tPBaseAdapter.setIar(adCache == null ? "1" : "2");
        tPBaseAdapter.setAs(string);
        tPBaseAdapter.setPID(string2);
        tPBaseAdapter.setAdsource(string3);
        tPBaseAdapter.setRequestId(this.requestId);
        tPBaseAdapter.setAsu(string2);
        tPBaseAdapter.setApid(Util.parseToInteger((String)string3));
        PushCenter.getInstance().sendMessageToCenter(context, (Object)tPBaseAdapter, PushMessageUtils.Type.EV_TRADPLUS.getValue());
    }

    public void showAdStart(AdCache adCache, String string) {
        Context context = GlobalTradPlus.getInstance().getContext();
        adCache = adCache == null ? null : adCache.getAdapter();
        adCache = adCache == null ? null : adCache.getWaterfallBean();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (adCache != null) {
            string2 = adCache.getId();
            string4 = adCache.getAdsource_placement_id();
            if ((adCache = adCache.getConfig()) != null) {
                string3 = adCache.getPlacementId();
            }
        }
        adCache = new ShowStartRequest(context, PushMessageUtils.PushStatus.EV_SHOW_AD_START.getValue());
        adCache.setAs(string2);
        adCache.setLuid(this.mAdUnitId);
        adCache.setAdsource(string4);
        adCache.setPID(string3);
        adCache.setAsu(string3);
        adCache.setApid(Util.parseToInteger((String)string4));
        adCache.setRequestId(this.requestId);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            adCache.setScid(string);
        }
        PushCenter.getInstance().sendMessageToCenter(context, (Object)adCache, PushMessageUtils.Type.EV_TRADPLUS.getValue());
    }

    public void showAdEnd(AdCache adCache, String string, String string2) {
        Context context = GlobalTradPlus.getInstance().getContext();
        adCache = adCache == null ? null : adCache.getAdapter();
        adCache = adCache == null ? null : adCache.getWaterfallBean();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (adCache != null) {
            string3 = adCache.getId();
            string5 = adCache.getAdsource_placement_id();
            if ((adCache = adCache.getConfig()) != null) {
                string4 = adCache.getPlacementId();
            }
        }
        adCache = new ShowRequest(context, PushMessageUtils.PushStatus.EV_SHOW_AD.getValue());
        adCache.setAs(string3);
        adCache.setPID(string4);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            adCache.setScid(string);
        }
        adCache.setEc(string2);
        adCache.setLuid(this.mAdUnitId);
        adCache.setAdsource(string5);
        adCache.setRequestId(this.requestId);
        adCache.setAsu(string4);
        adCache.setApid(Util.parseToInteger((String)string5));
        PushCenter.getInstance().sendMessageToCenter(context, (Object)adCache, PushMessageUtils.Type.EV_TRADPLUS.getValue());
    }

    public void adShown(TPBaseAdapter tPBaseAdapter, String string) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdShow(tPBaseAdapter);
        }
        Context context = GlobalTradPlus.getInstance().getContext();
        tPBaseAdapter = tPBaseAdapter == null ? null : tPBaseAdapter.getWaterfallBean();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (tPBaseAdapter != null) {
            string2 = tPBaseAdapter.getId();
            string4 = tPBaseAdapter.getAdsource_placement_id();
            if ((tPBaseAdapter = tPBaseAdapter.getConfig()) != null) {
                string3 = tPBaseAdapter.getPlacementId();
            }
        }
        tPBaseAdapter = new ShowStartRequest(context, PushMessageUtils.PushStatus.EV_SHOW_AD_START.getValue());
        tPBaseAdapter.setAs(string2);
        tPBaseAdapter.setLuid(this.mAdUnitId);
        tPBaseAdapter.setAdsource(string4);
        tPBaseAdapter.setPID(string3);
        tPBaseAdapter.setRequestId(this.requestId);
        tPBaseAdapter.setAsu(string3);
        tPBaseAdapter.setApid(Util.parseToInteger((String)string4));
        if (!TextUtils.isEmpty((CharSequence)string)) {
            tPBaseAdapter.setScid(string);
        }
        PushCenter.getInstance().sendMessageToCenter(context, (Object)tPBaseAdapter, PushMessageUtils.Type.EV_TRADPLUS.getValue());
        tPBaseAdapter = new ShowRequest(context, PushMessageUtils.PushStatus.EV_SHOW_AD.getValue());
        tPBaseAdapter.setAs(string2);
        tPBaseAdapter.setPID(string3);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            tPBaseAdapter.setScid(string);
        }
        tPBaseAdapter.setEc("1");
        tPBaseAdapter.setLuid(this.mAdUnitId);
        tPBaseAdapter.setAdsource(string4);
        tPBaseAdapter.setRequestId(this.requestId);
        tPBaseAdapter.setAsu(string3);
        tPBaseAdapter.setApid(Util.parseToInteger((String)string4));
        PushCenter.getInstance().sendMessageToCenter(context, (Object)tPBaseAdapter, PushMessageUtils.Type.EV_TRADPLUS.getValue());
    }

    void adClicked(TPBaseAdapter tPBaseAdapter, String string) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdClicked(tPBaseAdapter);
        }
        tPBaseAdapter = tPBaseAdapter == null ? null : tPBaseAdapter.getWaterfallBean();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (tPBaseAdapter != null) {
            string2 = tPBaseAdapter.getId();
            string3 = tPBaseAdapter.getName();
            string5 = tPBaseAdapter.getAdsource_placement_id();
            if ((tPBaseAdapter = tPBaseAdapter.getConfig()) != null) {
                string4 = tPBaseAdapter.getPlacementId();
            }
        }
        tPBaseAdapter = GlobalTradPlus.getInstance().getContext();
        ClickRequest clickRequest = new ClickRequest((Context)tPBaseAdapter, PushMessageUtils.PushStatus.EV_CLICK_AD.getValue());
        clickRequest.setAs(string2);
        clickRequest.setPID(string4);
        clickRequest.setLuid(this.mAdUnitId);
        clickRequest.setAdsource(string5);
        clickRequest.setRequestId(this.requestId);
        clickRequest.setAsu(string4);
        clickRequest.setApid(Util.parseToInteger((String)string5));
        if (!TextUtils.isEmpty((CharSequence)string)) {
            clickRequest.setScid(string);
        }
        PushCenter.getInstance().sendMessageToCenter((Context)tPBaseAdapter, (Object)clickRequest, PushMessageUtils.Type.EV_TRADPLUS.getValue());
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.CLICK_NETWORK, string3 + "  " + this.mAdUnitId);
    }

    void videoStart(TPBaseAdapter tPBaseAdapter, String string) {
        Context context;
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdShow(tPBaseAdapter);
            this.mLoadListener.onAdVideoStart(tPBaseAdapter);
        }
        ConfigResponse.WaterfallBean waterfallBean = tPBaseAdapter == null ? null : tPBaseAdapter.getWaterfallBean();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (waterfallBean != null) {
            string2 = waterfallBean.getId();
            string4 = waterfallBean.getAdsource_placement_id();
            context = waterfallBean.getConfig();
            if (context != null) {
                string3 = context.getPlacementId();
            }
            string5 = String.valueOf(waterfallBean.getEcpm());
        }
        context = GlobalTradPlus.getInstance().getContext();
        VideoRequest videoRequest = new VideoRequest(context, PushMessageUtils.PushStatus.EV_AD_VIDEO_START.getValue());
        videoRequest.setLuid(this.mAdUnitId);
        videoRequest.setAs(string2);
        videoRequest.setEc("1");
        videoRequest.setEcpm(string5);
        videoRequest.setPID(string3);
        videoRequest.setAdsource(string4);
        videoRequest.setRequestId(this.requestId);
        videoRequest.setAsu(string3);
        videoRequest.setApid(Util.parseToInteger((String)string4));
        if (!TextUtils.isEmpty((CharSequence)string)) {
            videoRequest.setScid(string);
        }
        PushCenter.getInstance().sendMessageToCenter(context, (Object)videoRequest, PushMessageUtils.Type.EV_TRADPLUS.getValue());
        if (tPBaseAdapter != null) {
            tPBaseAdapter.setShowStartTime();
        }
        if (waterfallBean != null && waterfallBean.getPayLoadInfo() != null) {
            HbTokenManager.getInstance(this.mAdUnitId).sendWinOrDisplayNotification(false, waterfallBean, this);
        }
    }

    public void sendDisPlayNotification(ConfigResponse.WaterfallBean waterfallBean, String string) {
        Context context = GlobalTradPlus.getInstance().getContext();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (waterfallBean != null) {
            string4 = waterfallBean.getId();
            string3 = waterfallBean.getAdsource_placement_id();
            if ((waterfallBean = waterfallBean.getConfig()) != null) {
                string2 = waterfallBean.getPlacementId();
            }
        }
        waterfallBean = new EventBiddingNotification(context, PushMessageUtils.PushStatus.BIDDING_IMP_AD.getValue());
        waterfallBean.setLuid(this.mAdUnitId);
        waterfallBean.setAdsource(string3);
        waterfallBean.setApid(string3);
        waterfallBean.setPID(string2);
        waterfallBean.setEc(string);
        waterfallBean.setAs(string4);
        waterfallBean.setAsu(string2);
        waterfallBean.setRequestid(this.requestId);
        waterfallBean.setEc(string);
        PushCenter.getInstance().sendMessageToCenter(context, (Object)waterfallBean, PushMessageUtils.Type.EV_TRADPLUS.getValue());
    }

    void videoEnd(TPBaseAdapter tPBaseAdapter, String string) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdClosed(tPBaseAdapter);
        }
        ConfigResponse.WaterfallBean waterfallBean = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        long l = 0L;
        if (tPBaseAdapter != null) {
            tPBaseAdapter.setShowEndTime();
            l = tPBaseAdapter.getShowStartTime();
            waterfallBean = tPBaseAdapter.getWaterfallBean();
        }
        if (waterfallBean != null) {
            string2 = waterfallBean.getId();
            string3 = waterfallBean.getName();
            string5 = waterfallBean.getAdsource_placement_id();
            tPBaseAdapter = waterfallBean.getConfig();
            if (tPBaseAdapter != null) {
                string4 = tPBaseAdapter.getPlacementId();
            }
            string6 = String.valueOf(waterfallBean.getEcpm());
        }
        tPBaseAdapter = GlobalTradPlus.getInstance().getContext();
        waterfallBean = new VideoCloseRequest((Context)tPBaseAdapter, PushMessageUtils.PushStatus.EV_AD_VIDEO_CLOSE.getValue());
        waterfallBean.setLuid(this.mAdUnitId);
        waterfallBean.setScid(string);
        if (l == 0L) {
            VideoRequest videoRequest = new VideoRequest((Context)tPBaseAdapter, PushMessageUtils.PushStatus.EV_AD_VIDEO_START.getValue());
            videoRequest.setLuid(this.mAdUnitId);
            videoRequest.setAs(string2);
            videoRequest.setEc("14");
            videoRequest.setEcpm(string6);
            videoRequest.setPID(string4);
            videoRequest.setAdsource(string5);
            videoRequest.setRequestId(this.requestId);
            videoRequest.setAsu(string4);
            videoRequest.setApid(Util.parseToInteger((String)string5));
            if (!TextUtils.isEmpty((CharSequence)string)) {
                videoRequest.setScid(string);
            }
            PushCenter.getInstance().sendMessageToCenter((Context)tPBaseAdapter, (Object)videoRequest, PushMessageUtils.Type.EV_TRADPLUS.getValue());
        }
        waterfallBean.setCreateTime(l);
        waterfallBean.setIc("2");
        long l2 = RequestUtils.getInstance().countRuntime(waterfallBean.getCreateTime());
        waterfallBean.setTt(String.valueOf(l2));
        waterfallBean.setPt(String.valueOf(l2));
        waterfallBean.setPr("1.0");
        waterfallBean.setRequestId(this.requestId);
        waterfallBean.setAs(string2);
        waterfallBean.setPID(string4);
        waterfallBean.setAdsource(string5);
        waterfallBean.setAsu(string4);
        waterfallBean.setApid(Util.parseToInteger((String)string5));
        PushCenter.getInstance().sendMessageToCenter((Context)tPBaseAdapter, (Object)waterfallBean, PushMessageUtils.Type.EV_TRADPLUS.getValue());
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.CLOSED_NETWORK, string3 + "  " + this.mAdUnitId);
    }

    void reward(TPBaseAdapter tPBaseAdapter, String string, Map<String, Object> map) {
        this.reward(tPBaseAdapter, string, null, -1, map);
    }

    void reward(TPBaseAdapter tPBaseAdapter, String string) {
        this.reward(tPBaseAdapter, string, null, -1, null);
    }

    void reward(TPBaseAdapter tPBaseAdapter, String string, String string2, int n, Map<String, Object> context) {
        if (this.mLoadListener != null) {
            if (context == null) {
                if (string2 == null) {
                    this.mLoadListener.onReward(tPBaseAdapter);
                } else {
                    this.mLoadListener.onReward(tPBaseAdapter, string2, n);
                }
            } else {
                this.mLoadListener.onReward(tPBaseAdapter, (Map<String, Object>)context);
            }
        }
        tPBaseAdapter = tPBaseAdapter == null ? null : tPBaseAdapter.getWaterfallBean();
        string = "";
        string2 = "";
        String string3 = "";
        if (tPBaseAdapter != null) {
            string = tPBaseAdapter.getId();
            string3 = tPBaseAdapter.getAdsource_placement_id();
            context = tPBaseAdapter.getConfig();
            if (context != null) {
                string2 = context.getPlacementId();
            }
            String.valueOf(tPBaseAdapter.getEcpm());
        }
        context = GlobalTradPlus.getInstance().getContext();
        tPBaseAdapter = new RewardRequest(context, PushMessageUtils.PushStatus.EV_ADVIDEO_REWARD.getValue());
        tPBaseAdapter.setLuid(this.mAdUnitId);
        tPBaseAdapter.setEc("1");
        tPBaseAdapter.setRequestId(this.requestId);
        tPBaseAdapter.setAs(string);
        tPBaseAdapter.setPID(string2);
        tPBaseAdapter.setAdsource(string3);
        tPBaseAdapter.setAsu(string2);
        tPBaseAdapter.setApid(Util.parseToInteger((String)string3));
        PushCenter.getInstance().sendMessageToCenter(context, (Object)tPBaseAdapter, PushMessageUtils.Type.EV_TRADPLUS.getValue());
    }

    void videoError(TPBaseAdapter tPBaseAdapter, String string, String string2) {
        this.videoEnd(tPBaseAdapter, string);
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdVideoError();
        }
    }

    void videoProgress() {
    }

    void dislikeClicked() {
    }

    void splashAdTick(long l) {
    }
}

