/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.core;

import android.util.SparseArray;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.banner.TPBannerAdapter;
import com.tradplus.ads.base.adapter.interstitial.TPInterstitialAdapter;
import com.tradplus.ads.base.adapter.nativead.TPNativeAdapter;
import com.tradplus.ads.base.adapter.reward.TPRewardAdapter;
import com.tradplus.ads.base.adapter.splash.TPSplashAdapter;
import com.tradplus.ads.base.config.response.BiddingResponse;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.common.util.NetWorkFrequencyUtils;
import com.tradplus.ads.core.HbTokenManager;
import com.tradplus.ads.core.cache.AdCache;
import com.tradplus.ads.network.response.ConfigResponse;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

public class AdCacheManager {
    private static AdCacheManager mInstance;
    private ConcurrentHashMap<String, a> allAdCaches = new ConcurrentHashMap();

    private AdCacheManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized AdCacheManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<AdCacheManager> clazz = AdCacheManager.class;
        synchronized (AdCacheManager.class) {
            mInstance = new AdCacheManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private boolean checkAdCacheValid(AdCache adCache) {
        if (adCache == null) {
            return false;
        }
        if (adCache.getCallback() == null) {
            return false;
        }
        if (adCache.getConfigBean() == null) {
            return false;
        }
        TPBaseAdapter tPBaseAdapter = adCache.getAdapter();
        if (tPBaseAdapter == null) {
            return false;
        }
        if (tPBaseAdapter instanceof TPInterstitialAdapter || tPBaseAdapter instanceof TPRewardAdapter || tPBaseAdapter instanceof TPSplashAdapter) {
            return tPBaseAdapter.isReady();
        }
        if (tPBaseAdapter instanceof TPNativeAdapter || tPBaseAdapter instanceof TPBannerAdapter) {
            return adCache.getAdObj() != null && !adCache.getAdObj().hasShown();
        }
        return false;
    }

    private void saveFirstLoadTime(AdCache adCache) {
        if (adCache == null) {
            return;
        }
        if ((adCache = adCache.getAdapter()) == null) {
            return;
        }
        if (adCache instanceof TPInterstitialAdapter) {
            ((TPInterstitialAdapter)adCache).setFirstLoadedTime();
        }
        if (adCache instanceof TPRewardAdapter) {
            ((TPRewardAdapter)adCache).setFirstLoadedTime();
        }
    }

    synchronized void saveWaterfallCache(String string, AdCache adCache, ArrayList<ConfigResponse.WaterfallBean> arrayList) {
        if (string == null) {
            return;
        }
        this.saveFirstLoadTime(adCache);
        if (!this.checkAdCacheValid(adCache)) {
            return;
        }
        Object object = adCache.getConfigBean();
        int n = arrayList == null ? 0 : arrayList.indexOf(object);
        if (n < 0) {
            return;
        }
        object = this.allAdCaches.get(string);
        if (object == null) {
            object = new a(0);
            this.allAdCaches.put(string, (a)object);
        }
        ((a)object).a(n, adCache);
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.SAVE_NETWORK_SUCCESS, adCache.getConfigBean().getName() + "  " + string);
    }

    @Deprecated
    synchronized void saveHbCache(String string, AdCache adCache) {
        if (string == null) {
            return;
        }
        if (!this.checkAdCacheValid(adCache)) {
            return;
        }
        if (adCache.getConfigBean().getPayLoadInfo() == null) {
            return;
        }
        a a2 = this.allAdCaches.get(string);
        if (a2 == null) {
            a2 = new a(0);
            this.allAdCaches.put(string, a2);
        }
        int n = 0;
        for (int i = 0; i < a2.b.size(); ++i) {
            BiddingResponse.PayLoadInfo payLoadInfo = a2.b.get(i).getConfigBean().getPayLoadInfo();
            BiddingResponse.PayLoadInfo payLoadInfo2 = adCache.getConfigBean().getPayLoadInfo();
            if (!(payLoadInfo.getPrice() <= payLoadInfo2.getPrice())) continue;
            n = i;
            break;
        }
        a2.b(n, adCache);
    }

    public synchronized boolean removeHbCache(String string, BiddingResponse.PayLoadInfo payLoadInfo) {
        if (string == null || payLoadInfo == null) {
            return false;
        }
        return this.removeCache(string, String.valueOf(payLoadInfo.getId()));
    }

    public synchronized boolean removeCache(String object, String string) {
        if (object == null || string == null) {
            return false;
        }
        if ((object = this.allAdCaches.get(object)) == null) {
            return false;
        }
        for (int i = 0; i < ((a)object).a.size(); ++i) {
            AdCache adCache = ((a)object).a(i);
            if (adCache == null || !adCache.getConfigBean().getAdsource_placement_id().equals(string)) continue;
            ((a)object).c(i);
            return true;
        }
        return false;
    }

    public synchronized void removeEndCache(String object, int n) {
        if (object == null && n <= 0) {
            return;
        }
        if ((object = this.allAdCaches.get(object)) == null) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Object object2 = object;
            ((a)object2).c(((a)object2).a.size() - 1);
        }
    }

    public AdCache getReadyAd(String string) {
        if (string == null) {
            return null;
        }
        a a2 = this.allAdCaches.get(string);
        if (a2 == null) {
            return null;
        }
        return this.getShowCache(string, a2, false);
    }

    public int getReadyAdNum(String string) {
        if (string == null) {
            return 0;
        }
        a a2 = this.allAdCaches.get(string);
        if (a2 == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n < a2.a.size()) {
            AdCache adCache = a2.a(n);
            if (this.checkAdCacheValid(adCache)) {
                if (NetWorkFrequencyUtils.getInstance().checkNetworkFrequency(adCache.getConfigBean())) {
                    ++n2;
                }
                ++n;
                continue;
            }
            if (adCache.getConfigBean() != null && adCache.getConfigBean().getPayLoadInfo() != null) {
                HbTokenManager.getInstance(string).sendLosNotification("4902", adCache.getConfigBean().getPayLoadInfo(), adCache.getCallback());
            }
            a2.c(n);
        }
        return n2;
    }

    public AdCache isExistCache(String string, ConfigResponse.WaterfallBean waterfallBean) {
        if (string == null) {
            return null;
        }
        if (waterfallBean == null) {
            return null;
        }
        a a2 = this.allAdCaches.get(string);
        if (a2 == null) {
            return null;
        }
        int n = 0;
        while (n < a2.a.size()) {
            AdCache adCache = a2.a(n);
            if (adCache == null || !adCache.getConfigBean().getAdsource_placement_id().equals(waterfallBean.getAdsource_placement_id())) {
                ++n;
                continue;
            }
            if (this.checkAdCacheValid(adCache)) {
                return adCache;
            }
            if (adCache.getConfigBean() != null && adCache.getConfigBean().getPayLoadInfo() != null) {
                HbTokenManager.getInstance(string).sendLosNotification("4902", adCache.getConfigBean().getPayLoadInfo(), adCache.getCallback());
            }
            a2.c(n);
        }
        return null;
    }

    @Deprecated
    public AdCache isExistHbCache(String iterator, ConfigResponse.WaterfallBean waterfallBean) {
        if (iterator == null) {
            return null;
        }
        if (waterfallBean == null) {
            return null;
        }
        if ((iterator = this.allAdCaches.get(iterator)) == null) {
            return null;
        }
        iterator = ((a)((Object)iterator)).b.iterator();
        while (iterator.hasNext()) {
            AdCache adCache = iterator.next();
            if (!adCache.getConfigBean().getAdsource_placement_id().equals(waterfallBean.getAdsource_placement_id())) continue;
            if (this.checkAdCacheValid(adCache)) {
                return adCache;
            }
            iterator.remove();
        }
        return null;
    }

    public AdCache isExistHbCache(String string, BiddingResponse.PayLoadInfo payLoadInfo) {
        if (string == null) {
            return null;
        }
        if (payLoadInfo == null) {
            return null;
        }
        a a2 = this.allAdCaches.get(string);
        if (a2 == null) {
            return null;
        }
        for (int i = 0; i < a2.a.size(); ++i) {
            AdCache adCache = a2.a(i);
            if (adCache == null || !adCache.getConfigBean().getAdsource_placement_id().equals(String.valueOf(payLoadInfo.getId()))) {
                continue;
            }
            if (this.checkAdCacheValid(adCache)) {
                return adCache;
            }
            if (adCache.getConfigBean() != null && adCache.getConfigBean().getPayLoadInfo() != null) {
                HbTokenManager.getInstance(string).sendLosNotification("4902", adCache.getConfigBean().getPayLoadInfo(), adCache.getCallback());
            }
            a2.c(i);
            return null;
        }
        return null;
    }

    public boolean checkAdCacheTimeout(String string) {
        if (string == null) {
            return false;
        }
        a a2 = this.allAdCaches.get(string);
        if (a2 == null) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < a2.a.size()) {
            AdCache adCache = a2.a(n2);
            if (!this.checkAdCacheValid(adCache)) {
                ++n;
                if (adCache.getConfigBean() != null && adCache.getConfigBean().getPayLoadInfo() != null) {
                    HbTokenManager.getInstance(string).sendLosNotification("4902", adCache.getConfigBean().getPayLoadInfo(), adCache.getCallback());
                }
                a2.c(n2);
                continue;
            }
            ++n2;
        }
        return n > 0;
    }

    public AdCache getAdCacheToShow(String string) {
        if (string == null) {
            return null;
        }
        a a2 = this.allAdCaches.get(string);
        if (a2 == null) {
            return null;
        }
        return this.getShowCache(string, a2, true);
    }

    private AdCache getShowCache(String string, a a2, boolean bl) {
        int n = 0;
        AdCache adCache = null;
        while (n < a2.a.size()) {
            int n2 = n;
            adCache = a2.b(n2 = a2.a.keyAt(n2));
            if (this.checkAdCacheValid(adCache)) {
                if (NetWorkFrequencyUtils.getInstance().checkNetworkFrequency(adCache.getConfigBean())) break;
                ++n;
                adCache = null;
                continue;
            }
            if (adCache.getConfigBean() != null && adCache.getConfigBean().getPayLoadInfo() != null) {
                HbTokenManager.getInstance(string).sendLosNotification("4902", adCache.getConfigBean().getPayLoadInfo(), adCache.getCallback());
            }
            adCache = null;
            a2.c(n);
        }
        if (adCache == null) {
            return null;
        }
        if (bl) {
            NetWorkFrequencyUtils.getInstance().saveNetworkFrequency(adCache.getConfigBean());
            a2.c(n);
        }
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.GET_NETWORK_SUCCESS, adCache.getConfigBean().getName() + "  " + adCache.getAdapter().getAdUnitId());
        return adCache;
    }

    final class a {
        volatile SparseArray<AdCache> a = new SparseArray();
        volatile ArrayList<AdCache> b = new ArrayList();

        private a() {
        }

        final AdCache a(int n) {
            AdCache adCache = null;
            try {
                adCache = (AdCache)this.a.valueAt(n);
            }
            catch (Exception exception) {}
            return adCache;
        }

        final AdCache b(int n) {
            AdCache adCache = null;
            try {
                adCache = (AdCache)this.a.get(n);
            }
            catch (Exception exception) {}
            return adCache;
        }

        final synchronized void c(int n) {
            this.a.removeAt(n);
        }

        final synchronized void a(int n, AdCache adCache) {
            this.a.put(n, (Object)adCache);
        }

        final synchronized void b(int n, AdCache adCache) {
            this.b.add(n, adCache);
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

